/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.DelegatingNotifyingListImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class DelegatingEcoreEList
extends DelegatingNotifyingListImpl
implements InternalEList.Unsettable,
EStructuralFeature.Setting {
    protected final InternalEObject owner;

    public DelegatingEcoreEList(InternalEObject owner) {
        this.owner = owner;
    }

    protected boolean canContainNull() {
        EClassifier eClassifier = this.getFeatureType();
        if (eClassifier instanceof EDataType) {
            if (eClassifier instanceof EEnum) {
                return false;
            }
            return !eClassifier.getInstanceClass().isPrimitive();
        }
        return false;
    }

    protected boolean isUnique() {
        return this.getEStructuralFeature().isUnique();
    }

    protected boolean hasInverse() {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature();
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            return eReference.isContainment() || ((EReference)eStructuralFeature).getEOpposite() != null;
        }
        return false;
    }

    protected Object validate(int index, Object object) {
        super.validate(index, object);
        if (object != null && !this.getFeatureType().isInstance(object)) {
            throw new ArrayStoreException();
        }
        return object;
    }

    public Object getNotifier() {
        return this.owner;
    }

    public Object getFeature() {
        return this.getEStructuralFeature();
    }

    public int getFeatureID() {
        return this.getEStructuralFeature().getFeatureID();
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.owner.eClass().getEStructuralFeature(this.getFeatureID());
    }

    protected EClassifier getFeatureType() {
        return this.getEStructuralFeature().getEType();
    }

    protected EReference getInverseEReference() {
        return ((EReference)this.getEStructuralFeature()).getEOpposite();
    }

    protected int getInverseFeatureID() {
        return this.getInverseEReference().getFeatureID();
    }

    protected Class getInverseFeatureClass() {
        return ((EClass)this.getInverseEReference().getEType()).getInstanceClass();
    }

    protected boolean hasManyInverse() {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature();
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            EReference oppositeEReference = ((EReference)eStructuralFeature).getEOpposite();
            return oppositeEReference != null && oppositeEReference.isMany();
        }
        return false;
    }

    protected boolean hasNavigableInverse() {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature();
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            EReference oppositeEReference = ((EReference)eStructuralFeature).getEOpposite();
            return oppositeEReference != null;
        }
        return false;
    }

    protected boolean isEObject() {
        return this.getFeatureType() instanceof EClass;
    }

    protected boolean isContainment() {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature();
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            return eReference.isContainment();
        }
        return false;
    }

    protected boolean hasProxies() {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeature();
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            return eReference.isResolveProxies();
        }
        return false;
    }

    protected boolean hasInstanceClass() {
        return this.getFeatureType().getInstanceClass() != null;
    }

    protected Object resolve(int index, Object object) {
        EObject resolved;
        if (this.isEObject() && this.hasProxies() && (resolved = this.resolveProxy((EObject)object)) != object) {
            Object oldObject = this.delegateGet(index);
            this.delegateSet(index, this.validate(index, resolved));
            this.didSet(index, resolved, oldObject);
            if (this.isNotificationRequired()) {
                this.owner.eNotify((Notification)new ENotificationImpl(this.owner, 9, this.getFeatureID(), object, (Object)resolved, index));
            }
            return resolved;
        }
        return object;
    }

    protected EObject resolveProxy(EObject eObject) {
        return EcoreUtil.resolve(eObject, this.owner);
    }

    public Object[] toArray() {
        if (this.hasProxies()) {
            int i = this.size() - 1;
            while (i >= 0) {
                this.get(i);
                --i;
            }
        }
        return super.toArray();
    }

    public Object[] toArray(Object[] array) {
        if (this.hasProxies()) {
            int i = this.size() - 1;
            while (i >= 0) {
                this.get(i);
                --i;
            }
        }
        return super.toArray(array);
    }

    protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index) {
        return new ENotificationImpl(this.owner, eventType, this.getFeatureID(), oldObject, newObject, index);
    }

    protected NotificationImpl createNotification(int eventType, boolean oldValue, boolean newValue) {
        return new ENotificationImpl(this.owner, eventType, this.getFeatureID(), oldValue, newValue);
    }

    protected void dispatchNotification(Notification notification) {
        this.owner.eNotify(notification);
    }

    public List basicList() {
        return super.basicList();
    }

    protected boolean isNotificationRequired() {
        return this.owner.eNotificationRequired();
    }

    public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
        InternalEObject internalEObject = (InternalEObject)object;
        if (this.hasNavigableInverse()) {
            if (!this.hasInstanceClass()) {
                return internalEObject.eInverseAdd(this.owner, internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.getInverseEReference()), null, notifications);
            }
            return internalEObject.eInverseAdd(this.owner, this.getInverseFeatureID(), this.getInverseFeatureClass(), notifications);
        }
        return internalEObject.eInverseAdd(this.owner, -1 - this.getFeatureID(), null, notifications);
    }

    public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
        InternalEObject internalEObject = (InternalEObject)object;
        if (this.hasNavigableInverse()) {
            if (!this.hasInstanceClass()) {
                return internalEObject.eInverseRemove(this.owner, internalEObject.eClass().getEAllStructuralFeatures().indexOf(this.getInverseEReference()), null, notifications);
            }
            return internalEObject.eInverseRemove(this.owner, this.getInverseFeatureID(), this.getInverseFeatureClass(), notifications);
        }
        return internalEObject.eInverseRemove(this.owner, -1 - this.getFeatureID(), null, notifications);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(Object object) {
        if (!this.isEObject()) return super.contains(object);
        int size = this.size();
        if (size > 4) {
            if (this.isContainment()) {
                if (!(object instanceof EObject)) {
                    return false;
                }
                InternalEObject eObject = (InternalEObject)object;
                if (eObject.eContainer() != this.owner) return false;
                if (this.hasNavigableInverse()) {
                    if (eObject.eContainerFeatureID() != this.getInverseFeatureID()) return false;
                    return true;
                }
                if (-1 - eObject.eContainerFeatureID() != this.getFeatureID()) return false;
                return true;
            }
            if (this.hasNavigableInverse() && !this.hasManyInverse()) {
                if (!(object instanceof EObject)) return false;
                if (((EObject)object).eGet(this.getInverseEReference()) != this.owner) return false;
                return true;
            }
        }
        boolean result = super.contains(object);
        if (!this.hasProxies()) return result;
        if (result) return result;
        int i = 0;
        while (i < size) {
            EObject eObject = this.resolveProxy((EObject)this.delegateGet(i));
            if (eObject == object) {
                return true;
            }
            ++i;
        }
        return result;
    }

    public int indexOf(Object object) {
        int index = super.indexOf(object);
        if (index >= 0) {
            return index;
        }
        if (this.isEObject()) {
            int i = 0;
            int size = this.size();
            while (i < size) {
                EObject eObject = this.resolveProxy((EObject)this.delegateGet(i));
                if (eObject == object) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int result = super.lastIndexOf(object);
        if (this.isEObject() && result == -1) {
            int i = this.size() - 1;
            while (i >= 0) {
                EObject eObject = EcoreUtil.resolve((EObject)this.delegateGet(i), this.owner);
                if (eObject == object) {
                    return i;
                }
                --i;
            }
        }
        return result;
    }

    public Iterator basicIterator() {
        return super.basicIterator();
    }

    public ListIterator basicListIterator() {
        return super.basicListIterator();
    }

    public ListIterator basicListIterator(int index) {
        return super.basicListIterator(index);
    }

    public EObject getEObject() {
        return this.owner;
    }

    public Object get(boolean resolve) {
        return this;
    }

    public void set(Object newValue) {
        this.clear();
        this.addAll((List)newValue);
    }

    public boolean isSet() {
        return !this.isEmpty();
    }

    public void unset() {
        this.clear();
    }

    public static abstract class Dynamic
    extends Generic {
        protected EStructuralFeature eStructuralFeature;

        public Dynamic(InternalEObject owner, EStructuralFeature eStructuralFeature) {
            super(Generic.kind(eStructuralFeature), owner);
            this.eStructuralFeature = eStructuralFeature;
        }

        public Dynamic(int kind, InternalEObject owner, EStructuralFeature eStructuralFeature) {
            super(kind, owner);
            this.eStructuralFeature = eStructuralFeature;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }
    }

    public static abstract class Generic
    extends DelegatingEcoreEList {
        public static final int IS_SET = 1;
        public static final int IS_UNSETTABLE = 2;
        public static final int HAS_INSTANCE_CLASS = 4;
        public static final int HAS_NAVIGABLE_INVERSE = 8;
        public static final int HAS_MANY_INVERSE = 16;
        public static final int IS_CONTAINMENT = 32;
        public static final int IS_CONTAINER = 64;
        public static final int IS_UNIQUE = 128;
        public static final int IS_PRIMITIVE = 256;
        public static final int IS_ENUM = 512;
        public static final int IS_EOBJECT = 1024;
        public static final int HAS_PROXIES = 2048;
        protected int kind;

        public static int kind(EStructuralFeature eStructuralFeature) {
            return EcoreEList.Generic.kind(eStructuralFeature);
        }

        public Generic(int kind, InternalEObject owner) {
            super(owner);
            this.kind = kind;
        }

        protected boolean useEquals() {
            return (this.kind & 0x600) == 0;
        }

        protected boolean canContainNull() {
            return (this.kind & 0x700) == 0;
        }

        protected boolean isUnique() {
            return (this.kind & 0x80) != 0;
        }

        protected boolean hasInverse() {
            return (this.kind & 0x28) != 0;
        }

        protected boolean hasManyInverse() {
            return (this.kind & 0x10) != 0;
        }

        protected boolean hasNavigableInverse() {
            return (this.kind & 8) != 0;
        }

        protected boolean isEObject() {
            return (this.kind & 0x400) != 0;
        }

        protected boolean isContainment() {
            return (this.kind & 0x20) != 0;
        }

        protected boolean hasProxies() {
            return (this.kind & 0x800) != 0;
        }

        protected boolean hasInstanceClass() {
            return (this.kind & 4) != 0;
        }

        protected boolean isContainer() {
            return (this.kind & 0x40) != 0;
        }

        protected boolean isUnsettable() {
            return (this.kind & 2) != 0;
        }

        public boolean isSet() {
            return this.isUnsettable() ? (this.kind & 1) != 0 : !this.isEmpty();
        }

        public void unset() {
            super.unset();
            if (this.isUnsettable()) {
                if (this.isNotificationRequired()) {
                    boolean oldIsSet = (this.kind & 1) != 0;
                    this.kind &= 0xFFFFFFFE;
                    this.owner.eNotify((Notification)this.createNotification(2, oldIsSet, false));
                } else {
                    this.kind &= 0xFFFFFFFE;
                }
            }
        }

        protected void didChange() {
            this.kind |= 1;
        }
    }

    public static class UnmodifiableEList
    extends DelegatingEList.UnmodifiableEList
    implements InternalEList.Unsettable,
    EStructuralFeature.Setting {
        protected final InternalEObject owner;
        protected final EStructuralFeature eStructuralFeature;

        public UnmodifiableEList(InternalEObject owner, EStructuralFeature eStructuralFeature, List underlyingList) {
            super(underlyingList);
            this.owner = owner;
            this.eStructuralFeature = eStructuralFeature;
        }

        public List basicList() {
            return super.basicList();
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public EObject getEObject() {
            return this.owner;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public Object get(boolean resolve) {
            return this;
        }

        public void set(Object newValue) {
            throw new UnsupportedOperationException();
        }

        public boolean isSet() {
            return !this.isEmpty();
        }

        public void unset() {
            throw new UnsupportedOperationException();
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            throw new UnsupportedOperationException();
        }

        public NotificationChain basicAdd(Object object, NotificationChain notifications) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Unsettable
    extends DelegatingEcoreEList {
        protected boolean isSet;

        public Unsettable(InternalEObject owner) {
            super(owner);
        }

        protected void didChange() {
            this.isSet = true;
        }

        public boolean isSet() {
            return this.isSet;
        }

        public void unset() {
            super.unset();
            if (this.isNotificationRequired()) {
                boolean oldIsSet = this.isSet;
                this.isSet = false;
                this.owner.eNotify((Notification)this.createNotification(2, oldIsSet, false));
            } else {
                this.isSet = false;
            }
        }
    }
}

