/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class URI {
    private final int hashCode;
    private final boolean hierarchical;
    private final String scheme;
    private final String authority;
    private final String fragment;
    private URI cachedTrimFragment;
    private String cachedToString;
    private final String device;
    private final boolean absolutePath;
    private final String[] segments;
    private final String query;
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final String SEGMENT_EMPTY = "";
    private static final String SEGMENT_SELF = ".";
    private static final String SEGMENT_PARENT = "..";
    private static final String[] NO_SEGMENTS = new String[0];
    private static final char SCHEME_SEPARATOR = ':';
    private static final String AUTHORITY_SEPARATOR = "//";
    private static final char DEVICE_IDENTIFIER = ':';
    private static final char SEGMENT_SEPARATOR = '/';
    private static final char QUERY_SEPARATOR = '?';
    private static final char FRAGMENT_SEPARATOR = '#';
    private static final char USER_INFO_SEPARATOR = '@';
    private static final char PORT_SEPARATOR = ':';
    private static final char FILE_EXTENSION_SEPARATOR = '.';
    private static final char[] MAJOR_SEPARATORS = new char[]{':', '/', '?', '#'};
    private static final char[] SEGMENT_END = new char[]{'/', '?', '#'};

    public static URI createGenericURI(String scheme, String opaquePart, String fragment) {
        if (scheme == null) {
            throw new IllegalArgumentException("relative non-hierarchical URI");
        }
        return new URI(false, scheme, opaquePart, null, false, NO_SEGMENTS, null, fragment);
    }

    public static URI createHierarchicalURI(String scheme, String authority, String device, String query, String fragment) {
        if (scheme != null && authority == null && device == null) {
            throw new IllegalArgumentException("absolute hierarchical URI without authority, device, path");
        }
        return new URI(true, scheme, authority, device, false, NO_SEGMENTS, query, fragment);
    }

    public static URI createHierarchicalURI(String scheme, String authority, String device, String[] segments, String query, String fragment) {
        return new URI(true, scheme, authority, device, true, URI.fix(segments), query, fragment);
    }

    public static URI createHierarchicalURI(String[] segments, String query, String fragment) {
        return new URI(true, null, null, null, false, URI.fix(segments), query, fragment);
    }

    private static String[] fix(String[] segments) {
        return segments == null ? NO_SEGMENTS : (String[])segments.clone();
    }

    public static URI createURI(String uri) {
        return URI.parseIntoURI(uri);
    }

    public static URI createDeviceURI(String uri) {
        return URI.parseIntoURI(uri);
    }

    private static URI parseIntoURI(String uri) {
        String s;
        boolean hierarchical = true;
        String scheme = null;
        String authority = null;
        String device = null;
        boolean absolutePath = false;
        String[] segments = NO_SEGMENTS;
        String query = null;
        String fragment = null;
        int i = 0;
        int j = URI.findSeparator(uri, i, MAJOR_SEPARATORS);
        if (j < uri.length() && uri.charAt(j) == ':') {
            scheme = uri.substring(i, j);
            i = j + 1;
        }
        if (uri.startsWith(AUTHORITY_SEPARATOR, i)) {
            j = URI.findSeparator(uri, i += AUTHORITY_SEPARATOR.length(), SEGMENT_END);
            authority = uri.substring(i, j);
            i = j;
        } else if (scheme != null && (i == uri.length() || uri.charAt(i) != '/' && !scheme.equalsIgnoreCase(SCHEME_FILE) && !scheme.equalsIgnoreCase(SCHEME_JAR))) {
            hierarchical = false;
            j = URI.findSeparator(uri, i, new char[]{'#'});
            authority = uri.substring(i, j);
            i = j;
        }
        if (i < uri.length() && uri.charAt(i) == '/' && (s = uri.substring(i + 1, j = URI.findSeparator(uri, i + 1, SEGMENT_END))).length() > 0 && s.charAt(s.length() - 1) == ':') {
            device = s;
            i = j;
        }
        if (i < uri.length() && uri.charAt(i) == '/') {
            ++i;
            absolutePath = true;
        }
        if (URI.segmentsRemain(uri, i)) {
            ArrayList<String> segmentList = new ArrayList<String>();
            while (URI.segmentsRemain(uri, i)) {
                j = URI.findSeparator(uri, i, SEGMENT_END);
                segmentList.add(uri.substring(i, j));
                i = j;
                if (i >= uri.length() || uri.charAt(i) != '/' || URI.segmentsRemain(uri, ++i)) continue;
                segmentList.add(SEGMENT_EMPTY);
            }
            segments = new String[segmentList.size()];
            segmentList.toArray(segments);
        }
        if (i < uri.length() && uri.charAt(i) == '?') {
            j = URI.findSeparator(uri, ++i, new char[]{'#'});
            query = uri.substring(i, j);
            i = j;
        }
        if (i < uri.length()) {
            fragment = uri.substring(++i);
        }
        return new URI(hierarchical, scheme, authority, device, absolutePath, segments, query, fragment);
    }

    public static URI createFileURI(String pathName) {
        String uri;
        File file = new File(pathName);
        String string = uri = File.separatorChar != '/' ? pathName.replace(File.separatorChar, '/') : pathName;
        if (file.isAbsolute()) {
            URI result = URI.parseIntoURI((uri.charAt(0) == '/' ? "file:" : "file:/") + uri);
            return result;
        }
        URI result = URI.parseIntoURI(uri);
        if (result.scheme() != null) {
            throw new IllegalArgumentException("invalid relative pathName: " + pathName);
        }
        return result;
    }

    public static URI createPlatformResourceURI(String pathName) {
        URI result = URI.parseIntoURI((pathName.charAt(0) == '/' ? "platform:/resource" : "platform:/resource/") + pathName);
        return result;
    }

    private static boolean segmentsRemain(String uri, int i) {
        return i < uri.length() && uri.charAt(i) != '?' && uri.charAt(i) != '#';
    }

    private static int findSeparator(String uri, int i, char[] separators) {
        int len = uri.length();
        if (i >= len) {
            return len;
        }
        i = i > 0 ? i : 0;
        block0: while (i < len) {
            int j = 0;
            int slen = separators.length;
            while (j < slen) {
                if (uri.charAt(i) == separators[j]) break block0;
                ++j;
            }
            ++i;
        }
        return i;
    }

    private URI(boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query, String fragment) {
        Object name = null;
        Object value = null;
        if (!URI.validScheme(scheme)) {
            throw new IllegalArgumentException("invalid scheme: " + scheme);
        }
        if (!hierarchical && !URI.validOpaquePart(authority)) {
            throw new IllegalArgumentException("invalid opaquePart: " + authority);
        }
        if (hierarchical && !URI.validAuthority(authority)) {
            throw new IllegalArgumentException("invalid authority: " + authority);
        }
        if (!URI.validDevice(device)) {
            throw new IllegalArgumentException("invalid device: " + device);
        }
        if (!URI.validSegments(segments)) {
            String s = segments == null ? "invalid segments: " + segments : "invalid segment: " + URI.firstInvalidSegment(segments);
            throw new IllegalArgumentException(s);
        }
        if (!URI.validQuery(query)) {
            throw new IllegalArgumentException("invalid query: " + query);
        }
        if (!URI.validFragment(fragment)) {
            throw new IllegalArgumentException("invalid fragment: " + fragment);
        }
        int hashCode = 0;
        if (hierarchical) {
            ++hashCode;
        }
        if (absolutePath) {
            hashCode += 2;
        }
        if (scheme != null) {
            hashCode ^= scheme.hashCode();
        }
        if (authority != null) {
            hashCode ^= authority.hashCode();
        }
        if (device != null) {
            hashCode ^= device.hashCode();
        }
        if (query != null) {
            hashCode ^= query.hashCode();
        }
        if (fragment != null) {
            hashCode ^= fragment.hashCode();
        }
        int i = 0;
        int len = segments.length;
        while (i < len) {
            hashCode ^= segments[i].hashCode();
            ++i;
        }
        this.hashCode = hashCode;
        this.hierarchical = hierarchical;
        this.scheme = scheme;
        this.authority = authority;
        this.device = device;
        this.absolutePath = absolutePath;
        this.segments = segments;
        this.query = query;
        this.fragment = fragment;
    }

    private static boolean contains(String s, char[] targets) {
        int i = 0;
        int len = s.length();
        while (i < len) {
            int j = 0;
            int tlen = targets.length;
            while (j < tlen) {
                if (s.charAt(i) == targets[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean validScheme(String value) {
        return value == null || !URI.contains(value, MAJOR_SEPARATORS);
    }

    public static boolean validOpaquePart(String value) {
        return value != null && value.indexOf(35) == -1 && value.length() > 0 && value.charAt(0) != '/';
    }

    public static boolean validAuthority(String value) {
        return value == null || !URI.contains(value, SEGMENT_END);
    }

    public static boolean validDevice(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        return len > 0 && value.charAt(len - 1) == ':' && !URI.contains(value, SEGMENT_END);
    }

    public static boolean validSegment(String value) {
        return value != null && !URI.contains(value, SEGMENT_END);
    }

    public static boolean validSegments(String[] value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length;
        while (i < len) {
            if (!URI.validSegment(value[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String firstInvalidSegment(String[] value) {
        if (value == null) {
            return null;
        }
        int i = 0;
        int len = value.length;
        while (i < len) {
            if (!URI.validSegment(value[i])) {
                return value[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean validQuery(String value) {
        return value == null || value.indexOf(35) == -1;
    }

    public static boolean validFragment(String value) {
        return true;
    }

    public boolean isRelative() {
        return this.scheme == null;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public boolean hasAuthority() {
        return this.hierarchical && this.authority != null;
    }

    public boolean hasOpaquePart() {
        return !this.hierarchical;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public boolean hasPath() {
        return this.absolutePath || this.authority == null && this.device == null;
    }

    public boolean hasAbsolutePath() {
        return this.absolutePath;
    }

    public boolean hasRelativePath() {
        return this.authority == null && this.device == null && !this.absolutePath;
    }

    public boolean hasEmptyPath() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0;
    }

    public boolean hasQuery() {
        return this.query != null;
    }

    public boolean hasFragment() {
        return this.fragment != null;
    }

    public boolean isCurrentDocumentReference() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0 && this.query == null;
    }

    public boolean isEmpty() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0 && this.query == null && this.fragment == null;
    }

    public boolean isFile() {
        return this.isHierarchical() && (this.isRelative() && !this.hasQuery() || SCHEME_FILE.equalsIgnoreCase(this.scheme));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URI)) {
            return false;
        }
        URI uri = (URI)obj;
        return this.hashCode == uri.hashCode() && this.hierarchical == uri.isHierarchical() && this.absolutePath == uri.hasAbsolutePath() && URI.equals(this.scheme, uri.scheme()) && URI.equals(this.authority, this.hierarchical ? uri.authority() : uri.opaquePart()) && URI.equals(this.device, uri.device()) && URI.equals(this.query, uri.query()) && URI.equals(this.fragment, uri.fragment()) && this.segmentsEqual(uri);
    }

    private boolean segmentsEqual(URI uri) {
        if (this.segments.length != uri.segmentCount()) {
            return false;
        }
        int i = 0;
        int len = this.segments.length;
        while (i < len) {
            if (!this.segments[i].equals(uri.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public String scheme() {
        return this.scheme;
    }

    public String opaquePart() {
        return this.isHierarchical() ? null : this.authority;
    }

    public String authority() {
        return this.isHierarchical() ? this.authority : null;
    }

    public String userInfo() {
        if (!this.hasAuthority()) {
            return null;
        }
        int i = this.authority.indexOf(64);
        return i < 0 ? null : this.authority.substring(0, i);
    }

    public String host() {
        if (!this.hasAuthority()) {
            return null;
        }
        int i = this.authority.indexOf(64);
        int j = this.authority.indexOf(58);
        return j < 0 ? this.authority.substring(i + 1) : this.authority.substring(i + 1, j);
    }

    public String port() {
        if (!this.hasAuthority()) {
            return null;
        }
        int i = this.authority.indexOf(58);
        return i < 0 ? null : this.authority.substring(i + 1);
    }

    public String device() {
        return this.device;
    }

    public String[] segments() {
        return (String[])this.segments.clone();
    }

    public List segmentsList() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public String segment(int i) {
        return this.segments[i];
    }

    public String lastSegment() {
        int len = this.segments.length;
        if (len == 0) {
            return null;
        }
        return this.segments[len - 1];
    }

    public String path() {
        if (!this.hasPath()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (this.hasAbsolutePath()) {
            result.append('/');
        }
        int i = 0;
        int len = this.segments.length;
        while (i < len) {
            if (i != 0) {
                result.append('/');
            }
            result.append(this.segments[i]);
            ++i;
        }
        return result.toString();
    }

    public String devicePath() {
        if (!this.hasPath()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (this.hasAuthority()) {
            result.append('/');
            result.append('/');
            result.append(this.authority);
            if (this.hasDevice()) {
                result.append('/');
            }
        }
        if (this.hasDevice()) {
            result.append(this.device);
        }
        if (this.hasAbsolutePath()) {
            result.append('/');
        }
        int i = 0;
        int len = this.segments.length;
        while (i < len) {
            if (i != 0) {
                result.append('/');
            }
            result.append(this.segments[i]);
            ++i;
        }
        return result.toString();
    }

    public String query() {
        return this.query;
    }

    public URI appendQuery(String query) {
        if (!URI.validQuery(query)) {
            throw new IllegalArgumentException("invalid query portion: " + query);
        }
        return new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, query, this.fragment);
    }

    public URI trimQuery() {
        if (this.query == null) {
            return this;
        }
        return new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, null, this.fragment);
    }

    public String fragment() {
        return this.fragment;
    }

    public URI appendFragment(String fragment) {
        if (!URI.validFragment(fragment)) {
            throw new IllegalArgumentException("invalid fragment portion: " + fragment);
        }
        URI result = new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, fragment);
        result.cachedTrimFragment = this;
        return result;
    }

    public URI trimFragment() {
        if (this.fragment == null) {
            return this;
        }
        if (this.cachedTrimFragment == null) {
            this.cachedTrimFragment = new URI(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, null);
        }
        return this.cachedTrimFragment;
    }

    public URI resolve(URI base) {
        return this.resolve(base, true);
    }

    public URI resolve(URI base, boolean preserveRootParents) {
        if (!base.isHierarchical() || base.isRelative()) {
            throw new IllegalArgumentException("resolve against non-hierarchical or relative base");
        }
        if (!this.isRelative()) {
            return this;
        }
        String newAuthority = this.authority;
        String newDevice = this.device;
        boolean newAbsolutePath = this.absolutePath;
        String[] newSegments = this.segments;
        String newQuery = this.query;
        if (this.authority == null) {
            newAuthority = base.authority();
            if (this.device == null) {
                newDevice = base.device();
                if (this.hasEmptyPath() && this.query == null) {
                    newAbsolutePath = base.hasAbsolutePath();
                    newSegments = base.segments();
                    newQuery = base.query();
                } else if (this.hasRelativePath()) {
                    newAbsolutePath = base.hasAbsolutePath() || !this.hasEmptyPath();
                    newSegments = newAbsolutePath ? this.mergePath(base, preserveRootParents) : NO_SEGMENTS;
                }
            }
        }
        return new URI(true, base.scheme(), newAuthority, newDevice, newAbsolutePath, newSegments, newQuery, this.fragment);
    }

    private String[] mergePath(URI base, boolean preserveRootParents) {
        if (base.hasRelativePath()) {
            throw new IllegalArgumentException("merge against relative path");
        }
        if (!this.hasRelativePath()) {
            throw new IllegalStateException("merge non-relative path");
        }
        int baseSegmentCount = base.segmentCount();
        int segmentCount = this.segments.length;
        String[] stack = new String[baseSegmentCount + segmentCount];
        int sp = 0;
        int i = 0;
        while (i < baseSegmentCount - 1) {
            sp = URI.accumulate(stack, sp, base.segment(i), preserveRootParents);
            ++i;
        }
        int i2 = 0;
        while (i2 < segmentCount) {
            sp = URI.accumulate(stack, sp, this.segments[i2], preserveRootParents);
            ++i2;
        }
        if (sp > 0 && (segmentCount == 0 || SEGMENT_EMPTY.equals(this.segments[segmentCount - 1]) || SEGMENT_PARENT.equals(this.segments[segmentCount - 1]) || SEGMENT_SELF.equals(this.segments[segmentCount - 1]))) {
            stack[sp++] = SEGMENT_EMPTY;
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    private static int accumulate(String[] stack, int sp, String segment, boolean preserveRootParents) {
        if (SEGMENT_PARENT.equals(segment)) {
            if (sp == 0) {
                if (preserveRootParents) {
                    stack[sp++] = segment;
                }
            } else if (SEGMENT_PARENT.equals(stack[sp - 1])) {
                stack[sp++] = segment;
            } else {
                --sp;
            }
        } else if (!SEGMENT_EMPTY.equals(segment) && !SEGMENT_SELF.equals(segment)) {
            stack[sp++] = segment;
        }
        return sp;
    }

    public URI deresolve(URI base) {
        return this.deresolve(base, true, false, true);
    }

    public URI deresolve(URI base, boolean preserveRootParents, boolean anyRelPath, boolean shorterRelPath) {
        if (!base.isHierarchical() || base.isRelative()) {
            throw new IllegalArgumentException("deresolve against non-hierarchical or relative base");
        }
        if (this.isRelative()) {
            throw new IllegalStateException("deresolve relative URI");
        }
        if (!this.scheme.equals(base.scheme())) {
            return this;
        }
        if (!this.isHierarchical()) {
            return this;
        }
        String newAuthority = this.authority;
        String newDevice = this.device;
        boolean newAbsolutePath = this.absolutePath;
        String[] newSegments = this.segments;
        String newQuery = this.query;
        if (URI.equals(this.authority, base.authority()) && (this.hasDevice() || this.hasPath() || !base.hasDevice() && !base.hasPath())) {
            newAuthority = null;
            if (URI.equals(this.device, base.device()) && (this.hasPath() || !base.hasPath())) {
                newDevice = null;
                if (anyRelPath || shorterRelPath) {
                    if (this.hasPath() == base.hasPath() && this.segmentsEqual(base) && URI.equals(this.query, base.query())) {
                        newAbsolutePath = false;
                        newSegments = NO_SEGMENTS;
                        newQuery = null;
                    } else if (!this.hasPath() && !base.hasPath()) {
                        newAbsolutePath = false;
                        newSegments = NO_SEGMENTS;
                    } else if (!this.hasCollapsableSegments(preserveRootParents)) {
                        String[] rel = this.findRelativePath(base, preserveRootParents);
                        if (anyRelPath || this.segments.length > rel.length) {
                            newAbsolutePath = false;
                            newSegments = rel;
                        }
                    }
                }
            }
        }
        return new URI(true, null, newAuthority, newDevice, newAbsolutePath, newSegments, newQuery, this.fragment);
    }

    private boolean hasCollapsableSegments(boolean preserveRootParents) {
        if (this.hasRelativePath()) {
            throw new IllegalStateException("test collapsability of relative path");
        }
        int i = 0;
        int len = this.segments.length;
        while (i < len) {
            String segment = this.segments[i];
            if (i < len - 1 && SEGMENT_EMPTY.equals(segment) || SEGMENT_SELF.equals(segment) || SEGMENT_PARENT.equals(segment) && (!preserveRootParents || i != 0 && !SEGMENT_PARENT.equals(this.segments[i - 1]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String[] findRelativePath(URI base, boolean preserveRootParents) {
        if (base.hasRelativePath()) {
            throw new IllegalArgumentException("find relative path against base with relative path");
        }
        if (!this.hasAbsolutePath()) {
            throw new IllegalArgumentException("find relative path of non-absolute path");
        }
        String[] startPath = base.collapseSegments(preserveRootParents);
        String[] endPath = this.segments;
        int startCount = startPath.length > 0 ? startPath.length - 1 : 0;
        int endCount = endPath.length;
        int diff = 0;
        int count = startCount < endCount ? startCount : endCount - 1;
        while (diff < count && startPath[diff].equals(endPath[diff])) {
            ++diff;
        }
        int upCount = startCount - diff;
        int downCount = endCount - diff;
        if (downCount == 1 && SEGMENT_EMPTY.equals(endPath[endCount - 1])) {
            downCount = 0;
        }
        if (upCount + downCount == 0) {
            if (this.query == null) {
                return new String[]{SEGMENT_SELF};
            }
            return NO_SEGMENTS;
        }
        Object[] result = new String[upCount + downCount];
        Arrays.fill(result, 0, upCount, SEGMENT_PARENT);
        System.arraycopy(endPath, diff, result, upCount, downCount);
        return result;
    }

    String[] collapseSegments(boolean preserveRootParents) {
        if (this.hasRelativePath()) {
            throw new IllegalStateException("collapse relative path");
        }
        if (!this.hasCollapsableSegments(preserveRootParents)) {
            return this.segments();
        }
        int segmentCount = this.segments.length;
        String[] stack = new String[segmentCount];
        int sp = 0;
        int i = 0;
        while (i < segmentCount) {
            sp = URI.accumulate(stack, sp, this.segments[i], preserveRootParents);
            ++i;
        }
        if (sp > 0 && (SEGMENT_EMPTY.equals(this.segments[segmentCount - 1]) || SEGMENT_PARENT.equals(this.segments[segmentCount - 1]) || SEGMENT_SELF.equals(this.segments[segmentCount - 1]))) {
            stack[sp++] = SEGMENT_EMPTY;
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer result = new StringBuffer();
            if (!this.isRelative()) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.isHierarchical()) {
                if (this.hasAuthority()) {
                    result.append(AUTHORITY_SEPARATOR);
                    result.append(this.authority);
                }
                if (this.hasDevice()) {
                    result.append('/');
                    result.append(this.device);
                }
                if (this.hasAbsolutePath()) {
                    result.append('/');
                }
                int i = 0;
                int len = this.segments.length;
                while (i < len) {
                    if (i != 0) {
                        result.append('/');
                    }
                    result.append(this.segments[i]);
                    ++i;
                }
                if (this.hasQuery()) {
                    result.append('?');
                    result.append(this.query);
                }
            } else {
                result.append(this.authority);
            }
            if (this.hasFragment()) {
                result.append('#');
                result.append(this.fragment);
            }
            this.cachedToString = result.toString();
        }
        return this.cachedToString;
    }

    String toString(boolean includeSimpleForm) {
        StringBuffer result = new StringBuffer();
        if (includeSimpleForm) {
            result.append(this.toString());
        }
        result.append("\n hierarchical: ");
        result.append(this.hierarchical);
        result.append("\n       scheme: ");
        result.append(this.scheme);
        result.append("\n    authority: ");
        result.append(this.authority);
        result.append("\n       device: ");
        result.append(this.device);
        result.append("\n absolutePath: ");
        result.append(this.absolutePath);
        result.append("\n     segments: ");
        if (this.segments.length == 0) {
            result.append("<empty>");
        }
        int i = 0;
        int len = this.segments.length;
        while (i < len) {
            if (i > 0) {
                result.append("\n               ");
            }
            result.append(this.segments[i]);
            ++i;
        }
        result.append("\n        query: ");
        result.append(this.query);
        result.append("\n     fragment: ");
        result.append(this.fragment);
        return result.toString();
    }

    public String toFileString() {
        if (!this.isFile()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        char separator = File.separatorChar;
        if (this.hasAuthority()) {
            result.append(separator);
            result.append(separator);
            result.append(this.authority);
            if (this.hasDevice()) {
                result.append(separator);
            }
        }
        if (this.hasDevice()) {
            result.append(this.device);
        }
        if (this.hasAbsolutePath()) {
            result.append(separator);
        }
        int i = 0;
        int len = this.segments.length;
        while (i < len) {
            if (i != 0) {
                result.append(separator);
            }
            result.append(this.segments[i]);
            ++i;
        }
        return result.toString();
    }

    public URI appendSegment(String segment) {
        if (!URI.validSegment(segment)) {
            throw new IllegalArgumentException("invalid segment: " + segment);
        }
        if (!this.isHierarchical()) {
            return this;
        }
        boolean newAbsolutePath = !this.hasRelativePath();
        int len = this.segments.length;
        String[] newSegments = new String[len + 1];
        System.arraycopy(this.segments, 0, newSegments, 0, len);
        newSegments[len] = segment;
        return new URI(true, this.scheme, this.authority, this.device, newAbsolutePath, newSegments, this.query, this.fragment);
    }

    public URI appendSegments(String[] segments) {
        if (!URI.validSegments(segments)) {
            String s = segments == null ? "invalid segments: " + segments : "invalid segment: " + URI.firstInvalidSegment(segments);
            throw new IllegalArgumentException(s);
        }
        if (!this.isHierarchical()) {
            return this;
        }
        boolean newAbsolutePath = !this.hasRelativePath();
        int len = this.segments.length;
        int segmentsCount = segments.length;
        String[] newSegments = new String[len + segmentsCount];
        System.arraycopy(this.segments, 0, newSegments, 0, len);
        System.arraycopy(segments, 0, newSegments, len, segmentsCount);
        return new URI(true, this.scheme, this.authority, this.device, newAbsolutePath, newSegments, this.query, this.fragment);
    }

    public URI trimSegments(int i) {
        if (!this.isHierarchical() || i < 1) {
            return this;
        }
        String[] newSegments = NO_SEGMENTS;
        int len = this.segments.length - i;
        if (len > 0) {
            newSegments = new String[len];
            System.arraycopy(this.segments, 0, newSegments, 0, len);
        }
        return new URI(true, this.scheme, this.authority, this.device, this.absolutePath, newSegments, this.query, this.fragment);
    }

    public boolean hasTrailingPathSeparator() {
        return this.segments.length > 0 && SEGMENT_EMPTY.equals(this.segments[this.segments.length - 1]);
    }

    public String fileExtension() {
        int len = this.segments.length;
        if (len == 0) {
            return null;
        }
        String lastSegment = this.segments[len - 1];
        int i = lastSegment.lastIndexOf(46);
        return i < 0 ? null : lastSegment.substring(i + 1);
    }

    public URI appendFileExtension(String fileExtension) {
        if (!URI.validSegment(fileExtension)) {
            throw new IllegalArgumentException("invalid segment portion: " + fileExtension);
        }
        int len = this.segments.length;
        if (len == 0) {
            return this;
        }
        String lastSegment = this.segments[len - 1];
        if (SEGMENT_EMPTY.equals(lastSegment)) {
            return this;
        }
        StringBuffer newLastSegment = new StringBuffer(lastSegment);
        newLastSegment.append('.');
        newLastSegment.append(fileExtension);
        String[] newSegments = new String[len];
        System.arraycopy(this.segments, 0, newSegments, 0, len - 1);
        newSegments[len - 1] = newLastSegment.toString();
        return new URI(true, this.scheme, this.authority, this.device, this.absolutePath, newSegments, this.query, this.fragment);
    }

    public URI trimFileExtension() {
        int len = this.segments.length;
        if (len == 0) {
            return this;
        }
        String lastSegment = this.segments[len - 1];
        int i = lastSegment.lastIndexOf(46);
        if (i < 0) {
            return this;
        }
        String newLastSegment = lastSegment.substring(0, i);
        String[] newSegments = new String[len];
        System.arraycopy(this.segments, 0, newSegments, 0, len - 1);
        newSegments[len - 1] = newLastSegment;
        return new URI(true, this.scheme, this.authority, this.device, this.absolutePath, newSegments, this.query, this.fragment);
    }

    public boolean isPrefix() {
        return this.hierarchical && this.query == null && this.fragment == null && (this.hasTrailingPathSeparator() || this.absolutePath && this.segments.length == 0);
    }

    public URI replacePrefix(URI oldPrefix, URI newPrefix) {
        if (!oldPrefix.isPrefix() || !newPrefix.isPrefix()) {
            String which = oldPrefix.isPrefix() ? "new" : "old";
            throw new IllegalArgumentException("non-prefix " + which + " value");
        }
        String[] tailSegments = this.getTailSegments(oldPrefix);
        if (tailSegments == null) {
            return null;
        }
        String[] mergedSegments = tailSegments;
        if (newPrefix.segmentCount() != 0) {
            int segmentsToKeep = newPrefix.segmentCount() - 1;
            mergedSegments = new String[segmentsToKeep + tailSegments.length];
            System.arraycopy(newPrefix.segments(), 0, mergedSegments, 0, segmentsToKeep);
            if (tailSegments.length != 0) {
                System.arraycopy(tailSegments, 0, mergedSegments, segmentsToKeep, tailSegments.length);
            }
        }
        return new URI(true, newPrefix.scheme(), newPrefix.authority(), newPrefix.device(), newPrefix.hasAbsolutePath(), mergedSegments, this.query, this.fragment);
    }

    /*
     * Unable to fully structure code
     */
    private String[] getTailSegments(URI prefix) {
        if (!prefix.isPrefix()) {
            throw new IllegalArgumentException("non-prefix trim");
        }
        if (!(this.hierarchical && URI.equals(this.scheme, prefix.scheme()) && URI.equals(this.authority, prefix.authority()) && URI.equals(this.device, prefix.device()) && this.absolutePath == prefix.hasAbsolutePath())) {
            return null;
        }
        if (prefix.segmentCount() == 0) {
            return this.segments;
        }
        i = 0;
        segmentsToCompare = prefix.segmentCount() - 1;
        if (this.segments.length > segmentsToCompare) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            if (!this.segments[i].equals(prefix.segment(i))) {
                return null;
            }
            ++i;
lbl14:
            // 2 sources

            ** while (i < segmentsToCompare)
        }
lbl15:
        // 1 sources

        if (i == this.segments.length - 1 && "".equals(this.segments[i])) {
            return URI.NO_SEGMENTS;
        }
        newSegments = new String[this.segments.length - i];
        System.arraycopy(this.segments, i, newSegments, 0, newSegments.length);
        return newSegments;
    }
}

