/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RemoveCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_RemoveCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_RemoveCommand_description");
    protected static final String DESCRIPTION_FOR_LIST = EMFEditPlugin.INSTANCE.getString("_UI_RemoveCommand_description_for_list");
    protected EObject owner;
    protected EStructuralFeature feature;
    protected EList ownerList;
    protected Collection collection;
    protected int[] indices;
    protected Collection affectedObjects;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$RemoveCommand;

    public static Command create(EditingDomain domain, Object value) {
        return RemoveCommand.create(domain, Collections.singleton(value));
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Object value) {
        return RemoveCommand.create(domain, owner, feature, Collections.singleton(value));
    }

    public static Command create(EditingDomain domain, Collection collection) {
        return RemoveCommand.create(domain, null, null, collection);
    }

    public static Command create(EditingDomain domain, Object owner, Object feature, Collection collection) {
        return domain.createCommand(class$org$eclipse$emf$edit$command$RemoveCommand == null ? (class$org$eclipse$emf$edit$command$RemoveCommand = RemoveCommand.class$("org.eclipse.emf.edit.command.RemoveCommand")) : class$org$eclipse$emf$edit$command$RemoveCommand, new CommandParameter(owner, feature, collection));
    }

    public RemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        this(domain, owner, feature, Collections.singleton(value));
    }

    public RemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection collection) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.collection = collection == null ? null : new ArrayList(collection);
        this.ownerList = AbstractOverrideableCommand.getOwnerList(this.owner, feature);
    }

    public RemoveCommand(EditingDomain domain, EList list, Object value) {
        this(domain, list, Collections.singleton(value));
    }

    public RemoveCommand(EditingDomain domain, EList list, Collection collection) {
        super(domain, LABEL, DESCRIPTION_FOR_LIST);
        this.collection = collection == null ? null : new ArrayList(collection);
        this.ownerList = list;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public EList getOwnerList() {
        return this.ownerList;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public int[] getIndices() {
        return this.indices;
    }

    protected boolean prepare() {
        boolean result = this.ownerList != null && this.collection != null && this.ownerList.containsAll(this.collection);
        return result;
    }

    public void doExecute() {
        this.indices = new int[this.collection.size()];
        int i = 0;
        ListIterator ownedObjects = this.ownerList.listIterator();
        while (ownedObjects.hasNext()) {
            Object ownedObject = ownedObjects.next();
            if (!this.collection.contains(ownedObject)) continue;
            this.collection.remove(ownedObject);
            this.collection.add(ownedObject);
            this.indices[i++] = ownedObjects.previousIndex();
        }
        this.ownerList.removeAll(this.collection);
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
    }

    public void doUndo() {
        int i = 0;
        Iterator objects = this.collection.iterator();
        while (objects.hasNext()) {
            this.ownerList.add(this.indices[i++], objects.next());
        }
        this.affectedObjects = this.collection;
    }

    public void doRedo() {
        this.ownerList.removeAll(this.collection);
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
    }

    public Collection doGetResult() {
        return this.collection;
    }

    public Collection doGetAffectedObjects() {
        return this.affectedObjects;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.feature + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (indices: " + this.indices + ")");
        result.append(" (affectedObjects: " + this.affectedObjects + ")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

