/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class ItemProviderAdapter
extends AdapterImpl
implements IChangeNotifier,
IDisposable,
CreateChildCommand.Helper,
ResourceLocator {
    protected AdapterFactory adapterFactory;
    protected List itemPropertyDescriptors;
    protected List childrenReferences;
    protected IChangeNotifier changeNotifier;
    protected Collection targets;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$SetCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$CopyCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$CreateCopyCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$InitializeCopyCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$RemoveCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$AddCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$MoveCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$ReplaceCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$DragAndDropCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$CreateChildCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemLabelProvider;

    public ItemProviderAdapter(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void addListener(INotifyChangedListener listener) {
        if (this.changeNotifier == null) {
            this.changeNotifier = new ChangeNotifier();
        }
        this.changeNotifier.addListener(listener);
    }

    public void removeListener(INotifyChangedListener listener) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeListener(listener);
        }
    }

    public void fireNotifyChanged(Notification notification) {
        if (this.changeNotifier != null) {
            this.changeNotifier.fireNotifyChanged(notification);
        }
        if (this.adapterFactory instanceof IChangeNotifier) {
            IChangeNotifier changeNotifier = (IChangeNotifier)this.adapterFactory;
            changeNotifier.fireNotifyChanged(notification);
        }
    }

    public Object getEditableValue(Object object) {
        return object;
    }

    public List getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList();
        }
        return this.itemPropertyDescriptors;
    }

    public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyId) {
        Iterator i = this.getPropertyDescriptors(object).iterator();
        while (i.hasNext()) {
            IItemPropertyDescriptor itemPropertyDescriptor = (IItemPropertyDescriptor)i.next();
            if (!propertyId.equals(itemPropertyDescriptor.getId(object))) continue;
            return itemPropertyDescriptor;
        }
        return null;
    }

    public Object getPropertyValue(Object object, String property) {
        return this.getPropertyDescriptor(object, property).getPropertyValue(object);
    }

    public boolean isPropertySet(Object object, String property) {
        return this.getPropertyDescriptor(object, property).isPropertySet(object);
    }

    public void resetPropertyValue(Object object, String property) {
        this.getPropertyDescriptor(object, property).resetPropertyValue(object);
    }

    public void setPropertyValue(Object object, String property, Object value) {
        this.getPropertyDescriptor(object, property).setPropertyValue(object, value);
    }

    public Collection getElements(Object object) {
        return this.getChildren(object);
    }

    public Collection getChildren(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator childrenReferences = this.getChildrenReferences(object).iterator();
        while (childrenReferences.hasNext()) {
            EReference childrenReference = (EReference)childrenReferences.next();
            if (childrenReference.isMany()) {
                result.addAll((List)((EObject)object).eGet((EStructuralFeature)childrenReference));
                continue;
            }
            Object child = ((EObject)object).eGet((EStructuralFeature)childrenReference);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    protected Collection getChildrenReferences(Object object) {
        if (this.childrenReferences == null) {
            this.childrenReferences = new ArrayList();
        }
        return this.childrenReferences;
    }

    protected Object getReferenceValue(EObject object, EReference reference) {
        return object.eGet((EStructuralFeature)reference);
    }

    protected EReference getChildReference(Object object, Object child) {
        if (child instanceof EObject) {
            EObject eChild = (EObject)child;
            Iterator childrenReferences = this.getChildrenReferences(object).iterator();
            while (childrenReferences.hasNext()) {
                EReference eReference = (EReference)childrenReferences.next();
                EClassifier eType = eReference.getEType();
                if (!eType.isInstance((Object)eChild)) continue;
                return eReference;
            }
        }
        return null;
    }

    protected Collection getSetFeatures(Object object) {
        return Collections.EMPTY_LIST;
    }

    protected EStructuralFeature getSetFeature(Object object, Object value) {
        Iterator setFeatures = this.getSetFeatures(object).iterator();
        while (setFeatures.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)setFeatures.next();
            EClassifier eType = eStructuralFeature.getEType();
            if (!eType.isInstance(value)) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public Object getParent(Object object) {
        EObject eObject = (EObject)object;
        EObject result = eObject.eContainer();
        if (result == null) {
            result = eObject.eResource();
        }
        return result;
    }

    public Object getImage(Object object) {
        return null;
    }

    public String getText(Object object) {
        return object.toString();
    }

    public String getUpdateableText(Object object) {
        return this.getText(object);
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        EObject eObject = (EObject)object;
        ArrayList newChildDescriptors = new ArrayList();
        this.collectNewChildDescriptors(newChildDescriptors, object);
        if (sibling != null) {
            EReference siblingReference = null;
            int siblingReferenceIndex = 0;
            int siblingIndex = -1;
            Iterator references = this.getChildrenReferences(object).iterator();
            while (references.hasNext()) {
                EReference reference = (EReference)references.next();
                Object o = eObject.eGet((EStructuralFeature)reference);
                if (reference.isMany()) {
                    siblingIndex = ((List)o).indexOf(sibling);
                    if (siblingIndex > -1) {
                        siblingReference = reference;
                        break;
                    }
                } else if (o == sibling) {
                    siblingReference = reference;
                    break;
                }
                ++siblingReferenceIndex;
            }
            Iterator parameters = newChildDescriptors.iterator();
            while (siblingReference != null && parameters.hasNext()) {
                CommandParameter parameter;
                EReference childReference;
                Object p = parameters.next();
                if (!(p instanceof CommandParameter) || (childReference = (parameter = (CommandParameter)p).getEReference()) == null || !childReference.isMany()) continue;
                int childReferenceIndex = 0;
                Iterator references2 = this.getChildrenReferences(object).iterator();
                while (references2.hasNext()) {
                    EReference reference = (EReference)references2.next();
                    if (reference == childReference) {
                        parameter.index = childReferenceIndex < siblingReferenceIndex ? ((List)eObject.eGet((EStructuralFeature)reference)).size() : (childReferenceIndex > siblingReferenceIndex ? 0 : siblingIndex + 1);
                    }
                    ++childReferenceIndex;
                }
            }
        }
        return newChildDescriptors;
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
    }

    public Command createCommand(Object object, EditingDomain domain, Class commandClass, CommandParameter commandParameter) {
        if (commandClass == (class$org$eclipse$emf$edit$command$SetCommand == null ? (class$org$eclipse$emf$edit$command$SetCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.SetCommand")) : class$org$eclipse$emf$edit$command$SetCommand)) {
            return this.createSetCommand(domain, commandParameter.getEOwner(), commandParameter.getEStructuralFeature() != null ? commandParameter.getEStructuralFeature() : this.getSetFeature(commandParameter.getEOwner(), commandParameter.getValue()), commandParameter.getValue());
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$CopyCommand == null ? (class$org$eclipse$emf$edit$command$CopyCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.CopyCommand")) : class$org$eclipse$emf$edit$command$CopyCommand)) {
            return this.createCopyCommand(domain, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$CreateCopyCommand == null ? (class$org$eclipse$emf$edit$command$CreateCopyCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.CreateCopyCommand")) : class$org$eclipse$emf$edit$command$CreateCopyCommand)) {
            return this.createCreateCopyCommand(domain, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$InitializeCopyCommand == null ? (class$org$eclipse$emf$edit$command$InitializeCopyCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.InitializeCopyCommand")) : class$org$eclipse$emf$edit$command$InitializeCopyCommand)) {
            return this.createInitializeCopyCommand(domain, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$RemoveCommand == null ? (class$org$eclipse$emf$edit$command$RemoveCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.RemoveCommand")) : class$org$eclipse$emf$edit$command$RemoveCommand)) {
            if (commandParameter.getEReference() != null) {
                return this.createRemoveCommand(domain, commandParameter.getEOwner(), commandParameter.getEReference(), commandParameter.getCollection());
            }
            return this.factorRemoveCommand(domain, commandParameter);
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$AddCommand == null ? (class$org$eclipse$emf$edit$command$AddCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.AddCommand")) : class$org$eclipse$emf$edit$command$AddCommand)) {
            if (commandParameter.getEReference() != null) {
                return this.createAddCommand(domain, commandParameter.getEOwner(), commandParameter.getEReference(), commandParameter.getCollection(), commandParameter.getIndex());
            }
            return this.factorAddCommand(domain, commandParameter);
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$MoveCommand == null ? (class$org$eclipse$emf$edit$command$MoveCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.MoveCommand")) : class$org$eclipse$emf$edit$command$MoveCommand)) {
            if (commandParameter.getEReference() != null) {
                return this.createMoveCommand(domain, commandParameter.getEOwner(), commandParameter.getEReference(), commandParameter.getEValue(), commandParameter.getIndex());
            }
            return this.factorMoveCommand(domain, commandParameter);
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$ReplaceCommand == null ? (class$org$eclipse$emf$edit$command$ReplaceCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.ReplaceCommand")) : class$org$eclipse$emf$edit$command$ReplaceCommand)) {
            return this.createReplaceCommand(domain, commandParameter.getEOwner(), commandParameter.getEReference(), (EObject)commandParameter.getValue(), commandParameter.getCollection());
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$DragAndDropCommand == null ? (class$org$eclipse$emf$edit$command$DragAndDropCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.DragAndDropCommand")) : class$org$eclipse$emf$edit$command$DragAndDropCommand)) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
            return this.createDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        }
        if (commandClass == (class$org$eclipse$emf$edit$command$CreateChildCommand == null ? (class$org$eclipse$emf$edit$command$CreateChildCommand = ItemProviderAdapter.class$("org.eclipse.emf.edit.command.CreateChildCommand")) : class$org$eclipse$emf$edit$command$CreateChildCommand)) {
            CommandParameter newChildParameter = (CommandParameter)commandParameter.getValue();
            return this.createCreateChildCommand(domain, commandParameter.getEOwner(), newChildParameter.getEReference(), newChildParameter.getEValue(), newChildParameter.getIndex(), commandParameter.getCollection());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        return new SetCommand(domain, owner, feature, value);
    }

    protected Command createCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new CopyCommand(domain, owner, helper, domain.getOptimizeCopy());
    }

    protected Command createCreateCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new CreateCopyCommand(domain, owner, helper);
    }

    protected Command createInitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new InitializeCopyCommand(domain, owner, helper);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EReference feature, Collection collection) {
        return new RemoveCommand(domain, owner, (EStructuralFeature)feature, collection);
    }

    protected Command createReplaceCommand(EditingDomain domain, EObject owner, EReference feature, EObject value, Collection collection) {
        return new ReplaceCommand(domain, owner, (EStructuralFeature)feature, (Object)value, collection);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EReference feature, Collection collection, int index) {
        return new AddCommand(domain, owner, (EStructuralFeature)feature, collection, index);
    }

    protected Command createMoveCommand(EditingDomain domain, EObject owner, EReference feature, EObject value, int index) {
        return new MoveCommand(domain, owner, (EStructuralFeature)feature, value, index);
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        return new DragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EReference feature, EObject value, int index, Collection collection) {
        return new CreateChildCommand(domain, owner, feature, value, index, collection, this);
    }

    protected Command factorRemoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final EObject eObject = commandParameter.getEOwner();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        CompoundCommand removeCommand = new CompoundCommand(Integer.MAX_VALUE);
        Iterator childrenReferences = this.getChildrenReferences(eObject).iterator();
        block0: while (childrenReferences.hasNext()) {
            Object value;
            EReference eReference = (EReference)childrenReferences.next();
            if (eReference.isMany()) {
                value = (List)this.getReferenceValue(eObject, eReference);
                ArrayList childrenOfThisReference = new ArrayList();
                ListIterator objects = list.listIterator();
                while (objects.hasNext()) {
                    Object o = objects.next();
                    if (!value.contains(o)) continue;
                    childrenOfThisReference.add(o);
                    objects.remove();
                }
                if (childrenOfThisReference.isEmpty()) continue;
                removeCommand.append(this.createRemoveCommand(domain, eObject, eReference, childrenOfThisReference));
                continue;
            }
            value = this.getReferenceValue(eObject, eReference);
            ListIterator objects = list.listIterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                if (o != value) continue;
                Command setCommand = this.createSetCommand(domain, eObject, (EStructuralFeature)eReference, null);
                removeCommand.append((Command)new CommandWrapper(setCommand){
                    protected Collection affected;

                    public void execute() {
                        super.execute();
                        this.affected = Collections.singleton(eObject);
                    }

                    public void undo() {
                        super.undo();
                        this.affected = Collections.singleton(value);
                    }

                    public void redo() {
                        super.redo();
                        this.affected = Collections.singleton(eObject);
                    }

                    public Collection getResult() {
                        return Collections.singleton(value);
                    }

                    public Collection getAffectedObjects() {
                        return this.affected;
                    }
                });
                objects.remove();
                continue block0;
            }
        }
        if (list.isEmpty()) {
            return removeCommand.unwrap();
        }
        removeCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final EObject eObject = commandParameter.getEOwner();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        int index = commandParameter.getIndex();
        CompoundCommand addCommand = new CompoundCommand(Integer.MAX_VALUE);
        while (!list.isEmpty()) {
            ListIterator children = list.listIterator();
            final Object firstChild = children.next();
            EReference childReference = this.getChildReference(eObject, firstChild);
            if (childReference == null) break;
            if (childReference.isMany()) {
                ArrayList childrenOfThisReference = new ArrayList();
                childrenOfThisReference.add(firstChild);
                children.remove();
                while (children.hasNext()) {
                    Object child = children.next();
                    if (this.getChildReference(eObject, child) != childReference) continue;
                    childrenOfThisReference.add(child);
                    children.remove();
                }
                addCommand.append(this.createAddCommand(domain, eObject, childReference, childrenOfThisReference, index));
                if (index >= childrenOfThisReference.size()) {
                    index -= childrenOfThisReference.size();
                    continue;
                }
                index = -1;
                continue;
            }
            if (eObject.eGet((EStructuralFeature)childReference) != null) break;
            Command setCommand = this.createSetCommand(domain, eObject, (EStructuralFeature)childReference, firstChild);
            addCommand.append((Command)new CommandWrapper(setCommand){
                protected Collection affected;

                public void execute() {
                    super.execute();
                    this.affected = Collections.singleton(firstChild);
                }

                public void undo() {
                    super.undo();
                    this.affected = Collections.singleton(eObject);
                }

                public void redo() {
                    super.redo();
                    this.affected = Collections.singleton(firstChild);
                }

                public Collection getResult() {
                    return Collections.singleton(firstChild);
                }

                public Collection getAffectedObjects() {
                    return this.affected;
                }
            });
            children.remove();
        }
        if (list.isEmpty()) {
            return addCommand.unwrap();
        }
        addCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    protected Command factorMoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        EObject eObject = commandParameter.getEOwner();
        EObject value = commandParameter.getEValue();
        int index = commandParameter.getIndex();
        EReference childReference = this.getChildReference(eObject, value);
        if (childReference != null && childReference.isMany()) {
            ArrayList result = new ArrayList();
            Iterator childrenReferences = this.getChildrenReferences(eObject).iterator();
            while (childrenReferences.hasNext()) {
                EReference childrenReference = (EReference)childrenReferences.next();
                if (childrenReference == childReference) break;
                if (childrenReference.isMany()) {
                    index -= ((List)eObject.eGet((EStructuralFeature)childrenReference)).size();
                    continue;
                }
                if (eObject.eGet((EStructuralFeature)childrenReference) == null) continue;
                --index;
            }
            return this.createMoveCommand(domain, eObject, childReference, value, index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void setTarget(Notifier target) {
        if (this.target != null) {
            if (this.target != target) {
                if (this.targets == null) {
                    this.targets = new ArrayList();
                }
                this.targets.add(this.target);
                super.setTarget(target);
            }
        } else {
            super.setTarget(target);
        }
    }

    public void dispose() {
        if (this.target != null) {
            this.target.eAdapters().remove(this);
            if (this.targets != null) {
                Iterator i = this.targets.iterator();
                while (i.hasNext()) {
                    Notifier otherTarget = (Notifier)i.next();
                    otherTarget.eAdapters().remove(this);
                }
            }
        }
    }

    protected CommandParameter createChildParameter(Object feature, Object child) {
        return new CommandParameter(null, feature, child);
    }

    public Collection getCreateChildResult(Object child) {
        return Collections.singletonList(child);
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection selection) {
        try {
            return this.getResourceLocator().getString("_UI_CreateChild_text", new Object[]{this.getTypeText(child), this.getFeatureText(feature), this.getTypeText(owner)});
        }
        catch (MissingResourceException e) {
            return this.getResourceLocator().getString("_UI_CreateChild_label", new Object[]{this.getTypeText(child), this.getFeatureText(feature), this.getTypeText(owner)});
        }
    }

    public String getCreateChildDescription(Object owner, Object feature, Object child, Collection selection) {
        Object selectionObject;
        Object v0 = selectionObject = selection == null || selection.isEmpty() ? null : selection.iterator().next();
        if (owner != selectionObject) {
            return this.getResourceLocator().getString("_UI_CreateSibling_description", new Object[]{this.getTypeText(child), this.getFeatureText(feature), this.getTypeText(selectionObject)});
        }
        return this.getResourceLocator().getString("_UI_CreateChild_description", new Object[]{this.getTypeText(child), this.getFeatureText(feature), this.getTypeText(owner)});
    }

    public String getCreateChildToolTipText(Object owner, Object feature, Object child, Collection selection) {
        return this.getResourceLocator().getString("_UI_CreateChild_tooltip", new Object[]{this.getTypeText(child), this.getFeatureText(feature), this.getTypeText(owner)});
    }

    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
        String name = "full/ctool16/CreateChild";
        if (feature instanceof EReference && child instanceof EObject) {
            EReference reference = (EReference)feature;
            EClass parentClass = reference.getEContainingClass();
            EClass childClass = ((EObject)child).eClass();
            name = "full/ctool16/Create" + parentClass.getName() + "_" + reference.getName() + "_" + childClass.getName();
        }
        return this.getResourceLocator().getImage(name);
    }

    protected String getTypeText(Object object) {
        if (object instanceof EObject) {
            String typeKey = ((EObject)object).eClass().getName();
            try {
                return this.getResourceLocator(object).getString("_UI_" + typeKey + "_type");
            }
            catch (MissingResourceException e) {
                return typeKey;
            }
        }
        return this.getString("_UI_Unknown_type");
    }

    protected String getFeatureText(Object feature) {
        String featureKey;
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            featureKey = reference.getEContainingClass().getName() + "_" + reference.getName();
        } else {
            featureKey = "Unknown";
        }
        return this.getResourceLocator().getString("_UI_" + featureKey + "_feature");
    }

    protected ResourceLocator getResourceLocator() {
        return EMFEditPlugin.INSTANCE;
    }

    protected ResourceLocator getResourceLocator(Object anyObject) {
        Object adapter;
        if (this.adapterFactory instanceof ComposeableAdapterFactory && (adapter = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory().adapt(anyObject, class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? (class$org$eclipse$emf$edit$provider$IItemLabelProvider = ItemProviderAdapter.class$("org.eclipse.emf.edit.provider.IItemLabelProvider")) : class$org$eclipse$emf$edit$provider$IItemLabelProvider)) instanceof ResourceLocator) {
            return (ResourceLocator)adapter;
        }
        return this.getResourceLocator();
    }

    public URL getBaseURL() {
        return this.getResourceLocator().getBaseURL();
    }

    public Object getImage(String key) {
        return this.getResourceLocator().getImage(key);
    }

    public String getString(String key) {
        return this.getResourceLocator().getString(key);
    }

    public String getString(String key, Object[] substitutions) {
        return this.getResourceLocator().getString(key, substitutions);
    }

    protected String getString(String key, String s0) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator.getString(key, new Object[]{resourceLocator.getString(s0)});
    }

    protected String getString(String key, String s0, String s1) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator.getString(key, new Object[]{resourceLocator.getString(s0), resourceLocator.getString(s1)});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

