/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JMerger;

public class CodeGen
implements IPlatformRunnable {
    public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IPath localLocation, IProgressMonitor progressMonitor) throws CoreException {
        String projectName = path.segment(0);
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        projectDescription.setLocation(localLocation);
        return CodeGen.findOrCreateContainer(path, forceRefresh, projectDescription, progressMonitor);
    }

    public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IProjectDescription projectDescription, IProgressMonitor progressMonitor) throws CoreException {
        IProject iProject;
        try {
            String projectName = path.segment(0);
            progressMonitor.beginTask("", path.segmentCount() + 3);
            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_ExaminingProject_message", new Object[]{projectName}));
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(path.segment(0));
            if (forceRefresh) {
                project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                progressMonitor.worked(1);
            }
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 2));
            }
            IProject container = project;
            int i = 1;
            int length = path.segmentCount();
            while (i < length) {
                IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                if (!folder.exists()) {
                    folder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    progressMonitor.worked(1);
                }
                container = folder;
                ++i;
            }
            iProject = container;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return iProject;
    }

    public Object run(Object object) {
        try {
            final String[] arguments = (String[])object;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            String templateFile = arguments[0];
                            File file = new File(templateFile);
                            if (file.exists()) {
                                templateFile = file.getAbsoluteFile().toURL().toString();
                            }
                            Path targetPath = new Path(new File(arguments[1]).getAbsolutePath());
                            progressMonitor.beginTask("", 5);
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_CompilingTemplate_message", new Object[]{templateFile}));
                            JControlModel jControlModel = arguments.length > 2 ? new JControlModel(arguments[2]) : null;
                            progressMonitor.worked(1);
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_ParsingTemplate_message", new Object[]{templateFile}));
                            JETCompiler jetCompiler = new JETCompiler(templateFile);
                            jetCompiler.parse();
                            progressMonitor.worked(1);
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_GeneratingJava_message", new Object[]{templateFile}));
                            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                            jetCompiler.generate(outputStream);
                            ByteArrayInputStream contents = new ByteArrayInputStream(outputStream.toByteArray());
                            progressMonitor.worked(1);
                            Path projectTargetPath = new Path("/Result/" + jetCompiler.getSkeleton().getPackageName().replace('.', '/'));
                            IContainer container = CodeGen.findOrCreateContainer((IPath)projectTargetPath, true, (IPath)targetPath, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            IFile targetFile = container.getFile((IPath)new Path(jetCompiler.getSkeleton().getClassName() + ".java"));
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_Updating_message", new Object[]{targetFile.getLocation()}));
                            if (targetFile.exists()) {
                                if (jControlModel != null) {
                                    JMerger jMerger = new JMerger();
                                    jMerger.setControlModel(jControlModel);
                                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(outputStream.toString()));
                                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForURI(targetPath.toString()));
                                    jMerger.merge();
                                    ByteArrayInputStream mergedContents = new ByteArrayInputStream(jMerger.getTargetCompilationUnit().getContents().getBytes());
                                    targetFile.setContents((InputStream)mergedContents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        }
                        catch (MalformedURLException exception) {
                            System.err.println(CodeGenPlugin.getPlugin().getString("_UI_BadURL_message", new Object[]{arguments[0]}));
                            exception.printStackTrace();
                            Object var15_16 = null;
                            progressMonitor.done();
                            return;
                        }
                        Object var15_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_17 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            };
            workspace.run(runnable, (IProgressMonitor)new StreamProgressMonitor(System.out));
            return new Integer(0);
        }
        catch (Exception exception) {
            System.err.println(CodeGenPlugin.getPlugin().getString("_UI_UsageArguments_message"));
            exception.printStackTrace();
            return new Integer(1);
        }
    }

    public static class StreamProgressMonitor
    extends NullProgressMonitor {
        protected PrintStream printStream;

        public StreamProgressMonitor(PrintStream printStream) {
            this.printStream = printStream;
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() != 0) {
                this.printStream.println(">>> " + name);
            }
            super.beginTask(name, totalWork);
        }

        public void setTaskName(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println("<>> " + name);
            }
            super.setTaskName(name);
        }

        public void subTask(String name) {
            if (name != null && name.length() != 0) {
                this.printStream.println(">>  " + name);
            }
            super.subTask(name);
        }
    }
}

