/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.EMFProjectWizard;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditor;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GenModelActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IMenuManager generateMenuManager;
    protected Action reloadAction = new ReloadAction();
    protected Action generateAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateModel_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerate();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            genObject.generate(progressMonitor);
        }
    };
    protected Action generateEditAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateEdit_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerateEdit();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            genObject.generateEdit(progressMonitor);
        }
    };
    protected Action generateEditorAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateEditor_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerateEditor();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            genObject.generateEditor(progressMonitor);
        }
    };
    protected Action generateAllAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateAll_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerate() || genObject.canGenerateEdit() || genObject.canGenerateEditor();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            progressMonitor.beginTask("", 3);
            genObject.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            genObject.generateEdit((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            genObject.generateEditor((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
    };

    protected ISelection getActiveEditorSelection() {
        return this.activeEditorPart == null ? null : ((GenModelEditor)this.activeEditorPart).getSelection();
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        this.generateMenuManager = new MenuManager(GenModelEditPlugin.INSTANCE.getString("_UI_Generate_menu"), "org.eclipse.emf.codegen.ecore.genmodelMenuID");
        menuManager.insertAfter("additions", (IContributionItem)this.generateMenuManager);
        this.generateMenuManager.add((IAction)this.generateAction);
        this.generateMenuManager.add((IAction)this.generateEditAction);
        this.generateMenuManager.add((IAction)this.generateEditorAction);
        this.generateMenuManager.add((IAction)this.generateAllAction);
        this.generateMenuManager.add((IContributionItem)new Separator("global-actions"));
        this.generateMenuManager.add((IAction)this.reloadAction);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("genmodel-settings"));
        toolBarManager.add((IContributionItem)new Separator("genmodel-additions"));
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IContributionItem[] items = this.generateMenuManager.getItems();
        int i = 0;
        int len = items.length;
        while (i < len) {
            items[i].update();
            ++i;
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        menuManager.insertAfter("additions", (IAction)this.generateAllAction);
        menuManager.insertAfter("additions", (IAction)this.generateEditorAction);
        menuManager.insertAfter("additions", (IAction)this.generateEditAction);
        menuManager.insertAfter("additions", (IAction)this.generateAction);
    }

    protected abstract class GenerateAction
    extends Action {
        public GenerateAction(String text) {
            super(text);
        }

        protected abstract boolean canGenerate(GenBase var1);

        protected abstract void generate(GenBase var1, IProgressMonitor var2);

        public boolean isEnabled() {
            ISelection s = GenModelActionBarContributor.this.getActiveEditorSelection();
            if (!(s instanceof IStructuredSelection)) {
                return false;
            }
            IStructuredSelection ss = (IStructuredSelection)s;
            if (ss.size() == 0) {
                return false;
            }
            Iterator iter = ss.iterator();
            while (iter.hasNext()) {
                Object selected = iter.next();
                if (selected instanceof GenBase && this.canGenerate((GenBase)selected)) continue;
                return false;
            }
            return true;
        }

        public void run() {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(this){
                private final /* synthetic */ GenerateAction this$1;
                {
                    this.this$1 = this$1;
                }

                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    List selection = ((IStructuredSelection)GenerateAction.access$000(this.this$1).getActiveEditorSelection()).toList();
                    progressMonitor.beginTask("", selection.size());
                    try {
                        Iterator<E> iter = selection.iterator();
                        while (iter.hasNext()) {
                            this.this$1.generate((GenBase)iter.next(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        }
                    }
                    catch (Exception exception) {
                        GenModelEditPlugin.INSTANCE.log(exception);
                    }
                    progressMonitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(GenModelActionBarContributor.this.activeEditorPart.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
        }

        static /* synthetic */ GenModelActionBarContributor access$000(GenerateAction x0) {
            return x0.GenModelActionBarContributor.this;
        }
    }

    protected class ReloadAction
    extends Action {
        public ReloadAction() {
            super(GenModelEditPlugin.INSTANCE.getString("_UI_GenModel_Reload"));
        }

        public void run() {
            IFile file = ((IFileEditorInput)GenModelActionBarContributor.this.activeEditorPart.getEditorInput()).getFile();
            EMFProjectWizard emfProjectWizard = new EMFProjectWizard(file);
            WizardDialog wizardDialog = new WizardDialog(GenModelActionBarContributor.this.activeEditorPart.getEditorSite().getShell(), (IWizard)emfProjectWizard);
            wizardDialog.create();
            wizardDialog.getShell().setSize(540, 580);
            int result = wizardDialog.open();
            ((GenModelEditor)GenModelActionBarContributor.this.activeEditorPart).handleActivate();
        }
    }
}

