/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class EditingDomainActionBarContributor
extends MultiPageEditorActionBarContributor
implements IMenuListener,
IPropertyListener {
    protected IEditorPart activeEditor;
    protected DeleteAction deleteAction;
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected UndoAction undoAction;
    protected RedoAction redoAction;

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        this.deleteAction = new DeleteAction();
        actionBars.setGlobalActionHandler("delete", (IAction)this.deleteAction);
        this.cutAction = new CutAction();
        actionBars.setGlobalActionHandler("cut", (IAction)this.cutAction);
        this.copyAction = new CopyAction();
        actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        this.pasteAction = new PasteAction();
        actionBars.setGlobalActionHandler("paste", (IAction)this.pasteAction);
        this.undoAction = new UndoAction();
        actionBars.setGlobalActionHandler("undo", (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        actionBars.setGlobalActionHandler("redo", (IAction)this.redoAction);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        if (!(page instanceof IPropertySheetPage)) {
            actionBars.setGlobalActionHandler("delete", (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler("cut", (IAction)this.cutAction);
            actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
            actionBars.setGlobalActionHandler("paste", (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler("undo", (IAction)this.undoAction);
        actionBars.setGlobalActionHandler("redo", (IAction)this.redoAction);
    }

    public void setActiveView(IViewPart part) {
        IActionBars actionBars = part.getViewSite().getActionBars();
        if (!(part instanceof PropertySheet)) {
            actionBars.setGlobalActionHandler("delete", (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler("cut", (IAction)this.cutAction);
            actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
            actionBars.setGlobalActionHandler("paste", (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler("undo", (IAction)this.undoAction);
        actionBars.setGlobalActionHandler("redo", (IAction)this.redoAction);
        actionBars.updateActionBars();
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != this.activeEditor) {
            if (this.activeEditor != null) {
                this.deactivate();
            }
            if (part instanceof IEditingDomainProvider) {
                this.activeEditor = part;
                this.activate();
            }
        }
    }

    public void setActivePage(IEditorPart part) {
    }

    public void deactivate() {
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveEditor(null);
        this.cutAction.setActiveEditor(null);
        this.copyAction.setActiveEditor(null);
        this.pasteAction.setActiveEditor(null);
        this.undoAction.setActiveEditor(null);
        this.redoAction.setActiveEditor(null);
        ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
    }

    public void activate() {
        this.activeEditor.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveEditor(this.activeEditor);
        this.cutAction.setActiveEditor(this.activeEditor);
        this.copyAction.setActiveEditor(this.activeEditor);
        this.pasteAction.setActiveEditor(this.activeEditor);
        this.undoAction.setActiveEditor(this.activeEditor);
        this.redoAction.setActiveEditor(this.activeEditor);
        ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        this.update();
    }

    public void update() {
        ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
        this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
        this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.undoAction.update();
        this.redoAction.update();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        menuManager.add((IContributionItem)new Separator("additions-end"));
    }

    public void propertyChanged(Object source, int id) {
        this.update();
    }
}

