/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.viewer;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ExtendedTableTreeViewer
extends TableTreeViewer {
    public static final String ITEM_ID = "TableTreeItemID";
    protected int offset;
    protected int indent;
    protected String imagePadding;
    protected int imagePaddingWidth;

    public ExtendedTableTreeViewer(TableTree tableTree) {
        super(tableTree);
    }

    public ExtendedTableTreeViewer(Composite parent) {
        super(parent);
    }

    public ExtendedTableTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected Item newItem(Widget parent, int flags, int index) {
        ExtendedTableTreeItem item = index >= 0 ? (parent instanceof TableTreeItem ? new ExtendedTableTreeItem((TableTreeItem)parent, flags, index) : new ExtendedTableTreeItem((TableTree)parent, flags, index)) : (parent instanceof TableTreeItem ? new ExtendedTableTreeItem((TableTreeItem)parent, flags) : new ExtendedTableTreeItem((TableTree)parent, flags));
        return item;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.getTableTree().getTable().addPaintListener(new PaintListener(){
            protected boolean isStarted;
            protected TableTreeItem firstTableTreeItem;
            protected TableTreeItem lastTableTreeItem;
            protected LinkedList chain;
            protected int scrollX;

            public void paintControl(PaintEvent event) {
                Table table = (Table)event.getSource();
                TableItem[] items = table.getItems();
                this.firstTableTreeItem = null;
                this.lastTableTreeItem = null;
                ExtendedTableTreeViewer.this.offset = 0;
                int i = table.getTopIndex();
                while (i < items.length) {
                    TableItem tableItem = items[i];
                    ExtendedTableTreeItem tableTreeItem = (ExtendedTableTreeItem)((Object)tableItem.getData(ExtendedTableTreeViewer.ITEM_ID));
                    if (!tableTreeItem.isDisposed()) {
                        Image image;
                        Rectangle bounds;
                        if (this.firstTableTreeItem == null) {
                            this.firstTableTreeItem = tableTreeItem;
                        }
                        this.lastTableTreeItem = tableTreeItem;
                        if (ExtendedTableTreeViewer.this.offset == 0) {
                            Rectangle interactorBounds = tableItem.getImageBounds(0);
                            ExtendedTableTreeViewer.this.offset = interactorBounds.width;
                            ExtendedTableTreeViewer.this.indent = Math.min(6, (ExtendedTableTreeViewer.this.offset - 8) / 2);
                        }
                        if ((bounds = tableTreeItem.getBounds(0)) != null && (image = tableTreeItem.getFirstImage()) != null) {
                            Rectangle imageBounds = image.getBounds();
                            imageBounds.x = bounds.x + ExtendedTableTreeViewer.this.offset;
                            imageBounds.y = bounds.y;
                            imageBounds.width = ExtendedTableTreeViewer.this.imagePaddingWidth;
                            event.gc.fillRectangle(imageBounds);
                            event.gc.drawImage(image, imageBounds.x + 5, imageBounds.y);
                            if (imageBounds.y + imageBounds.height > event.y + event.height) break;
                        }
                    }
                    ++i;
                }
                if (this.firstTableTreeItem != null) {
                    this.isStarted = false;
                    this.chain = new LinkedList();
                    event.gc.setForeground(table.getDisplay().getSystemColor(18));
                    this.scrollX = items[0].getBounds((int)0).x;
                    this.paintLines(event.gc, ExtendedTableTreeViewer.this.getTableTree().getItems());
                }
            }

            protected boolean paintLines(GC gc, TableTreeItem[] tableTreeItems) {
                if (tableTreeItems != null) {
                    int i = 0;
                    while (i < tableTreeItems.length) {
                        TableTreeItem tableTreeItem = tableTreeItems[i];
                        if (!this.isStarted && tableTreeItem == this.firstTableTreeItem) {
                            this.isStarted = true;
                        }
                        if (this.isStarted) {
                            Rectangle bounds = tableTreeItem.getBounds(0);
                            int x = 1 + this.scrollX;
                            Iterator j = this.chain.iterator();
                            while (j.hasNext()) {
                                TableTreeItem ancestor = (TableTreeItem)j.next();
                                if (ancestor != null) {
                                    gc.drawLine(x + ExtendedTableTreeViewer.this.offset / 2, bounds.y, x + ExtendedTableTreeViewer.this.offset / 2, bounds.y + bounds.height);
                                }
                                x += ExtendedTableTreeViewer.this.offset;
                            }
                            if (i + 1 == tableTreeItems.length) {
                                if (i != 0 || !this.chain.isEmpty()) {
                                    gc.drawLine(x + ExtendedTableTreeViewer.this.offset / 2, bounds.y, x + ExtendedTableTreeViewer.this.offset / 2, bounds.y + (tableTreeItem.getItemCount() > 0 ? ExtendedTableTreeViewer.this.indent - 1 : bounds.height / 2));
                                }
                            } else if (tableTreeItem.getItemCount() > 0) {
                                gc.drawLine(x + ExtendedTableTreeViewer.this.offset / 2, bounds.y, x + ExtendedTableTreeViewer.this.offset / 2, bounds.y + ExtendedTableTreeViewer.this.indent - 1);
                                gc.drawLine(x + ExtendedTableTreeViewer.this.offset / 2, bounds.y + bounds.height - ExtendedTableTreeViewer.this.indent + 2, x + ExtendedTableTreeViewer.this.offset / 2, bounds.y + bounds.height);
                            } else {
                                gc.drawLine(x + ExtendedTableTreeViewer.this.offset / 2, bounds.y, x + ExtendedTableTreeViewer.this.offset / 2, bounds.y + bounds.height);
                            }
                            gc.drawLine(x + (tableTreeItem.getItemCount() > 0 ? ExtendedTableTreeViewer.this.offset - ExtendedTableTreeViewer.this.indent + 1 : ExtendedTableTreeViewer.this.offset / 2), bounds.y + (bounds.height + 1) / 2, x + ExtendedTableTreeViewer.this.offset + 2, bounds.y + (bounds.height + 1) / 2);
                        }
                        if (tableTreeItem.getExpanded()) {
                            this.chain.addLast(i + 1 == tableTreeItems.length ? null : tableTreeItem);
                            if (!this.paintLines(gc, tableTreeItem.getItems())) {
                                return false;
                            }
                            this.chain.removeLast();
                        }
                        if (this.isStarted && tableTreeItem == this.lastTableTreeItem) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
        });
    }

    protected void createImagePadding(int width) {
        GC gc = new GC((Drawable)this.getTableTree().getTable());
        this.imagePadding = " ";
        while ((this.imagePaddingWidth = gc.stringExtent((String)this.imagePadding).x) < width + 6) {
            this.imagePadding = this.imagePadding + " ";
        }
        gc.dispose();
        TableItem[] tableItems = this.getTableTree().getTable().getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableTreeItem tableTreeItem = (TableTreeItem)tableItems[i].getData(ITEM_ID);
            tableTreeItem.setText(0, tableTreeItem.getText(0));
            ++i;
        }
    }

    public class ExtendedTableTreeItem
    extends TableTreeItem {
        protected Image firstImage;

        public ExtendedTableTreeItem(TableTree parent, int style) {
            super(parent, style);
        }

        public ExtendedTableTreeItem(TableTree parent, int style, int index) {
            super(parent, style, index);
        }

        public ExtendedTableTreeItem(TableTreeItem parent, int style) {
            super(parent, style);
        }

        public ExtendedTableTreeItem(TableTreeItem parent, int style, int index) {
            super(parent, style, index);
        }

        public void setText(int index, String text) {
            if (index == 0 && ExtendedTableTreeViewer.this.imagePadding != null) {
                if (text != null && text.indexOf(ExtendedTableTreeViewer.this.imagePadding) == 0) {
                    super.setText(0, text);
                } else {
                    super.setText(0, ExtendedTableTreeViewer.this.imagePadding + text);
                }
            } else {
                super.setText(index, text);
            }
        }

        public String getText(int index) {
            String result = super.getText(index);
            if (index == 0 && result != null && ExtendedTableTreeViewer.this.imagePadding != null && result.indexOf(ExtendedTableTreeViewer.this.imagePadding) == 0) {
                result = result.substring(ExtendedTableTreeViewer.this.imagePadding.length());
            }
            return result;
        }

        public void setImage(int index, Image image) {
            if (index == 0) {
                this.firstImage = image;
                if (image != null && ExtendedTableTreeViewer.this.imagePadding == null) {
                    ExtendedTableTreeViewer.this.createImagePadding(image.getBounds().width);
                }
            } else {
                super.setImage(index, image);
            }
        }

        public Image getFirstImage() {
            return this.firstImage;
        }

        public int getImagePaddingWidth() {
            return ExtendedTableTreeViewer.this.imagePaddingWidth;
        }
    }
}

