/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.command.AddMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class CreateMappingCommand
extends AbstractCommand {
    public static final int ENABLE_MULTIPLE_INPUTS = 1;
    public static final int ENABLE_MULTIPLE_OUTPUTS = 2;
    public static final int ENABLE_MAPPED_INPUTS = 4;
    public static final int ENABLE_MAPPED_OUTPUTS = 8;
    public static final int ENABLE_INCOMPATIBLE_METAOBJECTS = 16;
    public static final int ENABLE_INCOMPATIBLE_TYPE_CLASSIFIERS = 32;
    public static final int ENABLE_EMPTY_INPUTS = 64;
    public static final int ENABLE_EMPTY_OUTPUTS = 128;
    public static final int ENABLE_UNMAPPED_PARENTS = 256;
    public static final int ENABLE_ALL = 65535;
    protected static final String LABEL = MappingPlugin.getPlugin().getString("_UI_CreateMappingCommand_label");
    protected static final String DESCRIPTION = MappingPlugin.getPlugin().getString("_UI_CreateMappingCommand_description");
    protected MappingDomain domain;
    protected Collection inputs;
    protected Collection outputs;
    protected Mapping newMapping;
    protected Command subcommand;
    static /* synthetic */ Class class$org$eclipse$emf$mapping$command$CreateMappingCommand;

    public static Command create(MappingDomain domain, Collection collection) {
        return domain.createCommand(class$org$eclipse$emf$mapping$command$CreateMappingCommand == null ? (class$org$eclipse$emf$mapping$command$CreateMappingCommand = CreateMappingCommand.class$("org.eclipse.emf.mapping.command.CreateMappingCommand")) : class$org$eclipse$emf$mapping$command$CreateMappingCommand, new CommandParameter((Object)domain.getMappingRoot(), null, collection));
    }

    public static Command create(MappingDomain domain, Object input, Object output) {
        ArrayList<Object> collection = new ArrayList<Object>();
        collection.add(input);
        collection.add(output);
        return CreateMappingCommand.create(domain, collection);
    }

    public static Command create(MappingDomain domain, Collection inputs, Collection outputs) {
        ArrayList collection = new ArrayList();
        collection.addAll(inputs);
        collection.addAll(outputs);
        return CreateMappingCommand.create(domain, collection);
    }

    public static Command create(MappingDomain domain, Collection inputs, Object output) {
        ArrayList<Object> collection = new ArrayList<Object>();
        collection.addAll(inputs);
        collection.add(output);
        return CreateMappingCommand.create(domain, collection);
    }

    public static Command create(MappingDomain domain, Object input, Collection outputs) {
        ArrayList<Object> collection = new ArrayList<Object>();
        collection.add(input);
        collection.addAll(outputs);
        return CreateMappingCommand.create(domain, collection);
    }

    public CreateMappingCommand(MappingDomain domain, Collection collection, int enablementFlags) {
        this(domain, collection);
    }

    public CreateMappingCommand(MappingDomain domain, Collection collection) {
        super(LABEL, DESCRIPTION);
        this.domain = domain;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            Object object = objects.next();
            if (domain.getMappingRoot().isInputObject(object)) {
                this.inputs.add(object);
                continue;
            }
            if (domain.getMappingRoot().isOutputObject(object)) {
                this.outputs.add(object);
                continue;
            }
            this.outputs = null;
            this.inputs = null;
            break;
        }
    }

    protected boolean prepare() {
        boolean result = this.domain != null && this.inputs != null && this.outputs != null && this.domain.getMappingRoot().canCreateMapping(this.inputs, this.outputs, null);
        return result;
    }

    public void execute() {
        this.newMapping = this.domain.getMappingRoot().createMapping(this.inputs, this.outputs);
        StrictCompoundCommand subcommands = new StrictCompoundCommand();
        subcommands.appendAndExecute(AddMappingCommand.create(this.domain, this.newMapping));
        this.subcommand = subcommands.unwrap();
    }

    public void undo() {
        this.subcommand.undo();
    }

    public void redo() {
        this.subcommand.redo();
    }

    public Collection getResult() {
        return Collections.singleton(this.newMapping);
    }

    public Collection getAffectedObjects() {
        return Collections.singleton(this.newMapping);
    }

    public void dispose() {
        if (this.subcommand != null) {
            this.subcommand.dispose();
        }
        super.dispose();
    }

    public String getLabel() {
        if (this.inputs == null || this.inputs.isEmpty() || this.outputs == null || this.outputs.isEmpty()) {
            return MappingPlugin.getPlugin().getString("_UI_CreateMappingCommand_onesided_label");
        }
        return super.getLabel();
    }

    public String getDescription() {
        if (this.inputs == null || this.inputs.isEmpty() || this.outputs == null || this.outputs.isEmpty()) {
            return MappingPlugin.getPlugin().getString("_UI_CreateMappingCommand_onesided_description");
        }
        return super.getDescription();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (inputs: " + this.inputs + ")");
        result.append(" (outputs: " + this.outputs + ")");
        result.append(" (newMapping: " + this.newMapping + ")");
        result.append(" (subcommand: " + this.subcommand + ")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

