/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.OverrideableCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.AddOverrideCommand;
import org.eclipse.emf.mapping.command.CopyToClipboardOverrideCommand;
import org.eclipse.emf.mapping.command.CreateCopyOverrideCommand;
import org.eclipse.emf.mapping.command.CreateMappingCommand;
import org.eclipse.emf.mapping.command.DragAndDropOverrideCommand;
import org.eclipse.emf.mapping.command.InitializeCopyOverrideCommand;
import org.eclipse.emf.mapping.command.PasteFromClipboardOverrideCommand;
import org.eclipse.emf.mapping.command.PersistentCommandStack;
import org.eclipse.emf.mapping.command.RemoveOverrideCommand;
import org.eclipse.emf.mapping.command.SetOverrideCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.provider.MappedObjectItemProvider;

public class AdapterFactoryMappingDomain
extends AdapterFactoryEditingDomain
implements MappingDomain {
    public static final int LABEL_UPPER = 1;
    public static final int LABEL_LOWER = 2;
    public static final int LABEL_MIXED = 3;
    public static final char LABEL_NO_SEPARATOR = '\u0000';
    protected HashMap topToBottomTypeTable = new HashMap();
    protected HashMap bottomToTopTypeTable = new HashMap();
    protected char topLabelSeparator = '\u0000';
    protected char bottomLabelSeparator = '\u0000';
    protected int topLabelCase = 3;
    protected int bottomLabelCase = 3;
    protected List topLabelLongForms = new ArrayList();
    protected List bottomLabelLongForms = new ArrayList();
    protected List topLabelShortForms = new ArrayList();
    protected List bottomLabelShortForms = new ArrayList();
    protected char packageTypeSeparator = (char)124;
    protected MappingRoot mappingRoot;
    protected boolean isSameEditingDomainAdapterFactory;
    protected PersistentCommandStack persistentCommandStack;
    protected int mappingEnablementFlags = 0;
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemLabelProvider;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$SetCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$RemoveCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$AddCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$MoveCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$ReplaceCommand;

    public AdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory editingDomainAdapterFactory, CommandStack commandStack) {
        this(mappingDomainAdapterFactory, editingDomainAdapterFactory, editingDomainAdapterFactory, commandStack);
    }

    public AdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory editingDomainAdapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        this(mappingDomainAdapterFactory, editingDomainAdapterFactory, editingDomainAdapterFactory, commandStack, resourceSet);
    }

    public AdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory, CommandStack commandStack) {
        super(null, commandStack);
        this.adapterFactory = this.createComposedAdapterFactory(mappingDomainAdapterFactory, topDomainAdapterFactory, bottomDomainAdapterFactory);
        boolean bl = this.isSameEditingDomainAdapterFactory = topDomainAdapterFactory == bottomDomainAdapterFactory;
        if (commandStack instanceof PersistentCommandStack) {
            this.persistentCommandStack = (PersistentCommandStack)commandStack;
        }
    }

    public AdapterFactoryMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(null, commandStack, resourceSet);
        this.adapterFactory = this.createComposedAdapterFactory(mappingDomainAdapterFactory, topDomainAdapterFactory, bottomDomainAdapterFactory);
        boolean bl = this.isSameEditingDomainAdapterFactory = topDomainAdapterFactory == bottomDomainAdapterFactory;
        if (commandStack instanceof PersistentCommandStack) {
            this.persistentCommandStack = (PersistentCommandStack)commandStack;
        }
    }

    protected ComposedAdapterFactory createComposedAdapterFactory(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory) {
        AdapterFactory[] adapterFactories = topDomainAdapterFactory == bottomDomainAdapterFactory ? new AdapterFactory[]{mappingDomainAdapterFactory, new LabelUpdatePropagatingComposedAdapterFactory(topDomainAdapterFactory)} : new AdapterFactory[]{mappingDomainAdapterFactory, new LabelUpdatePropagatingComposedAdapterFactory(topDomainAdapterFactory), new LabelUpdatePropagatingComposedAdapterFactory(bottomDomainAdapterFactory)};
        return this.createComposedAdapterFactory(adapterFactories);
    }

    protected ComposedAdapterFactory createComposedAdapterFactory(AdapterFactory[] adapterFactories) {
        return new EditingDomainProvidingComposedAdapterFactory(adapterFactories, (EditingDomain)this);
    }

    public String getOutputName(String inputName) {
        if (this.isSameEditingDomainAdapterFactory) {
            return inputName;
        }
        if (this.mappingRoot.isTopToBottom()) {
            return this.convertName(inputName, this.topLabelSeparator, this.topLabelCase, this.topLabelShortForms, this.topLabelLongForms, this.bottomLabelSeparator, this.bottomLabelCase, this.bottomLabelShortForms, this.bottomLabelLongForms);
        }
        return this.convertName(inputName, this.bottomLabelSeparator, this.bottomLabelCase, this.bottomLabelShortForms, this.bottomLabelLongForms, this.topLabelSeparator, this.topLabelCase, this.topLabelShortForms, this.topLabelLongForms);
    }

    public List parseOutputName(String outputName) {
        if (this.mappingRoot.isTopToBottom()) {
            return this.parseName(outputName, this.bottomLabelSeparator);
        }
        return this.parseName(outputName, this.topLabelSeparator);
    }

    public List parseInputName(String inputName) {
        if (this.mappingRoot.isTopToBottom()) {
            return this.parseName(inputName, this.topLabelSeparator);
        }
        return this.parseName(inputName, this.bottomLabelSeparator);
    }

    public String getName(Object object) {
        if (object instanceof ENamedElement) {
            return ((ENamedElement)object).getName();
        }
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, (Object)(class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? (class$org$eclipse$emf$edit$provider$IItemLabelProvider = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.provider.IItemLabelProvider")) : class$org$eclipse$emf$edit$provider$IItemLabelProvider));
        return itemLabelProvider != null ? itemLabelProvider.getText(object) : null;
    }

    public void setName(Object object, String name) {
        if (object instanceof ENamedElement) {
            ((ENamedElement)object).setName(name);
        }
    }

    public EObject getOutputMetaObject(EObject inputMetaObject) {
        if (this.isSameEditingDomainAdapterFactory) {
            return inputMetaObject;
        }
        return this.getCorrespondingType(inputMetaObject, this.mappingRoot.isTopToBottom() ? this.topToBottomTypeTable : this.bottomToTopTypeTable);
    }

    public MappingRoot getMappingRoot() {
        return this.mappingRoot;
    }

    public void setMappingRoot(MappingRoot mappingRoot) {
        if (this.mappingRoot != mappingRoot) {
            this.mappingRoot = mappingRoot;
        }
    }

    public Object getTypeClassifier(Object mappedObject) {
        if (mappedObject instanceof ETypedElement) {
            return ((ETypedElement)mappedObject).getEType();
        }
        return null;
    }

    public void setTypeClassifier(Object mappedObject, Object typeClassifier) {
        if (mappedObject instanceof ETypedElement) {
            ((ETypedElement)mappedObject).setEType((EClassifier)typeClassifier);
        }
    }

    public Object getOutputTypeClassifier(Object inputType) {
        Collection mappings;
        Object outputType = null;
        MappingRoot typeMappingRoot = this.mappingRoot.getTypeMappingRoot();
        if (typeMappingRoot != null && (mappings = typeMappingRoot.getMappings(inputType)).size() == 1) {
            Mapping typeMapping = (Mapping)mappings.iterator().next();
            outputType = typeMapping.getOutputs().iterator().next();
        }
        return outputType;
    }

    public int getMappingEnablementFlags() {
        return this.mappingEnablementFlags;
    }

    public void setMappingEnablementFlags(int mappingEnablementFlags) {
        this.mappingEnablementFlags = mappingEnablementFlags;
    }

    public void handleCreateCommand(Class commandClass, CommandParameter commandParameter, Command command) {
        if (this.persistentCommandStack != null) {
            this.persistentCommandStack.handleCreateCommand(commandClass, commandParameter, command);
        }
    }

    public Command createCommand(Class commandClass, CommandParameter commandParameter) {
        if (commandClass == (class$org$eclipse$emf$edit$command$SetCommand == null ? (class$org$eclipse$emf$edit$command$SetCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.SetCommand")) : class$org$eclipse$emf$edit$command$SetCommand) && !(commandParameter.getOwner() instanceof Mapping) && !(commandParameter.getOwner() instanceof MappedObjectItemProvider) && commandParameter.getFeature() == null && commandParameter.getValue() instanceof Collection) {
            boolean inputToOutput = this.mappingRoot.isOutputObject(commandParameter.getOwner());
            boolean okay = true;
            Iterator objects = ((Collection)commandParameter.getValue()).iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (this.mappingRoot.isInputObject(object) == inputToOutput) continue;
                okay = false;
            }
            if (okay) {
                ArrayList<Object> mappedObjects = new ArrayList<Object>((Collection)commandParameter.getValue());
                mappedObjects.add(commandParameter.getOwner());
                return CreateMappingCommand.create(this, mappedObjects);
            }
        } else if (commandClass == (class$org$eclipse$emf$edit$command$RemoveCommand == null ? (class$org$eclipse$emf$edit$command$RemoveCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.RemoveCommand")) : class$org$eclipse$emf$edit$command$RemoveCommand) && commandParameter.getOwner() == null) {
            Collection collection = commandParameter.getCollection();
            if (this.mappingRoot.getMappedObjects().containsAll(collection)) {
                commandParameter.setOwner((Object)this.mappingRoot);
            }
        }
        if ((this.mappingRoot.isInputObject(commandParameter.getOwner()) || this.mappingRoot.isOutputReadOnly() && this.mappingRoot.isOutputObject(commandParameter.getOwner())) && (commandClass == (class$org$eclipse$emf$edit$command$AddCommand == null ? (class$org$eclipse$emf$edit$command$AddCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.AddCommand")) : class$org$eclipse$emf$edit$command$AddCommand) || commandClass == (class$org$eclipse$emf$edit$command$MoveCommand == null ? (class$org$eclipse$emf$edit$command$MoveCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.MoveCommand")) : class$org$eclipse$emf$edit$command$MoveCommand) || commandClass == (class$org$eclipse$emf$edit$command$RemoveCommand == null ? (class$org$eclipse$emf$edit$command$RemoveCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.RemoveCommand")) : class$org$eclipse$emf$edit$command$RemoveCommand) || commandClass == (class$org$eclipse$emf$edit$command$ReplaceCommand == null ? (class$org$eclipse$emf$edit$command$ReplaceCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.ReplaceCommand")) : class$org$eclipse$emf$edit$command$ReplaceCommand) || commandClass == (class$org$eclipse$emf$edit$command$SetCommand == null ? (class$org$eclipse$emf$edit$command$SetCommand = AdapterFactoryMappingDomain.class$("org.eclipse.emf.edit.command.SetCommand")) : class$org$eclipse$emf$edit$command$SetCommand))) {
            return UnexecutableCommand.INSTANCE;
        }
        Command result = super.createCommand(commandClass, commandParameter);
        this.handleCreateCommand(commandClass, commandParameter, result);
        return result;
    }

    public Command createOverrideCommand(OverrideableCommand command) {
        if (command instanceof AddCommand) {
            AddCommand addCommand = (AddCommand)command;
            return this.createAddOverrideCommand(addCommand);
        }
        if (command instanceof RemoveCommand) {
            RemoveCommand removeCommand = (RemoveCommand)command;
            return this.createRemoveOverrideCommand(removeCommand);
        }
        if (command instanceof SetCommand) {
            SetCommand setCommand = (SetCommand)command;
            return this.createSetOverrideCommand(setCommand);
        }
        if (command instanceof ReplaceCommand) {
            ReplaceCommand replaceCommand = (ReplaceCommand)command;
            return this.createReplaceOverrideCommand(replaceCommand);
        }
        if (command instanceof MoveCommand) {
            MoveCommand moveCommand = (MoveCommand)command;
            return this.createMoveOverrideCommand(moveCommand);
        }
        if (command instanceof CreateCopyCommand) {
            CreateCopyCommand createCopyCommand = (CreateCopyCommand)command;
            return this.createCreateCopyOverrideCommand(createCopyCommand);
        }
        if (command instanceof InitializeCopyCommand) {
            InitializeCopyCommand initializeCopyCommand = (InitializeCopyCommand)command;
            return this.createInitializeCopyOverrideCommand(initializeCopyCommand);
        }
        if (command instanceof CopyToClipboardCommand) {
            CopyToClipboardCommand copyToClipboardCommand = (CopyToClipboardCommand)command;
            return this.createCopyToClipboardOverrideCommand(copyToClipboardCommand);
        }
        if (command instanceof PasteFromClipboardCommand) {
            PasteFromClipboardCommand pasteFromClipboardCommand = (PasteFromClipboardCommand)command;
            return this.createPasteFromClipboardOverrideCommand(pasteFromClipboardCommand);
        }
        if (command instanceof DragAndDropCommand) {
            DragAndDropCommand dragAndDropCommand = (DragAndDropCommand)command;
            return this.createDragAndDropOverrideCommand(dragAndDropCommand);
        }
        return null;
    }

    protected Command createAddOverrideCommand(AddCommand addCommand) {
        if (!(addCommand.getOwner() instanceof Mapping)) {
            return new AddOverrideCommand(this, addCommand);
        }
        return null;
    }

    protected Command createRemoveOverrideCommand(RemoveCommand removeCommand) {
        if (!(removeCommand.getOwner() instanceof Mapping)) {
            return new RemoveOverrideCommand(this, removeCommand);
        }
        return null;
    }

    protected Command createSetOverrideCommand(SetCommand setCommand) {
        EStructuralFeature feature = setCommand.getFeature();
        return feature instanceof EReference && ((EReference)feature).isContainment() && this.mappingRoot.isOutputObject(setCommand.getOwner()) ? new SetOverrideCommand(this, setCommand) : null;
    }

    protected Command createMoveOverrideCommand(MoveCommand moveCommand) {
        return null;
    }

    protected Command createReplaceOverrideCommand(ReplaceCommand replaceCommand) {
        return null;
    }

    protected Command createCreateCopyOverrideCommand(CreateCopyCommand createCopyCommand) {
        if (this.mappingRoot.isInputObject(createCopyCommand.getOwner())) {
            return new CreateCopyOverrideCommand(this, createCopyCommand);
        }
        return null;
    }

    protected Command createInitializeCopyOverrideCommand(InitializeCopyCommand initializeCopyCommand) {
        EObject copy = initializeCopyCommand.getCopy();
        EObject owner = initializeCopyCommand.getOwner();
        if (!this.isSameEditingDomainAdapterFactory) {
            return new InitializeCopyOverrideCommand(this, initializeCopyCommand);
        }
        return null;
    }

    protected Command createCopyToClipboardOverrideCommand(CopyToClipboardCommand copyToClipboardCommand) {
        if (!(copyToClipboardCommand instanceof CopyToClipboardOverrideCommand)) {
            ArrayList inputObjects = new ArrayList();
            ArrayList nonInputObjects = new ArrayList();
            Iterator i = copyToClipboardCommand.getSourceObjects().iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (this.mappingRoot.isInputObject(object)) {
                    inputObjects.add(object);
                    continue;
                }
                nonInputObjects.add(object);
            }
            if (inputObjects.size() > 0) {
                return new CopyToClipboardOverrideCommand(this, nonInputObjects, inputObjects);
            }
        }
        return null;
    }

    protected Command createPasteFromClipboardOverrideCommand(PasteFromClipboardCommand pasteFromClipboardCommand) {
        if (!this.isSameEditingDomainAdapterFactory && this.optimizeCopy && !(pasteFromClipboardCommand instanceof PasteFromClipboardOverrideCommand)) {
            return new PasteFromClipboardOverrideCommand(this, pasteFromClipboardCommand);
        }
        return null;
    }

    protected Command createDragAndDropOverrideCommand(DragAndDropCommand dragAndDropCommand) {
        if (!this.isSameEditingDomainAdapterFactory && this.optimizeCopy && !(dragAndDropCommand instanceof DragAndDropOverrideCommand)) {
            return new DragAndDropOverrideCommand(this, dragAndDropCommand);
        }
        return null;
    }

    protected EObject getCorrespondingType(EObject sourceType, HashMap typeTable) {
        EClassifier result = null;
        EClassifier sourceClassifier = (EClassifier)sourceType;
        String sourceTypeName = sourceClassifier.getEPackage().getNsURI() + this.packageTypeSeparator + sourceClassifier.getName();
        String targetTypeName = (String)typeTable.get(sourceTypeName);
        if (targetTypeName != null) {
            int pos = targetTypeName.indexOf(this.packageTypeSeparator);
            if (pos != -1) {
                String pkgName = targetTypeName.substring(0, pos);
                EPackage targetPkg = EPackage.Registry.INSTANCE.getEPackage(pkgName);
                targetTypeName = targetTypeName.substring(pos + 1, targetTypeName.length());
                result = targetPkg.getEClassifier(targetTypeName);
            } else {
                throw new RuntimeException(MappingPlugin.INSTANCE.getString("_EXC_AdapterFactoryMappingDomain_getCorrespondingType_failed", new Object[]{targetTypeName, String.valueOf(this.packageTypeSeparator)}));
            }
        }
        return result;
    }

    protected List parseName(String sourceName, char sourceSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        int length = sourceName.length();
        boolean lastIsLower = false;
        int index = 0;
        while (index < length) {
            char curChar = sourceName.charAt(index);
            if (Character.isUpperCase(curChar) || curChar == sourceSeparator) {
                if (lastIsLower || curChar == sourceSeparator) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                lastIsLower = false;
            } else {
                int currentWordLength;
                if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                    char lastChar = currentWord.charAt(--currentWordLength);
                    currentWord.setLength(currentWordLength);
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                    currentWord.append(lastChar);
                }
                lastIsLower = true;
            }
            if (curChar != sourceSeparator) {
                currentWord.append(curChar);
            }
            ++index;
        }
        result.add(currentWord.toString());
        return result;
    }

    protected String convertName(String sourceName, char sourceSeparator, int sourceCase, List sourceShortForms, List sourceLongForms, char targetSeparator, int targetCase, List targetShortForms, List targetLongForms) {
        String result = this.convertNameForm(sourceName, sourceShortForms, sourceLongForms);
        if (targetSeparator == '\u0000') {
            result = this.convertCase(result, sourceCase, targetCase, sourceSeparator);
            result = this.convertSeparator(result, sourceSeparator, targetSeparator, sourceCase);
        } else {
            result = this.convertSeparator(result, sourceSeparator, targetSeparator, sourceCase);
            result = this.convertCase(result, sourceCase, targetCase, sourceSeparator);
        }
        result = this.convertNameForm(result, targetLongForms, targetShortForms);
        return result;
    }

    protected String convertCase(String sourceName, int sourceCase, int targetCase, char sourceSeparator) {
        if (targetCase == sourceCase) {
            return sourceName;
        }
        switch (targetCase) {
            case 1: {
                return sourceName.toUpperCase();
            }
            case 2: {
                return sourceName.toLowerCase();
            }
            case 3: {
                StringBuffer newString = new StringBuffer();
                int lastIndex = 0;
                int newIndex = 0;
                while ((newIndex = sourceName.indexOf(sourceSeparator, lastIndex)) != -1 && ++newIndex < sourceName.length()) {
                    newString.append(sourceName.substring(lastIndex, newIndex).toLowerCase());
                    newString.append(Character.toUpperCase(sourceName.charAt(newIndex)));
                    lastIndex = newIndex + 1;
                }
                newString.append(sourceName.substring(lastIndex).toLowerCase());
                return newString.toString();
            }
        }
        return null;
    }

    protected String convertSeparator(String sourceName, char sourceSeparator, char targetSeparator, int sourceCase) {
        if (targetSeparator == sourceSeparator) {
            return sourceName;
        }
        if (sourceSeparator != '\u0000' && targetSeparator != '\u0000') {
            return sourceName.replace(sourceSeparator, targetSeparator);
        }
        if (targetSeparator == '\u0000') {
            StringBuffer newString = new StringBuffer();
            int lastIndex = 0;
            int newIndex = 0;
            while ((newIndex = sourceName.indexOf(sourceSeparator, lastIndex)) != -1) {
                newString.append(sourceName.substring(lastIndex, newIndex));
                lastIndex = newIndex + 1;
            }
            newString.append(sourceName.substring(lastIndex));
            return newString.toString();
        }
        if (sourceCase == 3) {
            StringBuffer newString = new StringBuffer();
            int length = sourceName.length();
            int index = 0;
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (Character.isUpperCase(curChar) && index != 0) {
                    newString.append(targetSeparator);
                }
                newString.append(curChar);
                ++index;
            }
            return newString.toString();
        }
        return sourceName;
    }

    protected String convertNameForm(String name, List fromStrings, List toStrings) {
        String newName = name;
        int i = 0;
        while (i < fromStrings.size()) {
            String fromString = (String)fromStrings.get(i);
            if (name.indexOf(fromString) != -1) {
                String toString = (String)toStrings.get(i);
                newName = this.change(newName, fromString, toString);
            }
            ++i;
        }
        return newName;
    }

    protected String change(String in, String oldPat, String newPat) {
        if (oldPat.length() == 0) {
            return in;
        }
        if (oldPat.length() == 1 && newPat.length() == 1) {
            return in.replace(oldPat.charAt(0), newPat.charAt(0));
        }
        int lastIndex = 0;
        int newIndex = 0;
        StringBuffer newString = new StringBuffer();
        while ((newIndex = in.indexOf(oldPat, lastIndex)) != -1) {
            newString.append(in.substring(lastIndex, newIndex) + newPat);
            lastIndex = newIndex + oldPat.length();
        }
        newString.append(in.substring(lastIndex));
        return newString.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EditingDomainProvidingComposedAdapterFactory
    extends ComposedAdapterFactory
    implements IEditingDomainProvider {
        protected EditingDomain editingDomain;

        public EditingDomainProvidingComposedAdapterFactory(AdapterFactory adapterFactory, EditingDomain editingDomain) {
            super(adapterFactory);
            this.editingDomain = editingDomain;
            this.addAdapterFactory(adapterFactory);
        }

        public EditingDomainProvidingComposedAdapterFactory(AdapterFactory[] adapterFactories, EditingDomain editingDomain) {
            super(adapterFactories);
            this.editingDomain = editingDomain;
        }

        public EditingDomainProvidingComposedAdapterFactory(Collection adapterFactories, EditingDomain editingDomain) {
            super(adapterFactories);
            this.editingDomain = editingDomain;
        }

        public EditingDomain getEditingDomain() {
            return this.editingDomain;
        }
    }

    protected class LabelUpdatePropagatingComposedAdapterFactory
    extends ComposedAdapterFactory {
        static /* synthetic */ Class class$org$eclipse$emf$edit$provider$ITreeItemContentProvider;

        public LabelUpdatePropagatingComposedAdapterFactory(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public void fireNotifyChanged(Notification note) {
            super.fireNotifyChanged(note);
            if (this.parentAdapterFactory != null && AdapterFactoryMappingDomain.this.getMappingRoot() != null && note.getNotifier() != null) {
                Iterator mappings = AdapterFactoryMappingDomain.this.getMappingRoot().getMappings(note.getNotifier()).iterator();
                while (mappings.hasNext()) {
                    Mapping mapping = (Mapping)mappings.next();
                    this.parentAdapterFactory.fireNotifyChanged((Notification)new NotificationWrapper((Object)mapping, note));
                    ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)AdapterFactoryMappingDomain.this.getAdapterFactory().adapt((Notifier)mapping, (Object)(class$org$eclipse$emf$edit$provider$ITreeItemContentProvider == null ? LabelUpdatePropagatingComposedAdapterFactory.class$("org.eclipse.emf.edit.provider.ITreeItemContentProvider") : class$org$eclipse$emf$edit$provider$ITreeItemContentProvider));
                    if (treeItemContentProvider == null) continue;
                    Iterator children = treeItemContentProvider.getChildren((Object)mapping).iterator();
                    while (children.hasNext()) {
                        Object child = children.next();
                        if (!(child instanceof MappedObjectItemProvider) || ((MappedObjectItemProvider)((Object)child)).getMappedObject() != note.getNotifier()) continue;
                        this.parentAdapterFactory.fireNotifyChanged((Notification)new NotificationWrapper(child, note));
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

