/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGen;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;

public class Generator
extends CodeGen {
    protected String basePackage;
    public static int EMF_MODEL_PROJECT_STYLE = 1;
    public static int EMF_EDIT_PROJECT_STYLE = 2;
    public static int EMF_EDITOR_PROJECT_STYLE = 4;
    public static int EMF_XML_PROJECT_STYLE = 8;

    public static void main(String[] args) {
        new Generator().run(args);
    }

    public void printGenerateUsage() {
        System.out.println("Usage arguments:");
        System.out.println("  [-platform | -data] <workspace-directory> ");
        System.out.println("  [-projects ] <project-root-directory> ");
        System.out.println("  [-dynamicTemplates] [-forceOverwrite | -diff]");
        System.out.println("  [-generateSchema] [-nonNLSMarkers]");
        System.out.println("  [-model] [-edit] [-editor]");
        System.out.println("  <genmodel-file>");
        System.out.println("  [ <target-root-directory> ]");
        System.out.println("");
        System.out.println("For example:");
        System.out.println("");
        System.out.println("  generate result/src/model/Extended.genmodel");
    }

    public Object run(Object object) {
        try {
            final String[] arguments = (String[])object;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        block35: {
                            try {
                                if (arguments.length == 0) {
                                    Generator.this.printGenerateUsage();
                                    break block35;
                                }
                                if ("-ecore2GenModel".equalsIgnoreCase(arguments[0])) {
                                    Path ecorePath = new Path(arguments[1]);
                                    Generator.this.basePackage = arguments[2];
                                    String prefix = arguments[3];
                                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                                    URI ecoreURI = URI.createFileURI((String)ecorePath.toString());
                                    Resource resource = resourceSet.getResource(ecoreURI, true);
                                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                                    IPath genModelPath = ecorePath.removeFileExtension().addFileExtension("genmodel");
                                    progressMonitor.beginTask("", 2);
                                    progressMonitor.subTask("Creating " + genModelPath);
                                    URI genModelURI = URI.createFileURI((String)genModelPath.toString());
                                    Resource genModelResource = Resource.Factory.Registry.INSTANCE.getFactory(genModelURI).createResource(genModelURI);
                                    GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
                                    genModelResource.getContents().add(genModel);
                                    resourceSet.getResources().add(genModelResource);
                                    genModel.setModelDirectory("/TargetProject/src");
                                    genModel.getForeignModel().add(ecorePath.toString());
                                    genModel.initialize(Collections.singleton(ePackage));
                                    GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
                                    genModel.setModelName(genModelURI.trimFileExtension().lastSegment());
                                    genPackage.setPrefix(prefix);
                                    genPackage.setBasePackage(Generator.this.basePackage);
                                    progressMonitor.worked(1);
                                    genModelResource.save(Collections.EMPTY_MAP);
                                    break block35;
                                }
                                String rootLocation = null;
                                boolean dynamicTemplates = false;
                                boolean diff = false;
                                boolean forceOverwrite = false;
                                boolean generateSchema = false;
                                boolean nonNLSMarkers = false;
                                boolean model = false;
                                boolean edit = false;
                                boolean editor = false;
                                int index = 0;
                                while (index < arguments.length && arguments[index].startsWith("-")) {
                                    if (arguments[index].equalsIgnoreCase("-projects")) {
                                        rootLocation = new File(arguments[++index]).getAbsoluteFile().getCanonicalPath();
                                    } else if (arguments[index].equalsIgnoreCase("-dynamicTemplates")) {
                                        dynamicTemplates = true;
                                    } else if (arguments[index].equalsIgnoreCase("-diff")) {
                                        diff = true;
                                    } else if (arguments[index].equalsIgnoreCase("-forceOverwrite")) {
                                        forceOverwrite = true;
                                    } else if (arguments[index].equalsIgnoreCase("-generateSchema")) {
                                        generateSchema = true;
                                    } else if (arguments[index].equalsIgnoreCase("-nonNLSMarkers")) {
                                        nonNLSMarkers = true;
                                    } else if (arguments[index].equalsIgnoreCase("-model")) {
                                        model = true;
                                    } else if (arguments[index].equalsIgnoreCase("-edit")) {
                                        edit = true;
                                    } else if (arguments[index].equalsIgnoreCase("-editor")) {
                                        editor = true;
                                    } else {
                                        throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "Unrecognized argument: '" + arguments[index] + "'", null));
                                    }
                                    ++index;
                                }
                                if (!(model || edit || editor)) {
                                    model = true;
                                }
                                String genModelName = arguments[index++];
                                progressMonitor.beginTask("Generating " + genModelName, 2);
                                ResourceSetImpl resourceSet = new ResourceSetImpl();
                                URI genModelURI = URI.createFileURI((String)new File(genModelName).getAbsoluteFile().getCanonicalPath());
                                Resource genModelResource = resourceSet.getResource(genModelURI, true);
                                GenModel genModel = (GenModel)genModelResource.getContents().get(0);
                                IStatus status = genModel.validate();
                                if (!status.isOK()) {
                                    Generator.this.printStatus("", status);
                                    break block35;
                                }
                                if (dynamicTemplates) {
                                    genModel.setDynamicTemplates(dynamicTemplates);
                                }
                                genModel.setForceOverwrite(forceOverwrite);
                                genModel.setRedirection(diff ? ".{0}.new" : "");
                                if (index < arguments.length) {
                                    Path path = new Path(genModel.getModelDirectory());
                                    Path targetRootDirectory = new Path(arguments[index]);
                                    targetRootDirectory = new Path(targetRootDirectory.toFile().getAbsoluteFile().getCanonicalPath());
                                    CodeGen.findOrCreateContainer((IPath)new Path(path.segment(0)), (boolean)true, (IPath)targetRootDirectory, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                } else {
                                    String editorDirectory;
                                    String modelDirectory = genModel.getModelDirectory();
                                    genModel.setModelDirectory(Generator.this.findOrCreateContainerHelper(rootLocation, modelDirectory, progressMonitor));
                                    String editDirectory = genModel.getEditDirectory();
                                    if (editDirectory != null) {
                                        genModel.setEditDirectory(Generator.this.findOrCreateContainerHelper(rootLocation, editDirectory, progressMonitor));
                                    }
                                    if ((editorDirectory = genModel.getEditorDirectory()) != null) {
                                        genModel.setEditorDirectory(Generator.this.findOrCreateContainerHelper(rootLocation, editorDirectory, progressMonitor));
                                    }
                                }
                                genModel.setCanGenerate(true);
                                genModel.setUpdateClasspath(false);
                                genModel.setGenerateSchema(generateSchema);
                                genModel.setNonNLSMarkers(nonNLSMarkers);
                                if (model) {
                                    genModel.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                if (edit) {
                                    genModel.generateEdit((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                if (!editor) break block35;
                                genModel.generateEditor((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            catch (CoreException exception) {
                                throw exception;
                            }
                            catch (Exception exception) {
                                throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "EMF Error", (Throwable)exception));
                            }
                        }
                        Object var22_36 = null;
                    }
                    catch (Throwable throwable) {
                        Object var22_37 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            };
            workspace.run(runnable, (IProgressMonitor)new CodeGen.StreamProgressMonitor(System.out));
            return new Integer(0);
        }
        catch (Exception exception) {
            this.printGenerateUsage();
            exception.printStackTrace();
            CodeGenEcorePlugin.INSTANCE.log(exception);
            return new Integer(1);
        }
    }

    protected String findOrCreateContainerHelper(String rootLocation, String encodedPath, IProgressMonitor progressMonitor) throws CoreException {
        int index = encodedPath.indexOf("/./");
        if (encodedPath.endsWith("/.") && index != -1) {
            Path modelProjectLocation = new Path(encodedPath.substring(0, index));
            Path fragmentPath = new Path(encodedPath.substring(index + 3, encodedPath.length() - 2));
            IPath projectRelativePath = new Path(modelProjectLocation.lastSegment()).append((IPath)fragmentPath);
            CodeGen.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            return projectRelativePath.makeAbsolute().toString();
        }
        if (rootLocation != null) {
            index = encodedPath.indexOf("/org.");
            if (index == -1) {
                index = encodedPath.indexOf("/com.");
            }
            if (index == -1) {
                index = encodedPath.indexOf("/javax.");
            }
            if (index != -1) {
                Path projectRelativePath = new Path(encodedPath.substring(index, encodedPath.length()));
                if ((index = encodedPath.indexOf("/", index + 5)) != -1) {
                    Path modelProjectLocation = new Path(rootLocation + "/" + encodedPath.substring(0, index));
                    CodeGen.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    return projectRelativePath.makeAbsolute().toString();
                }
            }
        }
        return encodedPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List referencedProjects, IProgressMonitor progressMonitor, int style) {
        String projectName = javaSource.segment(0);
        IProject project = null;
        try {
            block24: {
                try {
                    String[] natureIds;
                    UniqueEList classpathEntries = new UniqueEList();
                    progressMonitor.beginTask("", 10);
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_CreatingEMFProject_message", new Object[]{projectName}));
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    project = workspace.getRoot().getProject(projectName);
                    if (!project.exists()) {
                        File projectFile;
                        IPath location = projectLocationPath;
                        if (location == null) {
                            location = workspace.getRoot().getLocation().append(projectName);
                        }
                        if ((projectFile = new File((location = location.append(".project")).toString())).exists()) {
                            projectFile.renameTo(new File(location.toString() + ".old"));
                        }
                    }
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IProjectDescription projectDescription = null;
                    if (!project.exists()) {
                        projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                        projectDescription.setLocation(projectLocationPath);
                        project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    } else {
                        projectDescription = project.getDescription();
                        classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                    }
                    boolean isInitiallyEmpty = classpathEntries.isEmpty();
                    if (referencedProjects.size() != 0) {
                        projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                        Iterator i = referencedProjects.iterator();
                        while (i.hasNext()) {
                            IProject referencedProject = (IProject)i.next();
                            IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                            classpathEntries.add(referencedProjectClasspathEntry);
                        }
                    }
                    if ((natureIds = projectDescription.getNatureIds()) == null) {
                        natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
                    } else {
                        boolean hasJavaNature = false;
                        int i = 0;
                        while (i < natureIds.length) {
                            if ("org.eclipse.jdt.core.javanature".equals(natureIds[i])) {
                                hasJavaNature = true;
                            }
                            ++i;
                        }
                        if (!hasJavaNature) {
                            String[] oldNatureIds = natureIds;
                            natureIds = new String[oldNatureIds.length + 1];
                            System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                            natureIds[oldNatureIds.length] = "org.eclipse.jdt.core.javanature";
                        }
                    }
                    projectDescription.setNatureIds(natureIds);
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    IProject sourceContainer = project;
                    if (javaSource.segmentCount() > 1 && !(sourceContainer = project.getFolder(javaSource.removeFirstSegments(1).makeAbsolute())).exists()) {
                        ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    if (isInitiallyEmpty) {
                        IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSource);
                        Iterator i = classpathEntries.iterator();
                        while (i.hasNext()) {
                            IClasspathEntry classpathEntry = (IClasspathEntry)i.next();
                            if (!classpathEntry.getPath().isPrefixOf(javaSource)) continue;
                            i.remove();
                        }
                        classpathEntries.add(0, sourceClasspathEntry);
                        IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                        Iterator i2 = classpathEntries.iterator();
                        while (i2.hasNext()) {
                            IClasspathEntry classpathEntry = (IClasspathEntry)i2.next();
                            if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                            i2.remove();
                        }
                        classpathEntries.add(jreClasspathEntry);
                    }
                    Generator.addClasspathEntries((Collection)classpathEntries, "APACHE_XERCES", "org.apache.xerces");
                    Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_CORE_RUNTIME", "org.eclipse.core.runtime");
                    Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_CORE_RESOURCES", "org.eclipse.core.resources");
                    Generator.addClasspathEntries((Collection)classpathEntries, "EMF_COMMON", "org.eclipse.emf.common");
                    Generator.addClasspathEntries((Collection)classpathEntries, "EMF_ECORE", "org.eclipse.emf.ecore");
                    if ((style & EMF_XML_PROJECT_STYLE) != 0) {
                        Generator.addClasspathEntries((Collection)classpathEntries, "EMF_ECORE_XMI", "org.eclipse.emf.ecore.xmi");
                    }
                    if ((style & EMF_MODEL_PROJECT_STYLE) == 0) {
                        Generator.addClasspathEntries((Collection)classpathEntries, "EMF_EDIT", "org.eclipse.emf.edit");
                        if ((style & EMF_EDIT_PROJECT_STYLE) == 0) {
                            Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_SWT", "org.eclipse.swt");
                            Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_JFACE", "org.eclipse.jface");
                            Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_VIEWS", "org.eclipse.ui.views");
                            Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_EDITORS", "org.eclipse.ui.editors");
                            Generator.addClasspathEntries((Collection)classpathEntries, "ECLIPSE_UI_WORKBENCH", "org.eclipse.ui.workbench");
                            Generator.addClasspathEntries((Collection)classpathEntries, "EMF_COMMON_UI", "org.eclipse.emf.common.ui");
                            Generator.addClasspathEntries((Collection)classpathEntries, "EMF_EDIT_UI", "org.eclipse.emf.edit.ui");
                            if ((style & EMF_XML_PROJECT_STYLE) == 0) {
                                Generator.addClasspathEntries((Collection)classpathEntries, "EMF_ECORE_XMI", "org.eclipse.emf.ecore.xmi");
                            }
                        }
                    }
                    javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    if (!isInitiallyEmpty) break block24;
                    javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/runtime"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                    Object var20_23 = null;
                    progressMonitor.done();
                    return project;
                }
            }
            Object var20_22 = null;
            progressMonitor.done();
            return project;
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            progressMonitor.done();
            throw throwable;
        }
    }

    public static void addClasspathEntries(Collection classpathEntries, String pluginID) throws Exception {
        Generator.addClasspathEntries(classpathEntries, null, pluginID);
    }

    public static void addClasspathEntries(Collection classpathEntries, String variableName, String pluginID) throws Exception {
        IPluginDescriptor descriptor = Platform.getPlugin((String)pluginID).getDescriptor();
        ILibrary[] libraries = descriptor.getRuntimeLibraries();
        int i = 0;
        int count = 0;
        while (i < libraries.length) {
            if (libraries[i].getType().equals("code") && !"nl1.jar".equals(libraries[i].getPath().lastSegment())) {
                Path path = new Path(descriptor.find(libraries[i].getPath()).getFile());
                if (variableName == null) {
                    classpathEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                } else if (count == 0 && pluginID.equals("org.apache.xerces")) {
                    String mangledName = variableName + "_API";
                    if (!path.equals((Object)JavaCore.getClasspathVariable((String)mangledName))) {
                        JavaCore.setClasspathVariable((String)mangledName, (IPath)path, null);
                    }
                    classpathEntries.add(JavaCore.newVariableEntry((IPath)new Path(mangledName), null, null));
                } else if (count != 1 || !pluginID.equals("org.eclipse.ui.workbench")) {
                    if (!path.equals((Object)JavaCore.getClasspathVariable((String)variableName))) {
                        JavaCore.setClasspathVariable((String)variableName, (IPath)path, null);
                    }
                    classpathEntries.add(JavaCore.newVariableEntry((IPath)new Path(variableName), null, null));
                }
                ++count;
            }
            ++i;
        }
    }

    public void printStatus(String prefix, IStatus status) {
        System.err.print(prefix);
        System.err.println(status.getMessage());
        IStatus[] children = status.getChildren();
        String childPrefix = "  " + prefix;
        int i = 0;
        while (i < children.length) {
            this.printStatus(childPrefix, children[i]);
            ++i;
        }
    }

    public static String validName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (JavaConventions.validateIdentifier((String)name).isOK()) {
            return name;
        }
        StringBuffer result = new StringBuffer();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            result.append(name.charAt(0));
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                result.append(name.charAt(i));
            }
            ++i;
        }
        return result.length() == 0 ? "_" : result.toString();
    }
}

