/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;

public class XMLHelperImpl
implements XMLHelper {
    protected static final Integer INTEGER_DATATYPE_IS_MANY = new Integer(2);
    protected static final Integer INTEGER_DATATYPE_SINGLE = new Integer(1);
    protected static final Integer INTEGER_IS_MANY_ADD = new Integer(3);
    protected static final Integer INTEGER_IS_MANY_MOVE = new Integer(4);
    protected EPackage noNamespacePackage;
    protected XMLResource.XMLMap xmlMap;
    protected XMLResource resource;
    protected Map packages = new HashMap();
    protected Map featuresToKinds = new HashMap();
    protected String processDanglingHREF;
    protected DanglingHREFException danglingHREFException;
    protected Map prefixesToURIs = new HashMap();

    public static String saveString(Map options, List contents, String encoding, XMLHelper helper) throws Exception {
        if (helper == null) {
            helper = new XMIHelperImpl();
        }
        if (!options.containsKey("DECLARE_XML")) {
            options = new HashMap<String, Boolean>(options);
            options.put("DECLARE_XML", Boolean.FALSE);
        }
        XMISaveImpl save = new XMISaveImpl(options, helper, encoding);
        ((XMLHelperImpl)helper).processDanglingHREF = (String)options.get("PROCESS_DANGLING_HREF");
        save.traverse(contents);
        char[] chars = save.toChar();
        return new String(chars);
    }

    public XMLHelperImpl() {
    }

    public XMLHelperImpl(XMLResource resource) {
        this();
        this.resource = resource;
    }

    public void setNoNamespacePackage(EPackage pkg) {
        this.noNamespacePackage = pkg;
    }

    public EPackage getNoNamespacePackage() {
        return this.noNamespacePackage;
    }

    public void setXMLMap(XMLResource.XMLMap map) {
        this.xmlMap = map;
        if (map != null && map.getNoNamespacePackage() != null) {
            this.setNoNamespacePackage(map.getNoNamespacePackage());
        }
    }

    public XMLResource.XMLMap getXMLMap() {
        return this.xmlMap;
    }

    public XMLResource getResource() {
        return this.resource;
    }

    public void setResource(XMLResource resource) {
        this.resource = resource;
    }

    public Object getValue(EObject obj, EStructuralFeature f) {
        return obj.eGet(f, false);
    }

    public String getQName(EClass c) {
        XMLResource.XMLInfo clsInfo;
        String name = this.getName((ENamedElement)c);
        if (this.xmlMap != null && (clsInfo = this.xmlMap.getInfo((ENamedElement)c)) != null) {
            String targetNamespace = clsInfo.getTargetNamespace();
            return this.getQName(targetNamespace, name);
        }
        EPackage p = c.getEPackage();
        this.packages.put(p, null);
        if (p.getNsPrefix().equals("")) {
            return name;
        }
        return p.getNsPrefix() + ":" + name;
    }

    protected String getQName(String uri, String name) {
        if (uri == null) {
            if (this.noNamespacePackage != null) {
                this.packages.put(this.noNamespacePackage, null);
            }
            return name;
        }
        EPackage pkg = EPackage.Registry.INSTANCE.getEPackage(uri);
        if (pkg == null || pkg.getNsPrefix().equals("")) {
            return name;
        }
        this.packages.put(pkg, null);
        return pkg.getNsPrefix() + ":" + name;
    }

    public String getName(ENamedElement obj) {
        XMLResource.XMLInfo info = null;
        if (this.xmlMap != null) {
            info = this.xmlMap.getInfo(obj);
        }
        if (info != null && info.getName() != null) {
            return info.getName();
        }
        return obj.getName();
    }

    public String getQName(EStructuralFeature feature) {
        XMLResource.XMLInfo info;
        String name = this.getName((ENamedElement)feature);
        if (this.xmlMap != null && (info = this.xmlMap.getInfo((ENamedElement)feature)) != null) {
            return this.getQName(info.getTargetNamespace(), name);
        }
        return name;
    }

    public String getID(EObject obj) {
        return this.resource == null ? null : this.resource.getID(obj);
    }

    public String getIDREF(EObject obj) {
        return this.resource == null ? null : this.resource.getURIFragment(obj);
    }

    protected URI handleDanglingHREF(EObject object) {
        if (!"DISCARD".equals(this.processDanglingHREF)) {
            DanglingHREFException exception = new DanglingHREFException("The object '" + object + "' is not contained in a resource.", this.resource.getURI().toString(), 0, 0);
            if (this.danglingHREFException == null) {
                this.danglingHREFException = exception;
            }
            this.resource.getErrors().add(exception);
        }
        return null;
    }

    public String getHREF(EObject obj) {
        URI deresolvedURI;
        URI uri;
        InternalEObject o = (InternalEObject)obj;
        URI objectURI = o.eProxyURI();
        if (objectURI == null) {
            Resource otherResource = obj.eResource();
            if (otherResource == null) {
                objectURI = this.handleDanglingHREF(obj);
                if (objectURI == null) {
                    return null;
                }
            } else {
                objectURI = otherResource.getURI().appendFragment(otherResource.getURIFragment(obj));
            }
        }
        if (!objectURI.isRelative() && !(uri = this.resource.getURI()).isRelative() && uri.isHierarchical() && (deresolvedURI = objectURI.deresolve(uri, true, true, false)).hasRelativePath()) {
            objectURI = deresolvedURI;
        }
        return objectURI.toString();
    }

    public int getFeatureKind(EStructuralFeature feature) {
        Integer kind = (Integer)this.featuresToKinds.get(feature);
        if (kind != null) {
            return kind;
        }
        this.computeFeatureKind(feature);
        kind = (Integer)this.featuresToKinds.get(feature);
        if (kind != null) {
            return kind;
        }
        return 5;
    }

    public EObject createObject(EFactory eFactory, String classXMIName) {
        EPackage ePackage = eFactory.getEPackage();
        EClass eClass = (EClass)ePackage.getEClassifier(classXMIName);
        if (eClass == null && this.xmlMap != null) {
            eClass = (EClass)this.xmlMap.getClassifier(ePackage.getNsURI(), classXMIName);
        }
        if (eClass != null) {
            return eFactory.create(eClass);
        }
        return null;
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name) {
        EStructuralFeature feature = this.getFeatureWithoutMap(eClass, name);
        if (feature == null && this.xmlMap != null && (feature = this.xmlMap.getFeature(eClass, namespaceURI, name)) != null) {
            this.computeFeatureKind(feature);
        }
        return feature;
    }

    protected EStructuralFeature getFeatureWithoutMap(EClass eClass, String name) {
        EStructuralFeature feature = eClass.getEStructuralFeature(name);
        if (feature != null) {
            this.computeFeatureKind(feature);
        }
        return feature;
    }

    protected void computeFeatureKind(EStructuralFeature feature) {
        EClassifier eMetaObject = feature.getEType();
        if (eMetaObject instanceof EDataType) {
            if (feature.isMany()) {
                this.featuresToKinds.put(feature, INTEGER_DATATYPE_IS_MANY);
            } else {
                this.featuresToKinds.put(feature, INTEGER_DATATYPE_SINGLE);
            }
        } else if (feature.isMany()) {
            EReference reference = (EReference)feature;
            EReference opposite = reference.getEOpposite();
            if (opposite == null || opposite.isTransient() || !opposite.isMany()) {
                this.featuresToKinds.put(feature, INTEGER_IS_MANY_ADD);
            } else {
                this.featuresToKinds.put(feature, INTEGER_IS_MANY_MOVE);
            }
        }
    }

    public String getJavaEncoding(String xmlEncoding) {
        return xmlEncoding;
    }

    public String getXMLEncoding(String javaEncoding) {
        return javaEncoding;
    }

    public EPackage[] packages() {
        Set pkgs = this.packages.keySet();
        EPackage[] packages = new EPackage[pkgs.size()];
        pkgs.toArray(packages);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((EPackage)o1).getNsPrefix().compareTo(((EPackage)o2).getNsPrefix());
            }
        };
        Arrays.sort(packages, comparator);
        return packages;
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        int kind = this.getFeatureKind(feature);
        switch (kind) {
            case 1: 
            case 2: {
                EClassifier eMetaObject = feature.getEType();
                EDataType eDataType = (EDataType)eMetaObject;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                if (kind == 2) {
                    InternalEList list = (InternalEList)object.eGet(feature);
                    if (position == -2) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)value, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken();
                            list.addUnique(eFactory.createFromString(eDataType, token));
                        }
                        if (!list.isEmpty()) break;
                        list.clear();
                        break;
                    }
                    if (value == null) {
                        list.addUnique(null);
                        break;
                    }
                    list.addUnique(eFactory.createFromString(eDataType, (String)value));
                    break;
                }
                if (value == null) {
                    object.eSet(feature, null);
                    break;
                }
                object.eSet(feature, eFactory.createFromString(eDataType, (String)value));
                break;
            }
            case 3: 
            case 4: {
                InternalEList list = (InternalEList)object.eGet(feature);
                if (position == -1) {
                    list.addUnique(value);
                    break;
                }
                if (position == -2) {
                    list.clear();
                    break;
                }
                if (kind == 3) {
                    list.addUnique(position, value);
                    break;
                }
                list.move(position, value);
                break;
            }
            default: {
                object.eSet(feature, value);
            }
        }
    }

    public List setManyReference(XMLHelper.ManyReference reference, String location) {
        EStructuralFeature feature = reference.getFeature();
        int kind = this.getFeatureKind(feature);
        InternalEList list = (InternalEList)reference.getObject().eGet(feature);
        BasicEList xmiExceptions = new BasicEList();
        Object[] values = reference.getValues();
        int[] positions = reference.getPositions();
        if (kind == 3) {
            int i = 0;
            int l = values.length;
            while (i < l) {
                if (values[i] != null) {
                    try {
                        list.addUnique(positions[i], values[i]);
                    }
                    catch (RuntimeException e) {
                        xmiExceptions.add(new IllegalValueException(reference.getObject(), feature, values[i], e, location, reference.getLineNumber(), reference.getColumnNumber()));
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int l = values.length;
            while (i < l) {
                if (values[i] != null) {
                    try {
                        list.move(positions[i], values[i]);
                    }
                    catch (RuntimeException e) {
                        xmiExceptions.add(new IllegalValueException(reference.getObject(), feature, values[i], e, location, reference.getLineNumber(), reference.getColumnNumber()));
                    }
                }
                ++i;
            }
        }
        if (xmiExceptions.isEmpty()) {
            return null;
        }
        return xmiExceptions;
    }

    public void setProcessDanglingHREF(String value) {
        this.processDanglingHREF = value;
    }

    public DanglingHREFException getDanglingHREFException() {
        return this.danglingHREFException;
    }

    public URI resolve(URI relative, URI base) {
        return relative.resolve(base);
    }

    public void addPrefix(String prefix, String uri) {
        this.prefixesToURIs.put(prefix, uri);
    }

    public String getURI(String prefix) {
        return (String)this.prefixesToURIs.get(prefix);
    }
}

