/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.xmi.impl.StringSegment;

public class XMLString
extends StringSegment {
    protected List elementNames;
    protected List indents;
    protected int lineWidth;
    protected int markedLineWidth;
    protected int currentLineWidth;
    protected boolean lastElementIsStart;

    public XMLString(int lineWidth) {
        this.lineWidth = lineWidth;
        this.elementNames = new BasicEList();
        this.indents = new BasicEList();
        this.indents.add("");
    }

    public void startElement(String name) {
        if (this.lastElementIsStart) {
            this.closeStartElement();
        }
        this.elementNames.add(name);
        this.add(this.getElementIndent());
        this.add("<");
        this.add(name);
        this.lastElementIsStart = true;
    }

    public void addAttribute(String name, String value) {
        if (this.currentLineWidth > this.lineWidth) {
            this.addLine();
            this.add(this.getAttributeIndent());
        } else {
            this.add(" ");
        }
        this.add(name);
        this.add("=\"");
        this.add(value);
        this.add("\"");
    }

    public void addAttributeNS(String prefix, String localName, String value) {
        if (this.currentLineWidth > this.lineWidth) {
            this.addLine();
            this.add(this.getAttributeIndent());
        } else {
            this.add(" ");
        }
        this.add(prefix);
        this.add(":");
        this.add(localName);
        this.add("=\"");
        this.add(value);
        this.add("\"");
    }

    public void startAttribute(String name) {
        if (this.currentLineWidth > this.lineWidth) {
            this.addLine();
            this.add(this.getAttributeIndent());
        } else {
            this.add(" ");
        }
        this.add(name);
        this.add("=\"");
    }

    public void addAttributeContent(String content) {
        this.add(content);
    }

    public void endAttribute() {
        this.add("\"");
    }

    protected void closeStartElement() {
        this.add(">");
        this.addLine();
    }

    public void endEmptyElement() {
        this.removeLast();
        this.add("/>");
        this.addLine();
        this.lastElementIsStart = false;
    }

    public void endContentElement(String content) {
        this.add(">");
        this.add(content);
        this.add("</");
        String name = this.removeLast();
        this.add(name);
        this.add(">");
        this.addLine();
        this.lastElementIsStart = false;
    }

    public void endElement() {
        if (this.lastElementIsStart) {
            this.endEmptyElement();
        } else {
            this.add(this.getElementIndent());
            this.add("</");
            String name = this.removeLast();
            this.add(name);
            this.add(">");
            this.addLine();
            this.lastElementIsStart = false;
        }
    }

    protected String removeLast() {
        int end = this.elementNames.size();
        return (String)this.elementNames.remove(end - 1);
    }

    protected String getElementIndent() {
        int depth = this.elementNames.size() - 1;
        int i = this.indents.size() - 1;
        while (i < depth) {
            this.indents.add(this.indents.get(i) + "  ");
            ++i;
        }
        return (String)this.indents.get(depth);
    }

    protected String getAttributeIndent() {
        int depth = this.elementNames.size() + 1;
        int i = this.indents.size() - 1;
        while (i < depth) {
            this.indents.add(this.indents.get(i) + "  ");
            ++i;
        }
        return (String)this.indents.get(depth);
    }

    public void add(String newString) {
        if (this.lineWidth != Integer.MAX_VALUE) {
            this.currentLineWidth += newString.length();
        }
        super.add(newString);
    }

    public void addLine() {
        super.addLine();
        this.currentLineWidth = 0;
    }

    public Object mark() {
        this.markedLineWidth = this.currentLineWidth;
        this.currentLineWidth = this.lineWidth - 2;
        return super.mark();
    }

    public void resetToMark(Object mark) {
        super.resetToMark(mark);
        this.elementNames.add("mark");
        this.currentLineWidth = this.markedLineWidth;
    }
}

