/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.EMFProjectWizard;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenBaseItemProvider;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProviderAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenPackageItemProvider;
import org.eclipse.emf.codegen.ecore.java2ecore.JavaEcoreBuilder;
import org.eclipse.emf.codegen.ecore.rose2ecore.RoseUtil;
import org.eclipse.emf.codegen.ecore.rose2ecore.UnitTreeNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.ui.celleditor.ExtendedTableEditor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.FileSelectionDialog;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class EMFProjectWizard
extends Wizard
implements INewWizard {
    protected static IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    protected WizardNewProjectCreationPage newProjectCreationPage;
    protected static final int JAVA = 0;
    protected static final int XSD = 1;
    protected static final int ECORE = 2;
    protected static final int ROSE = 3;
    protected static final int NOTHING = 4;
    protected int whichModel;
    protected static final int NEW_PROJECT = 0;
    protected static final int NEW_FILE = 1;
    protected static final int RELOAD = 2;
    protected int whichStyle;
    protected RoseModelPage roseModelPage;
    protected XMLSchemaModelPage xmlSchemaModelPage;
    protected EcoreModelPage ecoreModelPage;
    protected JavaEcoreBuilder javaEcoreBuilder;
    protected PackagePage packagePage;
    protected DetailsPage detailsPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected IFile genModelFile;
    protected GenModel originalGenModel;
    protected Map ePackageToInformationMap;
    protected IFile modelFile = null;

    public EMFProjectWizard() {
        this.whichStyle = 0;
        this.setWindowTitle(GenModelEditPlugin.INSTANCE.getString("_UI_NewProject_title"));
    }

    public EMFProjectWizard(IFile genModelFile) {
        this.genModelFile = genModelFile;
        this.whichStyle = 2;
        this.setWindowTitle(GenModelEditPlugin.INSTANCE.getString("_UI_Reload_title"));
    }

    public IFile getGenModelFile() {
        return this.genModelFile;
    }

    public String getGenModelName() {
        switch (this.whichStyle) {
            case 0: {
                switch (this.whichModel) {
                    case 3: {
                        return this.roseModelPage.getGenModelName();
                    }
                    case 1: {
                        return this.xmlSchemaModelPage.getGenModelName();
                    }
                    case 2: {
                        return this.ecoreModelPage.getGenModelName();
                    }
                }
            }
            case 1: {
                return this.getGenModelFile().getName();
            }
            case 2: {
                return new Path(this.originalGenModel.eResource().getURI().path()).lastSegment();
            }
        }
        return null;
    }

    public String getGenModelFileName() {
        switch (this.whichStyle) {
            case 0: {
                return this.getProjectName() + "/src/model/" + this.getGenModelName();
            }
            case 1: {
                return this.getGenModelFile().getFullPath().makeRelative().toString();
            }
            case 2: {
                return new Path(this.originalGenModel.eResource().getURI().path()).removeFirstSegments(1).toString();
            }
        }
        return null;
    }

    public String getProjectName() {
        switch (this.whichStyle) {
            case 0: {
                return this.newProjectCreationPage.getProjectName();
            }
            case 1: {
                return this.getGenModelFile().getProject().getName();
            }
            case 2: {
                return new Path(this.originalGenModel.eResource().getURI().path()).segment(1);
            }
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(GenModelEditPlugin.INSTANCE.getImage("full/wizban/NewEMFProject")));
    }

    public void addPages() {
        if (this.whichStyle == 0) {
            this.newProjectCreationPage = new WizardNewProjectCreationPage("Whatever1");
            this.newProjectCreationPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_EMFProject_title"));
            this.newProjectCreationPage.setDescription(GenModelEditPlugin.INSTANCE.getString("_UI_EMFProject_description"));
            this.addPage((IWizardPage)this.newProjectCreationPage);
        }
        this.detailsPage = new DetailsPage("Whatever2");
        this.detailsPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_InitialContents_title"));
        this.detailsPage.setDescription(GenModelEditPlugin.INSTANCE.getString("_UI_InitialContents_description"));
        this.addPage((IWizardPage)this.detailsPage);
        this.roseModelPage = new RoseModelPage("Whatever3");
        this.roseModelPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_RoseModelImport_title"));
        this.roseModelPage.setDescription(GenModelEditPlugin.INSTANCE.getString(this.whichStyle != 0 ? "_UI_RoseModelImportFile_description" : "_UI_RoseModelImportNewProject_description"));
        this.addPage((IWizardPage)this.roseModelPage);
        this.xmlSchemaModelPage = new XMLSchemaModelPage("Whatever4");
        this.xmlSchemaModelPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_XMLSchemaImport_title"));
        this.xmlSchemaModelPage.setDescription(GenModelEditPlugin.INSTANCE.getString(this.whichStyle != 0 ? "_UI_XMLSchemaImportFile_description" : "_UI_XMLSchemaImportNewProject_description"));
        this.addPage((IWizardPage)this.xmlSchemaModelPage);
        this.ecoreModelPage = new EcoreModelPage("Whatever5");
        this.ecoreModelPage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_EcoreImport_title"));
        this.ecoreModelPage.setDescription(GenModelEditPlugin.INSTANCE.getString(this.whichStyle != 0 ? "_UI_EcoreImportFile_description" : "_UI_EcoreImportNewProject_description"));
        this.addPage((IWizardPage)this.ecoreModelPage);
        this.packagePage = new PackagePage("Whatever6");
        this.packagePage.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_PackageSelection_title"));
        this.packagePage.setDescription(GenModelEditPlugin.INSTANCE.getString("_UI_PackageSelection_description"));
        this.addPage((IWizardPage)this.packagePage);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * Loose catch block
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    block29: {
                        try {
                            block28: {
                                String modelName;
                                int index;
                                if (EMFProjectWizard.this.whichModel == 4) {
                                    IPath projectLocationPath = EMFProjectWizard.this.newProjectCreationPage.getLocationPath();
                                    if (workspaceRoot.getLocation().equals((Object)projectLocationPath)) {
                                        projectLocationPath = null;
                                    }
                                    IProject emfProject = Generator.createEMFProject((IPath)new Path("/" + EMFProjectWizard.this.getProjectName() + "/src"), (IPath)projectLocationPath, (List)Collections.EMPTY_LIST, (IProgressMonitor)progressMonitor, (int)Generator.EMF_MODEL_PROJECT_STYLE);
                                    break block28;
                                }
                                if (EMFProjectWizard.this.whichModel == 0) {
                                    EPackage ePackage;
                                    EMFProjectWizard.this.modelFile = EMFProjectWizard.this.getGenModelFile();
                                    Iterator entries = EMFProjectWizard.this.packagePage.getEPackageToEcoreFileInformationMap().entrySet().iterator();
                                    while (entries.hasNext()) {
                                        Map.Entry entry = entries.next();
                                        ePackage = (EPackage)entry.getKey();
                                        List value = (List)entry.getValue();
                                        String ecoreFileName = value.get(0).toString();
                                        ePackage.eResource().setURI(ePackage.eResource().getURI().trimSegments(1).appendSegment(ecoreFileName));
                                    }
                                    Iterator i = EMFProjectWizard.this.packagePage.getEPackageToEcoreFileInformationMap().keySet().iterator();
                                    while (i.hasNext()) {
                                        ePackage = (EPackage)i.next();
                                        ePackage.eResource().save(Collections.EMPTY_MAP);
                                    }
                                    EMFProjectWizard.this.javaEcoreBuilder.getGenModel().eResource().save(Collections.EMPTY_MAP);
                                    break block28;
                                }
                                String projectName = EMFProjectWizard.this.getProjectName();
                                String genModelFileName = EMFProjectWizard.this.getGenModelFileName();
                                Path genModelFilePath = new Path(genModelFileName);
                                String baseLocation = genModelFilePath.removeLastSegments(1).toString() + "/";
                                ResourceSetImpl resourceSet = new ResourceSetImpl();
                                Iterator entries = EMFProjectWizard.this.packagePage.getEPackageToEcoreFileInformationMap().entrySet().iterator();
                                while (entries.hasNext()) {
                                    Map.Entry entry = entries.next();
                                    EPackage ePackage = (EPackage)entry.getKey();
                                    List value = (List)entry.getValue();
                                    String ecoreFileName = baseLocation + value.get(0).toString();
                                    URI ecoreURI = URI.createPlatformResourceURI((String)ecoreFileName);
                                    Resource resource = resourceSet.getResource(ecoreURI, false);
                                    if (resource == null) {
                                        resource = resourceSet.createResource(ecoreURI);
                                    }
                                    resource.getContents().add(ePackage);
                                }
                                ArrayList<GenPackage> referencedGenPackages = new ArrayList<GenPackage>();
                                HashSet<GenModel> referencedGenModels = new HashSet<GenModel>();
                                Iterator entries2 = EMFProjectWizard.this.packagePage.getEPackageToGenPackageMap().entrySet().iterator();
                                while (entries2.hasNext()) {
                                    Map.Entry entry = entries2.next();
                                    EPackage ePackage = (EPackage)entry.getKey();
                                    GenPackage referencedGenPackage = (GenPackage)entry.getValue();
                                    EPackage realEPackage = referencedGenPackage.getEcorePackage();
                                    GenModel referencedGenModel = referencedGenPackage.getGenModel();
                                    referencedGenModels.add(referencedGenPackage.getGenModel());
                                    URI ecoreURI = realEPackage.eResource().getURI();
                                    Resource resource = resourceSet.createResource(ecoreURI);
                                    resource.getContents().add(ePackage);
                                    referencedGenPackages.add(referencedGenPackage);
                                }
                                ArrayList<IProject> referencedModelProjects = new ArrayList<IProject>();
                                ArrayList<IProject> referencedEditProjects = new ArrayList<IProject>();
                                Iterator i = referencedGenModels.iterator();
                                while (i.hasNext()) {
                                    GenModel referencedGenModel = (GenModel)i.next();
                                    referencedModelProjects.add(workspaceRoot.getProject(new Path(referencedGenModel.getModelDirectory()).segment(0)));
                                    if (referencedGenModel.getModelDirectory().equals(referencedGenModel.getEditDirectory())) continue;
                                    referencedEditProjects.add(workspaceRoot.getProject(new Path(referencedGenModel.getEditDirectory()).segment(0)));
                                }
                                if (EMFProjectWizard.this.whichStyle == 0) {
                                    IPath projectLocationPath = EMFProjectWizard.this.newProjectCreationPage.getLocationPath();
                                    if (workspaceRoot.getLocation().equals((Object)projectLocationPath)) {
                                        projectLocationPath = null;
                                    }
                                    ArrayList referencedProjects = new ArrayList(referencedModelProjects);
                                    IProject emfProject = Generator.createEMFProject((IPath)new Path("/" + projectName + "/src"), (IPath)projectLocationPath, referencedProjects, (IProgressMonitor)progressMonitor, (int)Generator.EMF_MODEL_PROJECT_STYLE);
                                }
                                ArrayList ePackages = new ArrayList(resourceSet.getResources().size());
                                Iterator resources = resourceSet.getResources().iterator();
                                while (resources.hasNext()) {
                                    Resource resource = (Resource)resources.next();
                                    if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof EPackage)) continue;
                                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                                    if (!EMFProjectWizard.this.packagePage.getCheckedEPackageList().contains(ePackage)) continue;
                                    resource.save(Collections.EMPTY_MAP);
                                    ePackages.add(resource.getContents().get(0));
                                }
                                URI genModelURI = URI.createPlatformResourceURI((String)genModelFileName);
                                Resource genModelResource = resourceSet.createResource(genModelURI);
                                GenModelFactory genModelFactory = GenModelFactory.eINSTANCE;
                                GenModel genModel = genModelFactory.createGenModel();
                                genModelResource.getContents().add(genModel);
                                genModel.initialize(ePackages);
                                genModel.getUsedGenPackages().addAll(referencedGenPackages);
                                String qualifier = projectName;
                                if (!genModel.getGenPackages().isEmpty()) {
                                    EMFProjectWizard.this.traverseGenPackages((List)genModel.getGenPackages());
                                    GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
                                    while (genPackage.getGenClassifiers().isEmpty() && !genPackage.getNestedGenPackages().isEmpty()) {
                                        genPackage = (GenPackage)genPackage.getNestedGenPackages().get(0);
                                    }
                                    qualifier = genPackage.getInterfacePackageName();
                                }
                                if ((index = (modelName = EMFProjectWizard.this.getGenModelName()).lastIndexOf(46)) != -1) {
                                    modelName = modelName.substring(0, index);
                                }
                                modelName = Character.toUpperCase(modelName.charAt(0)) + modelName.substring(1);
                                genModel.setModelName(modelName);
                                genModel.setModelPluginID(projectName);
                                genModel.setEditPluginClass(qualifier + ".provider." + Generator.validName((String)genModel.getModelName()) + "EditPlugin");
                                genModel.setEditorPluginClass(qualifier + ".presentation." + Generator.validName((String)genModel.getModelName()) + "EditorPlugin");
                                genModel.setModelDirectory("/" + projectName + "/src");
                                genModel.setEditDirectory("/" + projectName + ".edit/src");
                                genModel.setEditorDirectory("/" + projectName + ".editor/src");
                                switch (EMFProjectWizard.this.whichModel) {
                                    case 3: {
                                        genModel.getForeignModel().add(EMFProjectWizard.this.makeRelative(URI.createFileURI((String)EMFProjectWizard.this.roseModelPage.getRoseModelLocationPath().toOSString()), genModelURI).toFileString());
                                        IPath projectLocation = workspaceRoot.getProject(projectName).getLocation().removeLastSegments(1);
                                        Iterator i2 = EMFProjectWizard.this.roseModelPage.getPathMap().entrySet().iterator();
                                        while (i2.hasNext()) {
                                            Map.Entry entry = i2.next();
                                            genModel.getForeignModel().add(entry.getKey());
                                            String value = (String)entry.getValue();
                                            if (new Path(value).equals((Object)projectLocation)) {
                                                value = "..";
                                                int depth = genModelFilePath.segmentCount();
                                                while (depth > 2) {
                                                    value = value + "/..";
                                                    --depth;
                                                }
                                                genModel.getForeignModel().add(value);
                                                continue;
                                            }
                                            genModel.getForeignModel().add(value);
                                        }
                                        break;
                                    }
                                    case 0: {
                                        genModel.getForeignModel().add("@model");
                                        break;
                                    }
                                    case 1: {
                                        genModel.getForeignModel().add(EMFProjectWizard.this.makeRelative(EMFProjectWizard.this.xmlSchemaModelPage.getXMLSchemaModelLocation(), genModelURI).toString());
                                        if (EMFProjectWizard.this.xmlSchemaModelPage.getMappingRoot() == null) break;
                                        URI mappingModelURI = URI.createPlatformResourceURI((String)genModelFileName).trimFileExtension().appendFileExtension("xsd2ecore");
                                        Resource mappingModelResource = resourceSet.createResource(mappingModelURI);
                                        mappingModelResource.getContents().add(EMFProjectWizard.this.xmlSchemaModelPage.getMappingRoot());
                                        mappingModelResource.save(Collections.EMPTY_MAP);
                                        break;
                                    }
                                    case 2: {
                                        genModel.getForeignModel().add(EMFProjectWizard.this.makeRelative(EMFProjectWizard.this.ecoreModelPage.getEcoreModelLocation(), genModelURI).toString());
                                    }
                                }
                                genModel.reconcile(EMFProjectWizard.this.originalGenModel);
                                genModelResource.save(Collections.EMPTY_MAP);
                                EMFProjectWizard.this.modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(genModelFileName));
                            }
                            Object var29_38 = null;
                        }
                        catch (Throwable throwable) {
                            Object var29_40 = null;
                            progressMonitor.done();
                            throw throwable;
                        }
                        progressMonitor.done();
                        {
                            break block29;
                            catch (Exception exception) {
                                GenModelEditPlugin.INSTANCE.log(exception);
                                Object var29_39 = null;
                                progressMonitor.done();
                            }
                        }
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            if (this.whichStyle != 2 && this.whichModel != 4) {
                IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                final IWorkbenchPart activePart = page.getActivePart();
                if (activePart instanceof ISetSelectionTarget) {
                    StructuredSelection targetSelection = new StructuredSelection((Object)this.modelFile);
                    this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                        private final /* synthetic */ ISelection val$targetSelection;
                        {
                            this.val$targetSelection = val$targetSelection;
                        }

                        public void run() {
                            ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                        }
                    });
                }
                try {
                    page.openEditor(this.modelFile);
                }
                catch (PartInitException exception) {
                    MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_OpenEditor_title"), (String)exception.getMessage());
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            GenModelEditPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    protected URI makeRelative(URI uri, URI relativeTo) {
        URI platformURI;
        URI result;
        IFile file;
        if ("file".equals(uri.scheme()) && (file = workspaceRoot.getFileForLocation((IPath)new Path(uri.toFileString()))) != null && (result = (platformURI = URI.createPlatformResourceURI((String)file.getFullPath().toString())).deresolve(relativeTo, false, true, false)).isRelative()) {
            return result;
        }
        URI result2 = uri.deresolve(relativeTo, true, true, false);
        if (result2.isRelative()) {
            return result2;
        }
        return uri;
    }

    protected URI makeAbsolute(URI uri, URI relativeTo) {
        if (uri.isRelative()) {
            return uri.resolve(relativeTo);
        }
        return uri;
    }

    public void traverseGenPackages(List genPackages) {
        Iterator i = genPackages.iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            EPackage ePackage = genPackage.getEcorePackage();
            List ePackageInformation = (List)this.ePackageToInformationMap.get(ePackage);
            if (ePackageInformation != null) {
                genPackage.setBasePackage((String)ePackageInformation.get(0));
                genPackage.setPrefix((String)ePackageInformation.get(1));
            }
            if (genPackage.getPrefix() == null || genPackage.getPrefix().length() == 0) {
                String name = ePackage.getName();
                genPackage.setPrefix(Character.toUpperCase(name.charAt(0)) + name.substring(1));
            }
            if (this.whichModel == 1) {
                genPackage.setResource(GenResourceKind.XML_LITERAL);
            }
            this.traverseGenPackages((List)genPackage.getNestedGenPackages());
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.detailsPage) {
            switch (this.whichModel) {
                case 3: {
                    return this.roseModelPage;
                }
                case 0: {
                    return this.packagePage;
                }
                case 1: {
                    return this.xmlSchemaModelPage;
                }
                case 2: {
                    return this.ecoreModelPage;
                }
                case 4: {
                    return null;
                }
            }
        } else if (page == this.roseModelPage || page == this.xmlSchemaModelPage || page == this.ecoreModelPage) {
            return this.packagePage;
        }
        return super.getNextPage(page);
    }

    protected static FileSystemElement createFileSystemElement(FileSystemElement parent, IResource resource, Collection matchingResources, String extension) {
        FileSystemElement result = null;
        String label = resource.getName();
        switch (resource.getType()) {
            case 1: {
                if (!resource.getName().endsWith("." + extension)) break;
                IProject project = resource.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                try {
                    if (javaProject.exists() && project != project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation()) && javaProject.getOutputLocation().isPrefixOf(resource.getFullPath())) break;
                    result = new FileSystemElement(label, parent, false);
                    result.setFileSystemObject((Object)resource);
                    matchingResources.add(result);
                }
                catch (JavaModelException exception) {
                    GenModelEditPlugin.INSTANCE.log((Object)exception);
                }
                break;
            }
            case 8: {
                label = GenModelEditPlugin.INSTANCE.getString("_UI_Workspace_label");
            }
            default: {
                result = new FileSystemElement(label, parent, true);
                result.setFileSystemObject((Object)resource);
                try {
                    IResource[] members = ((IContainer)resource).members();
                    int i = 0;
                    while (i < members.length) {
                        FileSystemElement child = EMFProjectWizard.createFileSystemElement(result, members[i], matchingResources, extension);
                        ++i;
                    }
                }
                catch (CoreException exception) {
                    // empty catch block
                }
                if (result.getFolders().size() != 0 || result.getFiles().size() != 0 || parent == null) break;
                parent.removeFolder(result);
                result = null;
            }
        }
        return result;
    }

    public class DetailsPage
    extends WizardPage {
        protected Button loadFromRose;
        protected Button loadFromJavaAnnotations;
        protected Button loadFromXMLSchema;
        protected Button loadFromEcore;
        protected Button loadNothing;

        public DetailsPage(String pageId) {
            super(pageId);
        }

        public void chooseRose() {
            EMFProjectWizard.this.whichModel = 3;
            EMFProjectWizard.this.xmlSchemaModelPage.setPageComplete(true);
            EMFProjectWizard.this.ecoreModelPage.setPageComplete(true);
            EMFProjectWizard.this.roseModelPage.setPageComplete(EMFProjectWizard.this.roseModelPage.isPageComplete());
            EMFProjectWizard.this.packagePage.setPageComplete(EMFProjectWizard.this.packagePage.isPageComplete());
            this.setPageComplete(true);
        }

        public void chooseJava() {
            EMFProjectWizard.this.whichModel = 0;
            EMFProjectWizard.this.roseModelPage.setPageComplete(true);
            EMFProjectWizard.this.xmlSchemaModelPage.setPageComplete(true);
            EMFProjectWizard.this.ecoreModelPage.setPageComplete(true);
            EMFProjectWizard.this.packagePage.setPageComplete(EMFProjectWizard.this.packagePage.isPageComplete());
            this.setPageComplete(true);
        }

        public void chooseXSD() {
            EMFProjectWizard.this.whichModel = 1;
            EMFProjectWizard.this.roseModelPage.setPageComplete(true);
            EMFProjectWizard.this.ecoreModelPage.setPageComplete(true);
            EMFProjectWizard.this.xmlSchemaModelPage.setPageComplete(EMFProjectWizard.this.xmlSchemaModelPage.isPageComplete());
            EMFProjectWizard.this.packagePage.setPageComplete(EMFProjectWizard.this.packagePage.isPageComplete());
            this.setPageComplete(true);
        }

        public void chooseEcore() {
            EMFProjectWizard.this.whichModel = 2;
            EMFProjectWizard.this.ecoreModelPage.setPageComplete(EMFProjectWizard.this.ecoreModelPage.isPageComplete());
            EMFProjectWizard.this.roseModelPage.setPageComplete(true);
            EMFProjectWizard.this.xmlSchemaModelPage.setPageComplete(true);
            EMFProjectWizard.this.packagePage.setPageComplete(EMFProjectWizard.this.packagePage.isPageComplete());
            this.setPageComplete(true);
        }

        public void chooseNothing() {
            EMFProjectWizard.this.whichModel = 4;
            EMFProjectWizard.this.ecoreModelPage.setPageComplete(true);
            EMFProjectWizard.this.roseModelPage.setPageComplete(true);
            EMFProjectWizard.this.xmlSchemaModelPage.setPageComplete(true);
            EMFProjectWizard.this.packagePage.setPageComplete(true);
            this.setPageComplete(true);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && EMFProjectWizard.this.whichStyle == 2 && EMFProjectWizard.this.genModelFile != null) {
                this.getControl().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ DetailsPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        try {
                            URI genModelURI = URI.createPlatformResourceURI((String)DetailsPage.access$600(this.this$1).getGenModelFile().getFullPath().toString());
                            Resource resource = resourceSet.getResource(genModelURI, true);
                            DetailsPage.access$600((DetailsPage)this.this$1).originalGenModel = (GenModel)resource.getContents().get(0);
                            DetailsPage.access$600((DetailsPage)this.this$1).originalGenModel.reconcile();
                            Iterator<E> values = DetailsPage.access$600((DetailsPage)this.this$1).originalGenModel.getForeignModel().iterator();
                            if (values.hasNext()) {
                                String firstValue = (String)values.next();
                                if (firstValue.endsWith(".mdl")) {
                                    this.this$1.chooseRose();
                                    this.this$1.loadFromRose.setSelection(true);
                                    this.this$1.loadFromXMLSchema.setSelection(false);
                                    this.this$1.loadFromJavaAnnotations.setSelection(false);
                                    this.this$1.loadFromEcore.setSelection(false);
                                    if (this.this$1.loadNothing != null) {
                                        this.this$1.loadNothing.setSelection(false);
                                    }
                                } else if (firstValue.endsWith(".xsd")) {
                                    firstValue = DetailsPage.access$600(this.this$1).makeAbsolute(URI.createURI((String)firstValue), genModelURI).toString();
                                    this.this$1.chooseXSD();
                                    this.this$1.loadFromXMLSchema.setSelection(true);
                                    this.this$1.loadFromRose.setSelection(false);
                                    this.this$1.loadFromJavaAnnotations.setSelection(false);
                                    this.this$1.loadFromEcore.setSelection(false);
                                    if (this.this$1.loadNothing != null) {
                                        this.this$1.loadNothing.setSelection(false);
                                    }
                                } else if (firstValue.equals("@model")) {
                                    this.this$1.chooseJava();
                                    this.this$1.loadFromJavaAnnotations.setSelection(true);
                                    this.this$1.loadFromRose.setSelection(false);
                                    this.this$1.loadFromXMLSchema.setSelection(false);
                                    this.this$1.loadFromEcore.setSelection(false);
                                    if (this.this$1.loadNothing != null) {
                                        this.this$1.loadNothing.setSelection(false);
                                    }
                                } else if (firstValue.endsWith(".ecore")) {
                                    firstValue = DetailsPage.access$600(this.this$1).makeAbsolute(URI.createURI((String)firstValue), genModelURI).toString();
                                    this.this$1.chooseEcore();
                                    this.this$1.loadFromEcore.setSelection(true);
                                    this.this$1.loadFromJavaAnnotations.setSelection(false);
                                    this.this$1.loadFromRose.setSelection(false);
                                    this.this$1.loadFromXMLSchema.setSelection(false);
                                    if (this.this$1.loadNothing != null) {
                                        this.this$1.loadNothing.setSelection(false);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            GenModelEditPlugin.INSTANCE.log(exception);
                        }
                    }
                });
            }
        }

        public void createControl(Composite parent) {
            GridData data;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data2 = new GridData();
            data2.verticalAlignment = 4;
            data2.grabExcessVerticalSpace = true;
            data2.horizontalAlignment = 4;
            composite.setLayoutData((Object)data2);
            if (EMFProjectWizard.this.whichStyle != 0) {
                EMFProjectWizard.this.whichModel = 0;
                this.loadFromJavaAnnotations = new Button(composite, 16);
                this.loadFromJavaAnnotations.setSelection(true);
                this.loadFromJavaAnnotations.setText(GenModelEditPlugin.INSTANCE.getString("_UI_LoadFromJava_label"));
                data = new GridData();
                this.loadFromJavaAnnotations.setLayoutData((Object)data);
                this.loadFromJavaAnnotations.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ DetailsPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        if (this.this$1.loadFromJavaAnnotations.getSelection()) {
                            this.this$1.chooseJava();
                        }
                    }
                });
            } else {
                EMFProjectWizard.this.whichModel = 1;
            }
            this.loadFromXMLSchema = new Button(composite, 16);
            this.loadFromXMLSchema.setText(GenModelEditPlugin.INSTANCE.getString("_UI_LoadFromXMLSchema_label"));
            data = new GridData();
            this.loadFromXMLSchema.setLayoutData((Object)data);
            this.loadFromXMLSchema.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ DetailsPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.this$1.loadFromXMLSchema.getSelection()) {
                        this.this$1.chooseXSD();
                    }
                }
            });
            if (Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.xsd.editor") == null) {
                this.loadFromXMLSchema.setEnabled(false);
                if (EMFProjectWizard.this.whichModel == 1) {
                    EMFProjectWizard.this.whichModel = 2;
                }
            } else if (EMFProjectWizard.this.whichModel == 1) {
                this.loadFromXMLSchema.setSelection(true);
            }
            this.loadFromEcore = new Button(composite, 16);
            if (EMFProjectWizard.this.whichModel == 2) {
                this.loadFromEcore.setSelection(true);
            }
            this.loadFromEcore.setText(GenModelEditPlugin.INSTANCE.getString("_UI_LoadFromEcore_label"));
            data = new GridData();
            this.loadFromEcore.setLayoutData((Object)data);
            this.loadFromEcore.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ DetailsPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.this$1.loadFromEcore.getSelection()) {
                        this.this$1.chooseEcore();
                    }
                }
            });
            this.loadFromRose = new Button(composite, 16);
            this.loadFromRose.setText(GenModelEditPlugin.INSTANCE.getString("_UI_loadFromRose_label"));
            data = new GridData();
            this.loadFromRose.setLayoutData((Object)data);
            EMFProjectWizard.this.xmlSchemaModelPage.setPageComplete(true);
            this.loadFromRose.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ DetailsPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.this$1.loadFromRose.getSelection()) {
                        this.this$1.chooseRose();
                    }
                }
            });
            if (EMFProjectWizard.this.whichStyle == 0) {
                this.loadNothing = new Button(composite, 16);
                this.loadNothing.setText(GenModelEditPlugin.INSTANCE.getString("_UI_CreateEmptyProject_label"));
                data = new GridData();
                this.loadNothing.setLayoutData((Object)data);
                this.loadNothing.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ DetailsPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        if (this.this$1.loadNothing.getSelection()) {
                            this.this$1.chooseNothing();
                        }
                    }
                });
            }
            this.setControl((Control)composite);
        }

        static /* synthetic */ EMFProjectWizard access$600(DetailsPage x0) {
            return x0.EMFProjectWizard.this;
        }
    }

    public class PackagePage
    extends WizardPage {
        public static final int ECORE_FILE_COLUMN = 0;
        public static final int BASE_COLUMN = 1;
        protected Map ePackageToGenPackageMap = new HashMap();
        protected Map ePackageToEcoreFileInformationMap = new HashMap();
        protected CheckboxTreeViewer referencedGenModelsCheckboxTreeViewer;
        protected CheckboxTableViewer packagesCheckboxTableViewer;
        protected Button referencedGenModelsTreeBrowseButton;
        protected Label referencedGenModelsLabel;
        protected boolean isCellEditing;
        protected RoseUtil roseUtil;
        protected UnitTreeNode unitTree;
        protected List ePackageList = new ArrayList();
        protected List checkedEPackageList = new ArrayList();
        protected List filteredEPackageList = new ArrayList();
        protected List targetPackageNames = new ArrayList();
        protected ResourceSet referencedGenModels;
        protected boolean isDirty = true;

        public PackagePage(String pageId) {
            super(pageId);
        }

        public void setDirty(boolean isDirty) {
            this.isDirty = isDirty;
        }

        public boolean isPageComplete() {
            return EMFProjectWizard.this.whichModel == 4 || this.getErrorMessage() == null && !this.isCellEditing && this.packagesCheckboxTableViewer != null && this.packagesCheckboxTableViewer.getCheckedElements().length > 0;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.referencedGenModelsCheckboxTreeViewer.getControl().setVisible(EMFProjectWizard.this.whichModel != 0);
                this.referencedGenModelsTreeBrowseButton.setVisible(EMFProjectWizard.this.whichModel != 0);
                this.referencedGenModelsLabel.setVisible(EMFProjectWizard.this.whichModel != 0);
            }
            if (visible && this.isDirty) {
                this.refreshPackagesTable();
                this.isDirty = false;
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label packagesLabel = new Label(composite, 16384);
            packagesLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_RootPackages_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            packagesLabel.setLayoutData((Object)data);
            Table packagesTable = new Table(composite, 2080);
            this.packagesCheckboxTableViewer = new CheckboxTableViewer(packagesTable);
            GridData data2 = new GridData();
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            data2.horizontalAlignment = 4;
            data2.horizontalSpan = 2;
            packagesTable.setLayoutData((Object)data2);
            packagesTable.setHeaderVisible(true);
            packagesTable.setLinesVisible(true);
            TableLayout layout2 = new TableLayout();
            TableColumn rosePackageColumn = new TableColumn(packagesTable, 0);
            layout2.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            rosePackageColumn.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Package_label"));
            rosePackageColumn.setResizable(true);
            TableColumn ecoreFileNameColumn = new TableColumn(packagesTable, 0);
            layout2.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            ecoreFileNameColumn.setText(GenModelEditPlugin.INSTANCE.getString("_UI_EcoreModelName_label"));
            ecoreFileNameColumn.setResizable(true);
            packagesTable.setLayout((Layout)layout2);
            ExtendedTableEditor extendedTableEditor = new ExtendedTableEditor(this, packagesTable){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                protected void editItem(TableItem tableItem, int column) {
                    switch (column) {
                        case 1: 
                        case 2: {
                            String string = tableItem.getText(column);
                            ((ControlEditor)this).horizontalAlignment = 16384;
                            ((ControlEditor)this).minimumWidth = Math.max(50, tableItem.getBounds((int)column).width);
                            Text text = new Text((Composite)this.table, 0);
                            this.setEditor((Control)text, tableItem, column);
                            text.setFocus();
                            text.setText(string);
                            text.setSelection(0, string.length());
                            PackagePage.access$300(this.this$1, string, null);
                            text.addFocusListener((FocusListener)new FocusAdapter(this, tableItem, column, text){
                                private final /* synthetic */ TableItem val$tableItem;
                                private final /* synthetic */ int val$column;
                                private final /* synthetic */ Text val$text;
                                private final /* synthetic */ 30 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$tableItem = val$tableItem;
                                    this.val$column = val$column;
                                    this.val$text = val$text;
                                }

                                public void focusLost(FocusEvent event) {
                                    this.this$2.modify(this.val$tableItem, this.val$column, this.val$text);
                                }
                            });
                            text.addKeyListener((KeyListener)new KeyAdapter(this, tableItem, column, text){
                                private final /* synthetic */ TableItem val$tableItem;
                                private final /* synthetic */ int val$column;
                                private final /* synthetic */ Text val$text;
                                private final /* synthetic */ 30 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$tableItem = val$tableItem;
                                    this.val$column = val$column;
                                    this.val$text = val$text;
                                }

                                public void keyPressed(KeyEvent event) {
                                    if (event.character == '\r' || event.character == '\n') {
                                        this.this$2.modify(this.val$tableItem, this.val$column, this.val$text);
                                        this.this$2.setEditor(null);
                                        this.val$text.dispose();
                                    } else if (event.character == '\u001b') {
                                        this.this$2.setEditor(null);
                                        this.val$text.dispose();
                                    }
                                }
                            });
                            text.addModifyListener(new ModifyListener(this, column, text){
                                private final /* synthetic */ int val$column;
                                private final /* synthetic */ Text val$text;
                                private final /* synthetic */ 30 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$column = val$column;
                                    this.val$text = val$text;
                                }

                                public void modifyText(ModifyEvent event) {
                                    if (this.val$column == 1) {
                                        PackagePage.access$300(30.access$400(this.this$2), this.val$text.getText(), null);
                                    }
                                }
                            });
                            this.this$1.isCellEditing = true;
                            this.this$1.setPageComplete(false);
                            break;
                        }
                    }
                }

                protected void modify(TableItem tableItem, int column, Text text) {
                    tableItem.setText(column, text.getText());
                    String value = tableItem.getText(column);
                    text.setVisible(false);
                    List ecoreFileNameInformation = (List)this.this$1.getEPackageToEcoreFileInformationMap().get(tableItem.getData());
                    if (ecoreFileNameInformation != null) {
                        StringBuffer oldValue = (StringBuffer)ecoreFileNameInformation.get(column - 1);
                        oldValue.replace(0, oldValue.length(), value);
                    }
                    this.this$1.isCellEditing = false;
                    this.this$1.validate();
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                }

                static /* synthetic */ PackagePage access$400(30 x0) {
                    return x0.this$1;
                }
            };
            AdapterFactoryImpl adapterFactory = new AdapterFactoryImpl();
            this.packagesCheckboxTableViewer.setColumnProperties(new String[]{"a", "b"});
            this.packagesCheckboxTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
            this.packagesCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this, (AdapterFactory)adapterFactory){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                public Image getColumnImage(Object o, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return ExtendedImageRegistry.INSTANCE.getImage((Object)((Object)new GenBaseItemProvider.UnderlayedImage(GenModelEditPlugin.INSTANCE.getImage("full/obj16/EPackage"))));
                        }
                    }
                    return null;
                }

                public String getColumnText(Object o, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return ((EPackage)o).getName();
                        }
                        case 1: 
                        case 2: {
                            return ((List)this.this$1.ePackageToEcoreFileInformationMap.get(o)).get(columnIndex - 1).toString();
                        }
                    }
                    return "";
                }
            });
            this.packagesCheckboxTableViewer.addCheckStateListener(new ICheckStateListener(this){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    this.this$1.validate();
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                    this.this$1.packagesCheckboxTableViewer.refresh();
                    this.this$1.targetPackageNames.clear();
                    Object[] checkedElements = this.this$1.packagesCheckboxTableViewer.getCheckedElements();
                    int i = 0;
                    while (i < checkedElements.length) {
                        EPackage ePackage = (EPackage)checkedElements[i];
                        this.this$1.targetPackageNames.add(ePackage.getName());
                        ++i;
                    }
                }
            });
            this.referencedGenModelsLabel = new Label(composite, 16384);
            this.referencedGenModelsLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_ReferencedGeneratorModels_label"));
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            this.referencedGenModelsLabel.setLayoutData((Object)data3);
            this.referencedGenModelsTreeBrowseButton = new Button(composite, 8);
            this.referencedGenModelsTreeBrowseButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Browse_label"));
            data3 = new GridData();
            data3.horizontalAlignment = 3;
            this.referencedGenModelsTreeBrowseButton.setLayoutData((Object)data3);
            this.referencedGenModelsTreeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    ArrayList<E> genModelResources = new ArrayList<E>();
                    FileSelectionDialog fileSelectionDialog = new FileSelectionDialog(this.this$1.getShell(), EMFProjectWizard.createFileSystemElement(null, (IResource)ResourcesPlugin.getWorkspace().getRoot(), genModelResources, "genmodel"), GenModelEditPlugin.INSTANCE.getString("_UI_SelectAllGeneratorModels_description"));
                    fileSelectionDialog.setExpandAllOnOpen(true);
                    fileSelectionDialog.setInitialSelections(genModelResources.toArray());
                    fileSelectionDialog.open();
                    StringBuffer text = new StringBuffer();
                    Object[] result = fileSelectionDialog.getResult();
                    if (result != null) {
                        this.this$1.referencedGenModels = new ResourceSetImpl();
                        ArrayList<E> genModels = new ArrayList<E>();
                        int i = 0;
                        while (i < result.length) {
                            try {
                                URI genModelURI = URI.createPlatformResourceURI((String)((IFile)((FileSystemElement)result[i]).getFileSystemObject()).getFullPath().toString());
                                Resource resource = this.this$1.referencedGenModels.getResource(genModelURI, true);
                                genModels.add(resource.getContents().get(0));
                            }
                            catch (Exception exception) {
                                GenModelEditPlugin.INSTANCE.log(exception);
                            }
                            ++i;
                        }
                        this.this$1.filterPackagesTable();
                        this.this$1.referencedGenModelsCheckboxTreeViewer.setInput((Object)new ItemProvider(genModels));
                        ArrayList<GenPackage> checkedGenPackages = new ArrayList<GenPackage>();
                        Iterator<E> j = genModels.iterator();
                        while (j.hasNext()) {
                            GenModel genModel = (GenModel)j.next();
                            Iterator<E> k = genModel.getGenPackages().iterator();
                            while (k.hasNext()) {
                                GenPackage genPackage = (GenPackage)k.next();
                                boolean match = false;
                                Iterator<E> l = this.this$1.ePackageList.iterator();
                                while (l.hasNext()) {
                                    EPackage ePackage = (EPackage)l.next();
                                    if (this.this$1.checkedEPackageList.contains(ePackage)) continue;
                                    if (genPackage.getEcorePackage().getNsURI().equalsIgnoreCase(ePackage.getNsURI())) {
                                        match = true;
                                        break;
                                    }
                                    if (!genPackage.getEcorePackage().getName().equalsIgnoreCase(ePackage.getName())) continue;
                                    match = true;
                                }
                                if (!match) continue;
                                checkedGenPackages.add(genPackage);
                            }
                        }
                        this.this$1.referencedGenModelsCheckboxTreeViewer.setSelection((ISelection)new StructuredSelection(checkedGenPackages.toArray()), true);
                    }
                }
            });
            Tree referencedGenModelsTree = new Tree(composite, 2082);
            this.referencedGenModelsCheckboxTreeViewer = new CheckboxTreeViewer(referencedGenModelsTree);
            GridData data4 = new GridData();
            data4.verticalAlignment = 4;
            data4.grabExcessHorizontalSpace = true;
            data4.horizontalAlignment = 4;
            data4.horizontalSpan = 2;
            referencedGenModelsTree.setLayoutData((Object)data4);
            GenModelItemProviderAdapterFactory genModelItemProviderAdapterFactory = new GenModelItemProviderAdapterFactory(this){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                public Adapter createGenPackageAdapter() {
                    if (this.genPackageItemProvider == null) {
                        this.genPackageItemProvider = new GenPackageItemProvider(this, (AdapterFactory)this){
                            private final /* synthetic */ 37 this$2;
                            {
                                super(x0);
                                this.this$2 = this$2;
                            }

                            public Collection getChildrenReferences(Object object) {
                                return Collections.EMPTY_LIST;
                            }
                        };
                    }
                    return this.genPackageItemProvider;
                }
            };
            this.referencedGenModelsCheckboxTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)genModelItemProviderAdapterFactory));
            this.referencedGenModelsCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)genModelItemProviderAdapterFactory));
            this.referencedGenModelsCheckboxTreeViewer.addCheckStateListener(new ICheckStateListener(this){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                public void checkStateChanged(CheckStateChangedEvent event) {
                    this.this$1.filterPackagesTable();
                    this.this$1.validate();
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                }
            });
            this.setControl((Control)composite);
        }

        private boolean validateName(String fileName, String packageName) {
            String msg = null;
            if (fileName == null || fileName.equals("")) {
                msg = packageName == null ? GenModelEditPlugin.INSTANCE.getString("_UI_EcoreModelFileNameCannotBeEmpty_message") : GenModelEditPlugin.INSTANCE.getString("_UI_EcoreModelFileNameForPackageCannotBeEmpty_message", new Object[]{packageName});
            } else if (!fileName.endsWith(".ecore")) {
                msg = packageName == null ? GenModelEditPlugin.INSTANCE.getString("_UI_EcoreModelFileNameMustEndWithEcore_message") : GenModelEditPlugin.INSTANCE.getString("_UI_EcoreModelFileNameForPackageMustEndWithEcore_message", new Object[]{packageName});
            }
            this.setErrorMessage(msg);
            return msg == null;
        }

        void validate() {
            UniqueEList referencedEPackages = new UniqueEList();
            Iterator i = this.ePackageList.iterator();
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                if (!this.getCheckedEPackageList().contains(ePackage) && this.filteredEPackageList.contains(ePackage)) continue;
                TreeIterator j = ePackage.eAllContents();
                while (j.hasNext()) {
                    EObject eObject = (EObject)j.next();
                    Iterator k = eObject.eCrossReferences().iterator();
                    while (k.hasNext()) {
                        Object o = k.next();
                        if (!(o instanceof EClassifier)) continue;
                        EClassifier eClassifier = (EClassifier)o;
                        referencedEPackages.add(eClassifier.getEPackage());
                    }
                }
            }
            String errorMessage = null;
            Iterator i2 = referencedEPackages.iterator();
            while (i2.hasNext()) {
                EPackage ePackage = (EPackage)i2.next();
                if (this.getCheckedEPackageList().contains(ePackage) || !this.filteredEPackageList.contains(ePackage)) continue;
                errorMessage = GenModelEditPlugin.INSTANCE.getString("_UI_PackageIsUsedBySelectedPackage_message", new Object[]{ePackage.getName()});
            }
            this.setErrorMessage(errorMessage);
            if (errorMessage == null) {
                List checked = this.getCheckedEPackageList();
                Iterator i3 = this.ePackageToEcoreFileInformationMap.entrySet().iterator();
                while (i3.hasNext()) {
                    String fileName;
                    Map.Entry entry = i3.next();
                    EPackage ePackage = (EPackage)entry.getKey();
                    if (checked.contains(ePackage) && !this.validateName(fileName = ((List)entry.getValue()).get(0).toString(), ePackage.getName())) break;
                }
            }
        }

        public void refreshPackagesTable() {
            WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(this){
                private final /* synthetic */ PackagePage this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            block2 : switch (PackagePage.access$500((PackagePage)this.this$1).whichModel) {
                                case 3: {
                                    String roseModelLocationString = PackagePage.access$500((PackagePage)this.this$1).roseModelPage.getRoseModelLocationPath().toString();
                                    progressMonitor.beginTask("", 2);
                                    progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_CreatingPackagesFor_message", new Object[]{roseModelLocationString}));
                                    this.this$1.roseUtil = new RoseUtil();
                                    this.this$1.roseUtil.getVariableToDirectoryMap().putAll(PackagePage.access$500((PackagePage)this.this$1).roseModelPage.getPathMap());
                                    this.this$1.ePackageToEcoreFileInformationMap.clear();
                                    this.this$1.unitTree = this.this$1.roseUtil.createRoseUnitTreeAndTable(roseModelLocationString, null);
                                    this.this$1.roseUtil.createExtent4RoseUnitTree(this.this$1.unitTree);
                                    this.this$1.roseUtil.processUnitTree(this.this$1.unitTree);
                                    PackagePage.access$500((PackagePage)this.this$1).ePackageToInformationMap = new HashMap<K, V>(this.this$1.roseUtil.getEPackageToInformationMap());
                                    this.this$1.ePackageList.clear();
                                    this.this$1.checkedEPackageList.clear();
                                    this.this$1.traversePackages(this.this$1.unitTree);
                                    this.this$1.filterPackagesTable();
                                    if (!this.this$1.roseUtil.getStatus().isOK()) {
                                        ErrorDialog.openError((Shell)this.this$1.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_RoseToGeneratorModelConversionProblem_title"), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ConversionMayBeIncomplete_message"), (IStatus)this.this$1.roseUtil.getStatus());
                                    }
                                    break;
                                }
                                case 1: {
                                    URI xmlSchemaModelLocation = PackagePage.access$500((PackagePage)this.this$1).xmlSchemaModelPage.getXMLSchemaModelLocation();
                                    progressMonitor.beginTask("", 2);
                                    progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_CreatingPackagesFor_message", new Object[]{xmlSchemaModelLocation}));
                                    this.this$1.ePackageToEcoreFileInformationMap.clear();
                                    this.this$1.ePackageList.clear();
                                    this.this$1.checkedEPackageList.clear();
                                    this.this$1.traversePackages(PackagePage.access$500((PackagePage)this.this$1).xmlSchemaModelPage.getEPackages());
                                    this.this$1.filterPackagesTable();
                                    break;
                                }
                                case 2: {
                                    URI ecoreModelLocation = PackagePage.access$500((PackagePage)this.this$1).ecoreModelPage.getEcoreModelLocation();
                                    progressMonitor.beginTask("", 2);
                                    progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_CreatingPackagesFor_message", new Object[]{ecoreModelLocation}));
                                    this.this$1.ePackageToEcoreFileInformationMap.clear();
                                    this.this$1.ePackageList.clear();
                                    this.this$1.checkedEPackageList.clear();
                                    this.this$1.traversePackages(PackagePage.access$500((PackagePage)this.this$1).ecoreModelPage.getEPackages());
                                    if (PackagePage.access$500((PackagePage)this.this$1).originalGenModel == null && ecoreModelLocation != null && this.this$1.ePackageList.size() == 1) {
                                        String ecoreModelName = ecoreModelLocation.lastSegment();
                                        EPackage ePackage = (EPackage)this.this$1.ePackageList.get(0);
                                        List fileInformation = (List)this.this$1.ePackageToEcoreFileInformationMap.get(ePackage);
                                        if (ecoreModelName != null && ecoreModelName.length() > 0 && fileInformation != null && fileInformation.size() > 0) {
                                            int index = ecoreModelName.lastIndexOf(46);
                                            StringBuffer buffer = new StringBuffer(ecoreModelName);
                                            if (index != -1) {
                                                buffer.setLength(index);
                                            }
                                            buffer.append(".ecore");
                                            fileInformation.set(0, buffer);
                                        }
                                    }
                                    this.this$1.filterPackagesTable();
                                    break;
                                }
                                case 0: {
                                    progressMonitor.beginTask("", 2);
                                    progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_CreatingPackages_message"));
                                    PackagePage.access$500((PackagePage)this.this$1).javaEcoreBuilder = new JavaEcoreBuilder(PackagePage.access$500(this.this$1).getGenModelFile(), PackagePage.access$500((PackagePage)this.this$1).originalGenModel);
                                    PackagePage.access$500((PackagePage)this.this$1).javaEcoreBuilder.run(progressMonitor, false);
                                    IStatus status = PackagePage.access$500((PackagePage)this.this$1).javaEcoreBuilder.getStatus();
                                    if (!status.isOK()) {
                                        ErrorDialog.openError((Shell)this.this$1.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ConversionProblem_title"), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessingJava_message"), (IStatus)status);
                                    }
                                    this.this$1.ePackageToEcoreFileInformationMap.clear();
                                    ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
                                    Iterator<E> i = PackagePage.access$500((PackagePage)this.this$1).javaEcoreBuilder.getGenModel().getGenPackages().iterator();
                                    while (true) {
                                        if (!i.hasNext()) {
                                            this.this$1.ePackageList.clear();
                                            this.this$1.checkedEPackageList.clear();
                                            this.this$1.traversePackages(ePackages);
                                            this.this$1.filterPackagesTable();
                                            break block2;
                                        }
                                        GenPackage genPackage = (GenPackage)i.next();
                                        ePackages.add(genPackage.getEcorePackage());
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            GenModelEditPlugin.INSTANCE.log(exception);
                            Object var9_16 = null;
                            progressMonitor.done();
                            return;
                        }
                        {
                        }
                        Object var9_15 = null;
                        progressMonitor.done();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                }
            };
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
        }

        public void filterPackagesTable() {
            if (EMFProjectWizard.this.whichStyle == 2 && this.isDirty && EMFProjectWizard.this.originalGenModel != null) {
                HashSet<GenModel> genModels = new HashSet<GenModel>();
                ArrayList<GenPackage> checkedElements = new ArrayList<GenPackage>();
                Iterator genPackages = EMFProjectWizard.this.originalGenModel.getUsedGenPackages().iterator();
                while (genPackages.hasNext()) {
                    GenPackage genPackage = (GenPackage)genPackages.next();
                    checkedElements.add(genPackage);
                    genModels.add(genPackage.getGenModel());
                }
                this.referencedGenModelsCheckboxTreeViewer.setInput((Object)new ItemProvider(genModels));
                this.referencedGenModelsCheckboxTreeViewer.setCheckedElements(checkedElements.toArray());
                this.referencedGenModelsCheckboxTreeViewer.expandAll();
            } else {
                this.checkedEPackageList = Arrays.asList(this.packagesCheckboxTableViewer.getCheckedElements());
            }
            this.filteredEPackageList = new ArrayList(this.ePackageList);
            Object[] checkedElements = this.referencedGenModelsCheckboxTreeViewer.getCheckedElements();
            Iterator ePackages = this.filteredEPackageList.iterator();
            while (ePackages.hasNext()) {
                EPackage ePackage = (EPackage)ePackages.next();
                int match = -1;
                int i = 0;
                while (i < checkedElements.length) {
                    if (checkedElements[i] instanceof GenPackage) {
                        if (((GenPackage)checkedElements[i]).getEcorePackage().getNsURI().equals(ePackage.getNsURI())) {
                            match = i;
                            break;
                        }
                        if (((GenPackage)checkedElements[i]).getEcorePackage().getName().equals(ePackage.getName()) && match == -1) {
                            match = i;
                        }
                    }
                    ++i;
                }
                if (match != -1) {
                    this.ePackageToGenPackageMap.put(ePackage, checkedElements[match]);
                    ePackages.remove();
                    this.checkedEPackageList.remove(ePackage);
                    continue;
                }
                this.ePackageToGenPackageMap.remove(ePackage);
            }
            this.packagesCheckboxTableViewer.setInput((Object)new ItemProvider((Collection)this.filteredEPackageList));
            this.packagesCheckboxTableViewer.setCheckedElements(this.checkedEPackageList.toArray());
        }

        protected void traversePackages(UnitTreeNode subNode) {
            this.ePackageList.addAll(subNode.getExtent());
            Iterator i = subNode.getExtent().iterator();
            while (i.hasNext()) {
                String ecoreFileName;
                EPackage ePackage = (EPackage)i.next();
                ArrayList<StringBuffer> ecoreFileNameInformation = new ArrayList<StringBuffer>();
                this.ePackageToEcoreFileInformationMap.put(ePackage, ecoreFileNameInformation);
                String roseFileName = subNode.getRoseFileName();
                int indexOfSlash = roseFileName.lastIndexOf(File.separator);
                if (roseFileName.endsWith(".cat") && indexOfSlash != -1) {
                    String baseName = roseFileName.substring(indexOfSlash + 1, roseFileName.length() - 4);
                    int indexOfDot = baseName.lastIndexOf(".");
                    if (indexOfDot != -1) {
                        baseName = baseName.substring(indexOfDot + 1);
                    }
                    ecoreFileName = baseName + ".ecore";
                } else {
                    ecoreFileName = subNode.getExtent().size() == 1 ? subNode.getName() + ".ecore" : ePackage.getName() + ".ecore";
                }
                if (EMFProjectWizard.this.originalGenModel != null) {
                    GenPackage match = null;
                    Iterator genPackages = EMFProjectWizard.this.originalGenModel.getGenPackages().iterator();
                    while (genPackages.hasNext()) {
                        GenPackage genPackage = (GenPackage)genPackages.next();
                        if (genPackage.getEcorePackage().getNsURI().equals(ePackage.getNsURI())) {
                            match = genPackage;
                            break;
                        }
                        if (!genPackage.getEcorePackage().getName().equals(ePackage.getName()) || match != null) continue;
                        match = genPackage;
                    }
                    if (match != null) {
                        ecoreFileName = new Path(match.getEcorePackage().eResource().getURI().path()).lastSegment();
                        this.checkedEPackageList.add(ePackage);
                    }
                }
                ecoreFileNameInformation.add(new StringBuffer(ecoreFileName));
            }
            Iterator i2 = subNode.getNodes().iterator();
            while (i2.hasNext()) {
                UnitTreeNode childTree = (UnitTreeNode)i2.next();
                this.traversePackages(childTree);
            }
        }

        protected void traversePackages(Collection ePackages) {
            EMFProjectWizard.this.ePackageToInformationMap = new HashMap();
            this.ePackageList.addAll(ePackages);
            Iterator i = ePackages.iterator();
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                ArrayList<String> packageInformation = new ArrayList<String>();
                EMFProjectWizard.this.ePackageToInformationMap.put(ePackage, packageInformation);
                ArrayList<StringBuffer> ecoreFileNameInformation = new ArrayList<StringBuffer>();
                this.ePackageToEcoreFileInformationMap.put(ePackage, ecoreFileNameInformation);
                String qualifiedName = ePackage.getName();
                String ecoreFileName = qualifiedName + ".ecore";
                int index = qualifiedName.lastIndexOf(".");
                if (index != -1) {
                    packageInformation.add(qualifiedName.substring(0, index));
                    ePackage.setName(qualifiedName.substring(index + 1));
                } else {
                    packageInformation.add(null);
                }
                String prefix = ePackage.getName();
                packageInformation.add(Character.toUpperCase(prefix.charAt(0)) + prefix.substring(1));
                if (EMFProjectWizard.this.originalGenModel != null) {
                    GenPackage match = null;
                    Iterator genPackages = EMFProjectWizard.this.originalGenModel.getGenPackages().iterator();
                    while (genPackages.hasNext()) {
                        GenPackage genPackage = (GenPackage)genPackages.next();
                        if (genPackage.getEcorePackage().getNsURI().equals(ePackage.getNsURI())) {
                            match = genPackage;
                            break;
                        }
                        if (!genPackage.getEcorePackage().getName().equals(ePackage.getName()) || match != null) continue;
                        match = genPackage;
                    }
                    if (match != null) {
                        ecoreFileName = new Path(match.getEcorePackage().eResource().getURI().path()).lastSegment();
                        this.checkedEPackageList.add(ePackage);
                        packageInformation.set(0, match.getBasePackage());
                        packageInformation.set(1, match.getPrefix());
                    }
                }
                ecoreFileNameInformation.add(new StringBuffer(ecoreFileName));
            }
        }

        public RoseUtil getRoseUtil() {
            return this.roseUtil;
        }

        public UnitTreeNode getUnitTree() {
            return this.unitTree;
        }

        public List getEPackageList() {
            return this.ePackageList;
        }

        public List getFilteredEPackageList() {
            return this.filteredEPackageList;
        }

        public List getCheckedEPackageList() {
            return Arrays.asList(this.packagesCheckboxTableViewer.getCheckedElements());
        }

        public List getTargetPackageNames() {
            return this.targetPackageNames;
        }

        public Map getEPackageToEcoreFileInformationMap() {
            return this.ePackageToEcoreFileInformationMap;
        }

        public Map getEPackageToGenPackageMap() {
            return this.ePackageToGenPackageMap;
        }

        static /* synthetic */ boolean access$300(PackagePage x0, String x1, String x2) {
            return x0.validateName(x1, x2);
        }

        static /* synthetic */ EMFProjectWizard access$500(PackagePage x0) {
            return x0.EMFProjectWizard.this;
        }
    }

    public class EcoreModelPage
    extends WizardPage {
        protected Text genModelNameText;
        protected Text ecoreModelLocationText;
        protected Collection ecoreModels = new ArrayList();
        protected boolean isDirty = true;

        public EcoreModelPage(String pageId) {
            super(pageId);
        }

        public boolean isPageComplete() {
            return EMFProjectWizard.this.whichModel != 2 || !this.ecoreModels.isEmpty() && this.getErrorMessage() == null;
        }

        Collection getEPackages() {
            return this.ecoreModels;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.isDirty && EMFProjectWizard.this.whichStyle == 2 && EMFProjectWizard.this.genModelFile != null) {
                this.isDirty = false;
                this.getControl().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ EcoreModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            String firstValue;
                            Iterator<E> values = EcoreModelPage.access$200((EcoreModelPage)this.this$1).originalGenModel.getForeignModel().iterator();
                            if (values.hasNext() && (firstValue = (String)values.next()).endsWith(".ecore")) {
                                URI genModelURI = URI.createPlatformResourceURI((String)EcoreModelPage.access$200(this.this$1).getGenModelFile().getFullPath().toString());
                                firstValue = EcoreModelPage.access$200(this.this$1).makeAbsolute(URI.createURI((String)firstValue), genModelURI).toString();
                                this.this$1.ecoreModelLocationText.setText(firstValue);
                                this.this$1.refreshEcoreModel();
                            }
                        }
                        catch (Exception exception) {
                            GenModelEditPlugin.INSTANCE.log(exception);
                        }
                    }
                });
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label ecoreModelLocationLabel = new Label(composite, 16384);
            ecoreModelLocationLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_EcoreModelURI_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            ecoreModelLocationLabel.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(composite, 0);
            GridData data2 = new GridData();
            data2.horizontalAlignment = 3;
            buttonComposite.setLayoutData((Object)data2);
            RowLayout layout2 = new RowLayout();
            layout2.justify = true;
            layout2.pack = true;
            layout2.spacing = 15;
            buttonComposite.setLayout((Layout)layout2);
            Button ecoreModelLocationBrowseFileSystemButton = new Button(buttonComposite, 8);
            ecoreModelLocationBrowseFileSystemButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_BroseFileSystemFile_label"));
            Button ecoreModelLocationBrowseWorkspaceButton = new Button(buttonComposite, 8);
            ecoreModelLocationBrowseWorkspaceButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_BroseWorkspace_label"));
            this.ecoreModelLocationText = new Text(composite, 2052);
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            data3.grabExcessHorizontalSpace = true;
            data3.horizontalSpan = 3;
            this.ecoreModelLocationText.setLayoutData((Object)data3);
            this.ecoreModelLocationText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ EcoreModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent event) {
                    this.this$1.ecoreModels.clear();
                    this.this$1.setPageComplete(false);
                }
            });
            ecoreModelLocationBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ EcoreModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(this.this$1.getShell());
                    fileDialog.setFilterExtensions(new String[]{"*.ecore"});
                    fileDialog.open();
                    if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                        String filePath = fileDialog.getFilterPath() + File.separator + fileDialog.getFileName();
                        this.this$1.ecoreModelLocationText.setText(URI.createFileURI((String)filePath).toString());
                        this.this$1.refreshEcoreModel();
                    }
                }
            });
            ecoreModelLocationBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ EcoreModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    ArrayList<E> ecoreModelResources = new ArrayList<E>();
                    FileSelectionDialog fileSelectionDialog = new FileSelectionDialog(this.this$1.getShell(), EMFProjectWizard.createFileSystemElement(null, (IResource)ResourcesPlugin.getWorkspace().getRoot(), ecoreModelResources, "ecore"), GenModelEditPlugin.INSTANCE.getString("_UI_SelectTheEcoreModel_label"));
                    fileSelectionDialog.setExpandAllOnOpen(true);
                    fileSelectionDialog.open();
                    Object[] result = fileSelectionDialog.getResult();
                    if (result != null && result.length > 0) {
                        URI ecoreModelURI = URI.createPlatformResourceURI((String)((IFile)((FileSystemElement)result[0]).getFileSystemObject()).getFullPath().toString());
                        this.this$1.ecoreModelLocationText.setText(ecoreModelURI.toString());
                        this.this$1.refreshEcoreModel();
                    }
                }
            });
            Button pathMapTableLoadButton = new Button(composite, 8);
            pathMapTableLoadButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Load_label"));
            GridData data4 = new GridData();
            data4.horizontalSpan = 2;
            data4.horizontalAlignment = 3;
            pathMapTableLoadButton.setLayoutData((Object)data4);
            pathMapTableLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ EcoreModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    this.this$1.refreshEcoreModel();
                }
            });
            if (EMFProjectWizard.this.whichStyle == 0) {
                Label genModelNameLabel = new Label(composite, 16384);
                genModelNameLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelName_label"));
                GridData data5 = new GridData();
                data5.horizontalAlignment = 4;
                data5.horizontalSpan = 2;
                genModelNameLabel.setLayoutData((Object)data5);
                this.genModelNameText = new Text(composite, 2052);
                data5 = new GridData();
                data5.horizontalAlignment = 4;
                data5.grabExcessHorizontalSpace = true;
                data5.horizontalSpan = 2;
                this.genModelNameText.setLayoutData((Object)data5);
                this.genModelNameText.addModifyListener(new ModifyListener(this){
                    private final /* synthetic */ EcoreModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void modifyText(ModifyEvent event) {
                        String name = ((Text)event.getSource()).getText();
                        String msg = null;
                        if (name == null || name.equals("")) {
                            msg = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameCannotBeEmpty_message");
                        } else if (!name.endsWith(".genmodel")) {
                            msg = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message");
                        }
                        this.this$1.setErrorMessage(msg);
                        this.this$1.setPageComplete(this.this$1.isPageComplete());
                    }
                });
            }
            this.setControl((Control)composite);
        }

        public void refreshEcoreModel() {
            WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(this){
                private final /* synthetic */ EcoreModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            URI ecoreModelLocation = this.this$1.getEcoreModelLocation();
                            progressMonitor.beginTask("", 2);
                            progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{ecoreModelLocation}));
                            ResourceSetImpl ecoreResourceSet = new ResourceSetImpl();
                            Resource ecoreResource = ecoreResourceSet.getResource(ecoreModelLocation, true);
                            TreeIterator i = ecoreResourceSet.getAllContents();
                            while (i.hasNext()) {
                                E content = i.next();
                                if (!(content instanceof EObject)) continue;
                                Iterator<E> j = ((EObject)content).eCrossReferences().iterator();
                                while (j.hasNext()) {
                                    E referencedObject = j.next();
                                }
                            }
                            this.this$1.ecoreModels.clear();
                            Iterator<E> i2 = ecoreResourceSet.getResources().iterator();
                            while (i2.hasNext()) {
                                Resource resource = (Resource)i2.next();
                                this.this$1.ecoreModels.addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
                            }
                            if (EcoreModelPage.access$200((EcoreModelPage)this.this$1).whichStyle == 0) {
                                String genModelName = ecoreModelLocation.trimFileExtension().lastSegment() + ".genmodel";
                                this.this$1.genModelNameText.setText(genModelName);
                            }
                            EcoreModelPage.access$200((EcoreModelPage)this.this$1).packagePage.setDirty(true);
                        }
                        catch (Exception exception) {
                            Object var10_11 = null;
                            if (this.this$1.ecoreModels.isEmpty()) {
                                this.this$1.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidEcoreModel_message"));
                            }
                            progressMonitor.done();
                            return;
                        }
                        Object var10_10 = null;
                        if (this.this$1.ecoreModels.isEmpty()) {
                            this.this$1.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidEcoreModel_message"));
                        }
                        progressMonitor.done();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        if (this.this$1.ecoreModels.isEmpty()) {
                            this.this$1.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidEcoreModel_message"));
                        }
                        progressMonitor.done();
                        throw throwable;
                    }
                }
            };
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
            this.setPageComplete(this.isPageComplete());
        }

        public URI getEcoreModelLocation() {
            return this.ecoreModelLocationText == null ? null : URI.createURI((String)this.ecoreModelLocationText.getText());
        }

        public String getGenModelName() {
            return this.genModelNameText == null ? null : this.genModelNameText.getText();
        }

        static /* synthetic */ EMFProjectWizard access$200(EcoreModelPage x0) {
            return x0.EMFProjectWizard.this;
        }
    }

    public class XMLSchemaModelPage
    extends WizardPage {
        protected Text genModelNameText;
        protected Text xmlSchemaModelLocationText;
        protected Button createMapButton;
        protected List ecoreModels = new ArrayList();
        protected EObject mappingRoot;
        protected boolean isDirty = true;

        public XMLSchemaModelPage(String pageId) {
            super(pageId);
        }

        public boolean isPageComplete() {
            return EMFProjectWizard.this.whichModel != 1 || !this.ecoreModels.isEmpty() && this.getErrorMessage() == null;
        }

        Collection getEPackages() {
            return this.ecoreModels;
        }

        EObject getMappingRoot() {
            return this.mappingRoot;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.isDirty && EMFProjectWizard.this.whichStyle == 2 && EMFProjectWizard.this.genModelFile != null) {
                this.isDirty = false;
                this.getControl().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ XMLSchemaModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            String firstValue;
                            Iterator<E> values = XMLSchemaModelPage.access$100((XMLSchemaModelPage)this.this$1).originalGenModel.getForeignModel().iterator();
                            if (values.hasNext() && (firstValue = (String)values.next()).endsWith(".xsd")) {
                                URI genModelURI = URI.createPlatformResourceURI((String)XMLSchemaModelPage.access$100(this.this$1).getGenModelFile().getFullPath().toString());
                                firstValue = XMLSchemaModelPage.access$100(this.this$1).makeAbsolute(URI.createURI((String)firstValue), genModelURI).toString();
                                this.this$1.xmlSchemaModelLocationText.setText(firstValue);
                                this.this$1.refreshXMLSchemaModel();
                            }
                        }
                        catch (Exception exception) {
                            GenModelEditPlugin.INSTANCE.log(exception);
                        }
                    }
                });
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label xmlSchemaModelLocationLabel = new Label(composite, 16384);
            xmlSchemaModelLocationLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_XMLSchemaURI_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            xmlSchemaModelLocationLabel.setLayoutData((Object)data);
            Composite buttonComposite = new Composite(composite, 0);
            GridData data2 = new GridData();
            data2.horizontalAlignment = 3;
            buttonComposite.setLayoutData((Object)data2);
            RowLayout layout2 = new RowLayout();
            layout2.justify = true;
            layout2.pack = true;
            layout2.spacing = 15;
            buttonComposite.setLayout((Layout)layout2);
            Button xmlSchemaModelLocationBrowseFileSystemButton = new Button(buttonComposite, 8);
            xmlSchemaModelLocationBrowseFileSystemButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_BroseFileSystemFile_label"));
            Button xmlSchemaModelLocationBrowseWorkspaceButton = new Button(buttonComposite, 8);
            xmlSchemaModelLocationBrowseWorkspaceButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_BroseWorkspace_label"));
            this.xmlSchemaModelLocationText = new Text(composite, 2052);
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            data3.grabExcessHorizontalSpace = true;
            data3.horizontalSpan = 3;
            this.xmlSchemaModelLocationText.setLayoutData((Object)data3);
            this.xmlSchemaModelLocationText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ XMLSchemaModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent event) {
                    this.this$1.ecoreModels.clear();
                    this.this$1.setPageComplete(false);
                }
            });
            xmlSchemaModelLocationBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ XMLSchemaModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(this.this$1.getShell());
                    fileDialog.setFilterExtensions(new String[]{"*.xsd"});
                    fileDialog.open();
                    if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                        String filePath = fileDialog.getFilterPath() + File.separator + fileDialog.getFileName();
                        this.this$1.xmlSchemaModelLocationText.setText(URI.createFileURI((String)filePath).toString());
                        this.this$1.refreshXMLSchemaModel();
                    }
                }
            });
            xmlSchemaModelLocationBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ XMLSchemaModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    ArrayList<E> xmlSchemaResources = new ArrayList<E>();
                    FileSelectionDialog fileSelectionDialog = new FileSelectionDialog(this.this$1.getShell(), EMFProjectWizard.createFileSystemElement(null, (IResource)ResourcesPlugin.getWorkspace().getRoot(), xmlSchemaResources, "xsd"), GenModelEditPlugin.INSTANCE.getString("_UI_SelectTheXMLSchema_label"));
                    fileSelectionDialog.setExpandAllOnOpen(true);
                    fileSelectionDialog.open();
                    Object[] result = fileSelectionDialog.getResult();
                    if (result != null && result.length > 0) {
                        URI xmlSchemaModelURI = URI.createPlatformResourceURI((String)((IFile)((FileSystemElement)result[0]).getFileSystemObject()).getFullPath().toString());
                        this.this$1.xmlSchemaModelLocationText.setText(xmlSchemaModelURI.toString());
                        this.this$1.refreshXMLSchemaModel();
                    }
                }
            });
            Plugin xsd2ecorePlugin = Platform.getPlugin((String)"org.eclipse.emf.mapping.xsd2ecore");
            if (xsd2ecorePlugin != null) {
                this.createMapButton = new Button(composite, 32);
                this.createMapButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Create_XML_Schema_to_Ecore_Map"));
                GridData data4 = new GridData();
                data4.horizontalSpan = 1;
                this.createMapButton.setLayoutData((Object)data4);
                this.createMapButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ XMLSchemaModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        this.this$1.refreshXMLSchemaModel();
                    }
                });
            }
            Button pathMapTableLoadButton = new Button(composite, 8);
            pathMapTableLoadButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Load_label"));
            GridData data5 = new GridData();
            data5.horizontalSpan = xsd2ecorePlugin == null ? 2 : 1;
            data5.horizontalAlignment = 3;
            pathMapTableLoadButton.setLayoutData((Object)data5);
            pathMapTableLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ XMLSchemaModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    this.this$1.refreshXMLSchemaModel();
                }
            });
            if (EMFProjectWizard.this.whichStyle == 0) {
                Label genModelNameLabel = new Label(composite, 16384);
                genModelNameLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelName_label"));
                GridData data6 = new GridData();
                data6.horizontalAlignment = 4;
                data6.horizontalSpan = 2;
                genModelNameLabel.setLayoutData((Object)data6);
                this.genModelNameText = new Text(composite, 2052);
                data6 = new GridData();
                data6.horizontalAlignment = 4;
                data6.grabExcessHorizontalSpace = true;
                data6.horizontalSpan = 2;
                this.genModelNameText.setLayoutData((Object)data6);
                this.genModelNameText.addModifyListener(new ModifyListener(this){
                    private final /* synthetic */ XMLSchemaModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void modifyText(ModifyEvent event) {
                        String name = ((Text)event.getSource()).getText();
                        String msg = null;
                        if (name == null || name.equals("")) {
                            msg = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameCannotBeEmpty_message");
                        } else if (!name.endsWith(".genmodel")) {
                            msg = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message");
                        }
                        this.this$1.setErrorMessage(msg);
                        this.this$1.setPageComplete(this.this$1.isPageComplete());
                    }
                });
            }
            this.setControl((Control)composite);
        }

        public void refreshXMLSchemaModel() {
            WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(this){
                static /* synthetic */ Class class$org$eclipse$emf$common$util$URI;
                private final /* synthetic */ XMLSchemaModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    block16: {
                        try {
                            try {
                                URI xmlSchemaModelLocation = this.this$1.getXMLSchemaModelLocation();
                                progressMonitor.beginTask("", 2);
                                progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{xmlSchemaModelLocation}));
                                Plugin xsdPlugin = Platform.getPlugin((String)"org.eclipse.xsd");
                                Class<?> theGeneratorClass = xsdPlugin.getClass().getClassLoader().loadClass("org.eclipse.xsd.ecore.XSDEcoreBuilder");
                                ? ecoreGenerator = theGeneratorClass.newInstance();
                                Plugin xsd2ecorePlugin = Platform.getPlugin((String)"org.eclipse.emf.mapping.xsd2ecore");
                                if (xsd2ecorePlugin != null && this.this$1.createMapButton != null && this.this$1.createMapButton.getSelection()) {
                                    try {
                                        Class<?> theMapperInterface = xsdPlugin.getClass().getClassLoader().loadClass("org.eclipse.xsd.ecore.MapBuilder$Mapper");
                                        Class<?> theMapperClass = xsd2ecorePlugin.getClass().getClassLoader().loadClass("org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreMapper");
                                        ? mapper = theMapperClass.newInstance();
                                        theGeneratorClass.getMethod("setMapper", theMapperInterface).invoke(ecoreGenerator, mapper);
                                    }
                                    catch (InstantiationException exception) {
                                        GenModelEditPlugin.INSTANCE.log(exception);
                                    }
                                    catch (NoSuchMethodException exception) {
                                        GenModelEditPlugin.INSTANCE.log(exception);
                                    }
                                    catch (IllegalAccessException exception) {
                                        GenModelEditPlugin.INSTANCE.log(exception);
                                    }
                                    catch (InvocationTargetException exception) {
                                        GenModelEditPlugin.INSTANCE.log(exception);
                                    }
                                    catch (ClassNotFoundException exception) {
                                        // empty catch block
                                    }
                                }
                                this.this$1.ecoreModels.clear();
                                this.this$1.ecoreModels.addAll((Collection)theGeneratorClass.getDeclaredMethod("generate", class$org$eclipse$emf$common$util$URI == null ? (class$org$eclipse$emf$common$util$URI = 22.class$("org.eclipse.emf.common.util.URI")) : class$org$eclipse$emf$common$util$URI).invoke(ecoreGenerator, xmlSchemaModelLocation));
                                if (!this.this$1.ecoreModels.isEmpty() && !(this.this$1.ecoreModels.get(this.this$1.ecoreModels.size() - 1) instanceof EPackage)) {
                                    this.this$1.mappingRoot = (EObject)this.this$1.ecoreModels.remove(this.this$1.ecoreModels.size() - 1);
                                }
                                if (XMLSchemaModelPage.access$100((XMLSchemaModelPage)this.this$1).whichStyle == 0) {
                                    String genModelName = xmlSchemaModelLocation.trimFileExtension().lastSegment() + ".genmodel";
                                    this.this$1.genModelNameText.setText(genModelName);
                                }
                                XMLSchemaModelPage.access$100((XMLSchemaModelPage)this.this$1).packagePage.setDirty(true);
                            }
                            catch (Exception exception) {
                                GenModelEditPlugin.INSTANCE.log(exception);
                                Object var13_17 = null;
                                if (this.this$1.ecoreModels.isEmpty()) {
                                    this.this$1.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidXMLSchema_message"));
                                }
                                progressMonitor.done();
                                return;
                            }
                            Object var13_16 = null;
                            if (!this.this$1.ecoreModels.isEmpty()) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var13_18 = null;
                            if (this.this$1.ecoreModels.isEmpty()) {
                                this.this$1.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidXMLSchema_message"));
                            }
                            progressMonitor.done();
                            throw throwable;
                        }
                        this.this$1.setErrorMessage(GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidXMLSchema_message"));
                    }
                    progressMonitor.done();
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            };
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
            this.setPageComplete(this.isPageComplete());
        }

        public URI getXMLSchemaModelLocation() {
            return this.xmlSchemaModelLocationText == null ? null : URI.createURI((String)this.xmlSchemaModelLocationText.getText());
        }

        public String getGenModelName() {
            return this.genModelNameText == null ? null : this.genModelNameText.getText();
        }

        static /* synthetic */ EMFProjectWizard access$100(XMLSchemaModelPage x0) {
            return x0.EMFProjectWizard.this;
        }
    }

    public class RoseModelPage
    extends WizardPage {
        protected Text genModelNameText;
        protected Text roseModelLocationText;
        protected Map pathMap = new HashMap();
        protected TableViewer pathMapTableViewer;
        protected boolean isCellEditing;
        protected boolean isDirty = true;
        protected RoseUtil roseUtil;
        protected UnitTreeNode unitTree;

        public RoseModelPage(String pageId) {
            super(pageId);
        }

        public boolean isPageComplete() {
            return EMFProjectWizard.this.whichModel != 3 || !this.isCellEditing && this.unitTree != null && this.getErrorMessage() == null;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.isDirty && EMFProjectWizard.this.whichStyle == 2 && EMFProjectWizard.this.genModelFile != null) {
                this.isDirty = false;
                this.getControl().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ RoseModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        try {
                            String firstValue;
                            Iterator<E> values = RoseModelPage.access$000((RoseModelPage)this.this$1).originalGenModel.getForeignModel().iterator();
                            if (values.hasNext() && (firstValue = (String)values.next()).endsWith(".mdl")) {
                                URI genModelFileURI = URI.createFileURI((String)RoseModelPage.access$000(this.this$1).getGenModelFile().getLocation().toOSString());
                                firstValue = RoseModelPage.access$000(this.this$1).makeAbsolute(URI.createFileURI((String)firstValue), genModelFileURI).toFileString();
                                this.this$1.roseModelLocationText.setText(firstValue);
                                while (values.hasNext()) {
                                    String variable = (String)values.next();
                                    String value = (String)values.next();
                                    value = RoseModelPage.access$000(this.this$1).makeAbsolute(URI.createFileURI((String)value), genModelFileURI).toFileString();
                                    this.this$1.pathMap.put(variable, value);
                                }
                                this.this$1.refreshPathMapTable();
                            }
                        }
                        catch (Exception exception) {
                            GenModelEditPlugin.INSTANCE.log(exception);
                        }
                    }
                });
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label roseModelLocationLabel = new Label(composite, 16384);
            roseModelLocationLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_RoseModelLocation_label"));
            data = new GridData();
            data.horizontalAlignment = 4;
            roseModelLocationLabel.setLayoutData((Object)data);
            Button roseModelLocationBrowseButton = new Button(composite, 8);
            roseModelLocationBrowseButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Browse_label"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 3;
            roseModelLocationBrowseButton.setLayoutData((Object)data2);
            this.roseModelLocationText = new Text(composite, 2052);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.horizontalSpan = 2;
            this.roseModelLocationText.setLayoutData((Object)data2);
            this.roseModelLocationText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent event) {
                    this.this$1.unitTree = null;
                    this.this$1.setPageComplete(false);
                }
            });
            roseModelLocationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(this.this$1.getShell());
                    fileDialog.setFilterExtensions(new String[]{"*.mdl"});
                    fileDialog.open();
                    if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
                        String filePath = fileDialog.getFilterPath() + File.separator + fileDialog.getFileName();
                        this.this$1.roseModelLocationText.setText(filePath);
                        this.this$1.refreshPathMapTable();
                    }
                }
            });
            Label pathMapLabel = new Label(composite, 16384);
            pathMapLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_PathMap_label"));
            GridData data3 = new GridData();
            data3.horizontalAlignment = 4;
            pathMapLabel.setLayoutData((Object)data3);
            Composite buttonComposite = new Composite(composite, 0);
            GridData data4 = new GridData();
            data4.horizontalAlignment = 3;
            buttonComposite.setLayoutData((Object)data4);
            RowLayout layout2 = new RowLayout();
            layout2.justify = true;
            layout2.pack = true;
            layout2.spacing = 15;
            buttonComposite.setLayout((Layout)layout2);
            Button pathMapTableLoadButton = new Button(buttonComposite, 8);
            pathMapTableLoadButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Load_label"));
            pathMapTableLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    this.this$1.refreshPathMapTable();
                }
            });
            Button pathMapTableBrowseButton = new Button(buttonComposite, 8);
            pathMapTableBrowseButton.setEnabled(false);
            pathMapTableBrowseButton.setText(GenModelEditPlugin.INSTANCE.getString("_UI_Browse_label"));
            Table pathMapTable = new Table(composite, 2048);
            pathMapTable.addSelectionListener((SelectionListener)new SelectionAdapter(this, pathMapTableBrowseButton, pathMapTable){
                private final /* synthetic */ Button val$pathMapTableBrowseButton;
                private final /* synthetic */ Table val$pathMapTable;
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                    this.val$pathMapTableBrowseButton = val$pathMapTableBrowseButton;
                    this.val$pathMapTable = val$pathMapTable;
                }

                public void widgetSelected(SelectionEvent event) {
                    this.val$pathMapTableBrowseButton.setEnabled(this.val$pathMapTable.getSelectionIndex() != -1);
                }
            });
            pathMapTableBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, pathMapTable){
                private final /* synthetic */ Table val$pathMapTable;
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                    this.val$pathMapTable = val$pathMapTable;
                }

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(this.this$1.getShell());
                    String path = directoryDialog.open();
                    if (path != null && path.length() > 0) {
                        int index = this.val$pathMapTable.getSelectionIndex();
                        this.this$1.pathMap.put(this.val$pathMapTable.getItem(index).getText(), path);
                        this.this$1.unitTree = null;
                        this.this$1.setPageComplete(false);
                        this.this$1.pathMapTableViewer.refresh();
                        if (++index < this.val$pathMapTable.getItemCount()) {
                            this.val$pathMapTable.select(index);
                        }
                    }
                }
            });
            this.pathMapTableViewer = new TableViewer(pathMapTable);
            GridData data5 = new GridData();
            data5.verticalAlignment = 4;
            data5.grabExcessVerticalSpace = true;
            data5.horizontalAlignment = 4;
            data5.horizontalSpan = 2;
            pathMapTable.setLayoutData((Object)data5);
            pathMapTable.setHeaderVisible(true);
            pathMapTable.setLinesVisible(true);
            TableLayout layout3 = new TableLayout();
            TableColumn variableNameColumn = new TableColumn(pathMapTable, 0);
            layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
            variableNameColumn.setText(GenModelEditPlugin.INSTANCE.getString("_UI_SymbolName_label"));
            variableNameColumn.setResizable(true);
            TableColumn locationColumn = new TableColumn(pathMapTable, 0);
            layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
            locationColumn.setText(GenModelEditPlugin.INSTANCE.getString("_UI_ActualLocation_label"));
            locationColumn.setResizable(true);
            pathMapTable.setLayout((Layout)layout3);
            ExtendedTableEditor extendedTableEditor = new ExtendedTableEditor(this, pathMapTable){
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                protected void editItem(TableItem tableItem, int column) {
                    switch (column) {
                        case 1: {
                            String string = tableItem.getText(column);
                            ((ControlEditor)this).horizontalAlignment = 16384;
                            ((ControlEditor)this).minimumWidth = Math.max(50, tableItem.getBounds((int)column).width);
                            Text text = new Text((Composite)this.table, 0);
                            this.setEditor((Control)text, tableItem, column);
                            text.setFocus();
                            text.setText(string);
                            text.setSelection(0, string.length());
                            text.addFocusListener((FocusListener)new FocusAdapter(this, tableItem, column, text){
                                private final /* synthetic */ TableItem val$tableItem;
                                private final /* synthetic */ int val$column;
                                private final /* synthetic */ Text val$text;
                                private final /* synthetic */ 9 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$tableItem = val$tableItem;
                                    this.val$column = val$column;
                                    this.val$text = val$text;
                                }

                                public void focusLost(FocusEvent event) {
                                    this.this$2.modify(this.val$tableItem, this.val$column, this.val$text);
                                }
                            });
                            text.addKeyListener((KeyListener)new KeyAdapter(this, tableItem, column, text){
                                private final /* synthetic */ TableItem val$tableItem;
                                private final /* synthetic */ int val$column;
                                private final /* synthetic */ Text val$text;
                                private final /* synthetic */ 9 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$tableItem = val$tableItem;
                                    this.val$column = val$column;
                                    this.val$text = val$text;
                                }

                                public void keyPressed(KeyEvent event) {
                                    if (event.character == '\r' || event.character == '\n') {
                                        this.this$2.modify(this.val$tableItem, this.val$column, this.val$text);
                                        this.this$2.setEditor(null);
                                        this.val$text.dispose();
                                    } else if (event.character == '\u001b') {
                                        this.this$2.setEditor(null);
                                        this.val$text.dispose();
                                    }
                                }
                            });
                            this.this$1.isCellEditing = true;
                            this.this$1.setPageComplete(false);
                            break;
                        }
                    }
                }

                protected void modify(TableItem tableItem, int column, Text text) {
                    tableItem.setText(column, text.getText());
                    String key = tableItem.getText();
                    String value = tableItem.getText(column);
                    text.setVisible(false);
                    if ("".equals(value)) {
                        value = null;
                    }
                    this.this$1.pathMap.put(key, value);
                    this.this$1.isCellEditing = false;
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                }
            };
            AdapterFactoryImpl adapterFactory = new AdapterFactoryImpl();
            this.pathMapTableViewer.setColumnProperties(new String[]{"a", "b"});
            this.pathMapTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
            this.pathMapTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this, (AdapterFactory)adapterFactory){
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                public Image getColumnImage(Object o, int columnIndex) {
                    switch (columnIndex) {
                        default: 
                    }
                    return null;
                }

                public String getColumnText(Object o, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return (String)o;
                        }
                    }
                    String result = (String)this.this$1.pathMap.get(o);
                    return result == null ? "" : result;
                }
            });
            if (EMFProjectWizard.this.whichStyle == 0) {
                Label genModelNameLabel = new Label(composite, 16384);
                genModelNameLabel.setText(GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelName_label"));
                GridData data6 = new GridData();
                data6.horizontalAlignment = 4;
                data6.horizontalSpan = 2;
                genModelNameLabel.setLayoutData((Object)data6);
                this.genModelNameText = new Text(composite, 2052);
                data6 = new GridData();
                data6.horizontalAlignment = 4;
                data6.grabExcessHorizontalSpace = true;
                data6.horizontalSpan = 2;
                this.genModelNameText.setLayoutData((Object)data6);
                this.genModelNameText.addModifyListener(new ModifyListener(this){
                    private final /* synthetic */ RoseModelPage this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void modifyText(ModifyEvent event) {
                        String name = ((Text)event.getSource()).getText();
                        String msg = null;
                        if (name == null || name.equals("")) {
                            msg = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameCannotBeEmpty_message");
                        } else if (!name.endsWith(".genmodel")) {
                            msg = GenModelEditPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message");
                        }
                        this.this$1.setErrorMessage(msg);
                        this.this$1.setPageComplete(this.this$1.isPageComplete());
                    }
                });
            }
            this.setControl((Control)composite);
        }

        public void refreshPathMapTable() {
            WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(this){
                private final /* synthetic */ RoseModelPage this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            String errorMessage;
                            String message;
                            block10: {
                                IPath genModelBasisPath;
                                IPath roseModelLocationPath = this.this$1.getRoseModelLocationPath();
                                String roseModelLocationString = roseModelLocationPath.toOSString();
                                progressMonitor.beginTask("", 2);
                                progressMonitor.subTask(GenModelEditPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{roseModelLocationString}));
                                while (true) {
                                    int index;
                                    this.this$1.unitTree = null;
                                    this.this$1.roseUtil = new RoseUtil();
                                    this.this$1.roseUtil.getVariableToDirectoryMap().putAll(this.this$1.pathMap);
                                    message = null;
                                    errorMessage = null;
                                    this.this$1.unitTree = this.this$1.roseUtil.createRoseUnitTreeAndTable(roseModelLocationString, null);
                                    if (this.this$1.unitTree == null) {
                                        errorMessage = GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyAValidRoseModel_message");
                                        break block10;
                                    }
                                    this.this$1.pathMap.putAll(this.this$1.roseUtil.getVariableToDirectoryMap());
                                    this.this$1.pathMap.remove(null);
                                    if (!this.this$1.pathMap.containsKey("VABASE_PLUGINS_PATH") || this.this$1.pathMap.get("VABASE_PLUGINS_PATH") != null || (index = roseModelLocationString.indexOf(File.separator + "plugins" + File.separator)) == -1) break;
                                    this.this$1.pathMap.put("VABASE_PLUGINS_PATH", roseModelLocationString.substring(0, index + 8));
                                }
                                Object object = genModelBasisPath = this.this$1.unitTree.getNodes().size() != 1 ? roseModelLocationPath : new Path(((UnitTreeNode)this.this$1.unitTree.getNodes().get(0)).getRoseFileName());
                                if (RoseModelPage.access$000((RoseModelPage)this.this$1).whichStyle == 0) {
                                    String genModelName = genModelBasisPath.removeFileExtension().lastSegment() + ".genmodel";
                                    this.this$1.genModelNameText.setText(genModelName);
                                }
                                Iterator<Map.Entry<K, V>> entries = this.this$1.roseUtil.getVariableToDirectoryMap().entrySet().iterator();
                                while (entries.hasNext()) {
                                    Map.Entry<K, V> entry = entries.next();
                                    if (entry.getValue() != null) continue;
                                    errorMessage = GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyTheSymbolLocations_message");
                                    break;
                                }
                                if (errorMessage == null && !this.this$1.roseUtil.getStatus().isOK()) {
                                    errorMessage = GenModelEditPlugin.INSTANCE.getString("_UI_SpecifyTheSymbolLocations_message");
                                    ErrorDialog.openError((Shell)this.this$1.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_LoadProblem_title"), (String)GenModelEditPlugin.INSTANCE.getString("_UI_RoseLoadFailed_message"), (IStatus)this.this$1.roseUtil.getStatus());
                                }
                            }
                            this.this$1.setMessage(message);
                            this.this$1.setErrorMessage(errorMessage);
                            this.this$1.pathMapTableViewer.setInput((Object)new ItemProvider(this.this$1.pathMap.keySet()));
                            RoseModelPage.access$000((RoseModelPage)this.this$1).packagePage.setDirty(true);
                        }
                        catch (Exception exception) {
                            GenModelEditPlugin.INSTANCE.log(exception);
                            Object var10_12 = null;
                            progressMonitor.done();
                            return;
                        }
                        Object var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            };
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
            this.setPageComplete(this.isPageComplete());
        }

        public IPath getRoseModelLocationPath() {
            return this.roseModelLocationText == null ? null : new Path(this.roseModelLocationText.getText());
        }

        public String getGenModelName() {
            return this.genModelNameText == null ? null : this.genModelNameText.getText();
        }

        public Map getPathMap() {
            return this.pathMap;
        }

        public RoseUtil getRoseUtil() {
            return this.roseUtil;
        }

        public UnitTreeNode getUnitTree() {
            return this.unitTree;
        }

        static /* synthetic */ EMFProjectWizard access$000(RoseModelPage x0) {
            return x0.EMFProjectWizard.this;
        }
    }
}

