/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.ChildrenToCopyProvider;
import org.eclipse.emf.edit.command.OverrideableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public abstract class AbstractOverrideableCommand
extends AbstractCommand
implements OverrideableCommand {
    protected EditingDomain domain;
    protected Command overrideCommand;

    protected AbstractOverrideableCommand(EditingDomain domain) {
        this(domain, null, null);
    }

    protected AbstractOverrideableCommand(EditingDomain domain, String label) {
        this(domain, label, null);
    }

    protected AbstractOverrideableCommand(EditingDomain domain, String label, String description) {
        super(label, description);
        this.domain = domain;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public Command getOverride() {
        return this.overrideCommand;
    }

    public void setOverride(Command overrideCommand) {
        this.overrideCommand = overrideCommand;
    }

    public final boolean canExecute() {
        if (this.domain != null && !this.isPrepared) {
            Command newOverrideCommand = this.domain.createOverrideCommand(this);
            this.setOverride(newOverrideCommand);
        }
        boolean result = this.overrideCommand != null ? this.overrideCommand.canExecute() : this.doCanExecute();
        return result;
    }

    public boolean doCanExecute() {
        return super.canExecute();
    }

    public final void execute() {
        if (this.overrideCommand != null) {
            this.overrideCommand.execute();
        } else {
            this.doExecute();
        }
    }

    public abstract void doExecute();

    public final boolean canUndo() {
        boolean result = this.overrideCommand != null ? this.overrideCommand.canUndo() : this.doCanUndo();
        return result;
    }

    public boolean doCanUndo() {
        return super.canUndo();
    }

    public final void undo() {
        if (this.overrideCommand != null) {
            this.overrideCommand.undo();
        } else {
            this.doUndo();
        }
    }

    public abstract void doUndo();

    public final void redo() {
        if (this.overrideCommand != null) {
            this.overrideCommand.redo();
        } else {
            this.doRedo();
        }
    }

    public abstract void doRedo();

    public final Collection getResult() {
        return this.overrideCommand != null ? this.overrideCommand.getResult() : this.doGetResult();
    }

    public Collection doGetResult() {
        return super.getResult();
    }

    public final Collection getAffectedObjects() {
        return this.overrideCommand != null ? this.overrideCommand.getAffectedObjects() : this.doGetAffectedObjects();
    }

    public Collection doGetAffectedObjects() {
        return super.getAffectedObjects();
    }

    public final String getLabel() {
        return this.overrideCommand != null ? this.overrideCommand.getLabel() : this.doGetLabel();
    }

    public String doGetLabel() {
        return super.getLabel();
    }

    public final String getDescription() {
        return this.overrideCommand != null ? this.overrideCommand.getDescription() : this.doGetDescription();
    }

    public String doGetDescription() {
        return super.getDescription();
    }

    public final void dispose() {
        if (this.overrideCommand != null) {
            this.overrideCommand.dispose();
        } else {
            this.doDispose();
        }
    }

    public void doDispose() {
        super.dispose();
    }

    public final Collection getChildrenToCopy() {
        Collection result = this.overrideCommand instanceof ChildrenToCopyProvider ? ((ChildrenToCopyProvider)this.overrideCommand).getChildrenToCopy() : this.doGetChildrenToCopy();
        return result;
    }

    public Collection doGetChildrenToCopy() {
        return Collections.EMPTY_LIST;
    }

    public static EList getOwnerList(EObject owner, EStructuralFeature feature) {
        return owner.eClass().getEAllStructuralFeatures().contains(feature) && feature.isMany() ? (EList)owner.eGet(feature) : null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (overrideCommand: " + this.overrideCommand + ")");
        return result.toString();
    }
}

