/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLString;

public class XMLSaveImpl
implements XMLSave {
    protected XMLHelper helper;
    protected XMLString doc;
    protected boolean declareXSI;
    protected boolean useEncodedAttributeStyle;
    protected boolean declareXML;
    protected Escape escape;
    protected Lookup featureTable;
    protected String encoding;
    protected String idAttributeName = "id";
    protected String processDanglingHREF;
    protected boolean declareSchemaLocation;
    protected static final int SKIP = 0;
    protected static final int SAME_DOC = 1;
    protected static final int CROSS_DOC = 2;
    protected static final int TRANSIENT = 0;
    protected static final int DATATYPE_SINGLE = 1;
    protected static final int DATATYPE_ELEMENT_SINGLE = 2;
    protected static final int DATATYPE_CONTENT_SINGLE = 3;
    protected static final int DATATYPE_SINGLE_NILLABLE = 4;
    protected static final int DATATYPE_MANY = 5;
    protected static final int OBJECT_CONTAIN_SINGLE = 6;
    protected static final int OBJECT_CONTAIN_MANY = 7;
    protected static final int OBJECT_HREF_SINGLE = 8;
    protected static final int OBJECT_HREF_MANY = 9;
    protected static final int OBJECT_CONTAIN_SINGLE_UNSETTABLE = 10;
    protected static final int OBJECT_CONTAIN_MANY_UNSETTABLE = 11;
    protected static final int OBJECT_HREF_SINGLE_UNSETTABLE = 12;
    protected static final int OBJECT_HREF_MANY_UNSETTABLE = 13;
    protected static final int OBJECT_ELEMENT_SINGLE = 14;
    protected static final int OBJECT_ELEMENT_MANY = 15;
    protected static final String XML_VERSION = "1.0";
    protected static final String XSI_NIL = "xsi:nil";
    protected static final String XSI_TYPE_NS = "xsi:type";
    protected static final String XSI_XMLNS = "xmlns:xsi";
    protected static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    protected static final String XSI_NO_NAMESPACE_SCHEMA_LOCATION = "xsi:noNamespaceSchemaLocation";
    protected static final int EMPTY_ELEMENT = 1;
    protected static final int CONTENT_ELEMENT = 2;

    public XMLSaveImpl(XMLHelper helper) {
        this.helper = helper;
    }

    public XMLSaveImpl(Map options, XMLHelper helper, String encoding) {
        this.helper = helper;
        this.init(helper.getResource(), options);
        this.encoding = encoding;
    }

    public void save(XMLResource resource, OutputStream outputStream, Map options) throws IOException {
        DanglingHREFException exception;
        this.init(resource, options);
        this.traverse((List)resource.getContents());
        if (this.encoding.equals("US-ASCII") || this.encoding.equals("ASCII")) {
            this.writeAscii(outputStream);
            outputStream.flush();
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.helper.getJavaEncoding(this.encoding));
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
        }
        this.featureTable = null;
        this.doc = null;
        if ((this.processDanglingHREF == null || "THROW".equals(this.processDanglingHREF)) && (exception = this.helper.getDanglingHREFException()) != null) {
            this.helper = null;
            throw new Resource.IOWrappedException((Exception)exception);
        }
        this.helper = null;
    }

    protected void init(XMLResource resource, Map options) {
        this.declareXSI = false;
        this.useEncodedAttributeStyle = Boolean.TRUE.equals(options.get("USE_ENCODED_ATTRIBUTE_STYLE"));
        this.declareXML = !Boolean.FALSE.equals(options.get("DECLARE_XML"));
        this.declareSchemaLocation = Boolean.TRUE.equals(options.get("SCHEMA_LOCATION"));
        Integer lineWidth = (Integer)options.get("LINE_WIDTH");
        this.doc = new XMLString(lineWidth == null ? Integer.MAX_VALUE : lineWidth);
        Escape escape = this.escape = Boolean.TRUE.equals(options.get("SKIP_ESCAPE")) ? null : new Escape();
        if (options.containsKey("ENCODING")) {
            this.encoding = (String)options.get("ENCODING");
        } else if (resource != null) {
            this.encoding = resource.getEncoding();
        }
        this.processDanglingHREF = (String)options.get("PROCESS_DANGLING_HREF");
        this.helper.setProcessDanglingHREF(this.processDanglingHREF);
        XMLResource.XMLMap map = (XMLResource.XMLMap)options.get("XML_MAP");
        if (map != null) {
            this.helper.setXMLMap(map);
            if (map.getIDAttributeName() != null) {
                this.idAttributeName = map.getIDAttributeName();
            }
        }
        this.featureTable = new Lookup(map);
    }

    public void traverse(List contents) {
        int size;
        if (this.declareXML) {
            this.doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.doc.addLine();
        }
        Object mark = (size = contents.size()) == 1 ? this.writeTopObject((EObject)contents.get(0)) : this.writeTopObjects(contents);
        this.doc.resetToMark(mark);
        this.addNamespaceDeclarations();
    }

    protected Object writeTopObject(EObject top) {
        EClass eClass = top.eClass();
        String name = this.helper.getQName(eClass);
        this.doc.startElement(name);
        Object mark = this.doc.mark();
        this.saveElementID(top);
        return mark;
    }

    protected Object writeTopObjects(List contents) {
        EObject top = (EObject)contents.get(0);
        EClass eClass = top.eClass();
        String name = this.helper.getQName(eClass);
        this.doc.startElement(name);
        Object mark = this.doc.mark();
        this.saveElementID(top);
        return mark;
    }

    protected void addNamespaceDeclarations() {
        EPackage ePackage;
        int i;
        EPackage noNamespacePackage = this.helper.getNoNamespacePackage();
        EPackage[] packages = this.helper.packages();
        StringBuffer xsiSchemaLocation = null;
        String xsiNoNamespaceSchemaLocation = null;
        if (this.declareSchemaLocation) {
            i = 0;
            while (i < packages.length) {
                ePackage = packages[i];
                EObject root = EcoreUtil.getRootContainer((EObject)ePackage);
                if (root instanceof EPackage) {
                    EPackage rootEPackage = (EPackage)root;
                    if (noNamespacePackage == rootEPackage) {
                        this.declareXSI = true;
                        xsiNoNamespaceSchemaLocation = this.helper.getHREF((EObject)rootEPackage);
                    } else {
                        Resource resource = rootEPackage.eResource();
                        if (resource != null) {
                            URI uri = resource.getURI();
                            String rootNsURI = rootEPackage.getNsURI();
                            boolean bl = uri == null ? rootNsURI != null : !uri.toString().equals(rootNsURI);
                            if (bl) {
                                this.declareXSI = true;
                                if (xsiSchemaLocation == null) {
                                    xsiSchemaLocation = new StringBuffer();
                                } else {
                                    xsiSchemaLocation.append(' ');
                                }
                                xsiSchemaLocation.append(rootNsURI);
                                xsiSchemaLocation.append(' ');
                                xsiSchemaLocation.append(this.helper.getHREF((EObject)rootEPackage));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if (this.declareXSI) {
            this.doc.addAttribute(XSI_XMLNS, "http://www.w3.org/2001/XMLSchema-instance");
        }
        i = 0;
        while (i < packages.length) {
            ePackage = packages[i];
            if (ePackage != noNamespacePackage) {
                String nsURI = ePackage.getNsURI();
                String nsPrefix = ePackage.getNsPrefix();
                this.doc.addAttributeNS("xmlns", nsPrefix, nsURI);
            }
            ++i;
        }
        if (xsiSchemaLocation != null) {
            this.doc.addAttribute(XSI_SCHEMA_LOCATION, xsiSchemaLocation.toString());
        }
        if (xsiNoNamespaceSchemaLocation != null) {
            this.doc.addAttribute(XSI_NO_NAMESPACE_SCHEMA_LOCATION, xsiNoNamespaceSchemaLocation);
        }
    }

    public void write(OutputStreamWriter os) throws IOException {
        int BUFFER_SIZE = 8192;
        char[] buffer = new char[8192];
        int pos = 0;
        Iterator i = this.doc.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            int slen = s.length();
            if (slen + pos >= buffer.length) {
                os.write(buffer, 0, pos);
                pos = 0;
                if (slen > buffer.length) {
                    buffer = new char[slen];
                }
            }
            s.getChars(0, slen, buffer, pos);
            pos += slen;
        }
        os.write(buffer, 0, pos);
        os.flush();
    }

    public void writeAscii(OutputStream os) throws IOException {
        int BUFFER_SIZE = 8192;
        char[] buffer = new char[8192];
        byte[] bytes = new byte[8192];
        int pos = 0;
        Iterator i = this.doc.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            int slen = s.length();
            if (slen + pos >= buffer.length) {
                int x = 0;
                while (x < pos) {
                    bytes[x] = (byte)(buffer[x] & 0xFF);
                    ++x;
                }
                os.write(bytes, 0, pos);
                pos = 0;
                if (slen > buffer.length) {
                    buffer = new char[slen];
                    bytes = new byte[slen];
                }
            }
            s.getChars(0, slen, buffer, pos);
            pos += slen;
        }
        int x = 0;
        while (x < pos) {
            bytes[x] = (byte)(buffer[x] & 0xFF);
            ++x;
        }
        os.write(bytes, 0, pos);
        os.flush();
    }

    public char[] toChar() {
        int size = this.doc.getLength();
        char[] output = new char[size];
        this.doc.getChars(output, 0);
        return output;
    }

    protected void saveElement(EObject o, EStructuralFeature f) {
        XMLResource.XMLMap map = this.helper.getXMLMap();
        EClass eClass = o.eClass();
        XMLResource.XMLInfo info = map == null ? null : map.getInfo((ENamedElement)eClass);
        boolean checkXSIType = true;
        if (info != null && info.getXMLRepresentation() == 0) {
            String elementName = this.helper.getQName(eClass);
            this.doc.startElement(elementName);
            checkXSIType = false;
        } else {
            String featureName = this.helper.getQName(f);
            this.doc.startElement(featureName);
        }
        if (checkXSIType && eClass != f.getEType()) {
            this.saveTypeAttribute(eClass);
        }
        this.saveElementID(o);
    }

    protected void saveTypeAttribute(EClass eClass) {
        this.declareXSI = true;
        this.doc.addAttribute(XSI_TYPE_NS, this.helper.getQName(eClass));
    }

    protected boolean saveFeatures(EObject o) {
        EClass eClass = o.eClass();
        EStructuralFeature[] features = this.featureTable.getFeatures(eClass);
        int[] featureKinds = this.featureTable.getKinds(eClass, features);
        int[] elementFeatures = null;
        int elementCount = 0;
        int i = 0;
        while (i < features.length) {
            int kind = featureKinds[i];
            EStructuralFeature f = features[i];
            if (kind != 0 && o.eIsSet(f)) {
                switch (kind) {
                    case 2: {
                        if (elementFeatures == null) {
                            elementFeatures = new int[features.length];
                        }
                        elementFeatures[elementCount++] = i;
                        break;
                    }
                    case 1: {
                        this.saveDataTypeSingle(o, f);
                        break;
                    }
                    case 4: {
                        if (this.isNil(o, f)) {
                            if (elementFeatures == null) {
                                elementFeatures = new int[features.length];
                            }
                            elementFeatures[elementCount++] = i;
                            break;
                        }
                        this.saveDataTypeSingle(o, f);
                        break;
                    }
                    case 12: {
                        if (this.isNil(o, f)) {
                            if (elementFeatures == null) {
                                elementFeatures = new int[features.length];
                            }
                            elementFeatures[elementCount++] = i;
                            break;
                        }
                    }
                    case 8: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectSingle(o, f);
                            break;
                        }
                        switch (this.sameDocSingle(o, f)) {
                            case 1: {
                                this.saveIDRefSingle(o, f);
                                break;
                            }
                            case 2: {
                                if (elementFeatures == null) {
                                    elementFeatures = new int[features.length];
                                }
                                elementFeatures[elementCount++] = i;
                            }
                        }
                        break;
                    }
                    case 13: {
                        if (this.isEmpty(o, f)) {
                            this.saveManyEmpty(f);
                            break;
                        }
                    }
                    case 9: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectMany(o, f);
                            break;
                        }
                        switch (this.sameDocMany(o, f)) {
                            case 1: {
                                this.saveIDRefMany(o, f);
                                break;
                            }
                            case 2: {
                                if (elementFeatures == null) {
                                    elementFeatures = new int[features.length];
                                }
                                elementFeatures[elementCount++] = i;
                            }
                        }
                        break;
                    }
                    case 5: 
                    case 11: {
                        if (this.isEmpty(o, f)) {
                            this.saveManyEmpty(f);
                            break;
                        }
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: {
                        if (elementFeatures == null) {
                            elementFeatures = new int[features.length];
                        }
                        elementFeatures[elementCount++] = i;
                    }
                }
            }
            ++i;
        }
        String content = this.getContent(o, features);
        if (elementFeatures == null) {
            if (content == null) {
                this.endSaveFeatures(o, 1, null);
                return false;
            }
            this.endSaveFeatures(o, 2, content);
            return true;
        }
        int i2 = 0;
        while (i2 < elementCount) {
            int kind = featureKinds[elementFeatures[i2]];
            EStructuralFeature f = features[elementFeatures[i2]];
            switch (kind) {
                case 4: {
                    this.saveNil(f);
                    break;
                }
                case 5: {
                    this.saveDataTypeMany(o, f);
                    break;
                }
                case 2: {
                    this.saveDataTypeElementSingle(o, f);
                    break;
                }
                case 10: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        break;
                    }
                }
                case 6: {
                    this.saveContainedSingle(o, f);
                    break;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(o, f);
                    break;
                }
                case 12: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        break;
                    }
                }
                case 8: {
                    this.saveHRefSingle(o, f);
                    break;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(o, f);
                    break;
                }
                case 14: {
                    this.saveElementReferenceSingle(o, f);
                    break;
                }
                case 15: {
                    this.saveElementReferenceMany(o, f);
                }
            }
            ++i2;
        }
        this.endSaveFeatures(o, 0, null);
        return true;
    }

    protected void endSaveFeatures(EObject o, int elementType, String content) {
        switch (elementType) {
            case 1: {
                this.doc.endEmptyElement();
                break;
            }
            case 2: {
                this.doc.endContentElement(content);
                break;
            }
            default: {
                this.doc.endElement();
            }
        }
    }

    protected void saveDataTypeSingle(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        Object value = this.helper.getValue(o, f);
        if (value != null) {
            String svalue = fac.convertToString(d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            this.doc.addAttribute(this.helper.getQName(f), svalue);
        }
    }

    protected boolean isNil(EObject o, EStructuralFeature f) {
        return this.helper.getValue(o, f) == null;
    }

    protected boolean isEmpty(EObject o, EStructuralFeature f) {
        return ((List)this.helper.getValue(o, f)).isEmpty();
    }

    protected void saveNil(EStructuralFeature f) {
        String name = this.helper.getQName(f);
        this.doc.startElement(name);
        this.doc.addAttribute(XSI_NIL, "true");
        this.doc.endEmptyElement();
        this.declareXSI = true;
    }

    protected void saveManyEmpty(EStructuralFeature f) {
        this.doc.addAttribute(this.helper.getQName(f), "");
    }

    protected void saveDataTypeMany(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        if (size > 0) {
            String name = this.helper.getQName(f);
            int i = 0;
            while (i < size) {
                Object value = values.get(i);
                if (value == null) {
                    this.doc.startElement(name);
                    this.doc.addAttribute(XSI_NIL, "true");
                    this.doc.endEmptyElement();
                    this.declareXSI = true;
                } else {
                    this.doc.startElement(name);
                    String svalue = fac.convertToString(d, value);
                    if (this.escape != null) {
                        svalue = this.escape.convert(svalue);
                    }
                    this.doc.endContentElement(svalue);
                }
                ++i;
            }
        }
    }

    protected void saveEObjectSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            String name = this.helper.getQName(f);
            String id = this.helper.getHREF(value);
            if (id != null) {
                EClass expectedType;
                EClass eClass;
                this.doc.startAttribute(name);
                if (!id.startsWith("#") && (eClass = value.eClass()) != (expectedType = (EClass)f.getEType()) && expectedType.isAbstract()) {
                    this.doc.addAttributeContent(this.helper.getQName(eClass));
                    this.doc.addAttributeContent(" ");
                }
                this.doc.addAttributeContent(id);
                this.doc.endAttribute();
            }
        }
    }

    protected void saveEObjectMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f);
            this.doc.startAttribute(name);
            Iterator i = values.basicIterator();
            while (true) {
                EObject value;
                String id;
                if ((id = this.helper.getHREF(value = (EObject)i.next())) != null) {
                    EClass expectedType;
                    EClass eClass;
                    if (!id.startsWith("#") && (eClass = value.eClass()) != (expectedType = (EClass)f.getEType()) && expectedType.isAbstract()) {
                        this.doc.addAttributeContent(this.helper.getQName(eClass));
                        this.doc.addAttributeContent(" ");
                    }
                    this.doc.addAttributeContent(id);
                }
                if (!i.hasNext()) break;
                this.doc.addAttributeContent(" ");
            }
            this.doc.endAttribute();
        }
    }

    protected void saveIDRefSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            String name = this.helper.getQName(f);
            String id = this.helper.getIDREF(value);
            this.doc.addAttribute(name, id);
        }
    }

    protected void saveIDRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f);
            StringBuffer ids = new StringBuffer(values.size() * 10);
            Iterator i = values.basicIterator();
            while (true) {
                EObject value = (EObject)i.next();
                String id = this.helper.getIDREF(value);
                ids.append(id);
                if (!i.hasNext()) break;
                ids.append(" ");
            }
            this.doc.addAttribute(name, ids.toString());
        }
    }

    protected void saveElementReference(EObject remote, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        String href = this.helper.getHREF(remote);
        if (href != null) {
            this.doc.startElement(name);
            this.doc.endContentElement(href);
        }
    }

    protected void saveElementReferenceSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveElementReference(value, f);
        }
    }

    protected void saveElementReferenceMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            this.saveElementReference((EObject)values.get(i), f);
            ++i;
        }
    }

    protected void saveHref(EObject remote, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        String href = this.helper.getHREF(remote);
        if (href != null) {
            this.doc.startElement(name);
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f.getEType();
            if (eClass != expectedType && expectedType.isAbstract()) {
                this.saveTypeAttribute(eClass);
            }
            this.doc.addAttribute("href", href);
            this.doc.endEmptyElement();
        }
    }

    protected void saveHRefSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveHref(value, f);
        }
    }

    protected void saveHRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            this.saveHref((EObject)values.get(i), f);
            ++i;
        }
    }

    protected void saveContainedSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveElement(value, f);
        }
    }

    protected void saveContainedMany(EObject o, EStructuralFeature f) {
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            EObject value = (EObject)values.get(i);
            if (value != null) {
                this.saveElement(value, f);
            }
            ++i;
        }
    }

    protected int sameDocSingle(EObject o, EStructuralFeature f) {
        InternalEObject value = (InternalEObject)this.helper.getValue(o, f);
        if (value == null) {
            return 0;
        }
        if (value.eIsProxy()) {
            return 2;
        }
        Resource res = value.eResource();
        return res == this.helper.getResource() ? 1 : 2;
    }

    protected int sameDocMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (values.isEmpty()) {
            return 0;
        }
        Iterator i = values.basicIterator();
        while (i.hasNext()) {
            InternalEObject value = (InternalEObject)i.next();
            if (!value.eIsProxy() && value.eResource() == this.helper.getResource()) continue;
            return 2;
        }
        return 1;
    }

    protected String getContent(EObject o, EStructuralFeature[] features) {
        XMLResource.XMLMap map = this.helper.getXMLMap();
        if (map == null) {
            return null;
        }
        int i = 0;
        while (i < features.length) {
            XMLResource.XMLInfo info = map.getInfo((ENamedElement)features[i]);
            if (info != null && info.getXMLRepresentation() == 2) {
                Object value = this.helper.getValue(o, features[i]);
                if (value == null) {
                    return null;
                }
                EDataType d = (EDataType)features[i].getEType();
                EPackage ePackage = d.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String svalue = fac.convertToString(d, value);
                if (this.escape != null) {
                    svalue = this.escape.convert(svalue);
                }
                return svalue;
            }
            ++i;
        }
        return null;
    }

    protected void saveDataTypeElementSingle(EObject o, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        Object value = this.helper.getValue(o, f);
        if (value == null) {
            this.doc.startElement(name);
            this.doc.addAttribute(XSI_NIL, "true");
            this.doc.endEmptyElement();
            this.declareXSI = true;
        } else {
            EDataType d = (EDataType)f.getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            this.doc.startElement(name);
            String svalue = fac.convertToString(d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            this.doc.endContentElement(svalue);
        }
    }

    protected void saveElementID(EObject o) {
        String id = this.helper.getID(o);
        if (id != null) {
            this.doc.addAttribute(this.idAttributeName, id);
        }
        this.saveFeatures(o);
    }

    protected static class Escape {
        protected char[] value;
        protected final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
        protected final char[] LESS = new char[]{'&', 'l', 't', ';'};
        protected final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        protected final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
        protected final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
        protected final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};

        Escape() {
            this.value = new char[100];
        }

        public String convert(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LF, inputLength);
                        changed = true;
                        break;
                    }
                    case '\r': {
                        pos = this.replace(pos, this.CR, inputLength);
                        changed = true;
                        break;
                    }
                    case '\t': {
                        pos = this.replace(pos, this.TAB, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        protected int replace(int pos, char[] replacement, int inputLength) {
            int rlen = replacement.length;
            int newPos = pos + rlen;
            this.grow(newPos + inputLength);
            System.arraycopy(this.value, pos + 1, this.value, newPos, inputLength);
            System.arraycopy(replacement, 0, this.value, pos, rlen);
            return newPos;
        }

        protected void grow(int newSize) {
            int vlen = this.value.length;
            if (vlen < newSize) {
                char[] newValue = new char[newSize + newSize / 2];
                System.arraycopy(this.value, 0, newValue, 0, vlen);
                this.value = newValue;
            }
        }
    }

    protected static class Lookup {
        protected static final int SIZE = 4095;
        protected EClass[] classes;
        protected EStructuralFeature[][] features;
        protected int[][] featureKinds;
        protected XMLResource.XMLMap map;

        Lookup(XMLResource.XMLMap map) {
            this.map = map;
            this.classes = new EClass[4096];
            this.features = new EStructuralFeature[4096][];
            this.featureKinds = new int[4096][];
        }

        public EStructuralFeature[] getFeatures(EClass cls) {
            int index = cls.hashCode() & 0xFFF;
            EClass c = this.classes[index];
            if (c == cls) {
                return this.features[index];
            }
            EStructuralFeature[] featureList = this.listFeatures(cls);
            if (c == null) {
                this.classes[index] = cls;
                this.features[index] = featureList;
                this.featureKinds[index] = this.listKinds(featureList);
            }
            return featureList;
        }

        public int[] getKinds(EClass cls, EStructuralFeature[] featureList) {
            int index = cls.hashCode() & 0xFFF;
            EClass c = this.classes[index];
            if (c == cls) {
                return this.featureKinds[index];
            }
            int[] kindsList = this.listKinds(featureList);
            if (c == null) {
                this.classes[index] = cls;
                this.features[index] = featureList;
                this.featureKinds[index] = kindsList;
            }
            return kindsList;
        }

        protected EStructuralFeature[] listFeatures(EClass cls) {
            EList f = this.map == null ? cls.getEAllStructuralFeatures() : this.map.getFeatures(cls);
            return f.toArray(new EStructuralFeature[f.size()]);
        }

        protected int[] listKinds(EStructuralFeature[] featureList) {
            int[] kinds = new int[featureList.length];
            int i = featureList.length - 1;
            while (i >= 0) {
                kinds[i] = this.featureKind(featureList[i]);
                --i;
            }
            return kinds;
        }

        protected int featureKind(EStructuralFeature f) {
            if (f.isTransient()) {
                return 0;
            }
            boolean isMany = f.isMany();
            boolean isUnsettable = f.isUnsettable();
            if (f instanceof EReference) {
                XMLResource.XMLInfo info;
                EReference r = (EReference)f;
                if (r.isContainment()) {
                    return isMany ? (isUnsettable ? 11 : 7) : (isUnsettable ? 10 : 6);
                }
                EReference opposite = r.getEOpposite();
                if (opposite != null && opposite.isContainment()) {
                    return 0;
                }
                if (this.map != null && (info = this.map.getInfo((ENamedElement)f)) != null && info.getXMLRepresentation() == 0) {
                    return isMany ? 15 : 14;
                }
                return isMany ? (isUnsettable ? 13 : 9) : (isUnsettable ? 12 : 8);
            }
            EDataType d = (EDataType)f.getEType();
            if (!d.isSerializable()) {
                return 0;
            }
            if (isMany) {
                return 5;
            }
            if (isUnsettable && this.map == null) {
                return 4;
            }
            if (this.map == null) {
                return 1;
            }
            XMLResource.XMLInfo info = this.map.getInfo((ENamedElement)f);
            if (info != null && info.getXMLRepresentation() == 0) {
                return 2;
            }
            if (info != null && info.getXMLRepresentation() == 2) {
                return 3;
            }
            if (isUnsettable) {
                return 4;
            }
            return 1;
        }
    }
}

