/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.viewer;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ExtendedTableTreeViewer
extends TableTreeViewer {
    public static final String ITEM_ID = "TableTreeItemID";
    protected Point interactorSize = new Point(12, 12);
    protected boolean interactorFound = false;
    protected String imagePadding;
    protected int imagePaddingWidth;

    public ExtendedTableTreeViewer(TableTree tableTree) {
        super(tableTree);
    }

    public ExtendedTableTreeViewer(Composite parent) {
        super(parent);
    }

    public ExtendedTableTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected Item newItem(Widget parent, int flags, int index) {
        ExtendedTableTreeItem item = index >= 0 ? (parent instanceof TableTreeItem ? new ExtendedTableTreeItem((TableTreeItem)parent, flags, index) : new ExtendedTableTreeItem((TableTree)parent, flags, index)) : (parent instanceof TableTreeItem ? new ExtendedTableTreeItem((TableTreeItem)parent, flags) : new ExtendedTableTreeItem((TableTree)parent, flags));
        return item;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.getTableTree().getTable().addPaintListener(new PaintListener(){
            protected boolean isStarted;
            protected TableTreeItem firstTableTreeItem;
            protected TableTreeItem lastTableTreeItem;
            protected LinkedList chain;
            protected int scrollX;
            private boolean indenting = false;
            private boolean indentingTested = false;

            protected Rectangle fixForGC(Rectangle bounds) {
                if (ExtendedTableTreeViewer.isGTK() && bounds != null) {
                    bounds.x -= 2;
                    bounds.y -= ExtendedTableTreeViewer.this.getTableTree().getTable().getHeaderHeight();
                }
                return bounds;
            }

            public void paintControl(PaintEvent event) {
                Table table = (Table)event.getSource();
                TableItem[] items = table.getItems();
                this.firstTableTreeItem = null;
                this.lastTableTreeItem = null;
                int i = table.getTopIndex();
                while (i < items.length) {
                    TableItem tableItem = items[i];
                    ExtendedTableTreeItem tableTreeItem = (ExtendedTableTreeItem)((Object)tableItem.getData(ExtendedTableTreeViewer.ITEM_ID));
                    if (!tableTreeItem.isDisposed()) {
                        Rectangle itemBounds;
                        if (this.firstTableTreeItem == null) {
                            this.firstTableTreeItem = tableTreeItem;
                        }
                        this.lastTableTreeItem = tableTreeItem;
                        if (!ExtendedTableTreeViewer.this.interactorFound) {
                            Rectangle bounds = tableItem.getImageBounds(0);
                            if (bounds.width != 0) {
                                ExtendedTableTreeViewer.this.interactorFound = true;
                                ExtendedTableTreeViewer.this.interactorSize = new Point(bounds.width, bounds.height);
                            }
                        }
                        if ((itemBounds = tableTreeItem.getBounds(0)) != null) {
                            Image image = tableTreeItem.getFirstImage();
                            if (image != null) {
                                if (!ExtendedTableTreeViewer.isGTK()) {
                                    Display display = tableItem.getDisplay();
                                    event.gc.setBackground(display.getSystemColor(25));
                                    Rectangle bounds = tableTreeItem.getImageBounds(tableItem, 0);
                                    bounds.x += bounds.width;
                                    bounds.y = itemBounds.y;
                                    bounds.width = ExtendedTableTreeViewer.this.imagePaddingWidth - 1;
                                    bounds.height = itemBounds.height;
                                    event.gc.fillRectangle(this.fixForGC(bounds));
                                }
                                Rectangle sourceBounds = image.getBounds();
                                Rectangle targetBounds = this.fixForGC(tableTreeItem.getFirstImageBounds(tableItem));
                                event.gc.drawImage(image, sourceBounds.x, sourceBounds.y, sourceBounds.width, sourceBounds.height, targetBounds.x, targetBounds.y, targetBounds.width, targetBounds.height);
                            }
                            this.fixForGC(itemBounds);
                            if (itemBounds.y + itemBounds.height > event.y + event.height) break;
                        }
                    }
                    ++i;
                }
                if (this.firstTableTreeItem != null && this.isIndenting()) {
                    this.isStarted = false;
                    this.chain = new LinkedList();
                    event.gc.setForeground(table.getDisplay().getSystemColor(18));
                    this.scrollX = items[0].getBounds((int)0).x;
                    this.paintLines(event.gc, ExtendedTableTreeViewer.this.getTableTree().getItems());
                }
            }

            protected boolean isIndenting() {
                TableItem[] items;
                if (!this.indentingTested && (items = ExtendedTableTreeViewer.this.getTableTree().getTable().getItems()).length > 1) {
                    int x = items[0].getBounds((int)0).x;
                    int i = 1;
                    int len = items.length;
                    while (i < len) {
                        TableTreeItem item;
                        if (items[i].getBounds((int)0).x != x) {
                            this.indenting = true;
                        }
                        if ((item = (TableTreeItem)items[i].getData(ExtendedTableTreeViewer.ITEM_ID)).getParentItem() != null) {
                            this.indentingTested = true;
                            break;
                        }
                        ++i;
                    }
                }
                return this.indenting;
            }

            protected boolean paintLines(GC gc, TableTreeItem[] tableTreeItems) {
                int offset = ExtendedTableTreeViewer.this.interactorSize.x;
                int indent = Math.min(6, (offset - 8) / 2);
                if (tableTreeItems != null) {
                    int i = 0;
                    while (i < tableTreeItems.length) {
                        TableTreeItem tableTreeItem = tableTreeItems[i];
                        if (!this.isStarted && tableTreeItem == this.firstTableTreeItem) {
                            this.isStarted = true;
                        }
                        if (this.isStarted) {
                            Rectangle bounds = tableTreeItem.getBounds(0);
                            int x = 1 + this.scrollX;
                            Iterator j = this.chain.iterator();
                            while (j.hasNext()) {
                                TableTreeItem ancestor = (TableTreeItem)j.next();
                                if (ancestor != null) {
                                    gc.drawLine(x + offset / 2, bounds.y, x + offset / 2, bounds.y + bounds.height);
                                }
                                x += offset;
                            }
                            if (i + 1 == tableTreeItems.length) {
                                if (i != 0 || !this.chain.isEmpty()) {
                                    gc.drawLine(x + offset / 2, bounds.y, x + offset / 2, bounds.y + (tableTreeItem.getItemCount() > 0 ? indent - 1 : bounds.height / 2));
                                }
                            } else if (tableTreeItem.getItemCount() > 0) {
                                gc.drawLine(x + offset / 2, bounds.y, x + offset / 2, bounds.y + indent - 1);
                                gc.drawLine(x + offset / 2, bounds.y + bounds.height - indent + 2, x + offset / 2, bounds.y + bounds.height);
                            } else {
                                gc.drawLine(x + offset / 2, bounds.y, x + offset / 2, bounds.y + bounds.height);
                            }
                            gc.drawLine(x + (tableTreeItem.getItemCount() > 0 ? offset - indent + 1 : offset / 2), bounds.y + (bounds.height + 1) / 2, x + offset + 2, bounds.y + (bounds.height + 1) / 2);
                        }
                        if (tableTreeItem.getExpanded()) {
                            this.chain.addLast(i + 1 == tableTreeItems.length ? null : tableTreeItem);
                            if (!this.paintLines(gc, tableTreeItem.getItems())) {
                                return false;
                            }
                            this.chain.removeLast();
                        }
                        if (this.isStarted && tableTreeItem == this.lastTableTreeItem) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }
        });
    }

    protected void createImagePadding(int width) {
        GC gc = new GC((Drawable)this.getTableTree().getTable());
        this.imagePadding = " ";
        while ((this.imagePaddingWidth = gc.stringExtent((String)this.imagePadding).x) < width + 6) {
            this.imagePadding = this.imagePadding + " ";
        }
        gc.dispose();
        TableItem[] tableItems = this.getTableTree().getTable().getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableTreeItem tableTreeItem = (TableTreeItem)tableItems[i].getData(ITEM_ID);
            tableTreeItem.setText(0, tableTreeItem.getText(0));
            ++i;
        }
    }

    protected static boolean isGTK() {
        return "gtk".equals(SWT.getPlatform());
    }

    public static Rectangle getImageBounds(TableItem tableItem, int column) {
        Object item = tableItem.getData(ITEM_ID);
        return item instanceof ExtendedTableTreeItem ? ((ExtendedTableTreeItem)((Object)item)).getImageBounds(tableItem, column) : tableItem.getImageBounds(column);
    }

    protected static Rectangle center(Rectangle bounds, int maxHeight) {
        if (bounds.height < maxHeight) {
            bounds.y += (maxHeight - bounds.height) / 2;
        }
        return bounds;
    }

    protected static Rectangle scale(Rectangle bounds, int maxHeight) {
        if (bounds.height > maxHeight) {
            float sf = (float)bounds.width / (float)bounds.height;
            bounds.width = Math.round(sf * (float)maxHeight);
            bounds.height = maxHeight;
        }
        return bounds;
    }

    public class ExtendedTableTreeItem
    extends TableTreeItem {
        protected Image firstImage;

        public ExtendedTableTreeItem(TableTree parent, int style) {
            super(parent, style);
        }

        public ExtendedTableTreeItem(TableTree parent, int style, int index) {
            super(parent, style, index);
        }

        public ExtendedTableTreeItem(TableTreeItem parent, int style) {
            super(parent, style);
        }

        public ExtendedTableTreeItem(TableTreeItem parent, int style, int index) {
            super(parent, style, index);
        }

        public void setText(int index, String text) {
            if (index == 0 && ExtendedTableTreeViewer.this.imagePadding != null) {
                if (text != null && text.indexOf(ExtendedTableTreeViewer.this.imagePadding) == 0) {
                    super.setText(0, text);
                } else {
                    super.setText(0, ExtendedTableTreeViewer.this.imagePadding + text);
                }
            } else {
                super.setText(index, text);
            }
        }

        public String getText(int index) {
            String result = super.getText(index);
            if (index == 0 && result != null && ExtendedTableTreeViewer.this.imagePadding != null && result.indexOf(ExtendedTableTreeViewer.this.imagePadding) == 0) {
                result = result.substring(ExtendedTableTreeViewer.this.imagePadding.length());
            }
            return result;
        }

        public void setImage(int index, Image image) {
            if (index == 0) {
                this.firstImage = image;
                if (image != null && ExtendedTableTreeViewer.this.imagePadding == null) {
                    ExtendedTableTreeViewer.this.createImagePadding(image.getBounds().width);
                }
            } else {
                super.setImage(index, image);
            }
        }

        public Image getFirstImage() {
            return this.firstImage;
        }

        public int getImagePaddingWidth() {
            return ExtendedTableTreeViewer.this.imagePaddingWidth;
        }

        public Rectangle getImageBounds(int column) {
            return this.getImageBounds(this.getTableItem(), column);
        }

        private Rectangle getImageBounds(TableItem tableItem, int column) {
            if (ExtendedTableTreeViewer.isGTK()) {
                Rectangle result = tableItem.getBounds(column);
                int itemHeight = result.height;
                if (column == 0) {
                    result.width = ExtendedTableTreeViewer.this.interactorSize.x;
                    result.height = ExtendedTableTreeViewer.this.interactorSize.y;
                } else {
                    Image image = tableItem.getImage(column);
                    if (image == null) {
                        result.width = 0;
                        result.height = 0;
                    } else {
                        Rectangle imageBounds = image.getBounds();
                        result.width = imageBounds.width;
                        result.height = imageBounds.height;
                    }
                }
                ExtendedTableTreeViewer.center(result, itemHeight);
                result.x += 3;
                return result;
            }
            return tableItem.getImageBounds(column);
        }

        public Rectangle getFirstImageBounds() {
            return this.getFirstImageBounds(this.getTableItem());
        }

        private Rectangle getFirstImageBounds(TableItem tableItem) {
            Rectangle result = new Rectangle(0, 0, 0, 0);
            if (tableItem != null) {
                Rectangle itemBounds = tableItem.getBounds(0);
                Rectangle interactorBounds = this.getImageBounds(tableItem, 0);
                result.x = interactorBounds.x + interactorBounds.width + 5;
                result.y = itemBounds.y;
                if (this.firstImage != null) {
                    Rectangle imageBounds = this.firstImage.getBounds();
                    result.width = imageBounds.width;
                    result.height = imageBounds.height;
                }
                ExtendedTableTreeViewer.scale(result, itemBounds.height);
                ExtendedTableTreeViewer.center(result, itemBounds.height);
            }
            return result;
        }

        protected TableItem getTableItem() {
            TableItem[] items = ExtendedTableTreeViewer.this.getTableTree().getTable().getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData(ExtendedTableTreeViewer.ITEM_ID) == this) {
                    return items[i];
                }
                ++i;
            }
            return null;
        }
    }
}

