/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public class JETEmitter {
    protected Method method;
    protected Object object;
    protected String[] templateURIPath;
    protected String templateURI;
    protected ClassLoader classLoader;
    protected String encoding;

    public JETEmitter(String templateURI) {
        this.templateURI = templateURI;
        this.classLoader = this.getClass().getClassLoader();
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = this.getClass().getClassLoader();
    }

    public JETEmitter(String templateURI, ClassLoader classLoader) {
        this.templateURI = templateURI;
        this.classLoader = classLoader;
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = classLoader;
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader, String encoding) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = classLoader;
        this.encoding = encoding;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        if ((method.getModifiers() & 8) == 0 && this.object == null) {
            try {
                this.object = method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException exception) {
                exception.printStackTrace();
            }
            catch (InstantiationException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void initialize(IProgressMonitor progressMonitor) throws JETException {
        progressMonitor.beginTask("", 10);
        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_GeneratingJETEmitterFor_message", new Object[]{this.templateURI}));
        try {
            try {
                IJavaProject javaProject;
                block23: {
                    try {
                        JavaRuntime.getDefaultVMInstall();
                    }
                    catch (Throwable throwable) {
                        URL jreURL = new URL(Platform.getPlugin((String)"org.eclipse.emf.codegen").getDescriptor().getInstallURL(), "plugin.xml");
                        Path jrePath = new Path(Platform.asLocalURL((URL)jreURL).getFile());
                        jrePath = jrePath.removeLastSegments(1).append((IPath)new Path("../../jre/lib/rt.jar"));
                        if (jrePath.equals((Object)JavaCore.getClasspathVariable((String)"JRE_LIB"))) break block23;
                        JavaCore.setClasspathVariable((String)"JRE_LIB", (IPath)jrePath, null);
                    }
                }
                JETEmitter.setVariable("EMF_CODEGEN", "org.eclipse.emf.codegen");
                JETEmitter.setVariable("EMF_CODEGEN_ECORE", "org.eclipse.emf.codegen.ecore");
                JETEmitter.setVariable("EMF_COMMON", "org.eclipse.emf.common");
                JETEmitter.setVariable("EMF_ECORE", "org.eclipse.emf.ecore");
                MyJETCompiler jetCompiler = this.templateURIPath == null ? new MyJETCompiler(this.templateURI, this.encoding) : new MyJETCompiler(this.templateURIPath, this.templateURI, this.encoding);
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETParsing_message", new Object[]{jetCompiler.getResolvedTemplateURI()}));
                jetCompiler.parse();
                progressMonitor.worked(1);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                jetCompiler.generate(outputStream);
                ByteArrayInputStream contents = new ByteArrayInputStream(outputStream.toByteArray());
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                if (!javaModel.isOpen()) {
                    javaModel.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    progressMonitor.worked(1);
                }
                IProject project = workspace.getRoot().getProject(".JETEmitters");
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETPreparingProject_message", new Object[]{project.getName()}));
                if (!project.exists()) {
                    IFolder runtimeFolder;
                    progressMonitor.subTask("JET creating project " + project.getName());
                    project.create((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreatingProject_message", new Object[]{project.getName()}));
                    IProjectDescription description = workspace.newProjectDescription(project.getName());
                    description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                    description.setLocation(null);
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    javaProject = JavaCore.create((IProject)project);
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETInitializingProject_message", new Object[]{project.getName()}));
                    IClasspathEntry classpathEntry = JavaCore.newSourceEntry((IPath)new Path("/" + project.getName() + "/src"));
                    IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                    IClasspathEntry commonClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("EMF_COMMON"), null, null);
                    IClasspathEntry mofGeneratorClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("EMF_ECORE"), null, null);
                    IClasspathEntry generatorClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("EMF_CODEGEN"), null, null);
                    IClasspathEntry ecoreGeneratorClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("EMF_CODEGEN_ECORE"), null, null);
                    javaProject.setRawClasspath(new IClasspathEntry[]{classpathEntry, jreClasspathEntry, mofGeneratorClasspathEntry, commonClasspathEntry, ecoreGeneratorClasspathEntry, generatorClasspathEntry}, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    javaProject.setOutputLocation((IPath)new Path("/" + project.getName() + "/runtime"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    IFolder sourceFolder = project.getFolder((IPath)new Path("src"));
                    if (!sourceFolder.exists()) {
                        sourceFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    if (!(runtimeFolder = project.getFolder((IPath)new Path("runtime"))).exists()) {
                        runtimeFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    javaProject.close();
                } else {
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                    javaProject = JavaCore.create((IProject)project);
                }
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETOpeningJavaProject_message", new Object[]{project.getName()}));
                javaProject.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                IPackageFragmentRoot sourcePackageFragmentRoot = null;
                int j = 0;
                while (j < packageFragmentRoots.length) {
                    IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
                    if (packageFragmentRoot.getKind() == 1) {
                        sourcePackageFragmentRoot = packageFragmentRoot;
                        break;
                    }
                    ++j;
                }
                String packageName = jetCompiler.getSkeleton().getPackageName();
                StringTokenizer stringTokenizer = new StringTokenizer(packageName, ".");
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
                subProgressMonitor.beginTask("", stringTokenizer.countTokens() + 4);
                subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_CreateTargetFile_message"));
                IContainer sourceContainer = (IContainer)sourcePackageFragmentRoot.getCorrespondingResource();
                while (stringTokenizer.hasMoreElements()) {
                    String folderName = stringTokenizer.nextToken();
                    if ((sourceContainer = sourceContainer.getFolder((IPath)new Path(folderName))).exists()) continue;
                    ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                }
                IFile targetFile = sourceContainer.getFile((IPath)new Path(jetCompiler.getSkeleton().getClassName() + ".java"));
                if (!targetFile.exists()) {
                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreating_message", new Object[]{targetFile.getFullPath()}));
                    targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                } else {
                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdating_message", new Object[]{targetFile.getFullPath()}));
                    targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                }
                subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETBuilding_message", new Object[]{project.getName()}));
                project.build(10, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                IMarker[] markers = targetFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                boolean errors = false;
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    if (marker.getAttribute("severity", 0) == 2) {
                        errors = true;
                        subProgressMonitor.subTask(marker.getAttribute("message") + " : " + CodeGenPlugin.getPlugin().getString("jet.mark.file.line", new Object[]{targetFile.getLocation(), marker.getAttribute("lineNumber")}));
                    }
                    ++i;
                }
                if (!errors) {
                    IFolder targetContainer = workspace.getRoot().getFolder(javaProject.getOutputLocation());
                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETLoadingClass_message", new Object[]{jetCompiler.getSkeleton().getClassName() + ".class"}));
                    URL url = new URL("file://" + project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/");
                    URLClassLoader theClassLoader = new URLClassLoader(new URL[]{url}, this.classLoader);
                    Class<?> theClass = theClassLoader.loadClass((packageName.length() == 0 ? "" : packageName + ".") + jetCompiler.getSkeleton().getClassName());
                    String methodName = jetCompiler.getSkeleton().getMethodName();
                    Method[] methods = theClass.getDeclaredMethods();
                    int i2 = 0;
                    while (i2 < methods.length) {
                        if (methods[i2].getName().equals(methodName)) {
                            this.setMethod(methods[i2]);
                            break;
                        }
                        ++i2;
                    }
                }
                subProgressMonitor.done();
            }
            catch (CoreException exception) {
                throw new JETException(exception);
            }
            catch (Exception exception) {
                throw new JETException(exception);
            }
            Object var28_31 = null;
        }
        catch (Throwable throwable) {
            Object var28_32 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
    }

    protected static void setVariable(String variableName, String pluginID) throws Exception {
        IPluginDescriptor descriptor = Platform.getPlugin((String)pluginID).getDescriptor();
        ILibrary[] libraries = descriptor.getRuntimeLibraries();
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].getType().equals("code")) {
                URL url = new URL(descriptor.getInstallURL(), libraries[i].getPath().toString());
                Path path = new Path(Platform.asLocalURL((URL)url).getFile());
                if (path.equals((Object)JavaCore.getClasspathVariable((String)variableName))) break;
                JavaCore.setClasspathVariable((String)variableName, (IPath)path, null);
                break;
            }
            ++i;
        }
    }

    public String generate(IProgressMonitor progressMonitor, Object[] arguments) throws JETException {
        if (this.method == null) {
            this.initialize(progressMonitor);
        }
        String result = "";
        if (this.method != null) {
            try {
                result = (String)this.method.invoke(this.object, arguments);
            }
            catch (IllegalAccessException exception) {
                throw new JETException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new JETException(exception);
            }
        }
        return result;
    }

    protected class MyJETCompiler
    extends JETCompiler {
        public MyJETCompiler(String templateURI) throws JETException {
            super(templateURI);
        }

        public MyJETCompiler(String templateURI, String encoding) throws JETException {
            super(templateURI, encoding);
        }

        public MyJETCompiler(String[] templateURIPath, String relativeTemplateURI) throws JETException {
            super(templateURIPath, relativeTemplateURI);
        }

        public MyJETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding) throws JETException {
            super(templateURIPath, relativeTemplateURI, encoding);
        }

        protected void handleNewSkeleton() {
            String packageName = this.skeleton.getPackageName();
            String skeletonClassName = this.skeleton.getClassName();
            String qualifiedSkeletonClassName = (packageName.length() == 0 ? "" : packageName + ".") + skeletonClassName;
            try {
                Class<?> theClass = JETEmitter.this.classLoader.loadClass(qualifiedSkeletonClassName);
                if (theClass != null) {
                    skeletonClassName = skeletonClassName + "_";
                    this.skeleton.setClassName(skeletonClassName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

