/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;

public class Literals {
    private Literals() {
    }

    public static String toLiteral(Object o) {
        if (o instanceof Boolean) {
            return Literals.toBooleanLiteral((Boolean)o);
        }
        if (o instanceof Byte) {
            return Literals.toByteLiteral((Byte)o);
        }
        if (o instanceof Short) {
            return Literals.toShortLiteral((Short)o);
        }
        if (o instanceof Integer) {
            return Literals.toIntLiteral((Integer)o);
        }
        if (o instanceof Long) {
            return Literals.toLongLiteral((Long)o);
        }
        if (o instanceof Float) {
            return Literals.toFloatLiteral(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return Literals.toDoubleLiteral((Double)o);
        }
        if (o instanceof Character) {
            return Literals.toCharLiteral(((Character)o).charValue());
        }
        if (o instanceof String) {
            return Literals.toStringLiteral((String)o);
        }
        if (o instanceof Class) {
            return Literals.toClassLiteral((Class)o);
        }
        return null;
    }

    public static String toBooleanLiteral(boolean b) {
        return b ? "true" : "false";
    }

    public static String toByteLiteral(byte b) {
        return Byte.toString(b);
    }

    public static String toShortLiteral(short s) {
        return Short.toString(s);
    }

    public static String toIntLiteral(int i) {
        return Integer.toString(i);
    }

    public static String toLongLiteral(long l) {
        return Long.toString(l) + "L";
    }

    public static String toFloatLiteral(float f) {
        if (Float.isNaN(f)) {
            return "java.lang.Float.NaN";
        }
        if (Float.isInfinite(f)) {
            return f > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY";
        }
        return Float.toString(f) + "F";
    }

    public static String toDoubleLiteral(double d) {
        if (Double.isNaN(d)) {
            return "java.lang.Double.NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY";
        }
        return Double.toString(d);
    }

    public static String toCharLiteral(char c) {
        StringBuffer result = new StringBuffer(8);
        result.append('\'');
        result.append(Literals.escapeChar(c));
        result.append('\'');
        return result.toString();
    }

    public static String toStringLiteral(String s) {
        if (s == null) {
            return "null";
        }
        int len = s.length();
        StringBuffer result = new StringBuffer(len + 16);
        result.append('\"');
        int i = 0;
        while (i < len) {
            result.append(Literals.escapeChar(s.charAt(i)));
            ++i;
        }
        result.append('\"');
        return result.toString();
    }

    private static String escapeChar(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c >= ' ' && c < '\u007f') {
            return String.valueOf(c);
        }
        String num = Integer.toHexString(c);
        switch (num.length()) {
            case 1: {
                return "\\u000" + num;
            }
            case 2: {
                return "\\u00" + num;
            }
            case 3: {
                return "\\u0" + num;
            }
        }
        return "\\u" + num;
    }

    public static String toClassLiteral(Class c) {
        if (c == null) {
            return "null";
        }
        String name = c.getName();
        int arrayDepth = 0;
        while (name.charAt(arrayDepth) == '[') {
            ++arrayDepth;
        }
        if (arrayDepth > 0) {
            if (name.charAt(arrayDepth) == 'B') {
                name = "byte";
            } else if (name.charAt(arrayDepth) == 'C') {
                name = "char";
            } else if (name.charAt(arrayDepth) == 'D') {
                name = "double";
            } else if (name.charAt(arrayDepth) == 'F') {
                name = "float";
            } else if (name.charAt(arrayDepth) == 'I') {
                name = "int";
            } else if (name.charAt(arrayDepth) == 'J') {
                name = "long";
            } else if (name.charAt(arrayDepth) == 'S') {
                name = "short";
            } else if (name.charAt(arrayDepth) == 'Z') {
                name = "boolean";
            } else if (name.charAt(arrayDepth) == 'L') {
                name = name.substring(arrayDepth + 1, name.length() - 1);
            } else {
                throw new IllegalArgumentException("Invalid class name: " + name);
            }
        }
        StringBuffer result = new StringBuffer(name.length() + 2 * arrayDepth + 8);
        result.append(name);
        int i = 0;
        while (i < arrayDepth) {
            result.append('[');
            result.append(']');
            ++i;
        }
        result.append(".class");
        return result.toString();
    }
}

