/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.java2ecore;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.core.jdom.IDOMType;

public class JavaEcoreBuilder {
    protected static DOMFactory jdomFactory = new DOMFactory();
    protected IFile genModelFile;
    protected GenModel genModel;
    protected Map externalPackageNameToEPackageMap = new HashMap();
    protected Map packageNameToEPackageMap = new HashMap();
    protected Map ePackageToOrderingMap = new HashMap();
    protected Map ePackageToPrefixMap = new HashMap();
    protected Map eModelElementToIDOMNodeMap = new HashMap();
    protected Map eTypedElementToTypeNameMap = new HashMap();
    protected Map eTypedElementToInstanceTypeNameMap = new HashMap();
    protected Set demandCreatedEDataTypes = new HashSet();
    protected Map eClassToSuperTypeNamesMap = new HashMap();
    protected Map eReferenceToOppositeNameMap = new HashMap();
    protected Collection externalGenModels = new ArrayList();
    protected Collection usedGenPackages = new ArrayList();
    protected MultiStatus status;
    protected GenModel oldGenModelVersion;
    protected static RegularExpression modelAnnotationExpression = new RegularExpression("@[ \\f\\n\\r\\t*]*model[ \\f\\n\\r\\t*]*((\\w*\\s*=\\s*(['\"]).*?\\3[ \\f\\n\\r\\t*]*)*)", "m");
    protected static RegularExpression extendsAnnotationExpression = new RegularExpression("@\\s*extends\\s*(([.\\w]*\\s*,*\\s*)+)", "m");
    protected static RegularExpression implementsAnnotationExpression = new RegularExpression("@\\s*implements\\s*(([.\\w]*\\s*,*\\s*)+)", "m");

    public JavaEcoreBuilder(IFile genModelFile) {
        this.genModelFile = genModelFile;
        this.status = new MultiStatus(CodeGenEcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, CodeGenEcorePlugin.INSTANCE.getString("_UI_ErrorsWereDetectedJava_message"), null);
    }

    public JavaEcoreBuilder(IFile genModelFile, GenModel oldGenModelVersion) {
        this(genModelFile);
        this.oldGenModelVersion = oldGenModelVersion;
    }

    public Map run(IProgressMonitor progressMonitor) {
        return this.run(progressMonitor, true);
    }

    public Map run(IProgressMonitor progressMonitor, boolean save) {
        IProject project = this.genModelFile.getProject();
        try {
            project.open(progressMonitor);
            this.genModel = GenModelFactory.eINSTANCE.createGenModel();
            this.genModel.getForeignModel().add("@model");
            ArrayList allGenModelFiles = new ArrayList();
            ArrayList allReferencedProjects = new ArrayList();
            this.getAllReferencedProjects(allReferencedProjects, project.getDescription().getReferencedProjects());
            Iterator i = allReferencedProjects.iterator();
            while (i.hasNext()) {
                this.getAllGenModelFiles(allGenModelFiles, (IContainer)((IProject)i.next()));
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Iterator i2 = allGenModelFiles.iterator();
            while (i2.hasNext()) {
                IFile file = (IFile)i2.next();
                Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString()), true);
                GenModel genModel = (GenModel)resource.getContents().get(0);
                this.externalGenModels.add(genModel);
                Iterator j = genModel.getGenPackages().iterator();
                while (j.hasNext()) {
                    GenPackage genPackage = (GenPackage)j.next();
                    this.determineExternalPackages(genPackage);
                }
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
            HashSet visited = new HashSet();
            int i3 = 0;
            while (i3 < packageFragmentRoots.length) {
                if (packageFragmentRoots[i3].getKind() == 1) {
                    this.traverse((IContainer)packageFragmentRoots[i3].getUnderlyingResource(), visited);
                }
                ++i3;
            }
            Iterator i4 = this.eTypedElementToTypeNameMap.entrySet().iterator();
            while (i4.hasNext()) {
                EClass container;
                String typeName;
                Map.Entry entry = i4.next();
                ETypedElement eTypedElement = (ETypedElement)entry.getKey();
                EClassifier eClassifier = this.resolve((EModelElement)eTypedElement, typeName = (String)entry.getValue());
                if (eClassifier instanceof EClass && eTypedElement instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)eTypedElement;
                    container = eAttribute.getEContainingClass();
                    EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                    eReference.setChangeable(eAttribute.isChangeable());
                    eReference.setVolatile(eAttribute.isVolatile());
                    eReference.setTransient(eAttribute.isTransient());
                    eReference.setLowerBound(eAttribute.getLowerBound());
                    eReference.setUpperBound(eAttribute.getUpperBound());
                    eReference.setName(eTypedElement.getName());
                    container.getEAttributes().remove(eTypedElement);
                    container.getEReferences().add(eReference);
                    eTypedElement = eReference;
                } else if (eClassifier instanceof EDataType && eTypedElement instanceof EReference) {
                    EReference eReference = (EReference)eTypedElement;
                    container = eReference.getEContainingClass();
                    EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    eAttribute.setChangeable(eReference.isChangeable());
                    eAttribute.setVolatile(eReference.isVolatile());
                    eAttribute.setTransient(eReference.isTransient());
                    eAttribute.setLowerBound(eReference.getLowerBound());
                    eAttribute.setUpperBound(eReference.getUpperBound());
                    eAttribute.setName(eTypedElement.getName());
                    container.getEReferences().remove(eTypedElement);
                    container.getEAttributes().add(eAttribute);
                    eTypedElement = eAttribute;
                }
                String instanceClassName = (String)this.eTypedElementToInstanceTypeNameMap.get(eTypedElement);
                if (instanceClassName != null && this.demandCreatedEDataTypes.contains(eClassifier)) {
                    this.demandCreatedEDataTypes.remove(eClassifier);
                    EClassifier resolvedInstanceClassName = this.resolve((EModelElement)eTypedElement, instanceClassName, false);
                    ((EDataType)eClassifier).setInstanceClassName(resolvedInstanceClassName.getInstanceClassName());
                }
                if (eClassifier == null) {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeDoesNotResolveCorrectly_message", new Object[]{typeName}));
                    eClassifier = EcorePackage.eINSTANCE.getEObject();
                }
                eTypedElement.setEType(eClassifier);
                this.used((EModelElement)eClassifier);
            }
            Iterator i5 = this.eClassToSuperTypeNamesMap.entrySet().iterator();
            while (i5.hasNext()) {
                Map.Entry entry = i5.next();
                EClass eClass = (EClass)entry.getKey();
                String[] superTypeNames = (String[])entry.getValue();
                if (superTypeNames == null) continue;
                int j = 0;
                while (j < superTypeNames.length) {
                    EClassifier eClassifier = this.resolve((EModelElement)eClass, superTypeNames[j], false);
                    if (eClassifier.getEPackage() == null) {
                        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)eClass);
                        EClass superEClass = EcoreFactory.eINSTANCE.createEClass();
                        superEClass.setInstanceClassName(eClassifier.getInstanceClassName());
                        superEClass.setName(eClassifier.getName());
                        superEClass.setAbstract(true);
                        ePackage.getEClassifiers().add(superEClass);
                        eClassifier = superEClass;
                    }
                    if (eClassifier instanceof EClass) {
                        if (eClassifier != EcorePackage.eINSTANCE.getEObject()) {
                            eClass.getESuperTypes().add(eClassifier);
                            this.used((EModelElement)eClassifier);
                        }
                    } else {
                        this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheSuperTypeDoesNotResolveCorrectly_message", new Object[]{superTypeNames[j]}));
                    }
                    ++j;
                }
            }
            Iterator i6 = this.eReferenceToOppositeNameMap.entrySet().iterator();
            while (i6.hasNext()) {
                Map.Entry entry = i6.next();
                EReference eReference = (EReference)entry.getKey();
                String oppositeName = (String)entry.getValue();
                EClass eClass = (EClass)eReference.getEType();
                EReference eOpposite = (EReference)eClass.getEStructuralFeature(oppositeName);
                if (eOpposite == null) {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheAttributeIsNotAMemberOf_message", new Object[]{oppositeName, eClass.getName()}));
                    continue;
                }
                if (eOpposite.getEOpposite() != eReference && eOpposite.getEOpposite() != null) {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheOppositeAlreadyHasOpposite_message", new Object[]{oppositeName, eOpposite.getEOpposite().getName(), eOpposite.getEOpposite().getEContainingClass().getName()}));
                    continue;
                }
                eReference.setEOpposite(eOpposite);
                eOpposite.setEOpposite(eReference);
                this.used((EModelElement)eOpposite);
                if (!eOpposite.isContainment()) continue;
                eReference.setTransient(true);
            }
            Iterator i7 = this.ePackageToOrderingMap.entrySet().iterator();
            while (i7.hasNext()) {
                Map.Entry entry = i7.next();
                EPackage ePackage = (EPackage)entry.getKey();
                Map nameToIDMap = (Map)entry.getValue();
                this.sort(ePackage.getEClassifiers(), nameToIDMap);
                Iterator j = ePackage.getEClassifiers().iterator();
                while (j.hasNext()) {
                    EClassifier eClassifier = (EClassifier)j.next();
                    if (!(eClassifier instanceof EClass)) continue;
                    EClass eClass = (EClass)eClassifier;
                    this.sort(eClass.getEAttributes(), nameToIDMap);
                    this.sort(eClass.getEReferences(), nameToIDMap);
                }
            }
            IPath targetFragmentRoot = project.getFullPath();
            int i8 = 0;
            while (i8 < packageFragmentRoots.length) {
                IPath path;
                if (packageFragmentRoots[i8].getKind() == 1 && targetFragmentRoot.isPrefixOf(path = packageFragmentRoots[i8].getUnderlyingResource().getFullPath())) {
                    targetFragmentRoot = path;
                }
                ++i8;
            }
            IPath projectLocationPath = project.getLocation();
            URI fileURI = URI.createPlatformResourceURI((String)this.genModelFile.getFullPath().toString());
            String fileName = fileURI.toString();
            Resource genModelResource = resourceSet.createResource(fileURI);
            this.genModel.setModelName(fileURI.trimFileExtension().lastSegment());
            ArrayList ePackages = new ArrayList(this.packageNameToEPackageMap.values());
            Iterator i9 = ePackages.iterator();
            while (i9.hasNext()) {
                EPackage ePackage = (EPackage)i9.next();
                if (ePackage.getName() != null) continue;
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_PackageNestingIsRequired_message"));
            }
            this.genModel.initialize(this.packageNameToEPackageMap.values());
            Iterator genPackages = this.genModel.getGenPackages().iterator();
            block15: while (genPackages.hasNext()) {
                GenPackage genPackage = (GenPackage)genPackages.next();
                EPackage ePackage = genPackage.getEcorePackage();
                String name = genPackage.getEcorePackage().getName();
                genPackage.setPrefix((String)this.ePackageToPrefixMap.get(ePackage));
                Iterator entries = this.packageNameToEPackageMap.entrySet().iterator();
                while (entries.hasNext()) {
                    int index;
                    Map.Entry entry = entries.next();
                    if (entry.getValue() != ePackage) continue;
                    String qualifiedPackageName = (String)entry.getKey();
                    int n = index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                    if (index == -1) continue block15;
                    genPackage.setBasePackage(qualifiedPackageName.substring(0, index));
                    continue block15;
                }
            }
            String qualifier = this.genModel.getGenPackages().isEmpty() ? targetFragmentRoot.segment(0) : ((GenPackage)this.genModel.getGenPackages().get(0)).getInterfacePackageName();
            this.genModel.setModelPluginID(targetFragmentRoot.segment(0));
            this.genModel.setEditPluginClass(qualifier + ".provider." + this.genModel.getModelName() + "EditPlugin");
            this.genModel.setEditorPluginClass(qualifier + ".presentation." + this.genModel.getModelName() + "EditorPlugin");
            this.genModel.setModelDirectory(targetFragmentRoot.toString());
            this.genModel.setEditDirectory("/" + targetFragmentRoot.segment(0) + ".edit/" + targetFragmentRoot.removeFirstSegments(1));
            this.genModel.setEditorDirectory("/" + targetFragmentRoot.segment(0) + ".editor/" + targetFragmentRoot.removeFirstSegments(1));
            this.genModel.getUsedGenPackages().addAll(this.usedGenPackages);
            genModelResource.getContents().add(this.genModel);
            String baseURI = URI.createPlatformResourceURI((String)this.genModelFile.getFullPath().removeLastSegments(1).toString()).toString();
            Iterator i10 = this.packageNameToEPackageMap.values().iterator();
            while (i10.hasNext()) {
                EPackage ePackage = (EPackage)i10.next();
                String uri = baseURI + "/" + ePackage.getName() + ".ecore";
                Resource resource = resourceSet.createResource(URI.createURI((String)uri));
                resource.getContents().add(ePackage);
            }
            if (this.oldGenModelVersion != null) {
                this.genModel.reconcile(this.oldGenModelVersion);
            }
            if (save) {
                genModelResource.save(Collections.EMPTY_MAP);
                Iterator i11 = this.packageNameToEPackageMap.values().iterator();
                while (i11.hasNext()) {
                    EPackage ePackage = (EPackage)i11.next();
                    ePackage.eResource().save(Collections.EMPTY_MAP);
                }
            }
            return this.packageNameToEPackageMap;
        }
        catch (CoreException exception) {
            CodeGenEcorePlugin.INSTANCE.log((Object)exception);
        }
        catch (Exception exception) {
            CodeGenEcorePlugin.INSTANCE.log(exception);
        }
        return Collections.EMPTY_MAP;
    }

    public void used(EModelElement modelElement) {
        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)modelElement);
        if (ePackage != EcorePackage.eINSTANCE) {
            Iterator i = this.externalGenModels.iterator();
            while (i.hasNext()) {
                GenModel genModel = (GenModel)i.next();
                GenPackage genPackage = genModel.findGenPackage(ePackage);
                if (genPackage == null) continue;
                if (this.usedGenPackages.contains(genPackage)) break;
                this.usedGenPackages.add(genPackage);
                TreeIterator j = ePackage.eAllContents();
                while (j.hasNext()) {
                    EObject eObject = (EObject)j.next();
                    Iterator k = eObject.eCrossReferences().iterator();
                    while (k.hasNext()) {
                        Object o = k.next();
                        if (!(o instanceof EModelElement)) continue;
                        this.used((EModelElement)o);
                    }
                }
                break block0;
            }
        }
    }

    public void determineExternalPackages(GenPackage genPackage) {
        EPackage ePackage = genPackage.getEcorePackage();
        this.externalPackageNameToEPackageMap.put(genPackage.getInterfacePackageName(), ePackage);
        Iterator i = genPackage.getNestedGenPackages().iterator();
        while (i.hasNext()) {
            this.determineExternalPackages((GenPackage)i.next());
        }
    }

    public void getAllReferencedProjects(Collection result, IProject[] projects) throws CoreException {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!result.contains(project)) {
                result.add(project);
                this.getAllReferencedProjects(result, project.getDescription().getReferencedProjects());
            }
            ++i;
        }
    }

    public void getAllGenModelFiles(Collection result, IContainer container) throws CoreException {
        IResource[] contents = container.members();
        int i = 0;
        while (i < contents.length) {
            IResource resource = contents[i];
            if (resource.getType() == 1) {
                this.getAllGenModelFiles(result, (IFile)resource);
            } else {
                this.getAllGenModelFiles(result, (IContainer)resource);
            }
            ++i;
        }
    }

    public void getAllGenModelFiles(Collection result, IFile file) throws CoreException {
        if (file.getName().endsWith(".genmodel")) {
            IProject project = file.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IPath outputLocation = javaProject.getOutputLocation();
                if (project == project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation()) || !outputLocation.isPrefixOf(file.getFullPath())) {
                    result.add(file);
                }
            }
            catch (JavaModelException exception) {
                CodeGenEcorePlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public void traverse(IContainer container, Set visited) throws CoreException {
        IResource[] contents = container.members();
        int i = 0;
        while (i < contents.length) {
            IResource resource = contents[i];
            if (visited.add(resource)) {
                if (resource.getType() == 1) {
                    this.traverse((IFile)resource);
                } else {
                    this.traverse((IContainer)resource, visited);
                }
            }
            ++i;
        }
    }

    public void traverse(IFile file) throws CoreException {
        if ("java".equalsIgnoreCase(file.getProjectRelativePath().getFileExtension())) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(file.getContents(true));
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                IDOMCompilationUnit jCompilationUnit = jdomFactory.createCompilationUnit(new String(input), "NAME");
                this.analyzeCompilationUnit(jCompilationUnit);
            }
            catch (IOException exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
    }

    protected void analyzeCompilationUnit(IDOMCompilationUnit compilationUnit) {
        IDOMNode child = compilationUnit.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 4) {
                this.analyzeType((IDOMType)child);
                break;
            }
            child = child.getNextNode();
        }
    }

    protected void analyzeType(IDOMType type) {
        String modelAnnotation;
        IDOMCompilationUnit compilationUnit = (IDOMCompilationUnit)type.getParent();
        String qualifiedPackageName = null;
        if (compilationUnit.getFirstChild() instanceof IDOMPackage) {
            qualifiedPackageName = ((IDOMPackage)compilationUnit.getFirstChild()).getName();
        }
        if ((modelAnnotation = this.getModelAnnotation(type.getComment())) != null) {
            EPackage ePackage = (EPackage)this.packageNameToEPackageMap.get(qualifiedPackageName);
            if (ePackage == null) {
                ePackage = EcoreFactory.eINSTANCE.createEPackage();
                int index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                String packageName = index == -1 ? qualifiedPackageName : qualifiedPackageName.substring(index + 1);
                ePackage.setName(packageName);
                ePackage.setNsURI("http:///" + (qualifiedPackageName == null ? "null" : qualifiedPackageName.replace('.', '/')) + ".ecore");
                ePackage.setNsPrefix(qualifiedPackageName == null ? "null" : qualifiedPackageName);
                this.packageNameToEPackageMap.put(qualifiedPackageName, ePackage);
                if (packageName != null) {
                    String prefix = Character.toUpperCase(packageName.charAt(0)) + packageName.substring(1);
                    this.ePackageToPrefixMap.put(ePackage, prefix);
                }
            }
            if ((type.getFlags() & 0x200) != 0) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                this.eModelElementToIDOMNodeMap.put(eClass, type);
                eClass.setName(type.getName());
                ePackage.getEClassifiers().add(eClass);
                String[] superInterfaces = type.getSuperInterfaces();
                String extend = this.getExtendsAnnotation(type.getComment());
                if (extend != null) {
                    ArrayList<String> superInterfaceList = new ArrayList<String>(Arrays.asList(superInterfaces));
                    StringTokenizer stringTokenizer = new StringTokenizer(extend, " ,\t\n\r\f");
                    while (stringTokenizer.hasMoreTokens()) {
                        superInterfaceList.remove(stringTokenizer.nextToken());
                    }
                    superInterfaces = new String[superInterfaceList.size()];
                    superInterfaceList.toArray(superInterfaces);
                }
                this.eClassToSuperTypeNamesMap.put(eClass, superInterfaces);
                String isAbstract = this.getModelAnnotationAttribute(modelAnnotation, "abstract");
                eClass.setAbstract("true".equals(isAbstract));
                String isInterface = this.getModelAnnotationAttribute(modelAnnotation, "interface");
                eClass.setInterface("true".equals(isInterface));
                IDOMNode child = type.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 6) {
                        this.analyzeMethod(eClass, (IDOMMethod)child);
                    }
                    child = child.getNextNode();
                }
            } else {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                this.eModelElementToIDOMNodeMap.put(eEnum, type);
                eEnum.setName(type.getName());
                ePackage.getEClassifiers().add(eEnum);
                IDOMNode child = type.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 5) {
                        this.analyzeField(eEnum, (IDOMField)child);
                    }
                    child = child.getNextNode();
                }
            }
        } else {
            String typeName = type.getName();
            boolean isPackage = false;
            if (typeName.endsWith("Package") && typeName.length() > 7) {
                String packagePrefix = typeName.substring(0, typeName.length() - 7);
                int index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                String name = index == -1 ? qualifiedPackageName : qualifiedPackageName.substring(index + 1);
                String nsURI = "http:///" + (qualifiedPackageName == null ? "null" : qualifiedPackageName.replace('.', '/')) + ".ecore";
                String nsPrefix = qualifiedPackageName == null ? "null" : qualifiedPackageName;
                ArrayList<EClass> eClasses = new ArrayList<EClass>();
                ArrayList<EDataType> eDataTypes = new ArrayList<EDataType>();
                HashMap<String, Integer> ordering = new HashMap<String, Integer>();
                IDOMNode child = type.getFirstChild();
                while (child != null) {
                    String returnType;
                    IDOMMethod method;
                    String methodAnnotation;
                    if (child.getNodeType() == 5) {
                        IDOMField field = (IDOMField)child;
                        String childName = child.getName();
                        String childType = field.getType();
                        if ("eNAME".equals(childName)) {
                            isPackage = true;
                            name = field.getInitializer();
                            name = name.substring(2, name.length() - 1);
                        } else if ("eNS_URI".equals(childName)) {
                            isPackage = true;
                            nsURI = field.getInitializer();
                            nsURI = nsURI.substring(2, nsURI.length() - 1);
                        } else if ("eNS_PREFIX".equals(childName)) {
                            isPackage = true;
                            nsPrefix = field.getInitializer();
                            nsPrefix = nsPrefix.substring(2, nsPrefix.length() - 1);
                        } else if ("int".equals(childType) && !childName.endsWith("FEATURE_COUNT")) {
                            try {
                                String initializer = field.getInitializer();
                                int plusIndex = initializer.lastIndexOf("+");
                                if (plusIndex != -1) {
                                    initializer = initializer.substring(plusIndex + 1);
                                }
                                initializer = initializer.trim();
                                int value = Integer.parseInt(initializer);
                                ordering.put(childName, new Integer(value));
                            }
                            catch (NumberFormatException exception) {}
                        }
                    } else if (child.getNodeType() == 6 && (methodAnnotation = this.getModelAnnotation((method = (IDOMMethod)child).getComment())) != null && (returnType = method.getReturnType()) != null) {
                        if (returnType.endsWith("EDataType")) {
                            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                            eDataType.setInstanceClassName(this.getModelAnnotationAttribute(methodAnnotation, "instanceClass"));
                            eDataType.setName(method.getName().substring(3));
                            String isSerializable = this.getModelAnnotationAttribute(methodAnnotation, "serializable");
                            if ("false".equals(isSerializable)) {
                                eDataType.setSerializable(false);
                            }
                            eDataTypes.add(eDataType);
                        } else if (returnType.endsWith("EClass")) {
                            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                            String instanceClass = this.getModelAnnotationAttribute(methodAnnotation, "instanceClass");
                            if (instanceClass != null) {
                                eClass.setInterface(true);
                                eClass.setAbstract(true);
                                eClass.setInstanceClassName(instanceClass);
                                eClass.setName(method.getName().substring(3));
                                eClasses.add(eClass);
                            } else {
                                eClass.setInstanceClassName("java.util.Map$Entry");
                                eClass.setName(method.getName().substring(3));
                                eClasses.add(eClass);
                                String features = this.getModelAnnotationAttribute(methodAnnotation, "features");
                                if (features != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(features, " ");
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String feature = stringTokenizer.nextToken();
                                        this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, feature), "get" + Character.toUpperCase(feature.charAt(0)) + feature.substring(1), "java.lang.Object", null, null);
                                    }
                                } else {
                                    this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, "key"), "getKey", "java.lang.Object", null, null);
                                    this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, "value"), "getValue", "java.lang.Object", null, null);
                                }
                            }
                        }
                    }
                    child = child.getNextNode();
                }
                if (isPackage || !eClasses.isEmpty() || !eDataTypes.isEmpty()) {
                    EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
                    this.ePackageToOrderingMap.put(ePackage, ordering);
                    this.eModelElementToIDOMNodeMap.put(ePackage, type);
                    ePackage.setNsURI(nsURI);
                    ePackage.setNsPrefix(nsPrefix);
                    ePackage.setName(name);
                    ePackage.getEClassifiers().addAll(eClasses);
                    ePackage.getEClassifiers().addAll(eDataTypes);
                    this.ePackageToPrefixMap.put(ePackage, packagePrefix);
                    EPackage existingEPackage = (EPackage)this.packageNameToEPackageMap.get(qualifiedPackageName);
                    if (existingEPackage != null) {
                        ePackage.getEClassifiers().addAll(existingEPackage.getEClassifiers());
                    }
                    this.packageNameToEPackageMap.put(qualifiedPackageName, ePackage);
                }
            }
        }
    }

    protected void analyzeMethod(EClass eClass, IDOMMethod method) {
        String modelAnnotation = this.getModelAnnotation(method.getComment());
        if (modelAnnotation != null) {
            String methodName = method.getName();
            String returnType = method.getReturnType();
            String[] parameterNames = method.getParameterNames();
            String[] parameterTypes = method.getParameterTypes();
            ETypedElement eTypedElement = this.analyzeMethod(eClass, modelAnnotation, methodName, returnType, parameterNames, parameterTypes);
            this.eModelElementToIDOMNodeMap.put(eTypedElement, method);
            if (eTypedElement instanceof EOperation) {
                EOperation eOperation = (EOperation)eTypedElement;
                Iterator i = eOperation.getEParameters().iterator();
                while (i.hasNext()) {
                    EParameter eParameter = (EParameter)i.next();
                    this.eModelElementToIDOMNodeMap.put(eParameter, method);
                }
            }
        }
    }

    protected ETypedElement analyzeMethod(EClass eClass, String modelAnnotation, String methodName, String returnType, String[] parameterNames, String[] parameterTypes) {
        String dataType;
        EOperation eTypedElement = null;
        String featureName = methodName;
        String parameters = this.getModelAnnotationAttribute(modelAnnotation, "parameters");
        if (parameterNames == null && parameters == null && methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && !"boolean".equals(returnType)) {
            featureName = this.genModel.uncapName(methodName.substring(3));
        } else if (parameterNames == null && parameters == null && methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && "boolean".equals(returnType)) {
            featureName = this.genModel.uncapName(methodName.substring(2));
        } else {
            EOperation eOperation;
            eTypedElement = eOperation = EcoreFactory.eINSTANCE.createEOperation();
            eClass.getEOperations().add(eTypedElement);
            if (parameterTypes != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(parameters == null ? "" : parameters);
                int i = 0;
                while (i < parameterNames.length) {
                    EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                    eOperation.getEParameters().add(eParameter);
                    eParameter.setName(parameterNames[i]);
                    String parameterType = parameterTypes[i];
                    if (stringTokenizer.hasMoreTokens()) {
                        this.eTypedElementToInstanceTypeNameMap.put(eParameter, parameterType);
                        dataType = stringTokenizer.nextToken();
                        if (!"-".equals(dataType)) {
                            parameterType = dataType;
                        }
                    }
                    this.eTypedElementToTypeNameMap.put(eParameter, parameterType);
                    ++i;
                }
            }
        }
        if (!"void".equals(returnType)) {
            if (eTypedElement == null) {
                String upperBound;
                String many;
                EReference eStructuralFeature = null;
                String opposite = this.getModelAnnotationAttribute(modelAnnotation, "opposite");
                String containment = this.getModelAnnotationAttribute(modelAnnotation, "containment");
                String resolveProxies = this.getModelAnnotationAttribute(modelAnnotation, "resolveProxies");
                String mapType = this.getModelAnnotationAttribute(modelAnnotation, "mapType");
                dataType = this.getModelAnnotationAttribute(modelAnnotation, "dataType");
                String keyType = this.getModelAnnotationAttribute(modelAnnotation, "keyType");
                String valueType = this.getModelAnnotationAttribute(modelAnnotation, "valueType");
                String modelType = this.getModelAnnotationAttribute(modelAnnotation, "type");
                if (opposite != null || containment != null || resolveProxies != null || mapType != null || keyType != null && valueType != null) {
                    EReference eReference;
                    eStructuralFeature = eReference = EcoreFactory.eINSTANCE.createEReference();
                    eTypedElement = eStructuralFeature;
                    eClass.getEReferences().add(eStructuralFeature);
                    eReference.setContainment("true".equals(containment) || mapType != null && !returnType.endsWith("Entry") || keyType != null && valueType != null);
                    eReference.setResolveProxies(!"false".equals(resolveProxies));
                    eReference.setUnsettable("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "unsettable")));
                    if (opposite != null) {
                        this.eReferenceToOppositeNameMap.put(eReference, opposite);
                    }
                } else {
                    EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    eStructuralFeature = eAttribute;
                    eTypedElement = eStructuralFeature;
                    eClass.getEAttributes().add(eStructuralFeature);
                    eAttribute.setUnsettable("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "unsettable")));
                    eAttribute.setID("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "id")));
                    String defaultValueLiteral = this.getModelAnnotationAttribute(modelAnnotation, "defaultValue");
                    if (defaultValueLiteral == null) {
                        defaultValueLiteral = this.getModelAnnotationAttribute(modelAnnotation, "default");
                    }
                    eStructuralFeature.setDefaultValueLiteral(defaultValueLiteral);
                    eStructuralFeature.setUnique(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "unique")));
                }
                if (dataType == null || mapType != null) {
                    if ("EList".equals(returnType) || "org.eclipse.emf.common.util.EList".equals(returnType) || "List".equals(returnType) || "java.util.List".equals(returnType)) {
                        eStructuralFeature.setUpperBound(-1);
                        if (modelType == null) {
                            this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeMustBeSpecifiedFor_message", new Object[]{eClass.getName() + "." + methodName}));
                            modelType = "java.lang.Object";
                        }
                    } else if ("EMap".equals(returnType) || "org.eclipse.emf.common.util.EMap".equals(returnType) || "Map".equals(returnType) || "java.util.Map".equals(returnType)) {
                        eStructuralFeature.setUpperBound(-1);
                    }
                }
                if ((many = this.getModelAnnotationAttribute(modelAnnotation, "many")) != null) {
                    eStructuralFeature.setUpperBound("true".equals(many) ? -1 : 1);
                }
                if (modelType != null) {
                    returnType = modelType;
                }
                if (mapType != null) {
                    returnType = keyType != null && valueType != null ? mapType + "@" + keyType + "/" + valueType : mapType;
                } else if (dataType != null) {
                    this.eTypedElementToInstanceTypeNameMap.put(eStructuralFeature, returnType);
                    returnType = dataType;
                } else if (keyType != null && valueType != null) {
                    returnType = keyType + "/" + valueType;
                }
                eStructuralFeature.setChangeable(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "changeable")));
                eStructuralFeature.setVolatile("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "volatile")));
                eStructuralFeature.setTransient("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "transient")));
                eStructuralFeature.setLowerBound("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "required")) ? 1 : 0);
                String lowerBound = this.getModelAnnotationAttribute(modelAnnotation, "lowerBound");
                if (lowerBound == null) {
                    lowerBound = this.getModelAnnotationAttribute(modelAnnotation, "lower");
                }
                if (lowerBound != null) {
                    eStructuralFeature.setLowerBound(Integer.parseInt(lowerBound));
                }
                if ((upperBound = this.getModelAnnotationAttribute(modelAnnotation, "upperBound")) == null) {
                    upperBound = this.getModelAnnotationAttribute(modelAnnotation, "upper");
                }
                if (upperBound != null) {
                    eStructuralFeature.setUpperBound(Integer.parseInt(upperBound));
                }
            } else {
                String dataType2 = this.getModelAnnotationAttribute(modelAnnotation, "dataType");
                if (dataType2 != null) {
                    this.eTypedElementToInstanceTypeNameMap.put(eTypedElement, returnType);
                    returnType = dataType2;
                }
            }
            this.eTypedElementToTypeNameMap.put(eTypedElement, returnType);
        }
        eTypedElement.setName(featureName);
        return eTypedElement;
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier eType) {
        if (eType instanceof EClass) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            eReference.setName(name);
            eReference.setEType(eType);
            eClass.getEReferences().add(eReference);
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(eType);
        eClass.getEAttributes().add(eAttribute);
        return eAttribute;
    }

    protected void analyzeField(EEnum eEnum, IDOMField field) {
        String modelAnnotation = this.getModelAnnotation(field.getComment());
        if (modelAnnotation != null) {
            String literalName = this.getModelAnnotationAttribute(modelAnnotation, "name");
            if (literalName == null) {
                literalName = field.getName();
            }
            EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
            this.eModelElementToIDOMNodeMap.put(eEnumLiteral, field);
            eEnumLiteral.setName(literalName);
            try {
                int value = Integer.parseInt(field.getInitializer().trim());
                eEnumLiteral.setValue(value);
            }
            catch (NumberFormatException exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
            eEnum.getELiterals().add(eEnumLiteral);
        }
    }

    protected String getModelAnnotation(String comment) {
        Match match = new Match();
        if (comment != null && modelAnnotationExpression.matches(comment, match)) {
            return comment.substring(match.getBeginning(1), match.getEnd(1));
        }
        return null;
    }

    protected String getExtendsAnnotation(String comment) {
        Match match = new Match();
        if (comment != null && (extendsAnnotationExpression.matches(comment, match) || implementsAnnotationExpression.matches(comment, match))) {
            return comment.substring(match.getBeginning(1), match.getEnd(1));
        }
        return null;
    }

    protected String getModelAnnotationAttribute(String modelAnnotation, String attributeName) {
        Match match;
        RegularExpression modelAnnotationAttributeExpressionDoubleQuote = new RegularExpression("\\<" + attributeName + "\\s*=\\s*([\"'])(.*?)\\1", "m");
        if (modelAnnotationAttributeExpressionDoubleQuote.matches(modelAnnotation, match = new Match())) {
            return modelAnnotation.substring(match.getBeginning(2), match.getEnd(2));
        }
        return null;
    }

    protected String getFilteredModelAnnotations(String modelAnnotation, String filter) {
        StringBuffer result = new StringBuffer();
        RegularExpression modelAnnotationAttributeExpressionDoubleQuote = new RegularExpression("\\<" + filter + "([A-Z]\\w*\\s*=\\s*([\"'])(.*?)\\2)", "m");
        int start = 0;
        int end = modelAnnotation.length();
        Match match = new Match();
        while (modelAnnotationAttributeExpressionDoubleQuote.matches(modelAnnotation, start, end, match)) {
            result.append(modelAnnotation.substring(match.getBeginning(1), match.getBeginning(1) + 1).toLowerCase());
            result.append(modelAnnotation.substring(match.getBeginning(1) + 1, match.getEnd(1)));
            result.append(' ');
            start = match.getEnd(0);
        }
        return result.toString();
    }

    protected EClassifier resolve(EModelElement eModelElement, String typeName) {
        return this.resolve(eModelElement, typeName, true);
    }

    protected EClassifier resolve(EModelElement eModelElement, String typeName, boolean recordDemandCreatedEDataType) {
        Iterator j;
        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)eModelElement);
        EClassifier eClassifier = null;
        int indexOfSlash = typeName.indexOf("/");
        if (indexOfSlash != -1) {
            String mapType = null;
            String keyType = typeName.substring(0, indexOfSlash);
            int indexOfAt = keyType.indexOf("@");
            if (indexOfAt != -1) {
                mapType = keyType.substring(0, indexOfAt);
                keyType = keyType.substring(indexOfAt + 1);
            }
            EClassifier keyEClassifier = this.resolve(eModelElement, keyType);
            String valueType = typeName.substring(indexOfSlash + 1);
            EClassifier valueEClassifier = this.resolve(eModelElement, valueType);
            if (mapType == null) {
                eClassifier = this.resolveMapEntry(ePackage, keyEClassifier, valueEClassifier);
                if (eClassifier == null) {
                    eClassifier = this.resolveMapEntry((EPackage)EcorePackage.eINSTANCE, keyEClassifier, valueEClassifier);
                }
            } else {
                eClassifier = this.resolve(eModelElement, mapType, false);
            }
            if (eClassifier == null) {
                String baseName;
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                eClass.setInstanceClassName("java.util.Map$Entry");
                String name = baseName = mapType != null ? mapType : keyEClassifier.getName() + "To" + valueEClassifier.getName() + "MapEntry";
                int j2 = 1;
                while (ePackage.getEClassifier(name) != null) {
                    name = baseName + "_" + j2;
                    ++j2;
                }
                eClass.setName(name);
                this.createFeature(eClass, "key", keyEClassifier);
                this.createFeature(eClass, "value", valueEClassifier);
                ePackage.getEClassifiers().add(eClass);
                eClassifier = eClass;
            }
            return eClassifier;
        }
        String baseName = typeName;
        String packageName = "";
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            IDOMNode node = (IDOMNode)this.eModelElementToIDOMNodeMap.get(eModelElement);
            while (node != null) {
                if (node.getNodeType() == 1) {
                    boolean firstWildcard = true;
                    IDOMNode child = ((IDOMCompilationUnit)node).getFirstChild();
                    while (child != null) {
                        if (child.getNodeType() == 3) {
                            int importIndex;
                            IDOMImport jImport = (IDOMImport)child;
                            String importName = jImport.getName();
                            if (importName.endsWith("." + baseName)) {
                                importIndex = importName.lastIndexOf(".");
                                packageName = importName.substring(0, importIndex);
                                typeName = packageName + "." + baseName;
                                break;
                            }
                            if (firstWildcard && importName.endsWith(".*")) {
                                importIndex = importName.lastIndexOf(".");
                                packageName = importName.substring(0, importIndex);
                                typeName = packageName + "." + baseName;
                                firstWildcard = false;
                            }
                        }
                        child = child.getNextNode();
                    }
                    EPackage otherEPackage = (EPackage)this.packageNameToEPackageMap.get(packageName);
                    if (otherEPackage == null) {
                        otherEPackage = (EPackage)this.externalPackageNameToEPackageMap.get(packageName);
                    }
                    if (otherEPackage == null) break;
                    eClassifier = otherEPackage.getEClassifier(baseName);
                    break;
                }
                node = node.getParent();
            }
            if (eClassifier == null && "".equals(packageName)) {
                eClassifier = ePackage.getEClassifier(typeName);
            }
        } else {
            packageName = typeName.substring(0, index);
            baseName = typeName.substring(index + 1);
            EPackage otherEPackage = (EPackage)this.packageNameToEPackageMap.get(packageName);
            if (otherEPackage == null) {
                otherEPackage = (EPackage)this.externalPackageNameToEPackageMap.get(packageName);
            }
            if (otherEPackage != null) {
                eClassifier = otherEPackage.getEClassifier(baseName);
            }
        }
        if (eClassifier == null) {
            j = ePackage.getEClassifiers().iterator();
            while (j.hasNext()) {
                EClassifier ePackageClassifier = (EClassifier)j.next();
                if (!typeName.equals(ePackageClassifier.getInstanceClassName())) continue;
                eClassifier = ePackageClassifier;
                break;
            }
        }
        if (EcorePackage.eINSTANCE.getEObject().getInstanceClassName().equals(typeName)) {
            eClassifier = EcorePackage.eINSTANCE.getEObject();
        }
        if (eClassifier == null && (packageName.length() == 0 || packageName.equals("java.lang"))) {
            j = EcorePackage.eINSTANCE.getEClassifiers().iterator();
            while (j.hasNext()) {
                String instanceClassName;
                EClassifier ecoreEClassifier = (EClassifier)j.next();
                if (!(ecoreEClassifier instanceof EDataType) || !(instanceClassName = ecoreEClassifier.getInstanceClassName()).equals(typeName) && !instanceClassName.equals("java.lang." + typeName)) continue;
                eClassifier = ecoreEClassifier;
                break;
            }
        }
        if (eClassifier == null && !(eModelElement instanceof EReference)) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            eDataType.setInstanceClassName(typeName);
            String name = baseName;
            int j3 = 1;
            while (ePackage.getEClassifier(name) != null) {
                name = baseName + "_" + j3;
                ++j3;
            }
            eDataType.setName(name);
            if (recordDemandCreatedEDataType) {
                this.demandCreatedEDataTypes.add(eDataType);
                ePackage.getEClassifiers().add(eDataType);
            }
            eClassifier = eDataType;
        }
        return eClassifier;
    }

    protected EClass resolveMapEntry(EPackage ePackage, EClassifier keyEClassifier, EClassifier valueEClassifier) {
        Iterator j = ePackage.getEClassifiers().iterator();
        while (j.hasNext()) {
            EStructuralFeature valueFeature;
            EClass mapEntryInterface;
            EStructuralFeature keyFeature;
            EClassifier ePackageClassifier = (EClassifier)j.next();
            if (!(ePackageClassifier instanceof EClass) || !"java.util.Map.Entry".equals(ePackageClassifier.getInstanceClassName()) && !"java.util.Map$Entry".equals(ePackageClassifier.getInstanceClassName()) || (keyFeature = (mapEntryInterface = (EClass)ePackageClassifier).getEStructuralFeature("key")) == null || keyFeature.getEType() != keyEClassifier || keyFeature.isMany() || (valueFeature = mapEntryInterface.getEStructuralFeature("value")) == null || valueFeature.getEType() != valueEClassifier || valueFeature.isMany()) continue;
            return mapEntryInterface;
        }
        return null;
    }

    protected void sort(EList eList, final Map nameToIDMap) {
        TreeSet ordered = new TreeSet(new Comparator(){

            public boolean equals(Object object) {
                return object == this;
            }

            public int compare(Object firstObject, Object secondObject) {
                int firstValue = JavaEcoreBuilder.this.getOrderingValue((ENamedElement)firstObject, nameToIDMap);
                int secondValue = JavaEcoreBuilder.this.getOrderingValue((ENamedElement)secondObject, nameToIDMap);
                return firstValue - secondValue;
            }
        });
        ordered.addAll(eList);
        int index = 0;
        Iterator i = ordered.iterator();
        while (i.hasNext()) {
            eList.move(index, i.next());
            ++index;
        }
    }

    protected int getOrderingValue(ENamedElement eNamedElement, Map nameToIDMap) {
        Integer result = (Integer)nameToIDMap.get(eNamedElement);
        if (result == null) {
            if (eNamedElement instanceof EClassifier) {
                String prefix = (String)this.ePackageToPrefixMap.get(eNamedElement.eContainer());
                String name = eNamedElement.getName();
                String id = this.genModel.format(name, '_', prefix, true).toUpperCase();
                result = (Integer)nameToIDMap.get(id);
            } else {
                String prefix = (String)this.ePackageToPrefixMap.get(eNamedElement.eContainer().eContainer());
                String eClassName = ((ENamedElement)eNamedElement.eContainer()).getName();
                String eFeatureName = eNamedElement.getName();
                String id = this.genModel.format(eClassName, '_', prefix, true).toUpperCase() + "__" + this.genModel.format(eFeatureName, '_', prefix, true).toUpperCase();
                result = (Integer)nameToIDMap.get(id);
            }
            if (result != null) {
                nameToIDMap.put(eNamedElement, result);
            }
        }
        if (result != null) {
            return result;
        }
        return Integer.MAX_VALUE;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    protected void error(String message) {
        System.err.println("-->Error: " + message);
        this.status.add((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, message, null));
    }
}

