/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDAnySimpleType.java, xsd, org.eclipse.102, 20030326_0335VL
 * @version 1.4 3/26/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;


public class XSDAnySimpleType 
{
  public void assess(XSDSimpleTypeDefinitionImpl.AssessmentImpl assessment)
  {
    assessment.xsdAnySimpleType = this;
    if (isValidLiteral(assessment.normalizedLiteral))
    {
      assessment.value = getValue(assessment.normalizedLiteral);
    }
    else
    {
      assessment.reportDatatypeDiagnostic();
    }
  }

  public boolean isValidLiteral(String normalizedLiteral)
  {
    return true;
  }

  public Object getValue(String normalizedLiteral)
  {
    return normalizedLiteral;
  }

  public String getCanonicalLiteral(Object value)
  {
    return value == null ? null : value.toString();
  }

  public int compareValues(Object value1, Object value2)
  {
    throw new RuntimeException(XSDPlugin.INSTANCE.getString("_EXC_CompareNotSupported"));
  }
}
