/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDBooleanType.java, xsd, org.eclipse.102, 20030326_0335VL
 * @version 1.3 3/26/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;


public class XSDBooleanType extends XSDAnySimpleType
{
  public boolean isValidLiteral(String literal)
  {
    try
    {
      return "true".equals(literal) || "false".equals(literal);
    }
    catch (RuntimeException exception)
    {
      return false;
    }
  }

  public Object getValue(String literal)
  {
    Boolean value = new Boolean(literal);
    return value;
  }

  public String getCanonicalLiteral(Object value)
  {
    return value.toString();
  }
}
