/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDGMonthType.java, xsd, org.eclipse.102, 20030326_0335VL
 * @version 1.2 3/26/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.MonthDV;



public class XSDGMonthType extends XSDAnySimpleType
{
  public static class AccessibleMonthDV extends MonthDV
  {
    public String dateToString(int[] month)
    {
      return super.dateToString(month);
    }

    public short compareDates(int[] month1, int[] month2, boolean strict) 
    {
      return super.compareDates(month1, month2, strict);
    }
  }

  protected static final AccessibleMonthDV monthDV = new AccessibleMonthDV();

  public boolean isValidLiteral(String normalizedLiteral)
  {
    try
    {
      monthDV.getActualValue(normalizedLiteral, null);
      return true;
    }
    catch (InvalidDatatypeValueException exception)
    {
      return false;
    }
  }

  public Object getValue(String normalizedLiteral)
  {
    try
    {
      return monthDV.getActualValue(normalizedLiteral, null);
    }
    catch (InvalidDatatypeValueException exception)
    {
      return null;
    }
  }

  public String getCanonicalLiteral(Object value)
  {
    return value == null ? null : monthDV.dateToString((int[]) value);
  }

  public int compareValues(Object value1, Object value2)
  {
    return monthDV.compareDates((int []) value1, (int [])value2, true);
  }
}
