/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.mapping.xsd2ecore/src/org/eclipse/emf/mapping/xsd2ecore/util/XSD2EcoreResourceFactoryImpl.java, emf.mapping.xsd2ecore, org.eclipse.dev, 20030620_1105VL
 * @version 1.4 6/20/03
 */
package org.eclipse.emf.mapping.xsd2ecore.util;


import java.util.Locale;

import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;

import org.eclipse.emf.ecore.xmi.XMIResource;

import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;


/**
 * <!-- begin-user-doc -->
 * The <b>Resource Factory</b> associated with the package.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.mapping.xsd2ecore.util.XSD2EcoreResourceImpl
 * @generated
 */
public class XSD2EcoreResourceFactoryImpl extends ResourceFactoryImpl
{
  protected static final boolean USE_ASCII = Locale.getDefault().getLanguage().equals("en");

  /**
   * Creates an instance of the resource factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public XSD2EcoreResourceFactoryImpl()
  {
    super();
  }

  /**
   * Creates an instance of the resource.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Resource createResource(URI uri)
  {
    XSD2EcoreResourceImpl result = new XSD2EcoreResourceImpl(uri);

    if (!USE_ASCII)
    {
      result.setEncoding("UTF-8");
    }

    result.getDefaultSaveOptions().put(XMIResource.OPTION_USE_ENCODED_ATTRIBUTE_STYLE, Boolean.TRUE);
    result.getDefaultSaveOptions().put(XMIResource.OPTION_LINE_WIDTH, new Integer(80));

    return result;
  }
} //XSD2EcoreResourceFactoryImpl
