/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.mapping.xsd2ecore.editor/src/org/eclipse/emf/mapping/xsd2ecore/presentation/XSD2EcoreEditor.java, emf.mapping.xsd2ecore.editor, org.eclipse.111, 20031020_1612WL
 * @version 1.5 10/20/03
 */
package org.eclipse.emf.mapping.xsd2ecore.presentation;


import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;

import org.eclipse.emf.common.notify.AdapterFactory;

import org.eclipse.emf.common.ui.ViewerPane;

import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import org.eclipse.emf.edit.command.InitializeCopyCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProvider;

import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;

import org.eclipse.emf.edit.ui.action.CommandAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;

import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;

import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;

import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertySource;

import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingRoot;

import org.eclipse.emf.mapping.command.InitializeCopyOverrideCommand;
import org.eclipse.emf.mapping.command.PersistentCommandStack;

import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.domain.AdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.domain.PluginAdapterFactoryMappingDomain;

import org.eclipse.emf.mapping.presentation.MappingEditor;

import org.eclipse.emf.mapping.provider.MappingItemProviderAdapterFactory;

import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreFactory;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreMappingRoot;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcorePackage;

import org.eclipse.emf.mapping.xsd2ecore.provider.XSD2EcoreItemProviderAdapterFactory;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;

import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

import org.eclipse.swt.SWT;

import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;

import org.eclipse.swt.graphics.Image;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;

import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

import org.eclipse.ui.actions.WorkspaceModifyOperation;

import org.eclipse.ui.dialogs.SaveAsDialog;

import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

import org.eclipse.xsd.provider.XSDItemProviderAdapterFactory;


/**
 * This is an example of a mapper model editor.
 */
public class XSD2EcoreEditor extends MappingEditor 
{
  public XSD2EcoreEditor()
  {
    topLabel = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XMLSchema_label");
    bottomLabel = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_Ecore_label");
  }

  public static class MyInitializeCopyOverrideCommand extends InitializeCopyOverrideCommand 
  {
    /**
     * Constructor for MyInitializeCopyOverrideCommand.
     * @param domain
     * @param initializeCommand
     */
    public MyInitializeCopyOverrideCommand(MappingDomain domain, InitializeCopyCommand initializeCommand) 
    {
      super(domain, initializeCommand);
    }
      
    /**
     * @see org.eclipse.emf.common.command.Command#execute()
     */
    public void execute() 
    {
      super.execute();
    }
  }
   
  public static class MyMappingDomain extends PluginAdapterFactoryMappingDomain 
  {
    /**
     * Constructor for MyMappingDomain.
     * @param mappingDomainAdapterFactory
     * @param topDomainAdapterFactory
     * @param bottomDomainAdapterFactory
     * @param commandStack
     * @param mappingDomainKey
     */
    public MyMappingDomain
      (AdapterFactory mappingDomainAdapterFactory,
       AdapterFactory topDomainAdapterFactory,
       AdapterFactory bottomDomainAdapterFactory,
       CommandStack commandStack,
       String mappingDomainKey) 
    {
     super
       (mappingDomainAdapterFactory,
        topDomainAdapterFactory,
        bottomDomainAdapterFactory,
        commandStack,
        mappingDomainKey);
    }

    protected Command createInitializeCopyOverrideCommand(InitializeCopyCommand initializeCopyCommand) 
    {
      EObject copy = initializeCopyCommand.getCopy();
      EObject owner = initializeCopyCommand.getOwner();

      // If the owner and the copy are of the same type, we can proceed with the command, i.e. no override.
      // If not, we will skip this command by returning a do-nothing override.
      //
      if (!isSameEditingDomainAdapterFactory) 
      {
        return new MyInitializeCopyOverrideCommand(this, initializeCopyCommand);
      }

      return null;
    }
  }

  protected AdapterFactoryMappingDomain createMappingDomain() 
  {
    AdapterFactory mappingAdapterFactory =
      new ComposedAdapterFactory(
        new AdapterFactory[] 
        {
          new ResourceItemProviderAdapterFactory(),
          new MappingItemProviderAdapterFactory(),
          new XSD2EcoreItemProviderAdapterFactory()
        });

    // This is a test case for the persistent command stack implementation.
    //
    CommandStack commandStack = new BasicCommandStack();

    ResourceSet resourceSet = new ResourceSetImpl();

    // This is a test case for cross domain code.
    // It creates two instances of the factory.
    //
    AdapterFactoryMappingDomain mappingDomain;
    mappingDomain =
      new MyMappingDomain
        (mappingAdapterFactory,
         new XSDItemProviderAdapterFactory(),
         new EcoreItemProviderAdapterFactory(),
         commandStack,
         null);

/*
    mappingDomain.setMappingEnablementFlags
      (MappingDomain.ENABLE_MULTIPLE_INPUTS |
        MappingDomain.ENABLE_MULTIPLE_INPUT_MAPPINGS |
        MappingDomain.ENABLE_EMPTY_INPUTS);
*/

    return mappingDomain;
  }

  /**
   * @see org.eclipse.emf.mapping.presentation.MappingEditor#handleMissingModelFile()
   */
  protected void handleMissingModelFile() 
  {
    try 
    {
      IFile mappingModelFile =
        modelFile.getFile().getParent().getFile
          (new Path(new Path(modelFile.getName()).removeFileExtension().toOSString() + ".mapper"));

      MappingRoot originalRootObject =
        (MappingRoot) ((Resource) mappingDomain.getResourceSet().getResources().iterator().next()).getContents().get(0);

      // Switch over.
      //
      modelFile = new FileEditorInput(mappingModelFile);

      Resource mappingModelResource = null;
      if (mappingModelFile.exists()) 
      {
        Resource resource = mappingDomain.loadResource(getURIFromFile(modelFile.getFile()));
        mappingRoot = (MappingRoot) resource.getContents().get(0);
      } 
      else 
      {
        // Get the resource factory for this type of file name.
        //
        mappingModelResource = 
          mappingDomain.getResourceSet().createResource(URI.createFileURI(modelFile.getFile().getFullPath().toString()));

        // Add the initial model object to the extent.
        //
        mappingRoot = XSD2EcoreFactory.eINSTANCE.createXSD2EcoreMappingRoot();

        mappingModelResource.getContents().add(mappingRoot);

        mappingDomain.getResourceSet().getResources().add(mappingModelResource);

        mappingRoot.getInputs().add(originalRootObject);

        IFile outputModelFile =
          modelFile.getFile().getParent().getFile
            (new Path(new Path(modelFile.getName()).removeFileExtension().toOSString() + "_mapper_result.classside"));

        Resource outputResource = null;

        if (outputModelFile.exists()) 
        {
          outputResource = mappingDomain.loadResource(getURIFromFile(outputModelFile));
        } 
        else 
        {
          // Get the resource factory for this type of file name.
          //
          outputResource = mappingDomain.getResourceSet().createResource(URI.createURI(getURIFromFile(outputModelFile)));

          XSD2EcoreMappingRoot xsd2EcoreMappingRoot = XSD2EcoreFactory.eINSTANCE.createXSD2EcoreMappingRoot();

          outputResource.getContents().add(xsd2EcoreMappingRoot);

          mappingRoot.getOutputs().addAll(outputResource.getContents());
        }

        doSave(null);
      }
      mappingRoot.setDomain(mappingDomain);
      mappingRoot.setTopToBottom(true);
    } 
    catch (Exception exception) 
    {
      exception.printStackTrace();
    }
  }
}
