/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/XSDConstrainingFacet.java, xsd, org.eclipse.111, 20031020_1612WL
 * @version 1.5 10/20/03
 */
package org.eclipse.xsd;


import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object 
 * '<a href="http://www.w3.org/TR/xmlschema-2/#rf-facets"><em><b>Constraining Facet</b></em></a>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * </p>
 *
 * @see org.eclipse.xsd.XSDPackage#getXSDConstrainingFacet()
 * @model abstract="true"
 * @generated
 */
public interface XSDConstrainingFacet extends XSDFacet {
  /**
   * Returns whether the given value satisfies the constraint of this facet.
   * @param value an arbitrary value.
   * @return whether the value satisfies the constraint of this facet.
   */
  boolean isConstraintSatisfied(Object value);
}
