/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDDurationType.java, xsd, org.eclipse.111, 20031020_1612WL
 * @version 1.3 10/20/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.DurationDV;



public class XSDDurationType extends XSDAnySimpleType
{
  public static class AccessibleDurationDV extends DurationDV
  {
    public String dateToString(int[] date)
    {
      return super.dateToString(date);
    }

    public short compareDates(int[] date1, int[] date2, boolean strict) 
    {
      return super.compareDates(date1, date2, strict);
    }
  }

  protected static final AccessibleDurationDV durationDV = new AccessibleDurationDV();

  public boolean isValidLiteral(String normalizedLiteral)
  {
    try
    {
      durationDV.getActualValue(normalizedLiteral, null);
      return true;
    }
    catch (InvalidDatatypeValueException exception)
    {
      return false;
    }
  }

  public Object getValue(String normalizedLiteral)
  {
    try
    {
      return new IntSequence(this, (int [])durationDV.getActualValue(normalizedLiteral, null));
    }
    catch (InvalidDatatypeValueException exception)
    {
      return null;
    }
  }

  public String getCanonicalLiteral(Object value)
  {
    return value == null ? null : durationDV.dateToString(((IntSequence)value).getInts());
  }

  public int compareValues(Object value1, Object value2)
  {
    return durationDV.compareDates(((IntSequence)value1).getInts(), ((IntSequence)value2).getInts(), true);
  }
}
