/**
 * <copyright>
 *
 * Copyright (c) 2002-2003 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/ecore/MapBuilder.java, xsd, org.eclipse.111, 20031120_1149WL
 * @version 1.1 11/20/03
 */
package org.eclipse.xsd.ecore;


import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.xsd.XSDComponent;


public class MapBuilder
{
  public interface Mapper
  {
    EObject getRoot();

    void addInput(EObject eObject);

    void addOutput(EObject eObject);

    void map(Collection inputs, Collection outputs);
  }

  protected Mapper mapper;
  protected Map xsdComponentToEModelElementMap = new HashMap();

  public MapBuilder()
  {
  }

  public void setMapper(Mapper mapper)
  {
    this.mapper = mapper;
  }

  protected void map(XSDComponent xsdComponent, EModelElement eModelElement)
  {
    if (mapper != null)
    {
      mapper.map(Collections.singleton(xsdComponent), Collections.singleton(eModelElement));
    }

    xsdComponentToEModelElementMap.put(xsdComponent, eModelElement);
  }

  protected void addInput(EObject eObject)
  {
    if (mapper != null)
    {
      mapper.addInput(eObject);
    }
  }

  protected void addOutput(EObject eObject)
  {
    if (mapper != null)
    {
      mapper.addOutput(eObject);
    }
  }
}
