/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDDoubleType.java, xsd, org.eclipse.111, 20031120_1149WL
 * @version 1.3 11/20/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;


public class XSDDoubleType extends XSDAnySimpleType
{
  public boolean isValidLiteral(String literal)
  {
    try
    {
      Double value = new Double(literal);
      return true;
    }
    catch (RuntimeException exception)
    {
      return false;
    }
  }

  public Object getValue(String literal)
  {
    Double value = new Double(literal);
    return value;
  }

  public String getCanonicalLiteral(Object value)
  {
    return value.toString();
  }

  public int compareValues(Object value1, Object value2)
  {
    return ((Double)value1).compareTo(value2);
  }
}
