/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDHexBinaryType.java, xsd, org.eclipse.111, 20031120_1149WL
 * @version 1.4 11/20/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.apache.xerces.impl.dv.util.HexBin;


public class XSDHexBinaryType extends XSDAnySimpleType
{
  public boolean isValidLiteral(String literal)
  {
    try
    {
      return HexBin.decode(literal) != null;
    }
    catch (RuntimeException exception)
    {
      return false;
    }
  }

  public Object getValue(String literal)
  {
    return new ByteSequence(this, HexBin.decode(literal.getBytes()));
  }

  public String getCanonicalLiteral(Object value)
  {
    return new String(HexBin.encode(((ByteSequence)value).getBytes()));
  }
}
