/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd.edit/src/org/eclipse/xsd/provider/XSDAnnotationItemProvider.java, xsd.edit, org.eclipse.102, 20030326_0335VL
 * @version 1.2 3/26/03
 */
package org.eclipse.xsd.provider;


import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.xsd.XSDAnnotation;

import org.eclipse.xsd.XSDPackage;

import org.eclipse.xsd.provider.XSDEditPlugin;

import org.eclipse.xsd.util.XSDConstants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.w3c.dom.Element;


/**
 * This is the item provider adpater for a {@link org.eclipse.xsd.XSDAnnotation} object.
 */
public class XSDAnnotationItemProvider
  extends XSDComponentItemProvider
  implements 
    IEditingDomainItemProvider,
    IStructuredItemContentProvider, 
    ITreeItemContentProvider, 
    IItemLabelProvider, 
    IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   */
  public XSDAnnotationItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      XSDAnnotation xsdAnnotation = ((XSDAnnotation)object);

    }
    return itemPropertyDescriptors;
  }

  /**
   * This returns XSDAnnotation.gif.
   */
  public Object getImage(Object object)
  {
    return XSDEditPlugin.getImage("full/obj16/XSDAnnotation");
  }

  public String getText(Object object)
  {
    XSDAnnotation xsdAnnotation = ((XSDAnnotation)object);
    String result = "";
    List userInformation = xsdAnnotation.getUserInformation();
    if (!userInformation.isEmpty())
    {
      Element element = (Element)userInformation.get(0);
      if (element.hasAttribute(XSDConstants.SOURCE_ATTRIBUTE))
      {
        result = element.getAttribute(XSDConstants.SOURCE_ATTRIBUTE);
      }
      else
      {
        org.w3c.dom.Node text = element.getFirstChild(); 
        if (text != null)
        {
          result = text.getNodeValue();
          result = result.trim();
          if (result.length() > 50)
          {
            result = result.substring(0, 50) + XSDEditPlugin.getString("_UI_DotDotDot_label");
          }
        }
      }
    }

    return result;
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   */
  public void notifyChanged(Notification msg) 
  {
    super.notifyChanged(msg);
  }

}
