/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd.edit/src/org/eclipse/xsd/provider/XSDIdentityConstraintDefinitionItemProvider.java, xsd.edit, org.eclipse.102, 20030326_0335VL
 * @version 1.3 3/26/03
 */
package org.eclipse.xsd.provider;


import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.xsd.XSDIdentityConstraintCategory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDXPathDefinition;

import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDXPathVariety;

import org.eclipse.xsd.provider.XSDEditPlugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;


/**
 * This is the item provider adpater for a {@link org.eclipse.xsd.XSDIdentityConstraintDefinition} object.
 */
public class XSDIdentityConstraintDefinitionItemProvider
  extends XSDNamedComponentItemProvider
  implements 
    IEditingDomainItemProvider,
    IStructuredItemContentProvider, 
    ITreeItemContentProvider, 
    IItemLabelProvider, 
    IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   */
  public XSDIdentityConstraintDefinitionItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      XSDIdentityConstraintDefinition xsdIdentityConstraintDefinition = ((XSDIdentityConstraintDefinition)object);

      // This is for the identityConstraintCategory feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_IdentityConstraintCategory_label"),
           XSDEditPlugin.getString("_UI_IdentityConstraintCategory_description"),
           xsdPackage.getXSDIdentityConstraintDefinition_IdentityConstraintCategory(),
           true,
           ItemPropertyDescriptor.TEXT_VALUE_IMAGE));

/*
      // This is for the selector feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Selector_label"),
           XSDEditPlugin.getString("_UI_Selector_description"),
           xsdPackage.getXSDIdentityConstraintDefinition_Selector(),
           true,
           ItemPropertyDescriptor.TEXT_VALUE_IMAGE));
*/

      // This is for the referencedKey feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_ReferencedKey_label"),
           XSDEditPlugin.getString("_UI_ReferencedKey_description"),
           xsdPackage.getXSDIdentityConstraintDefinition_ReferencedKey(), 
           false));

      // This is for the annotation feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Annotation_label"),
           XSDEditPlugin.getString("_UI_AnnotationOfIdentityConstraint_description"),
           xsdPackage.getXSDIdentityConstraintDefinition_Annotation(), 
           false));

    }
    return itemPropertyDescriptors;
  }

  /**
   * This specifies how to implement {@link #getChildren} and {@link AddCommand} and {@link RemoveCommand} support in {@link #createCommand}.
   */
  public Collection getChildrenReferences(Object object)
  {
    if (childrenReferences == null)
    {
      super.getChildrenReferences(object);
      XSDIdentityConstraintDefinition xsdIdentityConstraintDefinition = ((XSDIdentityConstraintDefinition)object);
      childrenReferences.add(xsdPackage.getXSDIdentityConstraintDefinition_Annotation());
      childrenReferences.add(xsdPackage.getXSDIdentityConstraintDefinition_Selector());
      childrenReferences.add(xsdPackage.getXSDIdentityConstraintDefinition_Fields());
    }
    return childrenReferences;
  }

  /**
   * This returns XSDIdentityConstraintDefinition.gif.
   */
  public Object getImage(Object object)
  {
    XSDIdentityConstraintDefinition xsdIdentityConstraintDefinition = ((XSDIdentityConstraintDefinition)object);
    return 
      XSDEditPlugin.getImage
        (XSDIdentityConstraintCategory.KEY_LITERAL ==  xsdIdentityConstraintDefinition.getIdentityConstraintCategory() ?  
          "full/obj16/XSDIdentityConstraintDefinitionKey" :
          XSDIdentityConstraintCategory.KEYREF_LITERAL == xsdIdentityConstraintDefinition.getIdentityConstraintCategory() ?  
            "full/obj16/XSDIdentityConstraintDefinitionKeyReference" :
            "full/obj16/XSDIdentityConstraintDefinitionUnique");
  }

  public String getText(Object object)
  {
    XSDIdentityConstraintDefinition xsdIdentityConstraintDefinition = ((XSDIdentityConstraintDefinition)object);
    String result = xsdIdentityConstraintDefinition.getName();
    return result == null ? "" : result;
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   */
  public void notifyChanged(Notification msg) 
  {
    if (
         msg.getFeature() == xsdPackage.getXSDIdentityConstraintDefinition_IdentityConstraintCategory() || 
         msg.getFeature() == xsdPackage.getXSDIdentityConstraintDefinition_Selector() || 
         msg.getFeature() == xsdPackage.getXSDIdentityConstraintDefinition_Fields() || 
         msg.getFeature() == xsdPackage.getXSDIdentityConstraintDefinition_ReferencedKey() || 
         msg.getFeature() == xsdPackage.getXSDIdentityConstraintDefinition_Annotation()
       )
    {
      fireNotifyChanged(msg);
      return;
    }
    super.notifyChanged(msg);
  }

  /**
   * This adds to the collection of {@link CommandParameter}s describing all
   * of the children that can be created under this object.
   */
  protected void collectNewChildDescriptors(Collection newChildDescriptors,
                                            Object object)
  {
    super.collectNewChildDescriptors(newChildDescriptors, object);
    XSDIdentityConstraintDefinition icd = 
      (XSDIdentityConstraintDefinition) object;

    // annotation
    newChildDescriptors.add(createChildParameter(xsdPackage.getXSDIdentityConstraintDefinition_Annotation(), xsdFactory.createXSDAnnotation()));

    // selector xpath
    XSDXPathDefinition xpd = xsdFactory.createXSDXPathDefinition();
    xpd.setVariety(XSDXPathVariety.SELECTOR_LITERAL);
    xpd.setValue("");
    newChildDescriptors.add(createChildParameter(xsdPackage.getXSDIdentityConstraintDefinition_Selector(), xpd));

    // field xpath
    xpd = xsdFactory.createXSDXPathDefinition();
    xpd.setVariety(XSDXPathVariety.FIELD_LITERAL);
    xpd.setValue("");
    newChildDescriptors.add(createChildParameter(xsdPackage.getXSDIdentityConstraintDefinition_Fields(), xpd));
  }
}
