/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd.edit/src/org/eclipse/xsd/provider/XSDModelGroupItemProvider.java, xsd.edit, org.eclipse.102, 20030326_0335VL
 * @version 1.3 3/26/03
 */
package org.eclipse.xsd.provider;


import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;

import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDCompositor;

import org.eclipse.xsd.provider.XSDEditPlugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;


/**
 * This is the item provider adpater for a {@link org.eclipse.xsd.XSDModelGroup} object.
 */
public class XSDModelGroupItemProvider
  extends XSDTermItemProvider
  implements 
    IEditingDomainItemProvider,
    IStructuredItemContentProvider, 
    ITreeItemContentProvider, 
    IItemLabelProvider, 
    IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   */
  public XSDModelGroupItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      XSDModelGroup xsdModelGroup = ((XSDModelGroup)object);

      // This is for the compositor feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Compositor_label"),
           XSDEditPlugin.getString("_UI_Compositor_description"),
           xsdPackage.getXSDModelGroup_Compositor(),
           true,
           ItemPropertyDescriptor.TEXT_VALUE_IMAGE));

      // This is for the annotation feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Annotation_label"),
           XSDEditPlugin.getString("_UI_AnnotationOfModelGroup_description"),
           xsdPackage.getXSDModelGroup_Annotation(), 
           false));

    }
    return itemPropertyDescriptors;
  }

  /**
   * This specifies how to implement {@link #getChildren} and {@link AddCommand} and {@link RemoveCommand} support in {@link #createCommand}.
   */
  public Collection getChildrenReferences(Object object)
  {
    if (childrenReferences == null)
    {
      super.getChildrenReferences(object);
      XSDModelGroup xsdModelGroup = ((XSDModelGroup)object);
      childrenReferences.add(xsdPackage.getXSDModelGroup_Annotation());
      childrenReferences.add(xsdPackage.getXSDModelGroup_Contents());
    }
    return childrenReferences;
  }

  /**
   * This returns XSDModelGroup.gif.
   */
  public Object getImage(Object object)
  {
    XSDModelGroup xsdModelGroup = ((XSDModelGroup)object);
    if (XSDCompositor.CHOICE_LITERAL == xsdModelGroup.getCompositor())
    {
      return XSDEditPlugin.getImage("full/obj16/XSDModelGroupChoice");
    }
    else if (XSDCompositor.ALL_LITERAL == xsdModelGroup.getCompositor())
    {
      return XSDEditPlugin.getImage("full/obj16/XSDModelGroupAll");
    }
    else 
    {
      return XSDEditPlugin.getImage("full/obj16/XSDModelGroupSequence");
    }
  }

  public String getText(Object object)
  {
    XSDModelGroup xsdModelGroup = ((XSDModelGroup)object);
    return xsdModelGroup.getCompositor().getName();
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   */
  public void notifyChanged(Notification msg) 
  {
    XSDModelGroup xsdModelGroup = (XSDModelGroup)msg.getNotifier();
    if (msg.getFeature() == xsdPackage.getXSDModelGroup_Compositor() || 
          msg.getFeature() == xsdPackage.getXSDModelGroup_Contents() || 
          msg.getFeature() == xsdPackage.getXSDModelGroup_Annotation())
    {
      fireNotifyChanged(msg);

      XSDConcreteComponent container = xsdModelGroup.getContainer();
      if (container instanceof XSDParticle)
      {
        ((ItemProviderAdapter)adapterFactory.adapt(container, IItemLabelProvider.class)).fireNotifyChanged
          (new ENotificationImpl
            ((InternalEObject)container, 
             msg.getEventType(), 
             (EStructuralFeature)msg.getFeature(), 
             msg.getOldValue(), 
             msg.getNewValue(), 
             msg.getPosition()));
      }
      return;
    }
    super.notifyChanged(msg);
  }

  /**
   * This adds to the collection of {@link CommandParameter}s describing all
   * of the children that can be created under this object.
   */
  protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object)
  {
    super.collectNewChildDescriptors(newChildDescriptors, object);
    XSDModelGroup mg = (XSDModelGroup) object;

    // annotation
    newChildDescriptors.add(createChildParameter(xsdPackage.getXSDModelGroup_Annotation(), xsdFactory.createXSDAnnotation()));

    // element declaration under particle
    XSDElementDeclaration ed = createElementDeclaration(mg);
    newChildDescriptors.add(createChildParameter(xsdPackage.getXSDModelGroup_Contents(), createParticle(ed, false)));

    // element declaration reference under particle
    newChildDescriptors.add(createChildParameter(xsdPackage.getXSDModelGroup_Contents(), createParticle(mg.resolveElementDeclaration(""), true)));

    // for choice and sequence model groups only...
    if (mg.getCompositor() != XSDCompositor.ALL_LITERAL)
    {
      // choice and sequence model groups under particles
      addModelGroupChildParameters(newChildDescriptors, xsdPackage.getXSDModelGroup_Contents(), false, true);

      // model group definition reference under particle
      newChildDescriptors.add(createChildParameter(xsdPackage.getXSDModelGroup_Contents(), createParticle(mg.resolveModelGroupDefinition(""), true)));

      // element wildcard under particle
      newChildDescriptors.add(createChildParameter(xsdPackage.getXSDModelGroup_Contents(), createParticle(xsdFactory.createXSDWildcard(), false)));
    }
  }
}
