/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/XSDComplexTypeContentImpl.java, xsd, org.eclipse.102, 20030326_0335VL
 * @version 1.14 3/26/03
 */
package org.eclipse.xsd.impl;


import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.NotificationChainImpl;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.xsd.*;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;

import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Complex Type Content</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * </p>
 *
 * @generated
 */
public abstract class XSDComplexTypeContentImpl 
  extends XSDComponentImpl 
  implements XSDComplexTypeContent
{
  protected XSDComplexTypeContentImpl() 
  {
    super();
  }
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass()
  {
    return XSDPackage.eINSTANCE.getXSDComplexTypeContent();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (baseClass == null ? featureID : eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__DIAGNOSTICS:
          return ((InternalEList)getDiagnostics()).basicRemove(otherEnd, msgs);
        default:
          return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
      }
    }
    return eBasicSetContainer(null, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__ELEMENT:
        return getElement();
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__CONTAINER:
        return getContainer();
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__ROOT_CONTAINER:
        return getRootContainer();
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__SCHEMA:
        return getSchema();
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__DIAGNOSTICS:
        return getDiagnostics();
    }
    return eDynamicGet(eFeature, resolve);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(EStructuralFeature eFeature, Object newValue)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__ELEMENT:
        setElement((Element)newValue);
        return;
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__DIAGNOSTICS:
        getDiagnostics().clear();
        getDiagnostics().addAll((Collection)newValue);
        return;
    }
    eDynamicSet(eFeature, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__ELEMENT:
        setElement(ELEMENT_EDEFAULT);
        return;
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__DIAGNOSTICS:
        getDiagnostics().clear();
        return;
    }
    eDynamicUnset(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__ELEMENT:
        return ELEMENT_EDEFAULT == null ? getElement() != null : !ELEMENT_EDEFAULT.equals(getElement());
      case XSDPackage.XSD_COMPLEX_TYPE_CONTENT__DIAGNOSTICS:
        return diagnostics != null && !getDiagnostics().isEmpty();
    }
    return eDynamicIsSet(eFeature);
  }

} 
