/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDDateType.java, xsd, org.eclipse.102, 20030326_0335VL
 * @version 1.4 3/26/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.DateDV;



public class XSDDateType extends XSDAnySimpleType
{
  public static class AccessibleDateDV extends DateDV
  {
    public String dateToString(int[] date)
    {
      return super.dateToString(date);
    }

    public short compareDates(int[] date1, int[] date2, boolean strict) 
    {
      return super.compareDates(date1, date2, strict);
    }
  }

  protected static final AccessibleDateDV dateDV = new AccessibleDateDV();

  public boolean isValidLiteral(String normalizedLiteral)
  {
    try
    {
      dateDV.getActualValue(normalizedLiteral, null);
      return true;
    }
    catch (InvalidDatatypeValueException exception)
    {
      return false;
    }
  }

  public Object getValue(String normalizedLiteral)
  {
    try
    {
      return dateDV.getActualValue(normalizedLiteral, null);
    }
    catch (InvalidDatatypeValueException exception)
    {
      return null;
    }
  }

  public String getCanonicalLiteral(Object value)
  {
    return value == null ? null : dateDV.dateToString((int[]) value);
  }

  public int compareValues(Object value1, Object value2)
  {
    return dateDV.compareDates((int []) value1, (int [])value2, true);
  }
}
