/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd.edit/src/org/eclipse/xsd/provider/XSDDiagnosticItemProvider.java, xsd.edit, org.eclipse.dev, 20030620_1105VL
 * @version 1.2 6/20/03
 */
package org.eclipse.xsd.provider;


import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;


import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDPackage;

import org.eclipse.xsd.provider.XSDEditPlugin;


/**
 * This is the item provider adpater for a {@link org.eclipse.xsd.XSDDiagnostic} object.
 */
public class XSDDiagnosticItemProvider
  extends XSDItemProviderAdapter
  implements 
    IEditingDomainItemProvider,
    IStructuredItemContentProvider, 
    ITreeItemContentProvider, 
    IItemLabelProvider, 
    IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   */
  public XSDDiagnosticItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      XSDDiagnostic f_xsdDiagnostic = ((XSDDiagnostic)object);

      // This is for the severity feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Severity_label"),
           XSDEditPlugin.getString("_UI_Severity_description"),
           xsdPackage.getXSDDiagnostic_Severity(),
       true,
       ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

      // This is for the message feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Message_label"),
           XSDEditPlugin.getString("_UI_Message_description"),
           xsdPackage.getXSDDiagnostic_Message(),
       true,
       ItemPropertyDescriptor.TEXT_VALUE_IMAGE));

      // This is for the locationURI feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_LocationURI_label"),
           XSDEditPlugin.getString("_UI_LocationURI_description"),
           xsdPackage.getXSDDiagnostic_LocationURI(),
       true,
       ItemPropertyDescriptor.TEXT_VALUE_IMAGE));

      // This is for the line feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Line_label"),
           XSDEditPlugin.getString("_UI_Line_description"),
           xsdPackage.getXSDDiagnostic_Line(),
       true,
       ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE));

      // This is for the column feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Column_label"),
           XSDEditPlugin.getString("_UI_Column_description"),
           xsdPackage.getXSDDiagnostic_Column(),
       true,
       ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE));

      // This is for the node feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Node_label"),
           XSDEditPlugin.getString("_UI_Node_description"),
           xsdPackage.getXSDDiagnostic_Node(),
       true,
       ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

      // This is for the annotationURI feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_AnnotationURI_label"),
           XSDEditPlugin.getString("_UI_AnnotationURI_description"),
           xsdPackage.getXSDDiagnostic_AnnotationURI(),
       true,
       ItemPropertyDescriptor.TEXT_VALUE_IMAGE));

    }
    return itemPropertyDescriptors;
  }

  /**
   * This returns XSDDiagnostic.gif.
   */
  public Object getImage(Object object)
  {
    return XSDEditPlugin.getImage("full/obj16/XSDDiagnostic");
  }

  public String getText(Object object)
  {
    XSDDiagnostic xsdDiagnostic = ((XSDDiagnostic)object);
    return xsdDiagnostic.getMessage();
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   */
  public void notifyChanged(Notification msg) 
  {
    if (msg.getFeature() == xsdPackage.getXSDDiagnostic_Severity() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_Message() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_LocationURI() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_Line() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_Column() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_Node() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_AnnotationURI() || 
         msg.getFeature() == xsdPackage.getXSDDiagnostic_Components())
    {
      fireNotifyChanged(msg);
    }
    else
    {
      super.notifyChanged(msg);
    }
  }
}
