/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDAnyURIType.java, xsd, org.eclipse.111, 20031020_1612WL
 * @version 1.2 10/20/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;

import org.apache.xerces.util.URI;



public class XSDAnyURIType extends XSDAnySimpleType
{
  static protected URI DUMMY_URI;

  {
    try
    {
      DUMMY_URI = new URI("http://www.dummy.com");
    }
    catch (URI.MalformedURIException exception)
    {
    }
  }

  public boolean isValidLiteral(String normalizedLiteral)
  {
    try
    {
      URI absoluteURI = new URI(normalizedLiteral);
      return true;
    }
    catch (URI.MalformedURIException exception)
    {
      try
      {
        URI relativeURI = new URI(DUMMY_URI, normalizedLiteral);
        return true;
      }
      catch (URI.MalformedURIException anotherException)
      {
      }
    }
    return false;
  }
}
