/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/impl/type/XSDBase64BinaryType.java, xsd, org.eclipse.111, 20031020_1612WL
 * @version 1.4 10/20/03
 */
package org.eclipse.xsd.impl.type;


import org.eclipse.xsd.XSDPlugin;

import org.apache.xerces.impl.dv.util.Base64;


public class XSDBase64BinaryType extends XSDAnySimpleType
{
  public boolean isValidLiteral(String literal)
  {
    try
    {
      return Base64.decode(literal) != null;
    }
    catch (RuntimeException exception)
    {
      return false;
    }
  }

  public Object getValue(String literal)
  {
    return new ByteSequence(this, Base64.decode(literal.getBytes()));
  }

  public String getCanonicalLiteral(Object value)
  {
    return new String(Base64.encode(((ByteSequence)value).getBytes()));
  }
}
