/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd.edit/src/org/eclipse/xsd/provider/XSDAttributeGroupDefinitionItemProvider.java, xsd.edit, org.eclipse.111, 20031020_1612WL
 * @version 1.2 10/20/03
 */
package org.eclipse.xsd.provider;


import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;

import org.eclipse.xsd.XSDPackage;

import org.eclipse.xsd.provider.XSDEditPlugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;


/**
 * This is the item provider adpater for a {@link org.eclipse.xsd.XSDAttributeGroupDefinition} object.
 */
public class XSDAttributeGroupDefinitionItemProvider
  extends XSDRedefinableComponentItemProvider
  implements 
    IEditingDomainItemProvider,
    IStructuredItemContentProvider, 
    ITreeItemContentProvider, 
    IItemLabelProvider, 
    IItemPropertySource
{
  /**
   * This constructs an instance from a factory and a notifier.
   */
  public XSDAttributeGroupDefinitionItemProvider(AdapterFactory adapterFactory)
  {
    super(adapterFactory);
  }

  /**
   * This returns the property descriptors for the adapted class.
   */
  public List getPropertyDescriptors(Object object)
  {
    if (itemPropertyDescriptors == null)
    {
      super.getPropertyDescriptors(object);

      XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)object);

      // This is for the attributeWildcard feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_AttributeWildcard_label"),
           XSDEditPlugin.getString("_UI_AttributeWildcardOfAttributeGroup_description"),
           xsdPackage.getXSDAttributeGroupDefinition_AttributeWildcardContent(), 
           false));

      // This is for the annotation feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_Annotation_label"),
           XSDEditPlugin.getString("_UI_AnnotationOfAttributeGroup_description"),
           xsdPackage.getXSDAttributeGroupDefinition_Annotation(), 
           false));

      // This is for the resolvedAttributeGroupDefinition feature.
      //
      itemPropertyDescriptors.add
        (new ItemPropertyDescriptor
          (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
           XSDEditPlugin.getString("_UI_ResolvedAttributeGroupDefinition_label"),
           XSDEditPlugin.getString("_UI_ResolvedAttributeGroupDefinition_description"),
           xsdPackage.getXSDAttributeGroupDefinition_ResolvedAttributeGroupDefinition(), 
           false));
    }
    return itemPropertyDescriptors;
  }

  /**
   * This specifies how to implement {@link #getChildren} and {@link AddCommand} and {@link RemoveCommand} support in {@link #createCommand}.
   */
  public Collection getChildrenReferences(Object object)
  {
    if (childrenReferences == null)
    {
      super.getChildrenReferences(object);
      XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)object);
      childrenReferences.add(xsdPackage.getXSDAttributeGroupDefinition_Annotation());
      childrenReferences.add(xsdPackage.getXSDAttributeGroupDefinition_Contents());
      childrenReferences.add(xsdPackage.getXSDAttributeGroupDefinition_AttributeWildcardContent());
    }
    return childrenReferences;
  }

  protected EReference getChildReference(Object object, Object child)
  {
    XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)object);
    EObject refObject = (EObject)child;
    if (refObject instanceof XSDAttributeDeclaration)
    {
      // TODO: check that this is what you want.
      return xsdPackage.getXSDAttributeGroupDefinition_Contents();
    }
    return super.getChildReference(object, child);
  }

  /**
   * This returns XSDAttributeGroupDefinition.gif.
   */
  public Object getImage(Object object)
  {
    XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)object);
    XSDAttributeGroupDefinition resolvedAttributeGroupDefinition = xsdAttributeGroupDefinition.getResolvedAttributeGroupDefinition();
    return 
      XSDEditPlugin.getImage
        (resolvedAttributeGroupDefinition.getContainer() == null ?
          "full/obj16/XSDAttributeGroupUnresolved" :
          xsdAttributeGroupDefinition.getResolvedAttributeGroupDefinition() == xsdAttributeGroupDefinition ?
            "full/obj16/XSDAttributeGroupDefinition" :
            "full/obj16/XSDAttributeGroupUse");
  }

  public String getText(Object object)
  {
    XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)object);
    String result =  
      xsdAttributeGroupDefinition.isAttributeGroupDefinitionReference() ?
        xsdAttributeGroupDefinition.getQName() :
        xsdAttributeGroupDefinition.getName();
    return result == null ? XSDEditPlugin.getString("_UI_Absent_label") : result;
  }

  /**
   * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
   */
  public void notifyChanged(Notification msg) 
  {
    if (
         msg.getFeature() == xsdPackage.getXSDAttributeGroupDefinition_Contents() || 
         msg.getFeature() == xsdPackage.getXSDAttributeGroupDefinition_AttributeUses() || 
         msg.getFeature() == xsdPackage.getXSDAttributeGroupDefinition_AttributeWildcardContent() || 
         msg.getFeature() == xsdPackage.getXSDAttributeGroupDefinition_Annotation()
       )
    {
      fireNotifyChanged(msg);
      return;
    }
    super.notifyChanged(msg);
  }

  /**
   * This adds to the collection of {@link CommandParameter}s describing all
   * of the children that can be created under this object.
   */
  protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object)
  {
    super.collectNewChildDescriptors(newChildDescriptors, object);
    XSDAttributeGroupDefinition xsdAttributeGroupDefinition = (XSDAttributeGroupDefinition) object;

    if (!xsdAttributeGroupDefinition.isAttributeGroupDefinitionReference())
    {
      // annotation
      //
      newChildDescriptors.add
        (createChildParameter
          (xsdPackage.getXSDAttributeGroupDefinition_Annotation(), 
           xsdFactory.createXSDAnnotation()));

      // attribute declaration under attribute use
      //
      XSDAttributeDeclaration xsdAttributeDeclaration = createAttributeDeclaration(xsdAttributeGroupDefinition);
      newChildDescriptors.add
        (createChildParameter
          (xsdPackage.getXSDAttributeGroupDefinition_Contents(), 
           createAttributeUse(xsdAttributeDeclaration, false)));

      // attribute declaration reference under attribute use
      //
      newChildDescriptors.add
        (createChildParameter
          (xsdPackage.getXSDAttributeGroupDefinition_Contents(), 
           createAttributeUse(xsdAttributeGroupDefinition.resolveAttributeDeclaration(""), true)));

      // attribute group definition reference
      //
      newChildDescriptors.add
        (createChildParameter
          (xsdPackage.getXSDAttributeGroupDefinition_Contents(), 
          createAttributeGroupDefinitionReference(xsdAttributeGroupDefinition.resolveAttributeGroupDefinition(""))));

      // attribute wildcard
      //
      newChildDescriptors.add
        (createChildParameter
          (xsdPackage.getXSDAttributeGroupDefinition_AttributeWildcardContent(), 
           xsdFactory.createXSDWildcard()));
    }
  }
}
