/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.xsd/src/org/eclipse/xsd/XSDNotationDeclaration.java, xsd, org.eclipse.111, 20031120_1149WL
 * @version 1.5 11/20/03
 */
package org.eclipse.xsd;


import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object 
 * '<a href="http://www.w3.org/TR/xmlschema-1/#cNotation_Declarations"><em><b>Notation Declaration</b></em></a>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.xsd.XSDNotationDeclaration#getSystemIdentifier <em>System Identifier</em>}</li>
 *   <li>{@link org.eclipse.xsd.XSDNotationDeclaration#getPublicIdentifier <em>Public Identifier</em>}</li>
 *   <li>{@link org.eclipse.xsd.XSDNotationDeclaration#getAnnotation <em>Annotation</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.xsd.XSDPackage#getXSDNotationDeclaration()
 * @model 
 * @generated
 */
public interface XSDNotationDeclaration extends XSDNamedComponent, XSDSchemaContent {
  /**
   * Returns the value of the '<em><b>System Identifier</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * This represents the
   * <a href="http://www.w3.org/TR/xmlschema-1/#system_identifier">system identifier</a>
   * infoset property.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>System Identifier</em>' attribute.
   * @see #setSystemIdentifier(String)
   * @see org.eclipse.xsd.XSDPackage#getXSDNotationDeclaration_SystemIdentifier()
   * @model 
   * @generated
   */
  String getSystemIdentifier();

  /**
   * Sets the value of the '{@link org.eclipse.xsd.XSDNotationDeclaration#getSystemIdentifier <em>System Identifier</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>System Identifier</em>' attribute.
   * @see #getSystemIdentifier()
   * @generated
   */
  void setSystemIdentifier(String value);

  /**
   * Returns the value of the '<em><b>Public Identifier</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * This represents the
   * <a href="http://www.w3.org/TR/xmlschema-1/#public_identifier">public identifier</a>
   * infoset property.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Public Identifier</em>' attribute.
   * @see #setPublicIdentifier(String)
   * @see org.eclipse.xsd.XSDPackage#getXSDNotationDeclaration_PublicIdentifier()
   * @model 
   * @generated
   */
  String getPublicIdentifier();

  /**
   * Sets the value of the '{@link org.eclipse.xsd.XSDNotationDeclaration#getPublicIdentifier <em>Public Identifier</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Public Identifier</em>' attribute.
   * @see #getPublicIdentifier()
   * @generated
   */
  void setPublicIdentifier(String value);

  /**
   * Returns the value of the '<em><b>Annotation</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <p>
   * This represents the
   * <a href="http://www.w3.org/TR/xmlschema-1/#n-annotation">annotation</a>
   * infoset property.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Annotation</em>' containment reference.
   * @see #setAnnotation(XSDAnnotation)
   * @see org.eclipse.xsd.XSDPackage#getXSDNotationDeclaration_Annotation()
   * @model containment="true"
   * @generated
   */
  XSDAnnotation getAnnotation();

  /**
   * Sets the value of the '{@link org.eclipse.xsd.XSDNotationDeclaration#getAnnotation <em>Annotation</em>}' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Annotation</em>' containment reference.
   * @see #getAnnotation()
   * @generated
   */
  void setAnnotation(XSDAnnotation value);

} 
