/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.presentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXWrapper;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.presentation.XSDEditor;
import org.eclipse.xsd.presentation.XSDEditorPlugin;
import org.eclipse.xsd.provider.XSDItemProviderAdapterFactory;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class XSDEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener {
    protected XSDSchema xsdSchema;
    protected AdapterFactoryEditingDomain editingDomain;
    protected XSDItemProviderAdapterFactory syntacticAdapterFactory;
    protected XSDItemProviderAdapterFactory semanticAdapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TextEditor textEditor;
    protected ISourceViewer sourceViewer;
    protected TreeViewer syntacticSelectionViewer;
    protected TreeViewer semanticSelectionViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection editorSelection;
    protected SelectDiagnosticAction selectNextDiagnosticsAction;
    protected SelectDiagnosticAction selectPreviousDiagnosticsAction;
    protected SelectUseAction selectNextUseAction;
    protected SelectUseAction selectPreviousUseAction;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            XSDEditor.this.handlePartActivated(p);
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected boolean handledStructuredModelChange = false;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;

    public XSDEditor() {
        this.syntacticAdapterFactory = new XSDItemProviderAdapterFactory();
        this.semanticAdapterFactory = new XSDSemanticItemProviderAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                XSDEditor.super.getContainer().getDisplay().asyncExec(new Runnable(this, event){
                    private final /* synthetic */ EventObject val$event;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        2.access$000(this.this$1).firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)this.val$event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            2.access$000(this.this$1).setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        2.access$000(this.this$1).handleStructuredModelChange();
                        2.access$000(this.this$1).updateActions();
                    }
                });
            }

            static /* synthetic */ XSDEditor access$000(2 x0) {
                return x0.XSDEditor.this;
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.syntacticAdapterFactory, (CommandStack)commandStack);
        this.editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    protected void updateActions() {
        if (this.selectNextDiagnosticsAction != null) {
            this.selectNextDiagnosticsAction.updateAction();
            this.selectPreviousDiagnosticsAction.updateAction();
            this.selectNextUseAction.updateAction();
            this.selectPreviousUseAction.updateAction();
        }
    }

    protected void handleStructuredModelChange() {
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        if (this.xsdSchema.getElement() == null) {
            this.xsdSchema.updateElement();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XSDResourceImpl.serialize((OutputStream)out, (Element)this.xsdSchema.getElement());
        try {
            String encoding = null;
            String newContent = encoding == null ? out.toString() : out.toString(encoding);
            String oldContent = document.get();
            int startIndex = 0;
            while (startIndex < newContent.length() && startIndex < oldContent.length() && newContent.charAt(startIndex) == oldContent.charAt(startIndex)) {
                ++startIndex;
            }
            int newEndIndex = newContent.length() - 1;
            int oldEndIndex = oldContent.length() - 1;
            while (newEndIndex >= startIndex && oldEndIndex >= startIndex && newContent.charAt(newEndIndex) == oldContent.charAt(oldEndIndex)) {
                --newEndIndex;
                --oldEndIndex;
            }
            String replacement = newContent.substring(startIndex, newEndIndex + 1);
            int length = oldEndIndex - startIndex + 1;
            this.handledStructuredModelChange = true;
            document.replace(startIndex, length, replacement);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void handlePartActivated(IWorkbenchPart workbenchPart) {
        if (workbenchPart == this) {
            if (this.getActivePage() == 0) {
                this.setCurrentViewer((Viewer)this.sourceViewer);
            }
        } else if (workbenchPart instanceof ContentOutline) {
            if (((ContentOutline)workbenchPart).getCurrentPage() == this.contentOutlinePage) {
                this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
                this.setCurrentViewer((Viewer)this.contentOutlineViewer);
            }
        } else if (workbenchPart instanceof PropertySheet && ((PropertySheet)workbenchPart).getCurrentPage() == this.propertySheetPage) {
            this.getActionBarContributor().setActiveEditor((IEditorPart)this);
        }
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(final Collection collection) {
        if (collection != null && !collection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (XSDEditor.this.currentViewer != null) {
                        XSDEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(collection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        if (this.currentViewerPane != null) {
            this.setCurrentViewer(this.currentViewerPane.getViewer());
        }
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        XSDEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createPages() {
        this.createSourcePage();
        this.createSemanticsPage();
        this.createSyntaxPage();
        this.setActivePage(0);
        this.setCurrentViewer((Viewer)this.sourceViewer);
    }

    protected void createResource(String uri) {
        this.extendedCreateResource(uri);
    }

    protected void standardCreateResource(String uri) {
        XSDResourceImpl xsdResource = (XSDResourceImpl)this.editingDomain.loadResource(uri);
        this.xsdSchema = xsdResource.getSchema();
    }

    protected void extendedCreateResource(String uri) {
        this.editingDomain.getResourceSet().getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        try {
            XSDResourceImpl xsdResource = (XSDResourceImpl)this.editingDomain.getResourceSet().getResource(URI.createDeviceURI((String)uri), true);
            this.xsdSchema = xsdResource.getSchema();
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void createModel() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                try {
                    progressMonitor.beginTask("", 10);
                    IFileEditorInput modelFile = (IFileEditorInput)XSDEditor.this.getEditorInput();
                    IFile file = modelFile.getFile();
                    XSDEditor.this.editingDomain.getResourceSet().getLoadOptions().put(XSDResourceImpl.XSD_PROGRESS_MONITOR, progressMonitor);
                    XSDEditor.this.createResource("platform:/resource" + file.getFullPath());
                    XSDEditor.this.editingDomain.getResourceSet().getLoadOptions().remove(XSDResourceImpl.XSD_PROGRESS_MONITOR);
                    progressMonitor.worked(1);
                    progressMonitor.subTask(XSDEditorPlugin.INSTANCE.getString("_UI_Validating_message"));
                    if (XSDEditor.this.xsdSchema.getDiagnostics().isEmpty()) {
                        XSDEditor.this.xsdSchema.validate();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(XSDEditorPlugin.INSTANCE.getString("_UI_ReportingErrors_message"));
                    XSDEditor.this.handleDiagnostics(progressMonitor);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    progressMonitor.done();
                    throw throwable;
                }
                progressMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void handleSourceCaretPosition() {
        int offset = this.sourceViewer.getTextWidget().getCaretOffset();
        Element element = this.xsdSchema.getElement();
        if (element != null) {
            IDocument document = this.sourceViewer.getDocument();
            int line = 0;
            int lineOffset = 0;
            try {
                line = document.getLineOfOffset(offset);
                lineOffset = document.getLineOffset(line);
            }
            catch (BadLocationException exception) {
                // empty catch block
            }
            int column = offset - lineOffset;
            Element bestElement = this.findBestElement(element, line + 1, column + 1);
            if (bestElement != null) {
                this.handleSelectedNodes(Collections.singleton(bestElement));
            }
        }
    }

    public Element findBestElement(Element element, int line, int column) {
        int startLine = XSDParser.getStartLine((Node)element);
        int startColumn = XSDParser.getStartColumn((Node)element);
        int endLine = XSDParser.getEndLine((Node)element);
        int endColumn = XSDParser.getEndColumn((Node)element);
        Element candidate = null;
        boolean bl = line == startLine ? column >= startColumn : line > startLine;
        if (bl) {
            boolean bl2 = line == endLine ? column <= endColumn : line < endLine;
            if (bl2) {
                candidate = element;
                Node child = element.getFirstChild();
                while (child != null) {
                    Element childElement;
                    Element betterCandidate;
                    if (child.getNodeType() == 1 && (betterCandidate = this.findBestElement(childElement = (Element)child, line, column)) != null) {
                        candidate = betterCandidate;
                        break;
                    }
                    child = child.getNextSibling();
                }
            }
        }
        return candidate;
    }

    public void handleSelectedNodes(Collection nodes) {
        ArrayList<XSDConcreteComponent> selection = new ArrayList<XSDConcreteComponent>();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            HashSet parents = new HashSet();
            XSDConcreteComponent bestXSDConcreteComponent = this.xsdSchema.getCorrespondingComponent(node);
            if (bestXSDConcreteComponent == null) continue;
            boolean add = true;
            XSDConcreteComponent parent = bestXSDConcreteComponent;
            while (parent != null) {
                if (selection.contains(parent)) {
                    add = false;
                    break;
                }
                parent = parent.getContainer();
            }
            if (!add) continue;
            XSDConcreteComponent container = bestXSDConcreteComponent.getContainer();
            if (container instanceof XSDParticle || container instanceof XSDAttributeUse) {
                bestXSDConcreteComponent = container;
            }
            selection.add(bestXSDConcreteComponent);
        }
        if (!selection.isEmpty()) {
            StructuredSelection newSelection = new StructuredSelection(selection.toArray());
            if (this.contentOutlineViewer != null) {
                this.contentOutlineViewer.setSelection((ISelection)newSelection, true);
            }
            this.setSelection((ISelection)newSelection);
            this.handleContentOutlineSelectionForTextEditor((ISelection)newSelection, false);
        }
    }

    protected void handleDocumentChange() {
        try {
            XSDParser xsdParser = new XSDParser();
            String documentContent = this.sourceViewer.getDocument().get();
            Document domDocument = this.xsdSchema.getElement().getOwnerDocument();
            byte[] bytes = documentContent.getBytes();
            xsdParser.parse((InputStream)new ByteArrayInputStream(bytes));
            xsdParser.setSchema(this.xsdSchema);
            this.xsdSchema.validate();
            this.handleDiagnostics(null);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void createSourcePage() {
        try {
            this.textEditor = new TextEditor(){

                public ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
                    ISourceViewer result = super.createSourceViewer(parent, ruler, styles);
                    result.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void mouseDown(MouseEvent event) {
                            7.access$200(this.this$1).handleSourceCaretPosition();
                        }
                    });
                    result.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void keyPressed(KeyEvent event) {
                            switch (event.keyCode) {
                                case 0x1000001: 
                                case 0x1000002: 
                                case 0x1000003: 
                                case 0x1000004: 
                                case 0x1000005: 
                                case 0x1000006: {
                                    7.access$200(this.this$1).handleSourceCaretPosition();
                                }
                            }
                        }
                    });
                    XSDEditor.this.sourceViewer = result;
                    return result;
                }

                static /* synthetic */ XSDEditor access$200(7 x0) {
                    return x0.XSDEditor.this;
                }
            };
            IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
            int pageIndex = this.addPage((IEditorPart)this.textEditor, (IEditorInput)modelFile);
            this.setPageText(pageIndex, "Source");
            this.createModel();
            IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
            document.addDocumentListener(new IDocumentListener(){
                protected Timer timer = new Timer();
                protected TimerTask timerTask;

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    try {
                        if (this.timerTask != null) {
                            this.timerTask.cancel();
                        }
                        if (XSDEditor.this.handledStructuredModelChange) {
                            XSDEditor.this.handledStructuredModelChange = false;
                            XSDEditor.this.handleDocumentChange();
                        } else {
                            this.timerTask = new TimerTask(this){
                                private final /* synthetic */ 10 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    10.access$400(this.this$1).getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                                        private final /* synthetic */ 11 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        public void run() {
                                            10.access$400(11.access$300(this.this$2)).handleDocumentChange();
                                        }
                                    });
                                }

                                static /* synthetic */ 10 access$300(11 x0) {
                                    return x0.this$1;
                                }
                            };
                            this.timer.schedule(this.timerTask, 1000L);
                        }
                    }
                    catch (Exception exception) {
                        XSDEditorPlugin.INSTANCE.log(exception);
                    }
                }

                static /* synthetic */ XSDEditor access$400(10 x0) {
                    return x0.XSDEditor.this;
                }
            });
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void createSemanticsPage() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                XSDEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.semanticSelectionViewer = (TreeViewer)viewerPane.getViewer();
        this.semanticSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.semanticAdapterFactory));
        this.semanticSelectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.semanticAdapterFactory));
        this.semanticSelectionViewer.setAutoExpandLevel(2);
        this.semanticSelectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (XSDEditor.this.currentViewer == XSDEditor.this.semanticSelectionViewer && XSDEditor.this.contentOutlineViewer != null) {
                    XSDEditor.this.contentOutlineViewer.setSelection(selectionChangedEvent.getSelection(), true);
                }
            }
        });
        this.semanticSelectionViewer.setInput((Object)new ItemProvider(Collections.singleton(this.xsdSchema)));
        viewerPane.setTitle((Object)this.xsdSchema);
        new AdapterFactoryTreeEditor(this.semanticSelectionViewer.getTree(), (AdapterFactory)this.semanticAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.semanticSelectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, XSDEditorPlugin.INSTANCE.getString("_UI_Semantics_title"));
    }

    protected void createSyntaxPage() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                XSDEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.syntacticSelectionViewer = (TreeViewer)viewerPane.getViewer();
        this.syntacticSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.syntacticAdapterFactory));
        this.syntacticSelectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.syntacticAdapterFactory));
        this.syntacticSelectionViewer.setAutoExpandLevel(2);
        this.syntacticSelectionViewer.setInput((Object)new ItemProvider(Collections.singleton(this.xsdSchema)));
        viewerPane.setTitle((Object)this.xsdSchema);
        new AdapterFactoryTreeEditor(this.syntacticSelectionViewer.getTree(), (AdapterFactory)this.syntacticAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.syntacticSelectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, XSDEditorPlugin.INSTANCE.getString("_UI_Syntax_title"));
    }

    protected void initializeMarkerPosition(IMarker marker, XSDDiagnostic xsdDiagnostic) throws CoreException {
        Node node = xsdDiagnostic.getNode();
        if (node != null && node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        }
        if (node != null && XSDParser.getUserData((Node)node) instanceof Map) {
            int startLine = XSDParser.getStartLine((Node)node) - 1;
            int startColumn = XSDParser.getStartColumn((Node)node);
            int endLine = XSDParser.getEndLine((Node)node) - 1;
            int endColumn = XSDParser.getEndColumn((Node)node);
            marker.setAttribute("lineNumber", startLine);
            try {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
                marker.setAttribute("charStart", document.getLineOffset(startLine) + startColumn - 1);
                marker.setAttribute("charEnd", document.getLineOffset(endLine) + endColumn - 1);
            }
            catch (BadLocationException exception) {}
        } else {
            marker.setAttribute("lineNumber", xsdDiagnostic.getLine());
        }
    }

    protected void handleDiagnostics(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor localProgressMonitor) throws CoreException {
                    XSDEditor.this.handleDiagnostics(localProgressMonitor);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(operation, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
            }
        } else {
            XSDConcreteComponent newSelection = null;
            try {
                IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
                IFile file = modelFile.getFile();
                IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                ArrayList<IMarker> deletableMarkers = new ArrayList<IMarker>(Arrays.asList(markers));
                Iterator xsdDiagnostics = this.xsdSchema.getAllDiagnostics().iterator();
                while (xsdDiagnostics.hasNext()) {
                    XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)xsdDiagnostics.next();
                    String uriReferencePath = this.xsdSchema.eResource().getURIFragment((EObject)xsdDiagnostic);
                    IMarker marker = null;
                    int i = 0;
                    while (i < markers.length) {
                        if (markers[i].getAttribute("diagnostic", "").equals(uriReferencePath)) {
                            marker = markers[i];
                            deletableMarkers.remove(marker);
                            break;
                        }
                        ++i;
                    }
                    if (marker == null) {
                        marker = file.createMarker("org.eclipse.xsd.diagnostic");
                        marker.setAttribute("diagnostic", (Object)uriReferencePath);
                    }
                    this.initializeMarkerPosition(marker, xsdDiagnostic);
                    marker.setAttribute("message", (Object)xsdDiagnostic.getMessage());
                    switch (xsdDiagnostic.getSeverity().getValue()) {
                        case 0: 
                        case 1: {
                            if (newSelection == null) {
                                newSelection = xsdDiagnostic.getPrimaryComponent();
                            }
                            marker.setAttribute("severity", 2);
                            break;
                        }
                        case 2: {
                            marker.setAttribute("severity", 1);
                            break;
                        }
                        case 3: {
                            marker.setAttribute("severity", 0);
                        }
                    }
                }
                Iterator i = deletableMarkers.iterator();
                while (i.hasNext()) {
                    IMarker marker = (IMarker)i.next();
                    marker.delete();
                }
            }
            catch (Exception exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
            }
            if (this.editorSelection != null) {
                this.setSelection(this.editorSelection);
            } else if (newSelection != null) {
                StructuredSelection errorSelection = new StructuredSelection(newSelection);
                this.getSite().getShell().getDisplay().asyncExec(new Runnable((IStructuredSelection)errorSelection){
                    private final /* synthetic */ IStructuredSelection val$errorSelection;
                    {
                        this.val$errorSelection = val$errorSelection;
                    }

                    public void run() {
                        if (XSDEditor.this.contentOutlineViewer != null) {
                            XSDEditor.this.contentOutlineViewer.setSelection((ISelection)this.val$errorSelection, true);
                        }
                        if (XSDEditor.this.sourceViewer != null) {
                            XSDEditor.this.handleContentOutlineSelectionForTextEditor((ISelection)this.val$errorSelection, true);
                        }
                        XSDEditor.this.setSelection((ISelection)this.val$errorSelection);
                        XSDEditor.this.handleSourceCaretPosition();
                    }
                });
            }
        }
    }

    protected void pageChange(int pageIndex) {
        Control control;
        super.pageChange(pageIndex);
        if (pageIndex == 0) {
            this.setCurrentViewerPane(null);
            this.setCurrentViewer((Viewer)this.sourceViewer);
        }
        if ((control = this.getControl(pageIndex)) != null) {
            control.setVisible(true);
            control.setFocus();
        }
        this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
    }

    public Object getAdapter(Class key) {
        if (key.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = XSDEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = XSDEditor.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheetPage();
        }
        return this.textEditor.getAdapter(key);
    }

    public static XSDConcreteComponent getResolvedObject(XSDConcreteComponent xsdConcreteComponent) {
        XSDConcreteComponent result = (XSDConcreteComponent)new XSDSwitch(){

            public Object caseXSDAttributeUse(XSDAttributeUse xsdAttributeUse) {
                return xsdAttributeUse.getAttributeDeclaration().getResolvedAttributeDeclaration();
            }

            public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration xsdAttributeDeclaration) {
                return xsdAttributeDeclaration.getResolvedAttributeDeclaration();
            }

            public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                return xsdAttributeGroupDefinition.getResolvedAttributeGroupDefinition();
            }

            public Object caseXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
                return xsdElementDeclaration.getResolvedElementDeclaration();
            }

            public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                return xsdModelGroupDefinition.getResolvedModelGroupDefinition();
            }

            public Object caseXSDParticle(XSDParticle xsdParticle) {
                XSDConcreteComponent resolvedObject = XSDEditor.getResolvedObject((XSDConcreteComponent)xsdParticle.getContent());
                if (resolvedObject instanceof XSDModelGroup) {
                    return xsdParticle;
                }
                return resolvedObject;
            }
        }.doSwitch((EObject)xsdConcreteComponent);
        return result == null ? xsdConcreteComponent : result;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                private final /* synthetic */ XSDEditor this$0;

                MyContentOutlinePage(XSDEditor this$0) {
                    this.this$0 = this$0;
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    this.this$0.contentOutlineViewer = this.getTreeViewer();
                    this.this$0.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    this.this$0.contentOutlineViewer.setAutoExpandLevel(2);
                    this.this$0.selectNextDiagnosticsAction = this.this$0.new SelectDiagnosticAction(true, (StructuredViewer)this.this$0.contentOutlineViewer);
                    this.this$0.selectPreviousDiagnosticsAction = this.this$0.new SelectDiagnosticAction(false, (StructuredViewer)this.this$0.contentOutlineViewer);
                    this.this$0.selectNextUseAction = this.this$0.new SelectUseAction(true, (StructuredViewer)this.this$0.contentOutlineViewer);
                    this.this$0.selectPreviousUseAction = this.this$0.new SelectUseAction(false, (StructuredViewer)this.this$0.contentOutlineViewer);
                    this.this$0.contentOutlineViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(this){
                        private final /* synthetic */ MyContentOutlinePage this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void mouseDoubleClick(MouseEvent event) {
                            IStructuredSelection selection = (IStructuredSelection)MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.getSelection();
                            Iterator<E> objects = selection.toList().iterator();
                            while (objects.hasNext()) {
                                XSDComplexTypeDefinition xsdComplexTypeDefinition;
                                XSDSimpleTypeDefinition baseTypeDefinition;
                                XSDSimpleTypeDefinition typeDefinition;
                                XSDConcreteComponent resolvedObject;
                                XSDConcreteComponent object = (XSDConcreteComponent)objects.next();
                                if (object != (resolvedObject = XSDEditor.getResolvedObject(object))) {
                                    MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{resolvedObject}), true);
                                    break;
                                }
                                if (object instanceof XSDAttributeDeclaration) {
                                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)object;
                                    typeDefinition = xsdAttributeDeclaration.getTypeDefinition();
                                    if (typeDefinition == null || typeDefinition.getSchema() != xsdAttributeDeclaration.getSchema()) continue;
                                    MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{typeDefinition}), true);
                                    break;
                                }
                                if (object instanceof XSDElementDeclaration) {
                                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)object;
                                    typeDefinition = xsdElementDeclaration.getTypeDefinition();
                                    if (typeDefinition == null || typeDefinition.getSchema() != xsdElementDeclaration.getSchema()) continue;
                                    MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{typeDefinition}), true);
                                    break;
                                }
                                if (object instanceof XSDSimpleTypeDefinition) {
                                    XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)object;
                                    baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                                    if (baseTypeDefinition != null && baseTypeDefinition.getSchema() == xsdSimpleTypeDefinition.getSchema()) {
                                        MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{baseTypeDefinition}), true);
                                        break;
                                    }
                                    XSDSimpleTypeDefinition itemTypeDefinition = xsdSimpleTypeDefinition.getItemTypeDefinition();
                                    if (itemTypeDefinition != null && itemTypeDefinition.getSchema() == xsdSimpleTypeDefinition.getSchema()) {
                                        MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{itemTypeDefinition}), true);
                                        break;
                                    }
                                    EList memberTypeDefinitions = xsdSimpleTypeDefinition.getMemberTypeDefinitions();
                                    if (memberTypeDefinitions.isEmpty()) continue;
                                    MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(memberTypeDefinitions.toArray()), true);
                                    break;
                                }
                                if (!(object instanceof XSDComplexTypeDefinition) || (baseTypeDefinition = (xsdComplexTypeDefinition = (XSDComplexTypeDefinition)object).getBaseTypeDefinition()) == null || baseTypeDefinition.getSchema() != xsdComplexTypeDefinition.getSchema()) continue;
                                MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{baseTypeDefinition}), true);
                                break;
                            }
                        }
                    });
                    this.this$0.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.this$0.syntacticAdapterFactory));
                    this.this$0.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.this$0.syntacticAdapterFactory));
                    this.this$0.contentOutlineViewer.setInput((Object)new ItemProvider(Collections.singleton(this.this$0.xsdSchema)));
                    this.this$0.createContextMenuFor((StructuredViewer)this.this$0.contentOutlineViewer);
                    ArrayList<XSDSchema> selection = new ArrayList<XSDSchema>();
                    selection.add(this.this$0.xsdSchema);
                    this.this$0.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    this.addSelectionChangedListener(new ISelectionChangedListener(this){
                        private final /* synthetic */ MyContentOutlinePage this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void selectionChanged(SelectionChangedEvent event) {
                            ISelection s = event.getSelection();
                            if (MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).contentOutlineViewer == MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).currentViewer) {
                                MyContentOutlinePage.access$500(this.this$1).handleContentOutlineSelection(s);
                            }
                            MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).selectNextDiagnosticsAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).selectPreviousDiagnosticsAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).selectNextUseAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            MyContentOutlinePage.access$500((MyContentOutlinePage)this.this$1).selectPreviousUseAction.setCurrentObjects(((IStructuredSelection)s).toList());
                        }
                    });
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    this.this$0.contentOutlineStatusLineManager = actionBars.getStatusLineManager();
                    actionBars.getToolBarManager().add((IAction)this.this$0.selectNextUseAction);
                    actionBars.getToolBarManager().add((IAction)this.this$0.selectPreviousUseAction);
                    actionBars.getToolBarManager().add((IAction)this.this$0.selectNextDiagnosticsAction);
                    actionBars.getToolBarManager().add((IAction)this.this$0.selectPreviousDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)this.this$0.selectNextDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)this.this$0.selectPreviousDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)this.this$0.selectNextUseAction);
                    actionBars.getMenuManager().add((IAction)this.this$0.selectPreviousUseAction);
                    this.this$0.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                static /* synthetic */ XSDEditor access$500(MyContentOutlinePage x0) {
                    return x0.this$0;
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage(this);
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (XSDEditor.this.contentOutlineViewer == XSDEditor.this.currentViewer) {
                        XSDEditor.this.handleContentOutlineSelection(event.getSelection());
                    }
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.syntacticAdapterFactory){

                public void notifyChanged(Object object, int eventType, Object feature, Object oldValue, Object newValue, int index) {
                    XSDEditor.super.getContainer().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            23.access$600(this.this$1).propertySheetPage.refresh();
                        }
                    });
                }

                protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
                    return new PropertySource(this, object, itemPropertySource){
                        private final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                            return new PropertyDescriptor(this, this.object, itemPropertyDescriptor){
                                private final /* synthetic */ 25 this$2;
                                {
                                    super(x0, x1);
                                    this.this$2 = this$2;
                                }

                                public CellEditor createPropertyEditor(Composite composite) {
                                    Collection choiceOfValues;
                                    EStructuralFeature feature;
                                    EClassifier getEType;
                                    if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                                        return null;
                                    }
                                    CellEditor result = null;
                                    Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
                                    if (genericFeature instanceof EStructuralFeature && (getEType = (feature = (EStructuralFeature)genericFeature).getEType()) == PropertyDescriptor.ecorePackage.getEBoolean() && (choiceOfValues = this.itemPropertyDescriptor.getChoiceOfValues(this.object)) != null) {
                                        result = new ExtendedComboBoxCellEditor(composite, new ArrayList<E>(choiceOfValues), this.getLabelProvider(), true);
                                    }
                                    if (result == null) {
                                        result = super.createPropertyEditor(composite);
                                    }
                                    return result;
                                }
                            };
                        }
                    };
                }

                static /* synthetic */ XSDEditor access$600(23 x0) {
                    return x0.XSDEditor.this;
                }
            });
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if ((this.currentViewerPane != null || this.getActivePage() == 0) && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            if (this.getActivePage() == 0) {
                this.handleContentOutlineSelectionForTextEditor(selection, true);
            } else if (this.currentViewerPane.getViewer() == this.syntacticSelectionViewer) {
                this.syntacticSelectionViewer.setSelection(selection);
            } else if (this.currentViewerPane.getViewer() == this.semanticSelectionViewer) {
                ArrayList<XSDConcreteComponent> selectionList = new ArrayList<XSDConcreteComponent>();
                Iterator elements = ((IStructuredSelection)selection).iterator();
                while (elements.hasNext()) {
                    selectionList.add(XSDEditor.getResolvedObject((XSDConcreteComponent)elements.next()));
                }
                this.semanticSelectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            }
        }
    }

    public void handleContentOutlineSelectionForTextEditor(ISelection selection, boolean reveal) {
        Element element;
        XSDParticle xsdParticle;
        XSDParticleContent content;
        XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)((IStructuredSelection)selection).iterator().next();
        if (xsdConcreteComponent instanceof XSDParticle && (content = (xsdParticle = (XSDParticle)xsdConcreteComponent).getContent()) != null) {
            xsdConcreteComponent = content;
        }
        if ((element = xsdConcreteComponent.getElement()) != null) {
            try {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
                int startLine = XSDParser.getStartLine((Node)element);
                int startColumn = XSDParser.getStartColumn((Node)element);
                int endLine = XSDParser.getEndLine((Node)element);
                int endColumn = XSDParser.getEndColumn((Node)element);
                int startOffset = document.getLineOffset(startLine - 1);
                startOffset += startColumn - 1;
                int endOffset = document.getLineOffset(endLine - 1);
                endOffset += endColumn - 1;
                if (startLine == endLine) {
                    this.textEditor.setHighlightRange(startOffset, endOffset - startOffset, false);
                    if (reveal) {
                        this.textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                } else {
                    this.textEditor.setHighlightRange(startOffset, endOffset - startOffset, reveal);
                }
            }
            catch (Exception exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || this.textEditor != null && this.textEditor.isDirty();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    XSDEditor.this.xsdSchema.eResource().save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null && (!file.exists() || MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)XSDEditorPlugin.INSTANCE.getString("_UI_FileExists_title"), (String)XSDEditorPlugin.INSTANCE.getString("_UI_FileExists_description", new Object[]{file.getFullPath()})))) {
            this.xsdSchema.eResource().setURI(URI.createURI((String)("platform:/resource" + file.getFullPath())));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setTitle(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
        try {
            this.setActivePage(0);
            this.textEditor.gotoMarker(marker);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setTitle(((IFileEditorInput)editorInput).getFile().getName());
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
        site.getPage().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(selectionChangedEvent);
        Iterator listeners = this.selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(selectionChangedEvent);
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (this.currentViewer == this.contentOutlineViewer) {
            statusLineManager = this.contentOutlineStatusLineManager;
        }
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(XSDEditorPlugin.INSTANCE.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        XSDConcreteComponent xsdConcreteComponent;
                        Object object = collection.iterator().next();
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.syntacticAdapterFactory).getText(object);
                        text = XSDEditorPlugin.INSTANCE.getString("_UI_SingleObjectSelected", new Object[]{text});
                        if (object instanceof XSDConcreteComponent && !(xsdConcreteComponent = (XSDConcreteComponent)object).getDiagnostics().isEmpty()) {
                            text = ((XSDDiagnostic)xsdConcreteComponent.getDiagnostics().get(0)).getMessage();
                        }
                        statusLineManager.setMessage(text);
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(XSDEditorPlugin.INSTANCE.getString("_UI_MultiObjectSelected", new Object[]{Integer.toString(collection.size())}));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        this.semanticAdapterFactory.dispose();
        this.syntacticAdapterFactory.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GenericXMLLoadAction
    extends ActionDelegate
    implements IActionDelegate {
        protected IFile file;

        public void run(IAction action) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new GenericXMLResourceFactoryImpl());
            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)this.file.getFullPath().toString()), true);
            resource.setURI(URI.createPlatformResourceURI((String)(this.file.getFullPath().toString() + ".save.xml")));
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
            Object object;
            if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
                this.file = (IFile)object;
                action.setEnabled(true);
                return;
            }
            this.file = null;
            action.setEnabled(false);
        }
    }

    public static class GenericXMLResourceImpl
    extends XMLResourceImpl {
        protected XSDEcoreBuilder xsdEcoreBuilder;
        protected XMLHelper xmlHelper;

        public GenericXMLResourceImpl(URI uri) {
            super(uri);
        }

        protected XMLHelper createXMLHelper() {
            if (this.xmlHelper == null) {
                this.xmlHelper = new XMLHelperImpl(this, (XMLResource)this){
                    private final /* synthetic */ GenericXMLResourceImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    protected String getQName(String uri, String name) {
                        if (uri == null) {
                            return name;
                        }
                        EPackage pkg = (EPackage)this.this$0.xsdEcoreBuilder.getTargetNamespaceToEPackageMap().get(uri);
                        if (pkg == null || pkg.getNsPrefix().equals("")) {
                            return name;
                        }
                        this.packages.put(pkg, null);
                        return pkg.getNsPrefix() + ":" + name;
                    }
                };
            }
            return this.xmlHelper;
        }

        public void doLoad(InputStream inputStream, Map op) throws IOException {
            XMLLoadImpl xmlStart = new XMLLoadImpl(this, op, this.createXMLHelper()){
                private final /* synthetic */ Map val$op;
                private final /* synthetic */ GenericXMLResourceImpl this$0;
                {
                    this.this$0 = this$0;
                    this.val$op = val$op;
                }

                protected DefaultHandler makeDefaultHandler() {
                    SAXXMLHandler saxXMLHandler = new SAXXMLHandler(this, this.resource, this.helper, this.val$op){
                        protected XMLHandler.MyStack elementDeclarations;
                        protected XMLHandler.MyStack dfaStates;
                        private final /* synthetic */ 29 this$1;
                        {
                            super(x0, x1, x2);
                            this.this$1 = this$1;
                            this.elementDeclarations = new XMLHandler.MyStack();
                            this.dfaStates = new XMLHandler.MyStack();
                        }

                        protected void createTopObject(String prefix, String name) {
                            String namespaceURI = ((XMLHandler)this).helper.getURI(prefix);
                            int i = 0;
                            int size = this.attribs.getLength();
                            while (i < size) {
                                String attributeName = this.attribs.getQName(i);
                                int index = attributeName.indexOf(":");
                                String attributeNamespaceURI = null;
                                String attributeLocalName = attributeName;
                                if (index != -1) {
                                    attributeNamespaceURI = ((XMLHandler)this).helper.getURI(attributeName.substring(0, index));
                                    attributeLocalName = attributeName.substring(index + 1);
                                }
                                if ("http://www.w3.org/2001/XMLSchema-instance".equals(attributeNamespaceURI) && (namespaceURI == null ? "noSchemaLocation" : "schemaLocation").equals(attributeLocalName)) {
                                    String schemaLocationHint = null;
                                    if (namespaceURI == null) {
                                        schemaLocationHint = this.attribs.getValue(i);
                                    } else {
                                        StringTokenizer stringTokenizer = new StringTokenizer(this.attribs.getValue(i));
                                        while (stringTokenizer.hasMoreTokens()) {
                                            String namespaceURIHint = stringTokenizer.nextToken();
                                            if (!stringTokenizer.hasMoreTokens()) break;
                                            if (namespaceURIHint.equals(namespaceURI)) {
                                                schemaLocationHint = stringTokenizer.nextToken();
                                                break;
                                            }
                                            stringTokenizer.nextToken();
                                        }
                                    }
                                    if (schemaLocationHint != null) {
                                        URI uri = URI.createDeviceURI((String)schemaLocationHint);
                                        if (((XMLHandler)this).resolve && uri.isRelative() && uri.hasRelativePath()) {
                                            uri = uri.resolve(((XMLHandler)this).resourceURI);
                                        }
                                        29.access$800(this.this$1).xsdEcoreBuilder = new XSDEcoreBuilder(1);
                                        Collection resources = 29.access$800(this.this$1).xsdEcoreBuilder.generateResources(uri);
                                        29.access$901(this.this$1).getResourceSet().getResources().addAll(resources);
                                    }
                                }
                                ++i;
                            }
                            if (29.access$800(this.this$1).xsdEcoreBuilder == null) {
                                this.error(new XMIException("Cannot resolve schema location", this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                            } else {
                                XSDElementDeclaration xsdElementDeclaration = 29.access$800(this.this$1).xsdEcoreBuilder.getSchema().resolveElementDeclaration(namespaceURI, name);
                                EClass eClass = (EClass)29.access$800(this.this$1).xsdEcoreBuilder.getXSDComponentToEModelElementMap().get(xsdElementDeclaration);
                                if (eClass != null) {
                                    this.processTopObject(eClass.getEPackage().getEFactoryInstance().create(eClass));
                                    this.elementDeclarations.push((Object)xsdElementDeclaration);
                                    XSDParticle xsdParticle = xsdElementDeclaration.getTypeDefinition().getComplexType();
                                    if (xsdParticle != null) {
                                        this.dfaStates.push((Object)xsdParticle.getDFA().getInitialState());
                                    } else {
                                        this.dfaStates.push(null);
                                    }
                                } else {
                                    this.error(new XMIException("Cannot resolve EClass ", this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                }
                            }
                        }

                        protected void processElement(String name, String prefix, String localName) {
                            if (this.isError()) {
                                ((XMLHandler)this).types.push((Object)"error");
                            } else if (((XMLHandler)this).objects.isEmpty()) {
                                this.createTopObject(prefix, localName);
                            } else {
                                EObject peekObject = (EObject)((XMLHandler)this).objects.peek();
                                XSDParticle.DFA.State state = (XSDParticle.DFA.State)this.dfaStates.peek();
                                if (state == null) {
                                    this.error(new XMIException("Cannot contain content ", this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                } else {
                                    XSDParticle.DFA.Transition transition = state.accept(((XMLHandler)this).helper.getURI(prefix), localName);
                                    if (transition == null) {
                                        this.error(new XMIException("Not expecting this element ", this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                    } else {
                                        this.dfaStates.set(this.dfaStates.size() - 1, transition.getState());
                                        XSDParticle transitionXSDParticle = transition.getParticle();
                                        XSDTerm xsdTerm = transitionXSDParticle.getTerm();
                                        XSDElementDeclaration xsdElementDeclaration = null;
                                        xsdElementDeclaration = xsdTerm instanceof XSDElementDeclaration ? (XSDElementDeclaration)xsdTerm : 29.access$800(this.this$1).xsdEcoreBuilder.getSchema().resolveElementDeclaration(((XMLHandler)this).helper.getURI(prefix), name);
                                        EClass eClass = (EClass)29.access$800(this.this$1).xsdEcoreBuilder.getXSDComponentToEModelElementMap().get(xsdElementDeclaration);
                                        if (eClass != null) {
                                            EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
                                            ((EList)peekObject.eGet(peekObject.eClass().getEStructuralFeature("contents"))).add(eObject);
                                            this.processObject(eObject);
                                            this.elementDeclarations.push((Object)xsdElementDeclaration);
                                            XSDParticle xsdParticle = xsdElementDeclaration.getTypeDefinition().getComplexType();
                                            if (xsdParticle != null) {
                                                this.dfaStates.push((Object)xsdParticle.getDFA().getInitialState());
                                            } else {
                                                EStructuralFeature valueFeature;
                                                this.dfaStates.push(null);
                                                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdElementDeclaration.getTypeDefinition().getSimpleType();
                                                if (xsdSimpleTypeDefinition != null && (valueFeature = eClass.getEStructuralFeature("value")) != null) {
                                                    ((XMLHandler)this).text = new StringBuffer();
                                                    ((XMLHandler)this).types.set(((XMLHandler)this).types.size() - 1, valueFeature);
                                                }
                                            }
                                        } else {
                                            this.error(new XMIException("Cannot resolve EClass ", this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                        }
                                    }
                                }
                            }
                        }

                        public void endElement(String uri, String localName, String name) {
                            XSDParticle.DFA.State state;
                            EObject topObject = (EObject)((XMLHandler)this).objects.pop();
                            ((XMLHandler)this).elements.pop();
                            Object type = ((XMLHandler)this).types.pop();
                            if (((XMLHandler)this).text != null) {
                                EAttribute eAttribute = (EAttribute)type;
                                EDataType eDataType = eAttribute.getEAttributeType();
                                Object value = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, ((XMLHandler)this).text.toString());
                                topObject.eSet((EStructuralFeature)eAttribute, value);
                                ((XMLHandler)this).text = null;
                            }
                            if ((state = (XSDParticle.DFA.State)this.dfaStates.pop()) != null && !state.isAccepting()) {
                                this.error(new XMIException("Need more content ", this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                            }
                            this.elementDeclarations.pop();
                        }
                    };
                    return new SAXWrapper((XMLHandler)saxXMLHandler);
                }

                static /* synthetic */ GenericXMLResourceImpl access$800(29 x0) {
                    return x0.this$0;
                }

                static /* synthetic */ XMLResource access$901(29 x0) {
                    return x0.resource;
                }
            };
            xmlStart.load((XMLResource)this, inputStream, op);
        }
    }

    public static class GenericXMLResourceFactoryImpl
    extends XMLResourceFactoryImpl {
        protected XMLResource.XMLMap xmlMap = new XMLMapImpl();

        public Resource createResource(URI uri) {
            GenericXMLResourceImpl result = new GenericXMLResourceImpl(uri);
            result.getDefaultSaveOptions().put("XML_MAP", this.xmlMap);
            result.getDefaultLoadOptions().put("XML_MAP", this.xmlMap);
            return result;
        }
    }

    public static class EcoreXMISchemaBuilder
    extends EcoreXMLSchemaBuilder {
        protected static final String XMI_PREFIX = "xmi";
        protected static final String XMI_URI = "http://www.omg.org/XMI";
        protected static final String XMI_SCHEMA_LOCATION = "XMI.xsd";

        public Collection generate(EPackage ePackage) {
            return this.generate(ePackage, null);
        }

        public Collection generate(EPackage ePackage, XMLResource.XMLMap map) {
            List result = (List)super.generate(ePackage, map);
            result.add(1, this.createXMISchema());
            return result;
        }

        protected void createSchema() {
            super.createSchema();
            Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
            namespaces.put(XMI_PREFIX, XMI_URI);
            XSDImport xmiImport = XSDFactory.eINSTANCE.createXSDImport();
            xmiImport.setNamespace(XMI_URI);
            xmiImport.setSchemaLocation(XMI_SCHEMA_LOCATION);
            this.xsdSchema.getContents().add(xmiImport);
        }

        protected XSDSchema createXMISchema() {
            XSDSchema xmiSchema = XSDFactory.eINSTANCE.createXSDSchema();
            xmiSchema.setTargetNamespace(XMI_URI);
            xmiSchema.setSchemaForSchemaQNamePrefix("xsd");
            Map namespaces = xmiSchema.getQNamePrefixToNamespaceMap();
            namespaces.put(XMI_PREFIX, XMI_URI);
            namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
            XSDAttributeDeclaration xmiIdAttribute = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            xmiIdAttribute.setName("id");
            xmiIdAttribute.setTypeDefinition(xmiSchema.getSchemaForSchema().resolveSimpleTypeDefinition("ID"));
            xmiSchema.getContents().add(xmiIdAttribute);
            XSDAttributeGroupDefinition xmiIdentityAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            xmiIdentityAttribs.setName("IdentityAttribs");
            EList contents = xmiIdentityAttribs.getContents();
            contents.add(this.createAttributeUse(xmiSchema, "label", "string", "optional", "qualified", null));
            contents.add(this.createAttributeUse(xmiSchema, "uuid", "string", "optional", "qualified", null));
            xmiSchema.getContents().add(xmiIdentityAttribs);
            XSDAttributeGroupDefinition xmiLinkAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            xmiLinkAttribs.setName("LinkAttribs");
            contents = xmiLinkAttribs.getContents();
            contents.add(this.createAttributeUse(xmiSchema, "href", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "idref", "IDREF", "optional", "qualified", null));
            xmiSchema.getContents().add(xmiLinkAttribs);
            XSDAttributeGroupDefinition xmiObjectAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            xmiObjectAttribs.setName("ObjectAttribs");
            contents = xmiObjectAttribs.getContents();
            contents.add(this.createAttributeGroupReference(xmiSchema, "IdentityAttribs"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "LinkAttribs"));
            contents.add(this.createAttributeUse(xmiSchema, "version", "string", "optional", "qualified", "2.0"));
            contents.add(this.createAttributeUse(xmiSchema, "type", "QName", "optional", "qualified", null));
            xmiSchema.getContents().add(xmiObjectAttribs);
            XSDComplexTypeDefinition xmiComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            xmiComplexTypeDefinition.setName("XMI");
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            XSDModelGroup modelGroup = this.createAnyModelGroup("strict");
            particle.setContent((XSDParticleContent)modelGroup);
            xmiComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
            contents = xmiComplexTypeDefinition.getAttributeContents();
            contents.add(this.createAttributeReference(xmiSchema, "id"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "IdentityAttribs"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "LinkAttribs"));
            contents.add(this.createAttributeUse(xmiSchema, "type", "QName", "optional", "qualified", null));
            contents.add(this.createAttributeUse(xmiSchema, "version", "string", "required", "qualified", "2.0"));
            xmiSchema.getContents().add(xmiComplexTypeDefinition);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "XMI", "XMI", false));
            XSDComplexTypeDefinition prComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            prComplexTypeDefinition.setName("PackageReference");
            particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
            this.addElementDeclaration(xmiSchema, modelGroup, "name", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "version", "string");
            this.addElementDeclarationReference(xmiSchema, modelGroup, "Extension");
            particle.setContent((XSDParticleContent)modelGroup);
            prComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
            contents = prComplexTypeDefinition.getAttributeContents();
            contents.add(this.createAttributeReference(xmiSchema, "id"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
            contents.add(this.createAttributeUse(xmiSchema, "name", "string", "optional", null, null));
            xmiSchema.getContents().add(prComplexTypeDefinition);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "PackageReference", "PackageReference", false));
            xmiSchema.getContents().add(this.createExtendedComplexTypeDefinition(xmiSchema, "Model", "PackageReference"));
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Model", "Model", false));
            xmiSchema.getContents().add(this.createExtendedComplexTypeDefinition(xmiSchema, "Import", "PackageReference"));
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Import", "Import", false));
            xmiSchema.getContents().add(this.createExtendedComplexTypeDefinition(xmiSchema, "MetaModel", "PackageReference"));
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "MetaModel", "MetaModel", false));
            XSDComplexTypeDefinition documentationComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            documentationComplexType.setName("Documentation");
            particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
            this.addElementDeclaration(xmiSchema, modelGroup, "contact", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "exporter", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "exporterVersion", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "longDescription", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "shortDescription", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "notice", "string");
            this.addElementDeclaration(xmiSchema, modelGroup, "owner", "string");
            this.addElementDeclarationReference(xmiSchema, modelGroup, "Extension");
            particle.setContent((XSDParticleContent)modelGroup);
            documentationComplexType.setContent((XSDComplexTypeContent)particle);
            contents = documentationComplexType.getAttributeContents();
            contents.add(this.createAttributeReference(xmiSchema, "id"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
            contents.add(this.createAttributeUse(xmiSchema, "contact", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "exporter", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "exporterVersion", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "longDescription", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "shortDescription", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "notice", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "owner", "string", "optional", null, null));
            xmiSchema.getContents().add(documentationComplexType);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Documentation", "Documentation", false));
            XSDComplexTypeDefinition extensionComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            extensionComplexType.setName("Extension");
            particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            modelGroup = this.createAnyModelGroup("lax");
            particle.setContent((XSDParticleContent)modelGroup);
            extensionComplexType.setContent((XSDComplexTypeContent)particle);
            contents = extensionComplexType.getAttributeContents();
            contents.add(this.createAttributeReference(xmiSchema, "id"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
            contents.add(this.createAttributeUse(xmiSchema, "extender", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "extenderID", "string", "optional", null, null));
            xmiSchema.getContents().add(extensionComplexType);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Extension", "Extension", false));
            XSDComplexTypeDefinition differenceComplexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            differenceComplexType.setName("Difference");
            particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
            XSDParticle particle2 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDElementDeclaration target = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            target.setName("target");
            XSDComplexTypeDefinition anonymous = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            XSDParticle particle3 = XSDFactory.eINSTANCE.createXSDParticle();
            particle3.setMinOccurs(0);
            particle3.setMaxOccurs(-1);
            particle3.setContent((XSDParticleContent)this.createAnyModelGroup("skip"));
            anonymous.setContent((XSDComplexTypeContent)particle3);
            anonymous.setAttributeWildcardContent(this.createAny("skip"));
            target.setAnonymousTypeDefinition((XSDTypeDefinition)anonymous);
            particle2.setContent((XSDParticleContent)target);
            modelGroup.getContents().add(particle2);
            this.addElementDeclaration(xmiSchema, modelGroup, "difference", "Difference", false);
            this.addElementDeclaration(xmiSchema, modelGroup, "container", "Difference", false);
            this.addElementDeclarationReference(xmiSchema, modelGroup, "Extension");
            particle.setContent((XSDParticleContent)modelGroup);
            differenceComplexType.setContent((XSDComplexTypeContent)particle);
            contents = differenceComplexType.getAttributeContents();
            contents.add(this.createAttributeReference(xmiSchema, "id"));
            contents.add(this.createAttributeGroupReference(xmiSchema, "ObjectAttribs"));
            contents.add(this.createAttributeUse(xmiSchema, "target", "IDREFS", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "container", "IDREFS", "optional", null, null));
            xmiSchema.getContents().add(differenceComplexType);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Difference", "Difference", false));
            XSDComplexTypeDefinition addComplexType = this.createExtendedComplexTypeDefinition(xmiSchema, "Add", "Difference");
            contents = addComplexType.getAttributeContents();
            contents.add(this.createAttributeUse(xmiSchema, "position", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "addition", "IDREFS", "optional", null, null));
            xmiSchema.getContents().add(addComplexType);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Add", "Add", false));
            XSDComplexTypeDefinition replaceComplexType = this.createExtendedComplexTypeDefinition(xmiSchema, "Replace", "Difference");
            contents = replaceComplexType.getAttributeContents();
            contents.add(this.createAttributeUse(xmiSchema, "position", "string", "optional", null, null));
            contents.add(this.createAttributeUse(xmiSchema, "replacement", "IDREFS", "optional", null, null));
            xmiSchema.getContents().add(replaceComplexType);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Replace", "Replace", false));
            XSDComplexTypeDefinition deleteComplexType = this.createExtendedComplexTypeDefinition(xmiSchema, "Delete", "Difference");
            xmiSchema.getContents().add(deleteComplexType);
            xmiSchema.getContents().add(this.createElementDeclaration(xmiSchema, "Delete", "Delete", false));
            XSDComplexTypeDefinition xmiAny = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            xmiAny.setName("Any");
            particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            particle.setContent((XSDParticleContent)this.createAnyModelGroup("skip"));
            xmiAny.setContent((XSDComplexTypeContent)particle);
            xmiAny.setAttributeWildcardContent(this.createAny("skip"));
            xmiSchema.getContents().add(xmiAny);
            return xmiSchema;
        }

        protected XSDModelGroup createAnyModelGroup(String processContents) {
            XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent((XSDParticleContent)this.createAny(processContents));
            modelGroup.getContents().add(particle);
            return modelGroup;
        }

        protected XSDWildcard createAny(String processContents) {
            XSDWildcard any = XSDFactory.eINSTANCE.createXSDWildcard();
            if ("strict".equals(processContents)) {
                any.setProcessContents(XSDProcessContents.STRICT_LITERAL);
            } else if ("skip".equals(processContents)) {
                any.setProcessContents(XSDProcessContents.SKIP_LITERAL);
            } else if ("lax".equals(processContents)) {
                any.setProcessContents(XSDProcessContents.LAX_LITERAL);
            }
            return any;
        }

        protected XSDComplexTypeDefinition createExtendedComplexTypeDefinition(XSDSchema schema, String name, String extension) {
            XSDComplexTypeDefinition complexType = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            complexType.setName(name);
            complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            complexType.setBaseTypeDefinition(schema.resolveTypeDefinition(extension));
            return complexType;
        }

        protected XSDAttributeGroupDefinition createAttributeGroupReference(XSDSchema schema, String name) {
            XSDAttributeGroupDefinition reference = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            reference.setResolvedAttributeGroupDefinition(schema.resolveAttributeGroupDefinition(name));
            return reference;
        }

        protected XSDElementDeclaration createElementDeclaration(XSDSchema schema, String name, String type, boolean schemaType) {
            XSDElementDeclaration elementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            elementDeclaration.setName(name);
            if (schemaType) {
                elementDeclaration.setTypeDefinition((XSDTypeDefinition)schema.getSchemaForSchema().resolveSimpleTypeDefinition(type));
            } else {
                elementDeclaration.setTypeDefinition((XSDTypeDefinition)schema.resolveSimpleTypeDefinition(type));
            }
            return elementDeclaration;
        }

        protected void addElementDeclaration(XSDSchema schema, XSDModelGroup modelGroup, String name, String type) {
            this.addElementDeclaration(schema, modelGroup, name, type, true);
        }

        protected void addElementDeclaration(XSDSchema schema, XSDModelGroup modelGroup, String name, String type, boolean schemaType) {
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent((XSDParticleContent)this.createElementDeclaration(schema, name, type, schemaType));
            modelGroup.getContents().add(particle);
        }

        protected void addElementDeclarationReference(XSDSchema schema, XSDModelGroup modelGroup, String reference) {
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            XSDElementDeclaration elementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            elementDeclaration.setResolvedElementDeclaration(schema.resolveElementDeclaration(reference));
            particle.setContent((XSDParticleContent)elementDeclaration);
            modelGroup.getContents().add(particle);
        }

        protected XSDAttributeUse createAttributeReference(XSDSchema schema, String name) {
            XSDAttributeDeclaration attributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attributeDeclaration.setResolvedAttributeDeclaration(schema.resolveAttributeDeclaration(name));
            XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attributeUse.setContent(attributeDeclaration);
            return attributeUse;
        }

        protected XSDAttributeUse createAttributeUse(XSDSchema schema, String name, String type, String use, String form, String fixed) {
            XSDAttributeDeclaration attributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attributeDeclaration.setName(name);
            attributeDeclaration.setTypeDefinition(schema.getSchemaForSchema().resolveSimpleTypeDefinition(type));
            if ("qualified".equals(form)) {
                attributeDeclaration.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            XSDAttributeUse attributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attributeUse.setContent(attributeDeclaration);
            if ("optional".equals(use)) {
                attributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
            }
            if ("required".equals(use)) {
                attributeUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
            }
            if (fixed != null) {
                attributeUse.setConstraint(XSDConstraint.FIXED_LITERAL);
                attributeUse.setLexicalValue("2.0");
            }
            return attributeUse;
        }

        protected boolean makeClassElementDeclaration(EClass eClass) {
            return true;
        }

        protected XSDModelGroup createModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setMinOccurs(0);
            particle.setMaxOccurs(-1);
            particle.setContent((XSDParticleContent)modelGroup);
            xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
            return modelGroup;
        }

        protected void setAttributeElementMultiplicity(EAttribute attribute, XSDParticle particle) {
        }

        protected void additionalProcessing(EClass eClass, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            if (eClass.getESuperTypes().size() == 0) {
                this.addXMIExtension(this.getModelGroup(xsdComplexTypeDefinition));
                this.addXMIAttributes(xsdComplexTypeDefinition);
            }
        }

        protected void addXMIExtension(XSDModelGroup modelGroup) {
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElementDeclaration.setResolvedElementDeclaration(xsdElementDeclaration.resolveElementDeclaration(XMI_URI, "Extension"));
            particle.setContent((XSDParticleContent)xsdElementDeclaration);
            modelGroup.getContents().add(particle);
        }

        protected void addXMIAttributes(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDAttributeGroupDefinition objAttribs = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            objAttribs.setResolvedAttributeGroupDefinition(objAttribs.resolveAttributeGroupDefinition(XMI_URI, "ObjectAttribs"));
            xsdComplexTypeDefinition.getAttributeContents().add(0, objAttribs);
            XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attrDecl.setResolvedAttributeDeclaration(attrDecl.resolveAttributeDeclaration(XMI_URI, "id"));
            XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attrUse.setContent(attrDecl);
            xsdComplexTypeDefinition.getAttributeContents().add(0, attrUse);
        }

        protected void setDefaultValue(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
        }

        protected boolean makeReferenceElement(EReference reference) {
            return true;
        }

        protected void setReferenceElementType(EReference reference, XSDElementDeclaration xsdElementDeclaration) {
            if (reference.getEType() != null) {
                super.setReferenceElementType(reference, xsdElementDeclaration);
            } else {
                xsdElementDeclaration.setTypeDefinition((XSDTypeDefinition)xsdElementDeclaration.resolveSimpleTypeDefinition(XMI_URI, "Any"));
            }
        }

        protected void setReferenceElementMultiplicity(EReference reference, XSDParticle particle) {
        }
    }

    public static class EcoreXMLSchemaBuilder
    extends MapBuilder {
        protected static final String EMF_SCHEMA_URI = "http://org.eclipse.emf/xsd";
        protected static final String EMF_SCHEMA_PREFIX = "emf";
        protected static final String EMF_SCHEMA_NAME = "EMF.xsd";
        protected static final String REFERENCE_TYPE_NAME = "string";
        protected XSDSchema xsdSchema;
        protected XSDSchema emfSchema;
        protected EPackage ePackage;
        protected Map ecoreToSchemaName;
        protected Map ePackageToXSDSchemaMap = new HashMap();
        protected XMLResource.XMLMap xmlMap;

        public Collection generate(EPackage ePackage) {
            return this.generate(ePackage, null);
        }

        public Collection generate(EPackage ePackage, XMLResource.XMLMap map) {
            this.xmlMap = map;
            this.addInput((EObject)ePackage);
            this.ePackage = ePackage;
            this.createSchema();
            this.processEnums();
            this.processClasses();
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(this.xsdSchema);
            if (this.emfSchema != null) {
                result.add(this.emfSchema);
            }
            if (this.mappingRoot != null) {
                result.add(this.mappingRoot);
            }
            return result;
        }

        protected void createSchema() {
            this.xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            this.addOutput((EObject)this.xsdSchema);
            this.xsdSchema.setTargetNamespace(this.ePackage.getNsURI());
            this.xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
            Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
            namespaces.put(this.ePackage.getNsPrefix(), this.xsdSchema.getTargetNamespace());
            namespaces.put(this.xsdSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        }

        protected void createEMFSchema() {
            this.emfSchema = XSDFactory.eINSTANCE.createXSDSchema();
            this.emfSchema.setTargetNamespace(EMF_SCHEMA_URI);
            this.emfSchema.setSchemaForSchemaQNamePrefix("xsd");
            Map namespaces = this.emfSchema.getQNamePrefixToNamespaceMap();
            namespaces.put(EMF_SCHEMA_PREFIX, this.emfSchema.getTargetNamespace());
            namespaces.put(this.emfSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
            XSDSimpleTypeDefinition list = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
            list.setName(REFERENCE_TYPE_NAME);
            XSDSimpleTypeDefinition union = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
            union.getMemberTypeDefinitions().add(this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("IDREF"));
            union.getMemberTypeDefinitions().add(this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("QName"));
            union.getMemberTypeDefinitions().add(this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("anyURI"));
            list.setItemTypeDefinition(union);
            list.getContents().add(union);
            this.emfSchema.getContents().add(list);
        }

        protected void addEMFSchema() {
        }

        protected XSDTypeDefinition typeInOtherSchema(EClassifier classifier) {
            EPackage typePkg = classifier.getEPackage();
            Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
            if (namespaces.get(typePkg.getNsPrefix()) == null) {
                namespaces.put(typePkg.getNsPrefix(), typePkg.getNsURI());
                this.addImport(typePkg.getNsURI(), this.getName((ENamedElement)typePkg) + ".xsd");
                this.createOtherSchema(typePkg);
            }
            XSDSchema otherXSDSchema = (XSDSchema)this.ePackageToXSDSchemaMap.get(typePkg);
            return otherXSDSchema.resolveTypeDefinition(this.getName((ENamedElement)classifier));
        }

        protected void addImport(String namespace, String schemaLocation) {
            XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
            xsdImport.setNamespace(namespace);
            xsdImport.setSchemaLocation(schemaLocation);
            this.xsdSchema.getContents().add(0, xsdImport);
        }

        protected void createOtherSchema(EPackage ePackage) {
            XSDSchema otherSchema = XSDFactory.eINSTANCE.createXSDSchema();
            otherSchema.setTargetNamespace(ePackage.getNsURI());
            otherSchema.setSchemaForSchemaQNamePrefix("xsd");
            Map namespaces = otherSchema.getQNamePrefixToNamespaceMap();
            namespaces.put(ePackage.getNsPrefix(), otherSchema.getTargetNamespace());
            namespaces.put(otherSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
            this.ePackageToXSDSchemaMap.put(ePackage, otherSchema);
        }

        protected void processClasses() {
            Iterator classifiers = this.ePackage.getEClassifiers().iterator();
            while (classifiers.hasNext()) {
                EClassifier classifier = (EClassifier)classifiers.next();
                if (!(classifier instanceof EClass)) continue;
                this.processClass((EClass)classifier);
            }
        }

        protected void processEnums() {
            Iterator classifiers = this.ePackage.getEClassifiers().iterator();
            while (classifiers.hasNext()) {
                EClassifier classifier = (EClassifier)classifiers.next();
                if (!(classifier instanceof EEnum)) continue;
                this.processEnum((EEnum)classifier);
            }
        }

        protected XMLResource.XMLInfo getInfo(ENamedElement element) {
            if (this.xmlMap == null) {
                return null;
            }
            return this.xmlMap.getInfo(element);
        }

        protected String getName(ENamedElement element) {
            XMLResource.XMLInfo info = this.getInfo(element);
            if (info == null || info.getName() == null) {
                return element.getName();
            }
            return info.getName();
        }

        protected void processEnum(EEnum eEnum) {
            XSDSimpleTypeDefinition enumType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
            enumType.setName(this.getName((ENamedElement)eEnum));
            enumType.setBaseTypeDefinition(this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("NCName"));
            this.xsdSchema.getContents().add(enumType);
            this.map((XSDComponent)enumType, (EModelElement)eEnum);
            Iterator literals = eEnum.getELiterals().iterator();
            while (literals.hasNext()) {
                EEnumLiteral literal = (EEnumLiteral)literals.next();
                XSDEnumerationFacet facet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
                facet.setLexicalValue(this.getName((ENamedElement)literal));
                enumType.getFacetContents().add(facet);
                this.map((XSDComponent)facet, (EModelElement)literal);
            }
        }

        protected void processClass(EClass eClass) {
            XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            xsdComplexTypeDefinition.setName(this.getName((ENamedElement)eClass));
            EList superClasses = eClass.getESuperTypes();
            if (superClasses.size() > 0) {
                xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
                EClass superClass = (EClass)superClasses.get(0);
                if (superClass.getEPackage() == this.ePackage) {
                    xsdComplexTypeDefinition.setBaseTypeDefinition(this.xsdSchema.resolveTypeDefinition(this.getName((ENamedElement)superClass)));
                } else {
                    xsdComplexTypeDefinition.setBaseTypeDefinition(this.typeInOtherSchema((EClassifier)superClass));
                }
            }
            this.xsdSchema.getContents().add(xsdComplexTypeDefinition);
            this.map((XSDComponent)xsdComplexTypeDefinition, (EModelElement)eClass);
            List features = this.getFeatures(eClass, (List)superClasses);
            Iterator fs = features.iterator();
            while (fs.hasNext()) {
                EStructuralFeature f = (EStructuralFeature)fs.next();
                if (f instanceof EAttribute) {
                    this.processAttribute((EAttribute)f, xsdComplexTypeDefinition);
                    continue;
                }
                if (!(f instanceof EReference)) continue;
                this.processReference((EReference)f, xsdComplexTypeDefinition);
            }
            if (this.makeClassElementDeclaration(eClass)) {
                XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                xsdElementDeclaration.setName(this.getName((ENamedElement)eClass));
                xsdElementDeclaration.setTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
                this.xsdSchema.getContents().add(xsdElementDeclaration);
                this.map((XSDComponent)xsdElementDeclaration, (EModelElement)eClass);
            }
            this.additionalProcessing(eClass, xsdComplexTypeDefinition);
        }

        protected boolean makeClassElementDeclaration(EClass eClass) {
            return !eClass.isAbstract();
        }

        protected void additionalProcessing(EClass cls, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        }

        protected List getFeatures(EClass eClass, List superClasses) {
            ArrayList features = new ArrayList();
            if (superClasses.size() > 0) {
                EList allSupers = ((EClass)superClasses.get(0)).getEAllSuperTypes();
                HashSet allSuperClasses = new HashSet();
                allSuperClasses.addAll(allSupers);
                int i = 1;
                while (i < superClasses.size()) {
                    features.addAll(this.getAllFeatures((EClass)superClasses.get(i), allSuperClasses));
                    ++i;
                }
            }
            features.addAll(eClass.getEAttributes());
            features.addAll(eClass.getEReferences());
            return features;
        }

        protected List getAllFeatures(EClass eClass, Set classesToIgnore) {
            ArrayList features = new ArrayList();
            EList superClasses = eClass.getESuperTypes();
            int i = 0;
            while (i < superClasses.size()) {
                if (!classesToIgnore.contains(superClasses.get(i))) {
                    features.addAll(this.getAllFeatures((EClass)superClasses.get(i), classesToIgnore));
                }
                ++i;
            }
            features.addAll(eClass.getEAttributes());
            features.addAll(eClass.getEReferences());
            return features;
        }

        protected void processAttribute(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            if (this.processAttribute(attribute)) {
                if (this.makeAttributeDeclaration(attribute)) {
                    this.createAttributeDeclaration(attribute, xsdComplexTypeDefinition);
                }
                if (this.makeAttributeElementDeclaration()) {
                    this.createAttributeElementDeclaration(attribute, xsdComplexTypeDefinition);
                }
            }
        }

        protected void createAttributeDeclaration(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attrDecl.setName(this.getName((ENamedElement)attribute));
            this.setAttributeType(attribute, attrDecl);
            this.setDefaultValue(attribute, attrDecl);
            XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            this.setUseToRequired(attribute, attrUse);
            attrUse.setContent(attrDecl);
            xsdComplexTypeDefinition.getAttributeContents().add(attrUse);
            this.map((XSDComponent)attrUse, (EModelElement)attribute);
        }

        protected void createAttributeElementDeclaration(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDModelGroup modelGroup = this.getModelGroup(xsdComplexTypeDefinition);
            XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElementDeclaration.setName(this.getName((ENamedElement)attribute));
            xsdElementDeclaration.setNillable(true);
            XSDSimpleTypeDefinition attrType = this.getType(attribute.getEAttributeType());
            if (attrType != null) {
                xsdElementDeclaration.setTypeDefinition((XSDTypeDefinition)attrType);
            }
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent((XSDParticleContent)xsdElementDeclaration);
            this.setAttributeElementMultiplicity(attribute, particle);
            modelGroup.getContents().add(particle);
            this.map((XSDComponent)particle, (EModelElement)attribute);
        }

        protected void setAttributeElementMultiplicity(EAttribute attribute, XSDParticle particle) {
            if (attribute.isMany()) {
                particle.setMinOccurs(attribute.getLowerBound());
            } else {
                particle.setMinOccurs(0);
            }
            particle.setMaxOccurs(attribute.getUpperBound());
        }

        protected boolean processAttribute(EAttribute attribute) {
            if (attribute.isTransient()) {
                return false;
            }
            EDataType type = attribute.getEAttributeType();
            return type == null || type.isSerializable();
        }

        protected boolean makeAttributeDeclaration(EAttribute attribute) {
            return !attribute.isMany();
        }

        protected boolean makeAttributeElementDeclaration() {
            return true;
        }

        protected XSDModelGroup getModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            if (xsdComplexTypeDefinition.getContent() == null) {
                return this.createModelGroup(xsdComplexTypeDefinition);
            }
            XSDParticle particle = (XSDParticle)xsdComplexTypeDefinition.getContent();
            return (XSDModelGroup)particle.getContent();
        }

        protected XSDModelGroup createModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent((XSDParticleContent)modelGroup);
            xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
            return modelGroup;
        }

        protected void setAttributeType(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
            XSDSimpleTypeDefinition attrType = this.getType(attribute.getEAttributeType());
            if (attrType != null) {
                attrDecl.setTypeDefinition(attrType);
            }
        }

        protected void setUseToRequired(EAttribute attribute, XSDAttributeUse attrUse) {
        }

        protected void setDefaultValue(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
            if (attribute.getDefaultValueLiteral() != null) {
                attrDecl.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                attrDecl.setLexicalValue(attribute.getDefaultValueLiteral());
            }
        }

        protected void processReference(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            if (!this.skipReference(reference)) {
                if (this.makeReferenceAttribute(reference)) {
                    this.makeReferenceAttribute(reference, xsdComplexTypeDefinition);
                }
                if (this.makeReferenceElement(reference)) {
                    this.makeReferenceElement(reference, xsdComplexTypeDefinition);
                }
            }
        }

        protected boolean makeReferenceAttribute(EReference reference) {
            return !reference.isContainment();
        }

        protected boolean makeReferenceElement(EReference reference) {
            return reference.isContainment();
        }

        protected boolean skipReference(EReference reference) {
            return reference.isTransient();
        }

        protected void makeReferenceAttribute(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
            attrDecl.setName(this.getName((ENamedElement)reference));
            this.setReferenceAttribType(attrDecl);
            XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            attrUse.setContent(attrDecl);
            xsdComplexTypeDefinition.getAttributeContents().add(attrUse);
            this.map((XSDComponent)attrUse, (EModelElement)reference);
        }

        protected void setReferenceAttribType(XSDAttributeDeclaration xsdAttributeDeclaration) {
            this.addEMFSchema();
            xsdAttributeDeclaration.setTypeDefinition(this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(REFERENCE_TYPE_NAME));
        }

        protected void makeReferenceElement(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
            XSDModelGroup modelGroup = this.getModelGroup(xsdComplexTypeDefinition);
            XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElementDeclaration.setName(this.getName((ENamedElement)reference));
            this.setReferenceElementType(reference, xsdElementDeclaration);
            XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
            particle.setContent((XSDParticleContent)xsdElementDeclaration);
            this.setReferenceElementMultiplicity(reference, particle);
            modelGroup.getContents().add(particle);
            this.map((XSDComponent)particle, (EModelElement)reference);
        }

        protected void setReferenceElementType(EReference reference, XSDElementDeclaration xsdElementDeclaration) {
            XSDTypeDefinition type;
            if (reference.getEType() != null && (type = reference.getEType().getEPackage() == this.ePackage ? this.xsdSchema.resolveTypeDefinition(this.getName((ENamedElement)reference.getEType())) : this.typeInOtherSchema(reference.getEType())) != null) {
                xsdElementDeclaration.setTypeDefinition(type);
            }
        }

        protected void setReferenceElementMultiplicity(EReference reference, XSDParticle particle) {
            particle.setMinOccurs(reference.getLowerBound());
            particle.setMaxOccurs(reference.getUpperBound());
        }

        protected XSDSimpleTypeDefinition getType(EDataType dataType) {
            if (dataType instanceof EEnum) {
                EPackage typePkg = dataType.getEPackage();
                if (typePkg == this.ePackage) {
                    return this.xsdSchema.resolveSimpleTypeDefinition(this.getName((ENamedElement)dataType));
                }
                return (XSDSimpleTypeDefinition)this.typeInOtherSchema((EClassifier)dataType);
            }
            String name = null;
            if (dataType != null) {
                name = this.getName((ENamedElement)dataType);
            }
            return this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(this.getSchemaName(name));
        }

        private String getSchemaName(String name) {
            String schemaName;
            if (this.ecoreToSchemaName == null) {
                this.ecoreToSchemaName = new HashMap();
                this.ecoreToSchemaName.put("EBoolean", "boolean");
                this.ecoreToSchemaName.put("EBooleanObject", "boolean");
                this.ecoreToSchemaName.put("EInt", "int");
                this.ecoreToSchemaName.put("EIntegerObject", "int");
                this.ecoreToSchemaName.put("ELong", "long");
                this.ecoreToSchemaName.put("ELongObject", "long");
                this.ecoreToSchemaName.put("EFloat", "float");
                this.ecoreToSchemaName.put("EFloatObject", "float");
                this.ecoreToSchemaName.put("EDouble", "double");
                this.ecoreToSchemaName.put("EDoubleObject", "double");
                this.ecoreToSchemaName.put("EString", REFERENCE_TYPE_NAME);
            }
            if ((schemaName = (String)this.ecoreToSchemaName.get(name)) != null) {
                return schemaName;
            }
            return REFERENCE_TYPE_NAME;
        }
    }

    public static class XSDEcoreBuilder
    extends MapBuilder {
        protected static final int TRIVIAL = 1;
        protected int style;
        protected XSDSchema xsdSchema;
        protected Map targetNamespaceToEPackageMap = new HashMap();

        public XSDEcoreBuilder() {
        }

        public XSDEcoreBuilder(int style) {
            this.style = style;
        }

        public XSDSchema getSchema() {
            return this.xsdSchema;
        }

        public Map getTargetNamespaceToEPackageMap() {
            return this.targetNamespaceToEPackageMap;
        }

        public Map getXSDComponentToEModelElementMap() {
            return this.xsdComponentToEModelElementMap;
        }

        public EPackage getEPackage(String targetNamespace) {
            EPackage ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(targetNamespace);
            if (ePackage == null) {
                ePackage = EcoreFactory.eINSTANCE.createEPackage();
                this.addOutput((EObject)ePackage);
                if (targetNamespace == null) {
                    ePackage.setName(this.validName(this.xsdSchema.eResource().getURI().trimFileExtension().lastSegment(), false));
                    ePackage.setNsURI(this.xsdSchema.eResource().getURI().toString());
                } else {
                    URI uri = URI.createURI((String)targetNamespace);
                    String host = uri.host();
                    if (host != null && host.startsWith("www.")) {
                        host = host.substring(4);
                    }
                    List parsedName = this.parseName(host, '.');
                    Collections.reverse(parsedName);
                    if (!parsedName.isEmpty()) {
                        parsedName.set(0, ((String)parsedName.get(0)).toLowerCase());
                    }
                    parsedName.addAll(this.parseName(uri.trimFileExtension().path(), '/'));
                    StringBuffer qualifiedPackageName = new StringBuffer();
                    Iterator i = parsedName.iterator();
                    while (i.hasNext()) {
                        String packageName = (String)i.next();
                        if (packageName.length() <= 0) continue;
                        if (qualifiedPackageName.length() > 0) {
                            qualifiedPackageName.append('.');
                        }
                        qualifiedPackageName.append(this.validName(packageName, false));
                    }
                    ePackage.setName(qualifiedPackageName.toString());
                    ePackage.setNsURI(targetNamespace);
                }
                ePackage.setNsPrefix(ePackage.getName());
                EAnnotation eAnnotation = this.createAnnotation();
                this.addAnnotationDetail(eAnnotation, "representation", "schema");
                this.addAnnotationDetail(eAnnotation, "targetNamespace", targetNamespace);
                ePackage.getEAnnotations().add(eAnnotation);
                this.targetNamespaceToEPackageMap.put(targetNamespace, ePackage);
            }
            return ePackage;
        }

        public EClassifier getEClassifier(XSDTypeDefinition xsdTypeDefinition) {
            EClassifier eClassifier = (EClassifier)this.xsdComponentToEModelElementMap.get(xsdTypeDefinition);
            if (eClassifier == null) {
                if (xsdTypeDefinition instanceof XSDSimpleTypeDefinition) {
                    String name;
                    XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)xsdTypeDefinition;
                    if (XSDConstants.isSchemaForSchemaNamespace((String)xsdSimpleTypeDefinition.getTargetNamespace())) {
                        name = xsdSimpleTypeDefinition.getName();
                        if ((this.style & 1) == 0 && ("anyURI".equals(name) || "QName".equals(name) || "IDREF".equals(name) || "IDREFS".equals(name))) {
                            eClassifier = EcorePackage.eINSTANCE.getEObject();
                        } else if ("string".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEString();
                        } else if ("boolean".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEBoolean();
                        } else if ("float".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEFloat();
                        } else if ("double".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEDouble();
                        } else if ("long".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getELong();
                        } else if ("int".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEInt();
                        } else if ("short".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEShort();
                        } else if ("byte".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEByte();
                        } else if ("unsignedByte".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEShort();
                        } else if ("unsignedShort".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getEInt();
                        } else if ("unsignedShort".equals(name)) {
                            eClassifier = EcorePackage.eINSTANCE.getELong();
                        } else {
                            XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                            if (baseTypeDefinition != null && !XSDConstants.isURType((XSDTypeDefinition)baseTypeDefinition)) {
                                eClassifier = this.getEClassifier((XSDTypeDefinition)baseTypeDefinition);
                            }
                        }
                    } else {
                        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                        if (baseTypeDefinition != null) {
                            if (!xsdSimpleTypeDefinition.getEnumerationFacets().isEmpty() && XSDConstants.isSchemaForSchemaNamespace((String)baseTypeDefinition.getTargetNamespace()) && "NCName".equals(baseTypeDefinition.getName())) {
                                ArrayList<XSDEnumerationFacet> enumerators = new ArrayList<XSDEnumerationFacet>();
                                Iterator i = xsdSimpleTypeDefinition.getEnumerationFacets().iterator();
                                while (i.hasNext()) {
                                    XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i.next();
                                    String enumerator = xsdEnumerationFacet.getLexicalValue();
                                    if (enumerator != null && enumerator.length() != 0) {
                                        if (Character.isJavaIdentifierStart(enumerator.charAt(0))) {
                                            int j = enumerator.length() - 1;
                                            while (j > 0) {
                                                if (!Character.isJavaIdentifierPart(enumerator.charAt(j))) {
                                                    enumerators.clear();
                                                    break;
                                                }
                                                --j;
                                            }
                                        }
                                        enumerators.add(xsdEnumerationFacet);
                                        continue;
                                    }
                                    enumerators.clear();
                                    break;
                                }
                                if (!enumerators.isEmpty()) {
                                    EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                                    ListIterator i2 = enumerators.listIterator();
                                    while (i2.hasNext()) {
                                        XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i2.next();
                                        String enumerator = xsdEnumerationFacet.getLexicalValue();
                                        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                                        eEnumLiteral.setName(enumerator);
                                        eEnumLiteral.setValue(i2.previousIndex());
                                        eEnum.getELiterals().add(eEnumLiteral);
                                        this.map((XSDComponent)xsdEnumerationFacet, (EModelElement)eEnumLiteral);
                                    }
                                    eClassifier = eEnum;
                                }
                            }
                            if (eClassifier == null) {
                                eClassifier = this.getEClassifier((XSDTypeDefinition)baseTypeDefinition);
                            }
                        }
                    }
                    if (eClassifier == null) {
                        eClassifier = EcoreFactory.eINSTANCE.createEDataType();
                        name = "java.lang.String";
                        eClassifier.setInstanceClassName("java.lang.String");
                    }
                } else {
                    EClassifier baseType;
                    XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)xsdTypeDefinition;
                    EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                    this.xsdComponentToEModelElementMap.put(xsdComplexTypeDefinition, eClass);
                    eClassifier = eClass;
                    XSDTypeDefinition baseTypeDefinition = xsdComplexTypeDefinition.getBaseTypeDefinition();
                    if (!XSDConstants.isURType((XSDTypeDefinition)baseTypeDefinition) && (baseType = this.getEClassifier(baseTypeDefinition)) instanceof EClass && baseType != EcorePackage.eINSTANCE.getEObject()) {
                        eClass.getESuperTypes().add(baseType);
                    }
                    if (eClass.getESuperTypes().isEmpty() || xsdComplexTypeDefinition.getDerivationMethod() == XSDDerivationMethod.EXTENSION_LITERAL) {
                        Iterator i;
                        EStructuralFeature eStructuralFeature;
                        if (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
                            if (eClass.getEAllReferences().isEmpty()) {
                                eStructuralFeature = this.createFeature(eClass, "value", this.getEClassifier((XSDTypeDefinition)xsdComplexTypeDefinition.getSimpleType()), null);
                            }
                        } else if ((this.style & 1) != 0 || xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.MIXED_LITERAL) {
                            if (eClass.getEAllReferences().isEmpty()) {
                                eStructuralFeature = this.createFeature(eClass, "contents", (EClassifier)EcorePackage.eINSTANCE.getEObject(), (XSDComponent)xsdComplexTypeDefinition.getComplexType());
                                eStructuralFeature.setLowerBound(0);
                                eStructuralFeature.setUpperBound(-1);
                                if ((this.style & 1) != 0) {
                                    List xsdParticles = this.collectParticles((XSDParticle)xsdComplexTypeDefinition.getContent());
                                    Iterator i3 = xsdParticles.iterator();
                                    while (i3.hasNext()) {
                                        XSDParticle xsdParticle = (XSDParticle)i3.next();
                                        XSDTerm xsdTerm = xsdParticle.getTerm();
                                        if (!(xsdTerm instanceof XSDElementDeclaration)) continue;
                                        this.getEClassifier((XSDElementDeclaration)xsdTerm);
                                    }
                                }
                            }
                        } else if (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.ELEMENT_ONLY_LITERAL && xsdComplexTypeDefinition.getContent() != null) {
                            List xsdParticles = this.collectParticles((XSDParticle)xsdComplexTypeDefinition.getContent());
                            i = xsdParticles.iterator();
                            while (i.hasNext()) {
                                EStructuralFeature eStructuralFeature2;
                                XSDParticle xsdParticle = (XSDParticle)i.next();
                                XSDTerm xsdTerm = xsdParticle.getTerm();
                                if (xsdTerm instanceof XSDModelGroup) {
                                    eStructuralFeature2 = this.createFeature(eClass, "contents", (EClassifier)EcorePackage.eINSTANCE.getEObject(), (XSDComponent)xsdParticle);
                                    eStructuralFeature2.setUpperBound(-1);
                                    continue;
                                }
                                if (xsdTerm instanceof XSDWildcard) {
                                    eStructuralFeature2 = this.createFeature(eClass, "any", (EClassifier)EcorePackage.eINSTANCE.getEObject(), (XSDComponent)xsdParticle);
                                    continue;
                                }
                                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                                EClassifier type = this.getEClassifier(xsdElementDeclaration.getTypeDefinition());
                                if (type instanceof EDataType && xsdElementDeclaration.isGlobal() && xsdElementDeclaration.getDisallowedSubstitutions().size() != 3) {
                                    type = this.getEClassifier(xsdElementDeclaration);
                                }
                                eStructuralFeature2 = this.createFeature(eClass, this.validName(xsdElementDeclaration.getName(), true), type, (XSDComponent)xsdParticle);
                            }
                        }
                        HashSet<String> baseAttributeUses = new HashSet<String>();
                        if (baseTypeDefinition instanceof XSDComplexTypeDefinition) {
                            i = ((XSDComplexTypeDefinition)baseTypeDefinition).getAttributeUses().iterator();
                            while (i.hasNext()) {
                                baseAttributeUses.add(((XSDAttributeUse)i.next()).getAttributeDeclaration().getURI());
                            }
                        }
                        i = xsdComplexTypeDefinition.getAttributeUses().iterator();
                        while (i.hasNext()) {
                            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i.next();
                            if (baseAttributeUses.contains(xsdAttributeUse.getAttributeDeclaration().getURI())) continue;
                            EStructuralFeature eStructuralFeature3 = this.createFeature(eClass, this.validName(xsdAttributeUse.getAttributeDeclaration().getName(), true), this.getEClassifier((XSDTypeDefinition)xsdAttributeUse.getAttributeDeclaration().getTypeDefinition()), (XSDComponent)xsdAttributeUse);
                        }
                    }
                }
                if (eClassifier.eContainer() == null) {
                    eClassifier.setName(this.validName(xsdTypeDefinition.getAliasName(), true));
                    EAnnotation eAnnotation = this.createAnnotation();
                    this.addAnnotationDetail(eAnnotation, "representation", "type");
                    this.addAnnotationDetail(eAnnotation, "name", xsdTypeDefinition.getAliasName());
                    this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdTypeDefinition.getTargetNamespace());
                    eClassifier.getEAnnotations().add(eAnnotation);
                    EPackage ePackage = this.getEPackage(xsdTypeDefinition.getSchema().getTargetNamespace());
                    ePackage.getEClassifiers().add(eClassifier);
                }
                this.map((XSDComponent)xsdTypeDefinition, (EModelElement)eClassifier);
            }
            return eClassifier;
        }

        protected EAnnotation createAnnotation() {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore");
            return eAnnotation;
        }

        protected void addAnnotationDetail(EAnnotation eAnnotation, String key, String value) {
            eAnnotation.getDetails().put((Object)key, (Object)value);
        }

        protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent) {
            if (type instanceof EClass) {
                EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                eReference.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
                eReference.setEType(type);
                eClass.getEReferences().add(eReference);
                if (xsdComponent != null) {
                    this.map(xsdComponent, (EModelElement)eReference);
                    if (xsdComponent instanceof XSDParticle) {
                        eReference.setContainment(true);
                        XSDParticle xsdParticle = (XSDParticle)xsdComponent;
                        eReference.setLowerBound(xsdParticle.getMinOccurs());
                        eReference.setUpperBound(xsdParticle.getMaxOccurs());
                        EAnnotation eAnnotation = this.createAnnotation();
                        XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                        if (xsdTerm instanceof XSDElementDeclaration) {
                            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                            if (xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                                eReference.setContainment(false);
                            }
                            this.addAnnotationDetail(eAnnotation, "representation", "element");
                            this.addAnnotationDetail(eAnnotation, "name", ((XSDElementDeclaration)xsdTerm).getName());
                            this.addAnnotationDetail(eAnnotation, "targetNamespace", ((XSDElementDeclaration)xsdTerm).getTargetNamespace());
                        } else if (xsdTerm instanceof XSDWildcard) {
                            this.addAnnotationDetail(eAnnotation, "representation", "element-wildcard");
                        } else {
                            this.addAnnotationDetail(eAnnotation, "representation", "general-content");
                        }
                        eReference.getEAnnotations().add(eAnnotation);
                    }
                }
                return eReference;
            }
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            eAttribute.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
            eAttribute.setEType(type);
            eClass.getEAttributes().add(eAttribute);
            EAnnotation eAnnotation = this.createAnnotation();
            if (xsdComponent == null) {
                this.addAnnotationDetail(eAnnotation, "representation", "simple-content");
            } else {
                this.map(xsdComponent, (EModelElement)eAttribute);
                if (xsdComponent instanceof XSDAttributeUse) {
                    XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                    this.addAnnotationDetail(eAnnotation, "representation", "attribute");
                    this.addAnnotationDetail(eAnnotation, "name", xsdAttributeDeclaration.getName());
                    this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdAttributeDeclaration.getTargetNamespace());
                    if (xsdAttributeUse.isRequired()) {
                        eAttribute.setLowerBound(1);
                    }
                } else if (xsdComponent instanceof XSDParticle) {
                    XSDParticle xsdParticle = (XSDParticle)xsdComponent;
                    eAttribute.setLowerBound(xsdParticle.getMinOccurs());
                    eAttribute.setUpperBound(xsdParticle.getMaxOccurs());
                    XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                    if (xsdTerm instanceof XSDElementDeclaration) {
                        this.addAnnotationDetail(eAnnotation, "representation", "element");
                        this.addAnnotationDetail(eAnnotation, "name", ((XSDElementDeclaration)xsdTerm).getName());
                        this.addAnnotationDetail(eAnnotation, "targetNamespace", ((XSDElementDeclaration)xsdTerm).getTargetNamespace());
                    } else if (xsdTerm instanceof XSDWildcard) {
                        this.addAnnotationDetail(eAnnotation, "representation", "element-wildcard");
                    } else {
                        this.addAnnotationDetail(eAnnotation, "representation", "general-content");
                    }
                } else if (xsdComponent instanceof XSDWildcard) {
                    this.addAnnotationDetail(eAnnotation, "representation", "attribute-wildcard");
                }
            }
            eAttribute.getEAnnotations().add(eAnnotation);
            return eAttribute;
        }

        public List collectParticles(XSDParticle xsdParticle) {
            ArrayList result = new ArrayList();
            this.collectParticlesHelper(result, xsdParticle);
            return result;
        }

        public void collectParticlesHelper(List result, XSDParticle xsdParticle) {
            if ((this.style & 1) != 0 || xsdParticle.getMaxOccurs() == 1) {
                XSDTerm xsdTerm = xsdParticle.getTerm();
                if (xsdTerm instanceof XSDModelGroup) {
                    Iterator i = ((XSDModelGroup)xsdTerm).getParticles().iterator();
                    while (i.hasNext()) {
                        XSDParticle childXSDParticle = (XSDParticle)i.next();
                        this.collectParticlesHelper(result, childXSDParticle);
                    }
                } else {
                    result.add(xsdParticle);
                }
            } else {
                result.add(xsdParticle);
            }
        }

        public EClassifier getEClassifier(XSDElementDeclaration xsdElementDeclaration) {
            EClassifier eClassifier = (EClassifier)this.xsdComponentToEModelElementMap.get(xsdElementDeclaration);
            if (eClassifier == null) {
                EClass elementEClass;
                EClassifier type = this.getEClassifier(xsdElementDeclaration.getType());
                if (xsdElementDeclaration.getAnonymousTypeDefinition() != null && type instanceof EClass) {
                    elementEClass = (EClass)type;
                    elementEClass.getEAnnotations().clear();
                } else {
                    elementEClass = EcoreFactory.eINSTANCE.createEClass();
                    EPackage ePackage = this.getEPackage(xsdElementDeclaration.getSchema().getTargetNamespace());
                    ePackage.getEClassifiers().add(elementEClass);
                }
                elementEClass.setName(this.validName(xsdElementDeclaration.getName(), true));
                EAnnotation eAnnotation = this.createAnnotation();
                this.addAnnotationDetail(eAnnotation, "representation", "element");
                this.addAnnotationDetail(eAnnotation, "name", xsdElementDeclaration.getAliasName());
                this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdElementDeclaration.getTargetNamespace());
                elementEClass.getEAnnotations().add(eAnnotation);
                XSDElementDeclaration substitutionGroupAffiliation = xsdElementDeclaration.getSubstitutionGroupAffiliation();
                if (substitutionGroupAffiliation != null) {
                    elementEClass.getESuperTypes().add(this.getEClassifier(substitutionGroupAffiliation));
                }
                if (type instanceof EClass) {
                    if (type != elementEClass && type != EcorePackage.eINSTANCE.getEObject()) {
                        elementEClass.getESuperTypes().add(type);
                    }
                } else if (elementEClass.getEAllReferences().isEmpty()) {
                    EStructuralFeature eStructuralFeature = this.createFeature(elementEClass, "value", type, null);
                }
                this.map((XSDComponent)xsdElementDeclaration, (EModelElement)elementEClass);
                eClassifier = elementEClass;
            }
            return eClassifier;
        }

        public Collection generate(URI uri) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof XSDSchema) {
                this.generate((XSDSchema)resource.getContents().get(0));
            }
            ArrayList result = new ArrayList(this.targetNamespaceToEPackageMap.values());
            result.add(this.mappingRoot);
            return result;
        }

        public Collection generateResources(URI uri) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof XSDSchema) {
                this.generate((XSDSchema)resource.getContents().get(0));
            }
            Iterator i = this.targetNamespaceToEPackageMap.values().iterator();
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                Resource ecoreResource = resourceSet.createResource(URI.createURI((String)"*.ecore"));
                ecoreResource.setURI(URI.createURI((String)(ePackage.getNsURI().endsWith(".ecore") ? ePackage.getNsURI() : ePackage.getNsURI() + ".ecore")));
                ecoreResource.getContents().add(ePackage);
            }
            return resourceSet.getResources();
        }

        public void generate(XSDSchema xsdSchema) {
            this.xsdSchema = xsdSchema;
            this.addInput((EObject)xsdSchema);
            Iterator i = xsdSchema.getElementDeclarations().iterator();
            while (i.hasNext()) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)i.next();
                EClassifier eClassifier = this.getEClassifier(xsdElementDeclaration);
            }
            Iterator i2 = xsdSchema.getTypeDefinitions().iterator();
            while (i2.hasNext()) {
                XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)i2.next();
                EClassifier eClassifier = this.getEClassifier(xsdTypeDefinition);
            }
        }

        protected String validName(String name, boolean isUpperCase) {
            List parsedName = this.parseName(name, '_');
            StringBuffer result = new StringBuffer();
            Iterator i = parsedName.iterator();
            while (i.hasNext()) {
                String nameComponent = (String)i.next();
                if (nameComponent.length() <= 0) continue;
                result.append(Character.toUpperCase(nameComponent.charAt(0)));
                result.append(nameComponent.substring(1));
            }
            return result.length() == 0 ? "_" : (Character.isJavaIdentifierStart(result.charAt(0)) ? (isUpperCase ? result.toString() : this.uncapName(result.toString())) : "_" + result);
        }

        protected List parseName(String sourceName, char separator) {
            ArrayList<String> result = new ArrayList<String>();
            if (sourceName != null) {
                StringBuffer currentWord = new StringBuffer();
                boolean lastIsLower = false;
                int index = 0;
                int length = sourceName.length();
                while (index < length) {
                    char curChar = sourceName.charAt(index);
                    if (!Character.isJavaIdentifierPart(curChar)) {
                        curChar = separator;
                    }
                    if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                        if ((lastIsLower || curChar == separator) && currentWord.length() > 0) {
                            result.add(currentWord.toString());
                            currentWord = new StringBuffer();
                        }
                        lastIsLower = false;
                    } else {
                        int currentWordLength;
                        if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                            char lastChar = currentWord.charAt(--currentWordLength);
                            currentWord.setLength(currentWordLength);
                            result.add(currentWord.toString());
                            currentWord = new StringBuffer();
                            currentWord.append(lastChar);
                        }
                        lastIsLower = true;
                    }
                    if (curChar != separator) {
                        currentWord.append(curChar);
                    }
                    ++index;
                }
                result.add(currentWord.toString());
            }
            return result;
        }

        public String uncapName(String name) {
            if (name.length() == 0) {
                return name;
            }
            String lowerName = name.toLowerCase();
            int i = 0;
            while (i < name.length()) {
                if (name.charAt(i) == lowerName.charAt(i)) break;
                ++i;
            }
            if (i > 1 && i < name.length()) {
                --i;
            }
            return name.substring(0, i).toLowerCase() + name.substring(i);
        }
    }

    public static class MapBuilder {
        protected EObject mappingRoot;
        protected Object mapper;
        protected Method mapMethod;
        protected Method addInputMethod;
        protected Method addOutputMethod;
        protected Map xsdComponentToEModelElementMap = new HashMap();
        static /* synthetic */ Class class$java$util$Collection;
        static /* synthetic */ Class class$org$eclipse$emf$ecore$EObject;

        public MapBuilder() {
            if (Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.emf.mapping.xsd2ecore.editor") != null) {
                Plugin plugin = Platform.getPlugin((String)"org.eclipse.emf.mapping.xsd2ecore.editor");
                try {
                    Class<?> theClass = plugin.getClass().getClassLoader().loadClass("org.eclipse.emf.mapping.xsd2ecore.presentation.XSD2EcoreEditor$XSD2EcoreMapper");
                    this.mapper = theClass.newInstance();
                    this.mapMethod = theClass.getDeclaredMethod("map", class$java$util$Collection == null ? (class$java$util$Collection = MapBuilder.class$("java.util.Collection")) : class$java$util$Collection, class$java$util$Collection == null ? (class$java$util$Collection = MapBuilder.class$("java.util.Collection")) : class$java$util$Collection);
                    this.addInputMethod = theClass.getDeclaredMethod("addInput", class$org$eclipse$emf$ecore$EObject == null ? (class$org$eclipse$emf$ecore$EObject = MapBuilder.class$("org.eclipse.emf.ecore.EObject")) : class$org$eclipse$emf$ecore$EObject);
                    this.addOutputMethod = theClass.getDeclaredMethod("addOutput", class$org$eclipse$emf$ecore$EObject == null ? (class$org$eclipse$emf$ecore$EObject = MapBuilder.class$("org.eclipse.emf.ecore.EObject")) : class$org$eclipse$emf$ecore$EObject);
                }
                catch (IllegalAccessException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
                catch (NoSuchMethodException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
                catch (InstantiationException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
                catch (ClassNotFoundException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
        }

        protected void map(XSDComponent xsdComponent, EModelElement eModelElement) {
            if (this.mapMethod != null) {
                try {
                    this.mappingRoot = (EObject)this.mapMethod.invoke(this.mapper, Collections.singleton(xsdComponent), Collections.singleton(eModelElement));
                }
                catch (InvocationTargetException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
                catch (IllegalAccessException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
            this.xsdComponentToEModelElementMap.put(xsdComponent, eModelElement);
        }

        protected void addInput(EObject eObject) {
            if (this.addInputMethod != null) {
                try {
                    this.mappingRoot = (EObject)this.addInputMethod.invoke(this.mapper, eObject);
                }
                catch (InvocationTargetException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
                catch (IllegalAccessException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
        }

        protected void addOutput(EObject eObject) {
            if (this.addOutputMethod != null) {
                try {
                    this.mappingRoot = (EObject)this.addOutputMethod.invoke(this.mapper, eObject);
                }
                catch (InvocationTargetException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
                catch (IllegalAccessException exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class SelectUseAction
    extends SelectObjectAction {
        boolean isForward;

        public SelectUseAction(boolean isForward, StructuredViewer structuredViewer) {
            super(structuredViewer, isForward ? "Select &Next Use" : "Select &Previous Use", ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/elcl16/SelectNextUseObject" : "full/elcl16/SelectPreviousUseObject")));
            this.isForward = isForward;
            this.setHoverImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/clcl16/SelectNextUseObject" : "full/clcl16/SelectPreviousUseObject")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/dlcl16/SelectNextUseObject" : "full/dlcl16/SelectPreviousUseObject")));
        }

        public void updateAction() {
            this.setCurrentObjects(((IStructuredSelection)this.structuredViewer.getSelection()).toList());
        }

        public void setCurrentObjects(List objects) {
            XSDConcreteComponent result = null;
            ArrayList<XSDConcreteComponent> resolvedObjects = new ArrayList<XSDConcreteComponent>();
            Iterator i = objects.iterator();
            while (i.hasNext()) {
                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)i.next();
                XSDConcreteComponent resolvedObject = XSDEditor.getResolvedObject(xsdConcreteComponent);
                if (resolvedObject == this) continue;
                resolvedObjects.add(resolvedObject);
            }
            boolean isStarted = false;
            TreeIterator tree = XSDEditor.this.editingDomain.treeIterator((Object)XSDEditor.this.xsdSchema);
            while (tree.hasNext()) {
                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)tree.next();
                if (!this.isForward && objects.contains(xsdConcreteComponent)) break;
                if (isStarted || !this.isForward) {
                    XSDConcreteComponent resolvedObject = XSDEditor.getResolvedObject(xsdConcreteComponent);
                    if (!resolvedObjects.contains(resolvedObject)) continue;
                    if (isStarted) {
                        result = xsdConcreteComponent;
                        break;
                    }
                    result = xsdConcreteComponent;
                    continue;
                }
                if (!objects.contains(xsdConcreteComponent)) continue;
                isStarted = true;
            }
            this.setObjectToSelect(result);
        }
    }

    class SelectDiagnosticAction
    extends SelectObjectAction {
        boolean isForward;

        public SelectDiagnosticAction(boolean isForward, StructuredViewer structuredViewer) {
            super(structuredViewer, isForward ? "Select &Next Diagnosed Object" : "Select &Previous Diagnosed Object", ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/elcl16/SelectNextDiagnosticObject" : "full/elcl16/SelectPreviousDiagnosticObject")));
            this.isForward = isForward;
            this.setHoverImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/clcl16/SelectNextDiagnosticObject" : "full/clcl16/SelectPreviousDiagnosticObject")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/dlcl16/SelectNextDiagnosticObject" : "full/dlcl16/SelectPreviousDiagnosticObject")));
        }

        public void updateAction() {
            this.setCurrentObjects(((IStructuredSelection)this.structuredViewer.getSelection()).toList());
        }

        public void setCurrentObjects(List objects) {
            XSDConcreteComponent result = null;
            boolean isStarted = false;
            TreeIterator tree = XSDEditor.this.editingDomain.treeIterator((Object)XSDEditor.this.xsdSchema);
            while (tree.hasNext()) {
                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)tree.next();
                if (!this.isForward && objects.contains(xsdConcreteComponent)) break;
                if (isStarted || !this.isForward) {
                    if (xsdConcreteComponent.getDiagnostics().isEmpty() && (!(xsdConcreteComponent instanceof XSDParticle) || ((XSDParticle)xsdConcreteComponent).getContent().getDiagnostics().isEmpty()) && (!(xsdConcreteComponent instanceof XSDAttributeUse) || ((XSDAttributeUse)xsdConcreteComponent).getContent().getDiagnostics().isEmpty())) continue;
                    if (isStarted) {
                        result = xsdConcreteComponent;
                        break;
                    }
                    result = xsdConcreteComponent;
                    continue;
                }
                if (!objects.contains(xsdConcreteComponent)) continue;
                isStarted = true;
            }
            this.setObjectToSelect(result);
        }
    }

    class SelectObjectAction
    extends Action {
        protected Collection objectsToSelect;
        protected StructuredViewer structuredViewer;

        public SelectObjectAction(StructuredViewer structuredViewer, String text, ImageDescriptor imageDescriptor) {
            super(text, imageDescriptor);
            this.structuredViewer = structuredViewer;
            this.setEnabled(false);
        }

        public void setObjectToSelect(Object objectToSelect) {
            this.setObjectsToSelect(objectToSelect != null ? Collections.singleton(objectToSelect) : Collections.EMPTY_LIST);
        }

        public void setObjectsToSelect(Collection objectsToSelect) {
            this.objectsToSelect = new ArrayList(objectsToSelect);
            this.setEnabled(!objectsToSelect.isEmpty());
        }

        public void run() {
            this.structuredViewer.setSelection((ISelection)new StructuredSelection(this.objectsToSelect.toArray()), true);
        }
    }

    public static class ActionBarContributor
    extends EditingDomainActionBarContributor
    implements ISelectionChangedListener {
        protected IEditorPart activeEditorPart;
        protected ISelectionProvider selectionProvider;
        protected Collection createChildActions = Collections.EMPTY_LIST;
        protected IMenuManager createChildMenuManager;
        protected Collection createSiblingActions = Collections.EMPTY_LIST;
        protected IMenuManager createSiblingMenuManager;

        public void contributeToMenu(IMenuManager menuManager) {
            super.contributeToMenu(menuManager);
            MenuManager submenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditor_menu"), "org.eclipse.xsdMenuID");
            menuManager.insertAfter("additions", (IContributionItem)submenuManager);
            submenuManager.add((IContributionItem)new Separator("settings"));
            submenuManager.add((IContributionItem)new Separator("additions"));
            this.createChildMenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
            this.createSiblingMenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
            submenuManager.insertBefore("additions", (IContributionItem)new Separator("actions"));
            submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
            submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            toolBarManager.add((IContributionItem)new Separator("xsd-settings"));
            toolBarManager.add((IContributionItem)new Separator("xsd-additions"));
        }

        public void setActiveEditor(IEditorPart part) {
            super.setActiveEditor(part);
            this.activeEditorPart = part;
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.createChildMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
            }
            if (this.createSiblingMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
            }
            Collection newChildDescriptors = Collections.EMPTY_LIST;
            Collection newSiblingDescriptors = Collections.EMPTY_LIST;
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() == 1) {
                Object object = ((IStructuredSelection)sel).getFirstElement();
                EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
                newChildDescriptors = domain.getNewChildDescriptors(object, null);
                newSiblingDescriptors = domain.getNewChildDescriptors(domain.getParent(object), object);
            }
            this.createChildActions = this.generateCreateChildActions(newChildDescriptors, sel);
            this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, sel);
            if (this.createChildMenuManager != null) {
                this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
                this.createChildMenuManager.update(true);
            }
            if (this.createSiblingMenuManager != null) {
                this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
                this.createSiblingMenuManager.update(true);
            }
        }

        protected Collection generateCreateChildActions(Collection descriptors, ISelection sel) {
            LinkedList<CreateChildAction> actions = new LinkedList<CreateChildAction>();
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateChildAction(this.activeEditorPart, sel, i.next()));
            }
            return actions;
        }

        protected Collection generateCreateSiblingActions(Collection descriptors, ISelection sel) {
            LinkedList<CreateSiblingAction> actions = new LinkedList<CreateSiblingAction>();
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new CreateSiblingAction(this.activeEditorPart, sel, i.next()));
            }
            return actions;
        }

        protected void populateManager(IContributionManager manager, Collection actions, String ID) {
            Iterator i = actions.iterator();
            while (i.hasNext()) {
                IAction action = (IAction)i.next();
                if (ID != null) {
                    manager.insertBefore(ID, action);
                    continue;
                }
                manager.add(action);
            }
        }

        protected void depopulateManager(IContributionManager manager, Collection actions) {
            IContributionItem[] item = manager.getItems();
            int i = 0;
            while (i < item.length) {
                IAction action;
                IContributionItem curItem = item[i];
                while (curItem instanceof SubContributionItem) {
                    curItem = ((SubContributionItem)curItem).getInnerItem();
                }
                if (curItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)curItem).getAction())) {
                    manager.remove(curItem);
                }
                ++i;
            }
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            super.menuAboutToShow(menuManager);
            menuManager.insertAfter("additions", (IContributionItem)new Separator());
            MenuManager submenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
            menuManager.insertAfter("additions", (IContributionItem)submenuManager);
            submenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        }
    }
}

