/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaCompositorImpl;
import org.eclipse.xsd.impl.XSDSchemaDirectiveImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDIncludeImpl
extends XSDSchemaCompositorImpl
implements XSDInclude {
    protected XSDAnnotation annotation = null;

    public static XSDInclude createInclude(Node node) {
        if (XSDConstants.nodeType(node) == 18) {
            XSDInclude xsdInclude = XSDFactory.eINSTANCE.createXSDInclude();
            xsdInclude.setElement((Element)node);
            return xsdInclude;
        }
        return null;
    }

    protected XSDIncludeImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDInclude();
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            if (msgs == null) {
                msgs = new NotificationChainImpl(4);
            }
            msgs.add((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldAnnotation, (Object)newAnnotation));
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (baseClass == null ? featureID : this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getSchemaLocation();
            }
            case 6: {
                return this.getResolvedSchema();
            }
            case 7: {
                return this.getIncorporatedSchema();
            }
            case 8: {
                return this.getAnnotation();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setSchemaLocation((String)newValue);
                return;
            }
            case 6: {
                this.setResolvedSchema((XSDSchema)newValue);
                return;
            }
            case 7: {
                this.setIncorporatedSchema((XSDSchema)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                this.setElement(XSDConcreteComponentImpl.ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setSchemaLocation(XSDSchemaDirectiveImpl.SCHEMA_LOCATION_EDEFAULT);
                return;
            }
            case 6: {
                this.setResolvedSchema(null);
                return;
            }
            case 7: {
                this.setIncorporatedSchema(null);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass())) {
            case 0: {
                return XSDConcreteComponentImpl.ELEMENT_EDEFAULT == null ? this.element != null : !XSDConcreteComponentImpl.ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return XSDSchemaDirectiveImpl.SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !XSDSchemaDirectiveImpl.SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
            case 6: {
                return this.resolvedSchema != null;
            }
            case 7: {
                return this.incorporatedSchema != null;
            }
            case 8: {
                return this.annotation != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public Element createElement() {
        Element newElement = this.createElement(18);
        this.setElement(newElement);
        return newElement;
    }

    protected void patch() {
        this.resolve(null, this.getSchemaLocation());
        super.patch();
    }

    protected void handleResolvedSchema(XSDSchema xsdSchema) {
        if (xsdSchema == null) {
            this.setResolvedSchema(null);
            this.setIncorporatedSchema(null);
        } else {
            ((XSDSchemaImpl)xsdSchema).included(this);
        }
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-include", theElement, new String[]{"id", "schemaLocation"});
            this.checkComplexContent("annotated", "http://www.w3.org/TR/xmlschema-1/", "element-include", theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-include", theElement, "id", false);
        }
        this.checkBuiltInTypeConstraint("anyURI", this.getSchemaLocation(), "http://www.w3.org/TR/xmlschema-1/", "element-include", theElement, "schemaLocation", true);
        XSDSchema theResolvedSchema = this.getResolvedSchema();
        if (theResolvedSchema == null) {
            this.createDiagnostic(XSDDiagnosticSeverity.WARNING_LITERAL, "src-include.0", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else if (theResolvedSchema.eResource() == null || theResolvedSchema.getElement() == null || XSDConstants.nodeType(theResolvedSchema.getElement()) != 33) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-include.1", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else {
            XSDSchema theSchema = this.getSchema();
            boolean bl = theSchema.getTargetNamespace() == null ? theResolvedSchema.getTargetNamespace() != null : !theSchema.getTargetNamespace().equals(theResolvedSchema.getTargetNamespace()) && theResolvedSchema.getTargetNamespace() != null;
            if (bl) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-include.2", theResolvedSchema.getTargetNamespace() == null ? "" : theResolvedSchema.getTargetNamespace(), theSchema.getTargetNamespace() == null ? "" : theSchema.getTargetNamespace());
            }
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDIncludeImpl clonedInclude = (XSDIncludeImpl)this.getXSDFactory().createXSDInclude();
        clonedInclude.isReconciling = true;
        clonedInclude.setSchemaLocation(this.getSchemaLocation());
        if (deep && this.getAnnotation() != null) {
            clonedInclude.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedInclude.setElement(this.getElement());
        }
        clonedInclude.isReconciling = shareDOM;
        return clonedInclude;
    }
}

