/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XSDParser
extends DefaultHandler {
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected XSDFactory xsdFactory;
    protected XSDSchema xsdSchema;
    protected List xsdDiagnostics;
    protected SAXParser saxParser;
    protected Document document;
    protected Stack stack;
    protected Element element;
    protected Locator locator;
    protected int line;
    protected int column;

    public static Map getUserData(Node node) {
        Map result = null;
        if (node instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)node;
            Object userData = nodeImpl.getUserData();
            if (userData == null) {
                result = new HashMap();
                nodeImpl.setUserData(result);
            } else if (userData instanceof Map) {
                result = (Map)userData;
            }
        }
        return result;
    }

    public static int getStartLine(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("startLine");
        return result == null ? 1 : result;
    }

    public static int getStartColumn(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("startColumn");
        return result == null ? 1 : result;
    }

    public static int getEndLine(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("endLine");
        return result == null ? 1 : result;
    }

    public static int getEndColumn(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("endColumn");
        return result == null ? 1 : result;
    }

    public XSDParser() {
        block5: {
            this.xsdFactory = XSDFactory.eINSTANCE;
            this.xsdDiagnostics = new ArrayList();
            this.stack = new Stack();
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                    saxParserFactory.setValidating(false);
                    saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
                    saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                    saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    this.saxParser = saxParserFactory.newSAXParser();
                }
                catch (SAXException exception) {
                    this.fatalError(exception);
                    Object var5_5 = null;
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                    break block5;
                }
                catch (ParserConfigurationException exception) {
                    this.fatalError(exception);
                    Object var5_6 = null;
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                }
                Object var5_4 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
                throw throwable;
            }
        }
    }

    public void parse(String uri) {
        block3: {
            try {
                this.saxParser.parse(new InputSource(uri), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public void parse(InputStream inputStream) {
        block3: {
            try {
                this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setSchema(XSDSchema xsdSchema) {
        if (this.document != null) {
            this.xsdSchema = xsdSchema;
            Element element = this.document.getDocumentElement();
            if (element != null) {
                xsdSchema.setElement(element);
            }
            xsdSchema.clearDiagnostics();
            XSDResourceImpl.assignDiagnostics(xsdSchema, this.xsdDiagnostics);
        }
    }

    public XSDSchema getSchema() {
        if (this.xsdSchema == null && this.document != null) {
            Element element = this.document.getDocumentElement();
            this.xsdSchema = element == null ? this.xsdFactory.createXSDSchema() : XSDSchemaImpl.createSchema(element);
            XSDResourceImpl.assignDiagnostics(this.xsdSchema, this.xsdDiagnostics);
        }
        return this.xsdSchema;
    }

    public Collection getDiagnostics() {
        return this.xsdDiagnostics;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element newElement = this.document.createElementNS(uri, qName);
        int i = 0;
        int length = attributes.getLength();
        while (i < length) {
            String attributeURI = attributes.getURI(i);
            String attributeQName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            if (attributeQName.equals("xmlns") || attributeQName.startsWith("xmlns:")) {
                attributeURI = "http://www.w3.org/2000/xmlns/";
            } else if ("".equals(attributeURI)) {
                attributeURI = null;
            }
            newElement.setAttributeNS(attributeURI, attributeQName, attributeValue);
            ++i;
        }
        if (this.stack.isEmpty()) {
            this.document.appendChild(newElement);
        } else {
            this.element.appendChild(newElement);
        }
        this.stack.push(this.element);
        this.element = newElement;
        Map extendedAttributes = XSDParser.getUserData(this.element);
        extendedAttributes.put("startLine", new Integer(this.line));
        extendedAttributes.put("startColumn", new Integer(this.column));
        this.saveLocation();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.saveLocation();
        Map extendedAttributes = XSDParser.getUserData(this.element);
        extendedAttributes.put("endLine", new Integer(this.line));
        extendedAttributes.put("endColumn", new Integer(this.column));
        this.element = (Element)this.stack.pop();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startDocument() {
        this.saveLocation();
        this.document = new DocumentImpl();
        this.xsdSchema = null;
    }

    public void endDocument() {
        this.saveLocation();
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        Text textNode = this.document.createTextNode(new String(characters, start, length));
        this.element.appendChild(textNode);
        this.saveLocation();
    }

    protected void fatalError(IOException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void fatalError(ParserConfigurationException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void error(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void warning(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.WARNING_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void saveLocation() {
        this.line = this.locator.getLineNumber();
        this.column = this.locator.getColumnNumber();
    }
}

