/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSDResourceImpl
extends ResourceImpl {
    public static String XSD_TRACK_LOCATION = "XSD_TRACK_LOCATION";
    public static String XSD_PROGRESS_MONITOR = "XSD_PROGRESS_MONITOR";
    static /* synthetic */ Class class$org$eclipse$xsd$util$XSDResourceFactoryImpl;

    public static void serialize(OutputStream outputStream, Element element) {
        try {
            XSDResourceImpl.doSerialize(outputStream, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void doSerialize(OutputStream outputStream, Element element) throws IOException {
        OutputFormat outputFormat = new OutputFormat(element.getOwnerDocument());
        outputFormat.setLineWidth(80);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(4);
        outputFormat.setPreserveSpace(false);
        XMLSerializer serializer = new XMLSerializer(outputStream, outputFormat);
        serializer.serialize(element);
    }

    protected static Document getDocument(InputStream inputStream, ErrorHandler errorHandler) throws IOException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Document document;
                Thread.currentThread().setContextClassLoader((class$org$eclipse$xsd$util$XSDResourceFactoryImpl == null ? (class$org$eclipse$xsd$util$XSDResourceFactoryImpl = XSDResourceImpl.class$("org.eclipse.xsd.util.XSDResourceFactoryImpl")) : class$org$eclipse$xsd$util$XSDResourceFactoryImpl).getClassLoader());
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                EntityResolver entityResolver = XSDResourceImpl.createEntityResolver();
                documentBuilder.setEntityResolver(entityResolver);
                documentBuilder.setErrorHandler(errorHandler);
                Document document2 = document = documentBuilder.parse(inputStream);
                Object var9_10 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
                return document2;
            }
            catch (ParserConfigurationException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
            catch (SAXException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            throw throwable;
        }
    }

    protected static EntityResolver createEntityResolver() {
        final String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
        DefaultHandler entityResolver = new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                InputSource inputSource;
                if ("-//W3C//DTD XMLSCHEMA 200102//EN".equals(publicId) || "http://www.w3.org/2001/XMLSchema.dtd".equals(systemId)) {
                    inputSource = new InputSource(baseURL + "cache/www.w3.org/2001/XMLSchema.dtd");
                    inputSource.setPublicId(publicId);
                } else {
                    inputSource = super.resolveEntity(publicId, systemId);
                }
                return inputSource;
            }
        };
        return entityResolver;
    }

    protected static void assignDiagnostics(XSDSchema xsdSchema, Collection xsdDiagnostics) {
        if (!xsdDiagnostics.isEmpty()) {
            xsdSchema.getDiagnostics().addAll(xsdDiagnostics);
            Iterator i = xsdDiagnostics.iterator();
            while (i.hasNext()) {
                XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i.next();
                xsdDiagnostic.getComponents().add(xsdSchema);
                if (xsdSchema.getElement() == null) continue;
                xsdDiagnostic.setNode(xsdSchema.getElement());
            }
        }
    }

    public XSDResourceImpl() {
    }

    public XSDResourceImpl(URI uri) {
        super(uri);
    }

    protected void doSave(OutputStream os, Map options) throws IOException {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            Element element = xsdSchema.getElement();
            if (element == null) {
                xsdSchema.updateElement();
                element = xsdSchema.getElement();
            }
            XSDResourceImpl.doSerialize(os, element);
        }
    }

    public XSDSchema getSchema() {
        return this.getContents().size() == 1 && this.getContents().get(0) instanceof XSDSchema ? (XSDSchema)this.getContents().get(0) : null;
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        XSDSchema xsdSchema;
        XSDParser xsdParser;
        IProgressMonitor progressMonitor;
        block15: {
            progressMonitor = null;
            Object monitor = options.get("XSD_PROGRESS_MONITOR");
            if (monitor != null) {
                progressMonitor = (IProgressMonitor)monitor;
                progressMonitor.setTaskName(XSDPlugin.INSTANCE.getString("_UI_ResourceLoad_progress"));
                progressMonitor.subTask(this.getURI().toString());
            }
            xsdParser = new XSDParser();
            xsdSchema = null;
            try {
                Document document;
                if (Boolean.TRUE.equals(options.get("XSD_TRACK_LOCATION"))) {
                    xsdParser.parse(inputStream);
                    document = xsdParser.getDocument();
                } else {
                    document = XSDResourceImpl.getDocument(inputStream, xsdParser);
                }
                if (document != null && document.getDocumentElement() != null) {
                    ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
                    Object oldMonitor = globalResourceSet.getLoadOptions().get("XSD_PROGRESS_MONITOR");
                    try {
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", progressMonitor);
                        xsdSchema = options.containsKey("XSD_MAGIC_XML_SCHEMA") || options.containsKey("XSD_XML_SCHEMA") ? XSDSchemaImpl.createMetaSchema(document.getDocumentElement()) : XSDSchemaImpl.createSchema(document.getDocumentElement());
                        Object var11_11 = null;
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", oldMonitor);
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", oldMonitor);
                        throw throwable;
                    }
                    {
                        break block15;
                    }
                }
                xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
                xsdSchema.getQNamePrefixToNamespaceMap().put(null, "http://www.w3.org/2001/XMLSchema");
            }
            catch (Exception exception) {
                XSDPlugin.INSTANCE.log(exception);
                xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
                xsdSchema.getQNamePrefixToNamespaceMap().put(null, "http://www.w3.org/2001/XMLSchema");
            }
        }
        if (xsdSchema != null) {
            this.getContents().add(xsdSchema);
            XSDResourceImpl.assignDiagnostics(xsdSchema, xsdParser.getDiagnostics());
            Iterator diagnostics = xsdParser.getDiagnostics().iterator();
            while (diagnostics.hasNext()) {
                XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)diagnostics.next();
                switch (xsdDiagnostic.getSeverity().getValue()) {
                    case 0: 
                    case 1: {
                        this.getErrors().add(xsdDiagnostic);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.getWarnings().add(xsdDiagnostic);
                    }
                }
            }
        }
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
    }

    public void attached(EObject eObject) {
        super.attached(eObject);
        if (eObject instanceof XSDSchema) {
            ((XSDSchema)eObject).setSchemaLocation(this.getURI().toString());
        }
    }

    public String getURIFragment(EObject eObject) {
        XSDConcreteComponent xsdConcreteComponent;
        Element theElement;
        if (eObject instanceof XSDConcreteComponent && (theElement = (xsdConcreteComponent = (XSDConcreteComponent)eObject).getElement()) != null && theElement.hasAttributeNS(null, "id") && theElement.getOwnerDocument().getElementById(theElement.getAttributeNS(null, "id")) == theElement) {
            return theElement.getAttributeNS(null, "id");
        }
        return super.getURIFragment(eObject);
    }

    public EObject getEObject(String uriFragment) {
        Element theElement;
        if (!uriFragment.startsWith("/") && (theElement = this.getSchema().getElement()) != null) {
            Element resultElement = theElement.getOwnerDocument().getElementById(uriFragment);
            ArrayList<Element> parents = new ArrayList<Element>();
            Node parent = resultElement;
            while (parent != null) {
                if (parent.getNodeType() == 1) {
                    parents.add((Element)parent);
                }
                parent = parent.getParentNode();
            }
            return ((XSDSchemaImpl)this.getSchema()).getBestConcreteComponent(parents);
        }
        return super.getEObject(uriFragment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

