/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public abstract class XSDSchemaQueryTools {
    public static List findTypesDerivedFrom(XSDSchema schema, String namespace, String localName) {
        if (null == schema || null == localName) {
            throw new IllegalArgumentException("findTypesDerivedFrom called with null schema/localName");
        }
        ArrayList<XSDTypeDefinition> typesDerivedFrom = new ArrayList<XSDTypeDefinition>();
        EList typedefs = schema.getTypeDefinitions();
        Iterator iter = typedefs.iterator();
        while (iter.hasNext()) {
            XSDTypeDefinition typedef = (XSDTypeDefinition)iter.next();
            if (!XSDSchemaQueryTools.isTypeDerivedFrom(typedef, namespace, localName)) continue;
            typesDerivedFrom.add(typedef);
        }
        return typesDerivedFrom;
    }

    protected static boolean isTypeDerivedFrom(XSDTypeDefinition typedef, String namespace, String localName) {
        XSDTypeDefinition baseType = typedef.getBaseType();
        if (baseType.hasNameAndTargetNamespace(localName, namespace)) {
            return true;
        }
        XSDTypeDefinition rootType = typedef.getRootType();
        if (rootType == baseType) {
            return false;
        }
        return XSDSchemaQueryTools.isTypeDerivedFrom(baseType, namespace, localName);
    }

    public static List findElementsUsingType(XSDSchema schema, String namespace, String localName) {
        if (null == schema || null == localName) {
            throw new IllegalArgumentException("findElementsUsingType called with null schema/localName");
        }
        ArrayList<XSDElementDeclaration> elemsUsingType = new ArrayList<XSDElementDeclaration>();
        EList elemDecls = schema.getElementDeclarations();
        Iterator iter = elemDecls.iterator();
        while (iter.hasNext()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)iter.next();
            XSDTypeDefinition typedef = null;
            if (elem.getAnonymousTypeDefinition() != null) {
                typedef = elem.getAnonymousTypeDefinition();
            } else {
                if (elem.getTypeDefinition() == null) continue;
                typedef = elem.getTypeDefinition();
            }
            if (!typedef.hasNameAndTargetNamespace(localName, namespace) && !XSDSchemaQueryTools.isTypeDerivedFrom(typedef, namespace, localName)) continue;
            elemsUsingType.add(elem);
        }
        return elemsUsingType;
    }

    public static HashMap hasImpInclRedef(XSDSchema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("hasImpInclRedef called with null schema");
        }
        HashMap hash = new HashMap();
        XSDSchemaQueryTools.mapImpInclRedef(schema, hash, 0);
        if (hash.size() == 0) {
            return null;
        }
        return hash;
    }

    public static HashMap hasImpInclRedef2(XSDSchema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("hasImpInclRedef2 called with null schema");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        Resource currentResource = schema.eResource();
        ResourceSet resourceSet = currentResource.getResourceSet();
        Iterator resources = resourceSet.getResources().iterator();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            if (!(resource instanceof XSDResourceImpl)) continue;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            XSDSchema otherSchema = xsdResource.getSchema();
            Iterator contents = otherSchema.getContents().iterator();
            while (contents.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)contents.next();
                if (!(content instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective schemaDirective = (XSDSchemaDirective)content;
                String type = null;
                type = content instanceof XSDImport ? "XSDImport" : (content instanceof XSDInclude ? "XSDInclude" : (content instanceof XSDRedefine ? "XSDRedefine" : "unknown"));
                if (schemaDirective.getResolvedSchema() == null) {
                    type = type + "-unresolved";
                }
                hash.put(schemaDirective.getSchemaLocation(), type);
                XSDSchema nextSchema = schemaDirective.getResolvedSchema();
                if (null == nextSchema) continue;
                XSDSchemaQueryTools.mapImpInclRedef(nextSchema, hash, 1);
            }
        }
        if (hash.size() == 0) {
            return null;
        }
        return hash;
    }

    protected static void mapImpInclRedef(XSDSchema schema, HashMap hash, int level) {
        Iterator schemaContents = schema.getContents().iterator();
        while (schemaContents.hasNext()) {
            XSDSchemaContent schemaContent = (XSDSchemaContent)schemaContents.next();
            if (!(schemaContent instanceof XSDSchemaDirective)) continue;
            XSDSchemaDirective schemaDirective = (XSDSchemaDirective)schemaContent;
            String type = null;
            type = schemaContent instanceof XSDImport ? "XSDImport-level" + level : (schemaContent instanceof XSDInclude ? "XSDInclude-level" + level : (schemaContent instanceof XSDRedefine ? "XSDRedefine-level" + level : "unknown-level" + level));
            if (schemaDirective.getResolvedSchema() == null) {
                type = type + "-unresolved";
            }
            hash.put(schemaDirective.getSchemaLocation(), type);
            XSDSchema nextSchema = schemaDirective.getResolvedSchema();
            if (null == nextSchema) continue;
            XSDSchemaQueryTools.mapImpInclRedef(nextSchema, hash, level + 1);
        }
    }
}

