/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.ecore.MapBuilder;

public class EcoreXMLSchemaBuilder
extends MapBuilder {
    protected static final String EMF_SCHEMA_URI = "http://org.eclipse.emf/xsd";
    protected static final String EMF_SCHEMA_PREFIX = "emf";
    protected static final String EMF_SCHEMA_NAME = "EMF.xsd";
    protected static final String REFERENCE_TYPE_NAME = "string";
    protected XSDSchema xsdSchema;
    protected XSDSchema emfSchema;
    protected EPackage ePackage;
    protected Map ecoreToSchemaName;
    protected Map ePackageToXSDSchemaMap = new HashMap();
    protected QNameMap qNameMap;

    public Collection generate(EPackage ePackage) {
        return this.generate(ePackage, null);
    }

    public Collection generate(EPackage ePackage, QNameMap qNameMap) {
        this.qNameMap = qNameMap;
        this.addInput((EObject)ePackage);
        this.ePackage = ePackage;
        this.createSchema();
        this.processEnums();
        this.processClasses();
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(this.xsdSchema);
        if (this.emfSchema != null) {
            result.add(this.emfSchema);
        }
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        return result;
    }

    protected void createSchema() {
        this.xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.addOutput(this.xsdSchema);
        this.xsdSchema.setTargetNamespace(this.ePackage.getNsURI());
        this.xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(this.ePackage.getNsPrefix(), this.xsdSchema.getTargetNamespace());
        namespaces.put(this.xsdSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
    }

    protected void createEMFSchema() {
        this.emfSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.emfSchema.setTargetNamespace(EMF_SCHEMA_URI);
        this.emfSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = this.emfSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(EMF_SCHEMA_PREFIX, this.emfSchema.getTargetNamespace());
        namespaces.put(this.emfSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        XSDSimpleTypeDefinition list = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        list.setName(REFERENCE_TYPE_NAME);
        XSDSimpleTypeDefinition union = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        union.getMemberTypeDefinitions().add(this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("IDREF"));
        union.getMemberTypeDefinitions().add(this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("QName"));
        union.getMemberTypeDefinitions().add(this.emfSchema.getSchemaForSchema().resolveSimpleTypeDefinition("anyURI"));
        list.setItemTypeDefinition(union);
        list.getContents().add(union);
        this.emfSchema.getContents().add(list);
    }

    protected void addEMFSchema() {
    }

    protected XSDTypeDefinition typeInOtherSchema(EClassifier classifier) {
        EPackage typePkg = classifier.getEPackage();
        Map namespaces = this.xsdSchema.getQNamePrefixToNamespaceMap();
        if (namespaces.get(typePkg.getNsPrefix()) == null) {
            namespaces.put(typePkg.getNsPrefix(), typePkg.getNsURI());
            this.addImport(typePkg.getNsURI(), this.getName((ENamedElement)typePkg) + ".xsd");
            this.createOtherSchema(typePkg);
        }
        XSDSchema otherXSDSchema = (XSDSchema)this.ePackageToXSDSchemaMap.get(typePkg);
        return otherXSDSchema.resolveTypeDefinition(this.getName((ENamedElement)classifier));
    }

    protected void addImport(String namespace, String schemaLocation) {
        XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
        xsdImport.setNamespace(namespace);
        xsdImport.setSchemaLocation(schemaLocation);
        this.xsdSchema.getContents().add(0, xsdImport);
    }

    protected void createOtherSchema(EPackage ePackage) {
        XSDSchema otherSchema = XSDFactory.eINSTANCE.createXSDSchema();
        otherSchema.setTargetNamespace(ePackage.getNsURI());
        otherSchema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = otherSchema.getQNamePrefixToNamespaceMap();
        namespaces.put(ePackage.getNsPrefix(), otherSchema.getTargetNamespace());
        namespaces.put(otherSchema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        this.ePackageToXSDSchemaMap.put(ePackage, otherSchema);
    }

    protected void processClasses() {
        Iterator classifiers = this.ePackage.getEClassifiers().iterator();
        while (classifiers.hasNext()) {
            EClassifier classifier = (EClassifier)classifiers.next();
            if (!(classifier instanceof EClass)) continue;
            this.processClass((EClass)classifier);
        }
    }

    protected void processEnums() {
        Iterator classifiers = this.ePackage.getEClassifiers().iterator();
        while (classifiers.hasNext()) {
            EClassifier classifier = (EClassifier)classifiers.next();
            if (!(classifier instanceof EEnum)) continue;
            this.processEnum((EEnum)classifier);
        }
    }

    protected String getName(ENamedElement element) {
        if (this.qNameMap == null) {
            return element.getName();
        }
        return this.qNameMap.getName(element);
    }

    protected void processEnum(EEnum eEnum) {
        XSDSimpleTypeDefinition enumType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        enumType.setName(this.getName((ENamedElement)eEnum));
        enumType.setBaseTypeDefinition(this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("NCName"));
        this.xsdSchema.getContents().add(enumType);
        this.map(enumType, (EModelElement)eEnum);
        Iterator literals = eEnum.getELiterals().iterator();
        while (literals.hasNext()) {
            EEnumLiteral literal = (EEnumLiteral)literals.next();
            XSDEnumerationFacet facet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
            facet.setLexicalValue(this.getName((ENamedElement)literal));
            enumType.getFacetContents().add(facet);
            this.map(facet, (EModelElement)literal);
        }
    }

    protected void processClass(EClass eClass) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setName(this.getName((ENamedElement)eClass));
        EList superClasses = eClass.getESuperTypes();
        if (superClasses.size() > 0) {
            xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            EClass superClass = (EClass)superClasses.get(0);
            if (superClass.getEPackage() == this.ePackage) {
                xsdComplexTypeDefinition.setBaseTypeDefinition(this.xsdSchema.resolveTypeDefinition(this.getName((ENamedElement)superClass)));
            } else {
                xsdComplexTypeDefinition.setBaseTypeDefinition(this.typeInOtherSchema((EClassifier)superClass));
            }
        }
        this.xsdSchema.getContents().add(xsdComplexTypeDefinition);
        this.map(xsdComplexTypeDefinition, (EModelElement)eClass);
        List features = this.getFeatures(eClass, (List)superClasses);
        Iterator fs = features.iterator();
        while (fs.hasNext()) {
            EStructuralFeature f = (EStructuralFeature)fs.next();
            if (f instanceof EAttribute) {
                this.processAttribute((EAttribute)f, xsdComplexTypeDefinition);
                continue;
            }
            if (!(f instanceof EReference)) continue;
            this.processReference((EReference)f, xsdComplexTypeDefinition);
        }
        if (this.makeClassElementDeclaration(eClass)) {
            XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElementDeclaration.setName(this.getName((ENamedElement)eClass));
            xsdElementDeclaration.setTypeDefinition(xsdComplexTypeDefinition);
            this.xsdSchema.getContents().add(xsdElementDeclaration);
            this.map(xsdElementDeclaration, (EModelElement)eClass);
        }
        this.additionalProcessing(eClass, xsdComplexTypeDefinition);
    }

    protected boolean makeClassElementDeclaration(EClass eClass) {
        return !eClass.isAbstract();
    }

    protected void additionalProcessing(EClass cls, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
    }

    protected List getFeatures(EClass eClass, List superClasses) {
        ArrayList features = new ArrayList();
        if (superClasses.size() > 0) {
            EList allSupers = ((EClass)superClasses.get(0)).getEAllSuperTypes();
            HashSet allSuperClasses = new HashSet();
            allSuperClasses.addAll(allSupers);
            int i = 1;
            while (i < superClasses.size()) {
                features.addAll(this.getAllFeatures((EClass)superClasses.get(i), allSuperClasses));
                ++i;
            }
        }
        features.addAll(eClass.getEAttributes());
        features.addAll(eClass.getEReferences());
        return features;
    }

    protected List getAllFeatures(EClass eClass, Set classesToIgnore) {
        ArrayList features = new ArrayList();
        EList superClasses = eClass.getESuperTypes();
        int i = 0;
        while (i < superClasses.size()) {
            if (!classesToIgnore.contains(superClasses.get(i))) {
                features.addAll(this.getAllFeatures((EClass)superClasses.get(i), classesToIgnore));
            }
            ++i;
        }
        features.addAll(eClass.getEAttributes());
        features.addAll(eClass.getEReferences());
        return features;
    }

    protected void processAttribute(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (this.processAttribute(attribute)) {
            if (this.makeAttributeDeclaration(attribute)) {
                this.createAttributeDeclaration(attribute, xsdComplexTypeDefinition);
            }
            if (this.makeAttributeElementDeclaration()) {
                this.createAttributeElementDeclaration(attribute, xsdComplexTypeDefinition);
            }
        }
    }

    protected void createAttributeDeclaration(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attrDecl.setName(this.getName((ENamedElement)attribute));
        this.setAttributeType(attribute, attrDecl);
        this.setDefaultValue(attribute, attrDecl);
        XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        this.setUseToRequired(attribute, attrUse);
        attrUse.setContent(attrDecl);
        xsdComplexTypeDefinition.getAttributeContents().add(attrUse);
        this.map(attrUse, (EModelElement)attribute);
    }

    protected void createAttributeElementDeclaration(EAttribute attribute, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDSimpleTypeDefinition attrType;
        XSDModelGroup modelGroup = this.getModelGroup(xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.getName((ENamedElement)attribute));
        if (attribute.getEType().getDefaultValue() == null && (attribute.isMany() || !attribute.isRequired() && (attribute.getDefaultValueLiteral() != null || attribute.isUnsettable()))) {
            xsdElementDeclaration.setNillable(true);
        }
        if ((attrType = this.getType(attribute.getEAttributeType())) != null) {
            xsdElementDeclaration.setTypeDefinition(attrType);
        }
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(xsdElementDeclaration);
        this.setAttributeElementMultiplicity(attribute, particle);
        modelGroup.getContents().add(particle);
        this.map(particle, (EModelElement)attribute);
    }

    protected void setAttributeElementMultiplicity(EAttribute attribute, XSDParticle particle) {
        if (attribute.isMany()) {
            particle.setMinOccurs(attribute.getLowerBound());
        } else {
            particle.setMinOccurs(0);
        }
        particle.setMaxOccurs(attribute.getUpperBound());
    }

    protected boolean processAttribute(EAttribute attribute) {
        if (attribute.isTransient()) {
            return false;
        }
        EDataType type = attribute.getEAttributeType();
        return type == null || type.isSerializable();
    }

    protected boolean makeAttributeDeclaration(EAttribute attribute) {
        return !attribute.isMany();
    }

    protected boolean makeAttributeElementDeclaration() {
        return true;
    }

    protected XSDModelGroup getModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (xsdComplexTypeDefinition.getContent() == null) {
            return this.createModelGroup(xsdComplexTypeDefinition);
        }
        XSDParticle particle = (XSDParticle)xsdComplexTypeDefinition.getContent();
        return (XSDModelGroup)particle.getContent();
    }

    protected XSDModelGroup createModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(modelGroup);
        xsdComplexTypeDefinition.setContent(particle);
        return modelGroup;
    }

    protected void setAttributeType(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
        XSDSimpleTypeDefinition attrType = this.getType(attribute.getEAttributeType());
        if (attrType != null) {
            attrDecl.setTypeDefinition(attrType);
        }
    }

    protected void setUseToRequired(EAttribute attribute, XSDAttributeUse attrUse) {
    }

    protected void setDefaultValue(EAttribute attribute, XSDAttributeDeclaration attrDecl) {
        if (attribute.getDefaultValueLiteral() != null) {
            attrDecl.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            attrDecl.setLexicalValue(attribute.getDefaultValueLiteral());
        }
    }

    protected void processReference(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (!this.skipReference(reference)) {
            if (this.makeReferenceAttribute(reference)) {
                this.makeReferenceAttribute(reference, xsdComplexTypeDefinition);
            }
            if (this.makeReferenceElement(reference)) {
                this.makeReferenceElement(reference, xsdComplexTypeDefinition);
            }
        }
    }

    protected boolean makeReferenceAttribute(EReference reference) {
        return !reference.isContainment();
    }

    protected boolean makeReferenceElement(EReference reference) {
        return reference.isContainment();
    }

    protected boolean skipReference(EReference reference) {
        return reference.isTransient();
    }

    protected void makeReferenceAttribute(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDAttributeDeclaration attrDecl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attrDecl.setName(this.getName((ENamedElement)reference));
        this.setReferenceAttribType(attrDecl);
        XSDAttributeUse attrUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        attrUse.setContent(attrDecl);
        xsdComplexTypeDefinition.getAttributeContents().add(attrUse);
        this.map(attrUse, (EModelElement)reference);
    }

    protected void setReferenceAttribType(XSDAttributeDeclaration xsdAttributeDeclaration) {
        this.addEMFSchema();
        xsdAttributeDeclaration.setTypeDefinition(this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(REFERENCE_TYPE_NAME));
    }

    protected void makeReferenceElement(EReference reference, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup modelGroup = this.getModelGroup(xsdComplexTypeDefinition);
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.getName((ENamedElement)reference));
        if (reference.isUnsettable() && !reference.isMany()) {
            xsdElementDeclaration.setNillable(true);
        }
        this.setReferenceElementType(reference, xsdElementDeclaration);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(xsdElementDeclaration);
        this.setReferenceElementMultiplicity(reference, particle);
        modelGroup.getContents().add(particle);
        this.map(particle, (EModelElement)reference);
    }

    protected void setReferenceElementType(EReference reference, XSDElementDeclaration xsdElementDeclaration) {
        XSDTypeDefinition type;
        if (reference.getEType() != null && (type = reference.getEType().getEPackage() == this.ePackage ? this.xsdSchema.resolveTypeDefinition(this.getName((ENamedElement)reference.getEType())) : this.typeInOtherSchema(reference.getEType())) != null) {
            xsdElementDeclaration.setTypeDefinition(type);
        }
    }

    protected void setReferenceElementMultiplicity(EReference reference, XSDParticle particle) {
        particle.setMinOccurs(reference.getLowerBound());
        particle.setMaxOccurs(reference.getUpperBound());
    }

    protected XSDSimpleTypeDefinition getType(EDataType dataType) {
        if (dataType instanceof EEnum) {
            EPackage typePkg = dataType.getEPackage();
            if (typePkg == this.ePackage) {
                return this.xsdSchema.resolveSimpleTypeDefinition(this.getName((ENamedElement)dataType));
            }
            return (XSDSimpleTypeDefinition)this.typeInOtherSchema((EClassifier)dataType);
        }
        String name = null;
        if (dataType != null) {
            name = this.getName((ENamedElement)dataType);
        }
        return this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(this.getSchemaName(name));
    }

    private String getSchemaName(String name) {
        String schemaName;
        if (this.ecoreToSchemaName == null) {
            this.ecoreToSchemaName = new HashMap();
            this.ecoreToSchemaName.put("EBoolean", "boolean");
            this.ecoreToSchemaName.put("EBooleanObject", "boolean");
            this.ecoreToSchemaName.put("EInt", "int");
            this.ecoreToSchemaName.put("EIntegerObject", "int");
            this.ecoreToSchemaName.put("ELong", "long");
            this.ecoreToSchemaName.put("ELongObject", "long");
            this.ecoreToSchemaName.put("EFloat", "float");
            this.ecoreToSchemaName.put("EFloatObject", "float");
            this.ecoreToSchemaName.put("EDouble", "double");
            this.ecoreToSchemaName.put("EDoubleObject", "double");
            this.ecoreToSchemaName.put("EString", REFERENCE_TYPE_NAME);
        }
        if ((schemaName = (String)this.ecoreToSchemaName.get(name)) != null) {
            return schemaName;
        }
        return REFERENCE_TYPE_NAME;
    }

    public static interface QNameMap {
        public String getName(ENamedElement var1);
    }
}

