/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.util.XSDConstants;

public class XSDEcoreBuilder
extends MapBuilder {
    public static final String XSD2ECORE_URI = "http:///org/eclipse/emf/mapping/xsd2ecore/XSD2Ecore";
    public static final int TRIVIAL = 1;
    protected int style;
    protected XSDSchema xsdSchema;
    protected Set xsdSchemas = new HashSet();
    protected Map targetNamespaceToEPackageMap = new HashMap();
    protected Map eClassToOrderedFeaturesMap = new HashMap();

    public XSDEcoreBuilder() {
    }

    public XSDEcoreBuilder(int style) {
        this.style = style;
    }

    public XSDSchema getSchema() {
        return this.xsdSchema;
    }

    public Map getTargetNamespaceToEPackageMap() {
        return this.targetNamespaceToEPackageMap;
    }

    public Map getXSDComponentToEModelElementMap() {
        return this.xsdComponentToEModelElementMap;
    }

    public EPackage getEPackage(XSDNamedComponent xsdNamedComponent) {
        String targetNamespace;
        EPackage ePackage;
        XSDSchema containingXSDSchema = xsdNamedComponent.getSchema();
        if (containingXSDSchema != null && !this.xsdSchemas.contains(containingXSDSchema)) {
            this.xsdSchemas.add(containingXSDSchema);
            this.addInput(containingXSDSchema);
        }
        if ((ePackage = (EPackage)this.targetNamespaceToEPackageMap.get(targetNamespace = containingXSDSchema == null ? xsdNamedComponent.getTargetNamespace() : containingXSDSchema.getTargetNamespace())) == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.addOutput((EObject)ePackage);
            if (targetNamespace == null) {
                if (containingXSDSchema == null) {
                    containingXSDSchema = this.xsdSchema;
                }
                ePackage.setName(this.validName(containingXSDSchema.eResource().getURI().trimFileExtension().lastSegment(), false));
                ePackage.setNsURI(containingXSDSchema.eResource().getURI().toString());
            } else {
                URI uri = URI.createURI((String)targetNamespace);
                String host = uri.host();
                if (host != null && host.startsWith("www.")) {
                    host = host.substring(4);
                }
                List parsedName = this.parseName(host, '.');
                Collections.reverse(parsedName);
                if (!parsedName.isEmpty()) {
                    parsedName.set(0, ((String)parsedName.get(0)).toLowerCase());
                }
                parsedName.addAll(this.parseName(uri.trimFileExtension().path(), '/'));
                StringBuffer qualifiedPackageName = new StringBuffer();
                Iterator i = parsedName.iterator();
                while (i.hasNext()) {
                    String packageName = (String)i.next();
                    if (packageName.length() <= 0) continue;
                    if (qualifiedPackageName.length() > 0) {
                        qualifiedPackageName.append('.');
                    }
                    qualifiedPackageName.append(this.validName(packageName, false));
                }
                ePackage.setName(qualifiedPackageName.toString());
                ePackage.setNsURI(targetNamespace);
            }
            ePackage.setNsPrefix(ePackage.getName());
            EAnnotation eAnnotation = this.createAnnotation();
            this.addAnnotationDetail(eAnnotation, "representation", "schema");
            this.addAnnotationDetail(eAnnotation, "targetNamespace", targetNamespace);
            ePackage.getEAnnotations().add(eAnnotation);
            this.targetNamespaceToEPackageMap.put(targetNamespace, ePackage);
        }
        return ePackage;
    }

    public EClassifier getEClassifier(XSDTypeDefinition xsdTypeDefinition) {
        return this.getEClassifier(xsdTypeDefinition, false);
    }

    public EClassifier getEClassifier(XSDTypeDefinition xsdTypeDefinition, boolean supportNull) {
        EClassifier eClassifier = (EClassifier)this.xsdComponentToEModelElementMap.get(xsdTypeDefinition);
        if (eClassifier == null) {
            if (xsdTypeDefinition instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)xsdTypeDefinition;
                if (XSDConstants.isSchemaForSchemaNamespace(xsdSimpleTypeDefinition.getTargetNamespace())) {
                    String name = xsdSimpleTypeDefinition.getName();
                    if ((this.style & 1) == 0 && ("anyURI".equals(name) || "QName".equals(name) || "IDREF".equals(name) || "IDREFS".equals(name))) {
                        eClassifier = EcorePackage.eINSTANCE.getEObject();
                    } else if ("string".equals(name) || "anySimpleType".equals(name)) {
                        eClassifier = EcorePackage.eINSTANCE.getEString();
                    } else if ("boolean".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEBooleanObject() : EcorePackage.eINSTANCE.getEBoolean();
                    } else if ("float".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEFloatObject() : EcorePackage.eINSTANCE.getEFloat();
                    } else if ("double".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEDoubleObject() : EcorePackage.eINSTANCE.getEDouble();
                    } else if ("long".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getELongObject() : EcorePackage.eINSTANCE.getELong();
                    } else if ("int".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEIntegerObject() : EcorePackage.eINSTANCE.getEInt();
                    } else if ("short".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEShortObject() : EcorePackage.eINSTANCE.getEShort();
                    } else if ("byte".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEByteObject() : EcorePackage.eINSTANCE.getEByte();
                    } else if ("unsignedByte".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEShortObject() : EcorePackage.eINSTANCE.getEShort();
                    } else if ("unsignedShort".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getEIntegerObject() : EcorePackage.eINSTANCE.getEInt();
                    } else if ("unsignedInt".equals(name)) {
                        eClassifier = supportNull ? EcorePackage.eINSTANCE.getELongObject() : EcorePackage.eINSTANCE.getELong();
                    } else {
                        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                        if (baseTypeDefinition != null && !XSDConstants.isURType(baseTypeDefinition)) {
                            eClassifier = this.getEClassifier(baseTypeDefinition, supportNull);
                        }
                    }
                } else {
                    XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                    if (baseTypeDefinition != null && !supportNull) {
                        if (!xsdSimpleTypeDefinition.getEnumerationFacets().isEmpty() && XSDConstants.isSchemaForSchemaNamespace(baseTypeDefinition.getTargetNamespace()) && "NCName".equals(baseTypeDefinition.getName())) {
                            ArrayList<XSDEnumerationFacet> enumerators = new ArrayList<XSDEnumerationFacet>();
                            Iterator i = xsdSimpleTypeDefinition.getEnumerationFacets().iterator();
                            while (i.hasNext()) {
                                XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i.next();
                                String enumerator = xsdEnumerationFacet.getLexicalValue();
                                if (enumerator != null && enumerator.length() != 0) {
                                    if (Character.isJavaIdentifierStart(enumerator.charAt(0))) {
                                        int j = enumerator.length() - 1;
                                        while (j > 0) {
                                            if (!Character.isJavaIdentifierPart(enumerator.charAt(j))) {
                                                enumerators.clear();
                                                break;
                                            }
                                            --j;
                                        }
                                    }
                                    enumerators.add(xsdEnumerationFacet);
                                    continue;
                                }
                                enumerators.clear();
                                break;
                            }
                            if (!enumerators.isEmpty()) {
                                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                                ListIterator i2 = enumerators.listIterator();
                                while (i2.hasNext()) {
                                    XSDEnumerationFacet xsdEnumerationFacet = (XSDEnumerationFacet)i2.next();
                                    String enumerator = xsdEnumerationFacet.getLexicalValue();
                                    EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                                    eEnumLiteral.setName(enumerator);
                                    eEnumLiteral.setValue(i2.previousIndex());
                                    eEnum.getELiterals().add(eEnumLiteral);
                                    this.map(xsdEnumerationFacet, (EModelElement)eEnumLiteral);
                                }
                                eClassifier = eEnum;
                            }
                        }
                        if (eClassifier == null) {
                            eClassifier = this.getEClassifier(baseTypeDefinition, supportNull);
                        }
                    }
                }
                if (eClassifier == null) {
                    eClassifier = EcorePackage.eINSTANCE.getEString();
                }
            } else if (XSDConstants.isAnyType(xsdTypeDefinition)) {
                eClassifier = EcorePackage.eINSTANCE.getEObject();
            } else {
                EClassifier baseType;
                XSDComplexTypeDefinition xsdComplexTypeDefinition = (XSDComplexTypeDefinition)xsdTypeDefinition;
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                if (xsdComplexTypeDefinition.isAbstract()) {
                    eClass.setAbstract(true);
                }
                this.xsdComponentToEModelElementMap.put(xsdComplexTypeDefinition, eClass);
                eClassifier = eClass;
                XSDTypeDefinition baseTypeDefinition = xsdComplexTypeDefinition.getBaseTypeDefinition();
                if (!XSDConstants.isURType(baseTypeDefinition) && (baseType = this.getEClassifier(baseTypeDefinition, supportNull)) instanceof EClass && baseType != EcorePackage.eINSTANCE.getEObject()) {
                    eClass.getESuperTypes().add(baseType);
                }
                if (eClass.getESuperTypes().isEmpty() || xsdComplexTypeDefinition.getDerivationMethod() == XSDDerivationMethod.EXTENSION_LITERAL) {
                    Iterator i;
                    EStructuralFeature eStructuralFeature;
                    if (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
                        if (eClass.getEAllReferences().isEmpty()) {
                            eStructuralFeature = this.createFeature(eClass, "value", this.getEClassifier(xsdComplexTypeDefinition.getSimpleType(), false), null, 0, 1);
                        }
                    } else if ((this.style & 1) != 0 || xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.MIXED_LITERAL) {
                        if (eClass.getEAllReferences().isEmpty()) {
                            eStructuralFeature = this.createFeature(eClass, "contents", (EClassifier)EcorePackage.eINSTANCE.getEObject(), xsdComplexTypeDefinition.getComplexType(), 0, -1);
                            this.bindElements(xsdComplexTypeDefinition.getComplexType().getTerm());
                        }
                    } else if (xsdComplexTypeDefinition.getContentTypeCategory() == XSDContentTypeCategory.ELEMENT_ONLY_LITERAL && xsdComplexTypeDefinition.getContent() != null) {
                        ArrayList<EStructuralFeature> orderedFeatures = new ArrayList<EStructuralFeature>();
                        this.eClassToOrderedFeaturesMap.put(eClass, orderedFeatures);
                        EMap xsdParticles = this.collectParticles((XSDParticle)xsdComplexTypeDefinition.getContent());
                        Iterator i3 = xsdParticles.iterator();
                        while (i3.hasNext()) {
                            EStructuralFeature eStructuralFeature2;
                            Map.Entry entry = (Map.Entry)i3.next();
                            XSDParticle xsdParticle = (XSDParticle)entry.getKey();
                            EffectiveOccurrence effectiveOccurrence = (EffectiveOccurrence)entry.getValue();
                            XSDTerm xsdTerm = xsdParticle.getTerm();
                            if (xsdTerm instanceof XSDModelGroup) {
                                eStructuralFeature2 = this.createFeature(eClass, "contents", (EClassifier)EcorePackage.eINSTANCE.getEObject(), xsdParticle, 0, -1);
                                this.bindElements(xsdTerm);
                            } else if (xsdTerm instanceof XSDWildcard) {
                                eStructuralFeature2 = this.createFeature(eClass, "any", (EClassifier)EcorePackage.eINSTANCE.getEObject(), xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs);
                            } else {
                                EClassifier type;
                                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                                EClassifier eClassifier2 = type = xsdElementDeclaration.getScope() instanceof XSDSchema ? this.getEClassifier(xsdElementDeclaration) : this.getEClassifier(xsdElementDeclaration.getTypeDefinition(), xsdElementDeclaration.isNillable());
                                if (type instanceof EDataType && xsdElementDeclaration.isGlobal() && xsdElementDeclaration.getDisallowedSubstitutions().size() != 3) {
                                    type = this.getEClassifier(xsdElementDeclaration);
                                }
                                eStructuralFeature2 = this.createFeature(eClass, this.validName(xsdElementDeclaration.getName(), true), type, xsdParticle, effectiveOccurrence.minOccurs, effectiveOccurrence.maxOccurs);
                            }
                            orderedFeatures.add(eStructuralFeature2);
                        }
                    }
                    HashSet<String> baseAttributeUses = new HashSet<String>();
                    if (baseTypeDefinition instanceof XSDComplexTypeDefinition) {
                        i = ((XSDComplexTypeDefinition)baseTypeDefinition).getAttributeUses().iterator();
                        while (i.hasNext()) {
                            baseAttributeUses.add(((XSDAttributeUse)i.next()).getAttributeDeclaration().getURI());
                        }
                    }
                    i = xsdComplexTypeDefinition.getAttributeUses().iterator();
                    while (i.hasNext()) {
                        XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i.next();
                        if (baseAttributeUses.contains(xsdAttributeUse.getAttributeDeclaration().getURI())) continue;
                        EStructuralFeature eStructuralFeature3 = this.createFeature(eClass, this.validName(xsdAttributeUse.getAttributeDeclaration().getName(), true), this.getEClassifier(xsdAttributeUse.getAttributeDeclaration().getTypeDefinition(), false), xsdAttributeUse, xsdAttributeUse.isRequired() ? 1 : 0, 1);
                    }
                }
            }
            if (eClassifier.eContainer() == null) {
                eClassifier.setName(this.validName(xsdTypeDefinition.getAliasName(), true));
                EAnnotation eAnnotation = this.createAnnotation();
                this.addAnnotationDetail(eAnnotation, "representation", "type");
                this.addAnnotationDetail(eAnnotation, "name", xsdTypeDefinition.getAliasName());
                this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdTypeDefinition.getTargetNamespace());
                eClassifier.getEAnnotations().add(eAnnotation);
                EPackage ePackage = this.getEPackage(xsdTypeDefinition);
                ePackage.getEClassifiers().add(eClassifier);
            }
            this.map(xsdTypeDefinition, (EModelElement)eClassifier);
        }
        return eClassifier;
    }

    protected EAnnotation createAnnotation() {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(XSD2ECORE_URI);
        return eAnnotation;
    }

    protected void addAnnotationDetail(EAnnotation eAnnotation, String key, String value) {
        eAnnotation.getDetails().put((Object)key, (Object)value);
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent) {
        return this.createFeature(eClass, name, type, xsdComponent, 0, 1);
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier type, XSDComponent xsdComponent, int minOccurs, int maxOccurs) {
        if (type instanceof EClass) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            eReference.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
            eReference.setEType(type);
            eReference.setLowerBound(minOccurs);
            eReference.setUpperBound(maxOccurs);
            eClass.getEReferences().add(eReference);
            if (xsdComponent != null) {
                this.map(xsdComponent, (EModelElement)eReference);
                if (xsdComponent instanceof XSDParticle) {
                    eReference.setContainment(true);
                    XSDParticle xsdParticle = (XSDParticle)xsdComponent;
                    EAnnotation eAnnotation = this.createAnnotation();
                    XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                    if (xsdTerm instanceof XSDElementDeclaration) {
                        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                        if (xsdElementDeclaration.getScope() instanceof XSDComplexTypeDefinition && xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
                            eReference.setContainment(false);
                        }
                        this.addAnnotationDetail(eAnnotation, "representation", "element");
                        this.addAnnotationDetail(eAnnotation, "name", ((XSDElementDeclaration)xsdTerm).getName());
                        this.addAnnotationDetail(eAnnotation, "targetNamespace", ((XSDElementDeclaration)xsdTerm).getTargetNamespace());
                    } else if (xsdTerm instanceof XSDWildcard) {
                        this.addAnnotationDetail(eAnnotation, "representation", "element-wildcard");
                    } else {
                        this.addAnnotationDetail(eAnnotation, "representation", "general-content");
                    }
                    eReference.getEAnnotations().add(eAnnotation);
                }
            }
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(Character.toLowerCase(name.charAt(0)) + name.substring(1));
        eAttribute.setEType(type);
        eAttribute.setLowerBound(minOccurs);
        eAttribute.setUpperBound(maxOccurs);
        eClass.getEAttributes().add(eAttribute);
        EAnnotation eAnnotation = this.createAnnotation();
        if (xsdComponent == null) {
            this.addAnnotationDetail(eAnnotation, "representation", "simple-content");
        } else {
            this.map(xsdComponent, (EModelElement)eAttribute);
            if (xsdComponent instanceof XSDAttributeUse) {
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdComponent;
                XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                this.addAnnotationDetail(eAnnotation, "representation", "attribute");
                this.addAnnotationDetail(eAnnotation, "name", xsdAttributeDeclaration.getName());
                this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdAttributeDeclaration.getTargetNamespace());
                eAttribute.setDefaultValueLiteral(xsdAttributeUse.getLexicalValue());
                if (XSDConstants.isOrIsDerivedFromID(xsdAttributeDeclaration.getTypeDefinition())) {
                    eAttribute.setID(true);
                }
            } else if (xsdComponent instanceof XSDParticle) {
                XSDParticle xsdParticle = (XSDParticle)xsdComponent;
                XSDTerm xsdTerm = ((XSDParticle)xsdComponent).getTerm();
                if (xsdTerm instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdTerm;
                    this.addAnnotationDetail(eAnnotation, "representation", "element");
                    this.addAnnotationDetail(eAnnotation, "name", xsdElementDeclaration.getName());
                    this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdElementDeclaration.getTargetNamespace());
                    eAttribute.setDefaultValueLiteral(xsdElementDeclaration.getLexicalValue());
                } else if (xsdTerm instanceof XSDWildcard) {
                    this.addAnnotationDetail(eAnnotation, "representation", "element-wildcard");
                } else {
                    this.addAnnotationDetail(eAnnotation, "representation", "general-content");
                }
            } else if (xsdComponent instanceof XSDWildcard) {
                this.addAnnotationDetail(eAnnotation, "representation", "attribute-wildcard");
            }
        }
        eAttribute.getEAnnotations().add(eAnnotation);
        if (type.getDefaultValue() != null || eAttribute.getDefaultValueLiteral() != null) {
            eAttribute.setUnsettable(true);
        }
        return eAttribute;
    }

    public EMap collectParticles(XSDParticle xsdParticle) {
        BasicEMap result = new BasicEMap();
        this.collectParticlesHelper((EMap)result, xsdParticle, 1, 1);
        return result;
    }

    public void collectParticlesHelper(EMap result, XSDParticle xsdParticle, int minOccurs, int maxOccurs) {
        EffectiveOccurrence effectiveOccurrence;
        int particleMaxOccurs = xsdParticle.getMaxOccurs();
        int effectiveMinOccurs = minOccurs * xsdParticle.getMinOccurs();
        int effectiveMaxOccurs = maxOccurs == -1 || particleMaxOccurs == -1 ? -1 : maxOccurs * particleMaxOccurs;
        XSDTerm xsdTerm = xsdParticle.getTerm();
        if (xsdTerm instanceof XSDModelGroup) {
            XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdTerm;
            EList particles = xsdModelGroup.getParticles();
            if (particles.size() == 0) {
                return;
            }
            if ((this.style & 1) != 0 || particleMaxOccurs == 1 || particles.size() == 1) {
                if (xsdModelGroup.getCompositor() == XSDCompositor.CHOICE_LITERAL) {
                    effectiveMinOccurs = 0;
                }
                Iterator i = ((XSDModelGroup)xsdTerm).getParticles().iterator();
                while (i.hasNext()) {
                    XSDParticle childXSDParticle = (XSDParticle)i.next();
                    this.collectParticlesHelper(result, childXSDParticle, effectiveMinOccurs, effectiveMaxOccurs);
                }
                return;
            }
        }
        if ((effectiveOccurrence = (EffectiveOccurrence)result.get((Object)xsdParticle)) == null) {
            effectiveOccurrence = new EffectiveOccurrence(effectiveMinOccurs, effectiveMaxOccurs);
            result.put((Object)xsdParticle, (Object)effectiveOccurrence);
        } else {
            effectiveOccurrence.minOccurs += effectiveMinOccurs;
            effectiveOccurrence.maxOccurs += effectiveMaxOccurs;
        }
    }

    public void bindElements(XSDTerm xsdTerm) {
        if (xsdTerm instanceof XSDModelGroup) {
            Iterator i = ((XSDModelGroup)xsdTerm).getParticles().iterator();
            while (i.hasNext()) {
                XSDParticle childXSDParticle = (XSDParticle)i.next();
                this.bindElements(childXSDParticle.getTerm());
            }
        } else if (xsdTerm instanceof XSDElementDeclaration) {
            this.getEClassifier((XSDElementDeclaration)xsdTerm);
        }
    }

    public EClassifier getEClassifier(XSDElementDeclaration xsdElementDeclaration) {
        EClassifier eClassifier = (EClassifier)this.xsdComponentToEModelElementMap.get(xsdElementDeclaration);
        if (eClassifier == null) {
            EClass elementEClass;
            EClassifier type = this.getEClassifier(xsdElementDeclaration.getType(), xsdElementDeclaration.isNillable());
            if (xsdElementDeclaration.getAnonymousTypeDefinition() != null && type instanceof EClass) {
                elementEClass = (EClass)type;
                elementEClass.getEAnnotations().clear();
            } else {
                elementEClass = EcoreFactory.eINSTANCE.createEClass();
                EPackage ePackage = this.getEPackage(xsdElementDeclaration);
                ePackage.getEClassifiers().add(elementEClass);
                if (xsdElementDeclaration.isAbstract()) {
                    elementEClass.setAbstract(true);
                }
            }
            elementEClass.setName(this.validName(xsdElementDeclaration.getName(), true));
            EAnnotation eAnnotation = this.createAnnotation();
            this.addAnnotationDetail(eAnnotation, "representation", "element");
            this.addAnnotationDetail(eAnnotation, "name", xsdElementDeclaration.getAliasName());
            this.addAnnotationDetail(eAnnotation, "targetNamespace", xsdElementDeclaration.getTargetNamespace());
            elementEClass.getEAnnotations().add(eAnnotation);
            XSDElementDeclaration substitutionGroupAffiliation = xsdElementDeclaration.getSubstitutionGroupAffiliation();
            if (substitutionGroupAffiliation != null) {
                elementEClass.getESuperTypes().add(this.getEClassifier(substitutionGroupAffiliation));
            }
            if (type instanceof EClass) {
                if (type != elementEClass && type != EcorePackage.eINSTANCE.getEObject() && !elementEClass.getEAllSuperTypes().contains(type)) {
                    elementEClass.getESuperTypes().add(type);
                }
            } else if (elementEClass.getEAllReferences().isEmpty()) {
                EStructuralFeature eStructuralFeature = this.createFeature(elementEClass, "value", type, null);
            }
            this.map(xsdElementDeclaration, (EModelElement)elementEClass);
            eClassifier = elementEClass;
        }
        return eClassifier;
    }

    public Collection generate(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof XSDSchema) {
            this.generate((XSDSchema)resource.getContents().get(0));
        }
        ArrayList result = new ArrayList(this.targetNamespaceToEPackageMap.values());
        if (this.mapper != null) {
            result.add(this.mapper.getRoot());
        }
        return result;
    }

    protected void resolveNameConflicts() {
        Iterator i = this.targetNamespaceToEPackageMap.values().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            HashMap<String, EClassifier> eClassifierMap = new HashMap<String, EClassifier>();
            Iterator j = ePackage.getEClassifiers().iterator();
            while (j.hasNext()) {
                EClassifier eClassifier = (EClassifier)j.next();
                EClassifier otherEClassifier = (EClassifier)eClassifierMap.get(eClassifier.getName());
                if (otherEClassifier != null) {
                    String representation = (String)eClassifier.getEAnnotation(XSD2ECORE_URI).getDetails().get((Object)"representation");
                    if (eClassifier.getEAnnotation(XSD2ECORE_URI).getDetails().get((Object)"representation").equals("type")) {
                        this.resolveNameConflict(eClassifierMap, (ENamedElement)eClassifier, "Type");
                    } else if (otherEClassifier.getEAnnotation(XSD2ECORE_URI).getDetails().get((Object)"representation").equals("type")) {
                        this.resolveNameConflict(eClassifierMap, (ENamedElement)otherEClassifier, "Type");
                    } else {
                        this.resolveNameConflict(eClassifierMap, (ENamedElement)eClassifier, "");
                    }
                }
                eClassifierMap.put(eClassifier.getName(), eClassifier);
                if (!(eClassifier instanceof EClass)) continue;
                HashMap<String, EStructuralFeature> eFeatureMap = new HashMap<String, EStructuralFeature>();
                Iterator k = ((EClass)eClassifier).getEAllStructuralFeatures().iterator();
                while (k.hasNext()) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)k.next();
                    this.resolveNameConflict(eFeatureMap, (ENamedElement)eStructuralFeature, "");
                    eFeatureMap.put(eStructuralFeature.getName(), eStructuralFeature);
                }
            }
        }
    }

    protected void resolveNameConflict(Map map, ENamedElement eNamedElement, String suffix) {
        String name = eNamedElement.getName();
        if (!name.endsWith(suffix)) {
            name = name + suffix;
        }
        if (map.containsKey(name)) {
            int index = 0;
            while (map.containsKey(name + ++index)) {
            }
            eNamedElement.setName(name + index);
        } else {
            eNamedElement.setName(name);
        }
    }

    public Collection generateResources(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof XSDSchema) {
            this.generate((XSDSchema)resource.getContents().get(0));
        }
        Iterator i = this.targetNamespaceToEPackageMap.values().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            Resource ecoreResource = resourceSet.createResource(URI.createURI((String)"*.ecore"));
            ecoreResource.setURI(URI.createURI((String)(ePackage.getNsURI().endsWith(".ecore") ? ePackage.getNsURI() : ePackage.getNsURI() + ".ecore")));
            ecoreResource.getContents().add(ePackage);
        }
        return resourceSet.getResources();
    }

    public void generate(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
        this.xsdSchemas.add(xsdSchema);
        this.addInput(xsdSchema);
        Iterator i = xsdSchema.getElementDeclarations().iterator();
        while (i.hasNext()) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)i.next();
            EClassifier eClassifier = this.getEClassifier(xsdElementDeclaration);
        }
        Iterator i2 = xsdSchema.getTypeDefinitions().iterator();
        while (i2.hasNext()) {
            XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)i2.next();
            EClassifier eClassifier = this.getEClassifier(xsdTypeDefinition);
        }
        this.resolveNameConflicts();
        Iterator i3 = this.eClassToOrderedFeaturesMap.entrySet().iterator();
        while (i3.hasNext()) {
            Map.Entry entry = i3.next();
            EClass eClass = (EClass)entry.getKey();
            List orderedFeatures = (List)entry.getValue();
            boolean containsUnorderedEAttribute = false;
            boolean containsEReference = false;
            StringBuffer stringBuffer = new StringBuffer();
            int j = 0;
            int size = orderedFeatures.size();
            while (j < size) {
                EStructuralFeature eStructuralFeature;
                if (j != 0) {
                    stringBuffer.append(' ');
                }
                if ((eStructuralFeature = (EStructuralFeature)orderedFeatures.get(j)) instanceof EAttribute) {
                    containsUnorderedEAttribute = containsEReference;
                } else {
                    containsEReference = true;
                }
                stringBuffer.append(((EStructuralFeature)orderedFeatures.get(j)).getName());
                ++j;
            }
            if (!containsUnorderedEAttribute) continue;
            EAnnotation eAnnotation = eClass.getEAnnotation(XSD2ECORE_URI);
            eAnnotation.getDetails().put((Object)"feature-order", (Object)stringBuffer.toString());
        }
    }

    protected String validName(String name, boolean isUpperCase) {
        List parsedName = this.parseName(name, '_');
        StringBuffer result = new StringBuffer();
        Iterator i = parsedName.iterator();
        while (i.hasNext()) {
            String nameComponent = (String)i.next();
            if (nameComponent.length() <= 0) continue;
            result.append(Character.toUpperCase(nameComponent.charAt(0)));
            result.append(nameComponent.substring(1));
        }
        return result.length() == 0 ? "_" : (Character.isJavaIdentifierStart(result.charAt(0)) ? (isUpperCase ? result.toString() : this.uncapName(result.toString())) : "_" + result);
    }

    protected List parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuffer currentWord = new StringBuffer();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (!Character.isJavaIdentifierPart(curChar)) {
                    curChar = separator;
                }
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if ((lastIsLower || curChar == separator) && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar != separator) {
                    currentWord.append(curChar);
                }
                ++index;
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public String uncapName(String name) {
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase();
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == lowerName.charAt(i)) break;
            ++i;
        }
        if (i > 1 && i < name.length()) {
            --i;
        }
        return name.substring(0, i).toLowerCase() + name.substring(i);
    }

    public static class EffectiveOccurrence {
        public int minOccurs;
        public int maxOccurs;

        public EffectiveOccurrence(int minOccurs, int maxOccurs) {
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }
    }
}

