/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl.type;

import java.util.Arrays;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;

public class XSDAnySimpleType {
    public void assess(XSDSimpleTypeDefinitionImpl.AssessmentImpl assessment) {
        assessment.xsdAnySimpleType = this;
        if (this.isValidLiteral(assessment.normalizedLiteral)) {
            assessment.value = this.getValue(assessment.normalizedLiteral);
        } else {
            assessment.reportDatatypeDiagnostic();
        }
    }

    public boolean isValidLiteral(String normalizedLiteral) {
        return true;
    }

    public Object getValue(String normalizedLiteral) {
        return normalizedLiteral;
    }

    public String getCanonicalLiteral(Object value) {
        return value == null ? null : value.toString();
    }

    public int compareValues(Object value1, Object value2) {
        throw new RuntimeException(XSDPlugin.INSTANCE.getString("_EXC_CompareNotSupported"));
    }

    public static class IntSequence {
        protected final XSDAnySimpleType xsdAnySimpleType;
        protected final int[] ints;

        public IntSequence(XSDAnySimpleType xsdAnySimpleType, int[] ints) {
            this.xsdAnySimpleType = xsdAnySimpleType;
            this.ints = ints;
        }

        public int[] getInts() {
            return this.ints;
        }

        public boolean equals(Object that) {
            if (that == this) {
                return true;
            }
            if (that instanceof IntSequence) {
                return Arrays.equals(this.ints, ((IntSequence)that).ints);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 1;
            int i = 0;
            while (i < this.ints.length) {
                int theInt = this.ints[i];
                hashCode = 31 * hashCode + theInt;
                ++i;
            }
            return hashCode;
        }

        public String toString() {
            return this.xsdAnySimpleType.getCanonicalLiteral(this);
        }
    }

    public static class ByteSequence {
        protected final XSDAnySimpleType xsdAnySimpleType;
        protected final byte[] bytes;

        public ByteSequence(XSDAnySimpleType xsdAnySimpleType, byte[] bytes) {
            this.xsdAnySimpleType = xsdAnySimpleType;
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public boolean equals(Object that) {
            if (that == this) {
                return true;
            }
            if (that instanceof ByteSequence) {
                return Arrays.equals(this.bytes, ((ByteSequence)that).bytes);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 1;
            int i = 0;
            while (i < this.bytes.length) {
                byte theByte = this.bytes[i];
                hashCode = 31 * hashCode + theByte;
                ++i;
            }
            return hashCode;
        }

        public String toString() {
            return this.xsdAnySimpleType.getCanonicalLiteral(this);
        }
    }
}

