/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XSDParser
extends DefaultHandler
implements LexicalHandler {
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected XSDFactory xsdFactory;
    protected XSDSchema xsdSchema;
    protected List xsdDiagnostics;
    protected javax.xml.parsers.SAXParser saxParser;
    protected Document document;
    protected Stack stack;
    protected Element element;
    protected Locator locator;
    protected int line;
    protected int column;
    protected String encoding;

    public static Map getUserData(Node node) {
        Map result = null;
        if (node instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)node;
            Object userData = nodeImpl.getUserData();
            if (userData == null) {
                result = new HashMap();
                nodeImpl.setUserData(result);
            } else if (userData instanceof Map) {
                result = (Map)userData;
            }
        }
        return result;
    }

    public static int getStartLine(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("startLine");
        return result == null ? 1 : result;
    }

    public static int getStartColumn(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("startColumn");
        return result == null ? 1 : result;
    }

    public static int getEndLine(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("endLine");
        return result == null ? 1 : result;
    }

    public static int getEndColumn(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("endColumn");
        return result == null ? 1 : result;
    }

    public XSDParser() {
        block5: {
            this.xsdFactory = XSDFactory.eINSTANCE;
            this.xsdDiagnostics = new ArrayList();
            this.stack = new Stack();
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    class GiantHack
                    extends SAXParserFactory {
                        protected Hashtable features;
                        private final /* synthetic */ XSDParser this$0;

                        GiantHack(XSDParser this$0) {
                            this.this$0 = this$0;
                        }

                        public javax.xml.parsers.SAXParser newSAXParser() throws ParserConfigurationException {
                            try {
                                return new javax.xml.parsers.SAXParser(this){
                                    protected XMLReader xmlReader;
                                    protected String schemaLanguage;
                                    private final /* synthetic */ GiantHack this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.schemaLanguage = null;
                                        try {
                                            this.xmlReader = new SAXParser(this){
                                                protected MyLocatorProxy locator;
                                                private final /* synthetic */ 1 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
                                                    try {
                                                        if (((AbstractSAXParser)this).fDocumentHandler != null) {
                                                            if (locator != null) {
                                                                this.locator = new MyLocatorProxy(this, locator);
                                                                ((AbstractSAXParser)this).fDocumentHandler.setDocumentLocator((Locator)((Object)this.locator));
                                                            }
                                                            ((AbstractSAXParser)this).fDocumentHandler.startDocument();
                                                        }
                                                        if (((AbstractSAXParser)this).fContentHandler != null) {
                                                            if (locator != null) {
                                                                this.locator = new MyLocatorProxy(this, locator);
                                                                ((AbstractSAXParser)this).fContentHandler.setDocumentLocator((Locator)((Object)this.locator));
                                                            }
                                                            ((AbstractSAXParser)this).fContentHandler.startDocument();
                                                        }
                                                    }
                                                    catch (SAXException e) {
                                                        throw new XNIException((Exception)e);
                                                    }
                                                }

                                                public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) {
                                                    if (this.locator != null) {
                                                        this.locator.setEncoding(encoding);
                                                    }
                                                    super.xmlDecl(version, encoding, standalone, augs);
                                                }
                                            };
                                            this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.this$1.isValidating());
                                            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", this.this$1.isNamespaceAware());
                                            this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", !this.this$1.isNamespaceAware());
                                            this.setFeatures(this.this$1.features);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }

                                    private void setFeatures(Hashtable features) throws SAXNotSupportedException, SAXNotRecognizedException {
                                        if (features != null) {
                                            Enumeration<K> e = features.keys();
                                            while (e.hasMoreElements()) {
                                                String feature = (String)e.nextElement();
                                                boolean value = (Boolean)features.get(feature);
                                                this.xmlReader.setFeature(feature, value);
                                            }
                                        }
                                    }

                                    public Parser getParser() throws SAXException {
                                        return (Parser)((Object)this.xmlReader);
                                    }

                                    public XMLReader getXMLReader() {
                                        return this.xmlReader;
                                    }

                                    public boolean isNamespaceAware() {
                                        try {
                                            return this.xmlReader.getFeature("http://xml.org/sax/features/namespaces");
                                        }
                                        catch (SAXException x) {
                                            throw new IllegalStateException(x.getMessage());
                                        }
                                    }

                                    public boolean isValidating() {
                                        return false;
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
                                        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
                                            if ("http://www.w3.org/2001/XMLSchema".equals(value)) {
                                                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                                                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                                                return;
                                            } else {
                                                if (value != null) throw new SAXNotSupportedException("Unsupported schema language");
                                                this.schemaLanguage = null;
                                                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
                                            }
                                            return;
                                        } else {
                                            this.xmlReader.setProperty(name, value);
                                        }
                                    }

                                    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
                                        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
                                            return this.schemaLanguage;
                                        }
                                        return this.xmlReader.getProperty(name);
                                    }
                                };
                            }
                            catch (Exception exception) {
                                throw new ParserConfigurationException(exception.getMessage());
                            }
                        }

                        public void setFeature(String name, boolean value) {
                            if (this.features == null) {
                                this.features = new Hashtable<K, V>();
                            }
                            this.features.put(name, value ? Boolean.TRUE : Boolean.FALSE);
                        }

                        public boolean getFeature(String name) {
                            return false;
                        }
                    }
                    GiantHack saxParserFactory = new GiantHack(this);
                    saxParserFactory.setNamespaceAware(true);
                    saxParserFactory.setValidating(false);
                    ((SAXParserFactory)saxParserFactory).setFeature("http://xml.org/sax/features/validation", false);
                    ((SAXParserFactory)saxParserFactory).setFeature("http://xml.org/sax/features/namespaces", true);
                    ((SAXParserFactory)saxParserFactory).setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    this.saxParser = ((SAXParserFactory)saxParserFactory).newSAXParser();
                    this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException exception) {
                    this.fatalError(exception);
                    Object var5_5 = null;
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                    break block5;
                }
                catch (ParserConfigurationException exception) {
                    this.fatalError(exception);
                    Object var5_6 = null;
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                }
                Object var5_4 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
                throw throwable;
            }
        }
    }

    public void parse(String uri) {
        block3: {
            try {
                this.saxParser.parse(new InputSource(uri), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public void parseString(String input) {
        this.parse(new InputSource(new StringReader(input)));
    }

    public void parse(InputSource inputSource) {
        block3: {
            try {
                this.saxParser.parse(inputSource, (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public void parse(InputStream inputStream) {
        block3: {
            try {
                this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public String getEncoding() {
        if (this.locator != null) {
            try {
                Method getEncodingMethod = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                if (getEncodingMethod != null) {
                    this.encoding = (String)getEncodingMethod.invoke((Object)this.locator, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.encoding;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setSchema(XSDSchema xsdSchema) {
        if (this.document != null) {
            this.xsdSchema = xsdSchema;
            Element element = this.document.getDocumentElement();
            if (element != null) {
                xsdSchema.setElement(element);
            }
            xsdSchema.clearDiagnostics();
            XSDResourceImpl.assignDiagnostics(xsdSchema, this.xsdDiagnostics);
            XSDResourceImpl resource = (XSDResourceImpl)xsdSchema.eResource();
            if (resource != null && this.getEncoding() != null) {
                resource.getDefaultSaveOptions().put(XSDResourceImpl.XSD_ENCODING, this.getEncoding());
            }
        }
    }

    public XSDSchema getSchema() {
        if (this.xsdSchema == null && this.document != null) {
            Element element = this.document.getDocumentElement();
            this.xsdSchema = element == null ? this.xsdFactory.createXSDSchema() : XSDSchemaImpl.createSchema(element);
            XSDResourceImpl.assignDiagnostics(this.xsdSchema, this.xsdDiagnostics);
        }
        return this.xsdSchema;
    }

    public Collection getDiagnostics() {
        return this.xsdDiagnostics;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element newElement = this.document.createElementNS(uri, qName);
        int i = 0;
        int length = attributes.getLength();
        while (i < length) {
            String attributeURI = attributes.getURI(i);
            String attributeQName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            if (attributeQName.equals("xmlns") || attributeQName.startsWith("xmlns:")) {
                attributeURI = "http://www.w3.org/2000/xmlns/";
            } else if ("".equals(attributeURI)) {
                attributeURI = null;
            }
            newElement.setAttributeNS(attributeURI, attributeQName, attributeValue);
            ++i;
        }
        if (this.stack.isEmpty()) {
            this.document.appendChild(newElement);
        } else {
            this.element.appendChild(newElement);
        }
        this.stack.push(this.element);
        this.element = newElement;
        Map extendedAttributes = XSDParser.getUserData(this.element);
        extendedAttributes.put("startLine", new Integer(this.line));
        extendedAttributes.put("startColumn", new Integer(this.column));
        this.saveLocation();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.saveLocation();
        Map extendedAttributes = XSDParser.getUserData(this.element);
        extendedAttributes.put("endLine", new Integer(this.line));
        extendedAttributes.put("endColumn", new Integer(this.column));
        this.element = (Element)this.stack.pop();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startDocument() {
        this.saveLocation();
        this.document = new DocumentImpl();
        this.xsdSchema = null;
    }

    public void endDocument() {
        this.element = null;
        this.saveLocation();
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        Text textNode = this.document.createTextNode(new String(characters, start, length));
        this.element.appendChild(textNode);
        this.saveLocation();
    }

    public void comment(char[] characters, int start, int length) throws SAXException {
        Comment commentNode = this.document.createComment(new String(characters, start, length));
        if (this.element == null) {
            this.document.appendChild(commentNode);
        } else {
            this.element.appendChild(commentNode);
        }
        this.saveLocation();
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void endDTD() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    protected void fatalError(IOException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void fatalError(ParserConfigurationException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void error(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void warning(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.WARNING_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void saveLocation() {
        this.line = this.locator.getLineNumber();
        this.column = this.locator.getColumnNumber();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource inputSource;
        if ("-//W3C//DTD XMLSCHEMA 200102//EN".equals(publicId)) {
            inputSource = new InputSource(XSDPlugin.INSTANCE.getBaseURL() + "cache/www.w3.org/2001/XMLSchema.dtd");
            inputSource.setPublicId(publicId);
        } else {
            inputSource = super.resolveEntity(publicId, systemId);
        }
        return inputSource;
    }
}

