/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDScope;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDNamedComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;

public abstract class XSDFeatureImpl
extends XSDNamedComponentImpl
implements XSDFeature {
    protected static final Object VALUE_EDEFAULT = null;
    protected Object value = VALUE_EDEFAULT;
    protected static final XSDConstraint CONSTRAINT_EDEFAULT = XSDConstraint.DEFAULT_LITERAL;
    protected XSDConstraint constraint = CONSTRAINT_EDEFAULT;
    protected boolean constraintESet = false;
    protected static final XSDForm FORM_EDEFAULT = XSDForm.QUALIFIED_LITERAL;
    protected XSDForm form = FORM_EDEFAULT;
    protected boolean formESet = false;
    protected static final String LEXICAL_VALUE_EDEFAULT = null;
    protected String lexicalValue = LEXICAL_VALUE_EDEFAULT;

    protected XSDFeatureImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDFeature();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public XSDConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(XSDConstraint newConstraint) {
        XSDConstraint oldConstraint = this.constraint;
        this.constraint = newConstraint == null ? CONSTRAINT_EDEFAULT : newConstraint;
        boolean oldConstraintESet = this.constraintESet;
        this.constraintESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldConstraint, (Object)this.constraint, !oldConstraintESet));
        }
    }

    public void unsetConstraint() {
        XSDConstraint oldConstraint = this.constraint;
        boolean oldConstraintESet = this.constraintESet;
        this.constraint = CONSTRAINT_EDEFAULT;
        this.constraintESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 12, (Object)oldConstraint, (Object)CONSTRAINT_EDEFAULT, oldConstraintESet));
        }
    }

    public boolean isSetConstraint() {
        return this.constraintESet;
    }

    public XSDForm getForm() {
        return this.form;
    }

    public void setForm(XSDForm newForm) {
        XSDForm oldForm = this.form;
        this.form = newForm == null ? FORM_EDEFAULT : newForm;
        boolean oldFormESet = this.formESet;
        this.formESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldForm, (Object)this.form, !oldFormESet));
        }
    }

    public void unsetForm() {
        XSDForm oldForm = this.form;
        boolean oldFormESet = this.formESet;
        this.form = FORM_EDEFAULT;
        this.formESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 13, (Object)oldForm, (Object)FORM_EDEFAULT, oldFormESet));
        }
    }

    public boolean isSetForm() {
        return this.formESet;
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    public void setLexicalValue(String newLexicalValue) {
        String oldLexicalValue = this.lexicalValue;
        this.lexicalValue = newLexicalValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldLexicalValue, (Object)this.lexicalValue));
        }
    }

    public Boolean getGlobal() {
        return new Boolean(this.isGlobal());
    }

    protected boolean analyze() {
        String theLexicalValue;
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
        super.analyze();
        Object newValue = null;
        if (!this.isFeatureReference() && (xsdSimpleTypeDefinition = this.getType().getSimpleType()) != null && (theLexicalValue = this.getLexicalValue()) != null && xsdSimpleTypeDefinition != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(theLexicalValue);
            }
            catch (RuntimeException exception) {
                // empty catch block
            }
        }
        boolean bl = newValue == null ? this.getValue() != null : !newValue.equals(this.getValue());
        if (bl) {
            this.setValue(newValue);
        }
        return true;
    }

    protected boolean isUpdatingDOM() {
        return super.isUpdatingDOM() || this.getContainer() instanceof XSDConcreteComponentImpl && ((XSDConcreteComponentImpl)this.getContainer()).isUpdatingDOM();
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement() && (XSDConstants.nodeType(changedElement) != 5 || changedElement.getParentNode() == null || XSDConstants.nodeType(changedElement.getParentNode()) == 33)) {
            if (changedElement.hasAttributeNS(null, "fixed")) {
                String newLexicalValue = changedElement.getAttributeNS(null, "fixed");
                if (newLexicalValue == null || !newLexicalValue.equals(this.getLexicalValue())) {
                    this.setLexicalValue(newLexicalValue);
                }
                if (!this.isSetConstraint() || XSDConstraint.FIXED_LITERAL != this.getConstraint()) {
                    this.setConstraint(XSDConstraint.FIXED_LITERAL);
                }
            } else if (changedElement.hasAttributeNS(null, "default")) {
                String newLexicalValue = changedElement.getAttributeNS(null, "default");
                if (newLexicalValue == null || !newLexicalValue.equals(this.getLexicalValue())) {
                    this.setLexicalValue(newLexicalValue);
                }
                if (!this.isSetConstraint() || XSDConstraint.DEFAULT_LITERAL != this.getConstraint()) {
                    this.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                }
            } else if (this.getLexicalValue() != null) {
                this.unsetConstraint();
                this.setLexicalValue(null);
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        Element theElement;
        super.changeAttribute(eAttribute);
        if (!(this.isFeatureReference() || this.isReconciling || eAttribute != null && eAttribute != XSDPackage.eINSTANCE.getXSDFeature_LexicalValue() && eAttribute != XSDPackage.eINSTANCE.getXSDFeature_Constraint() || (theElement = this.getElement()) == null)) {
            if (this.getLexicalValue() != null) {
                switch (this.getConstraint().getValue()) {
                    case 1: {
                        this.niceSetAttribute(theElement, "fixed", this.getLexicalValue());
                        if (!theElement.hasAttributeNS(null, "default")) break;
                        this.niceSetAttribute(theElement, "default", null);
                        break;
                    }
                    case 0: {
                        this.niceSetAttribute(theElement, "default", this.getLexicalValue());
                        if (!theElement.hasAttributeNS(null, "fixed")) break;
                        this.niceSetAttribute(theElement, "fixed", null);
                    }
                }
            } else if (!(this.getContainer() instanceof XSDAttributeUse)) {
                if (theElement.hasAttributeNS(null, "fixed")) {
                    this.niceSetAttribute(theElement, "fixed", null);
                }
                if (theElement.hasAttributeNS(null, "default")) {
                    this.niceSetAttribute(theElement, "default", null);
                }
            }
        }
    }

    public XSDScope getScope() {
        XSDConcreteComponent container = this.getContainer();
        while (container != null) {
            if (container instanceof XSDScope) {
                return (XSDScope)container;
            }
            if (container instanceof XSDModelGroupDefinition || container instanceof XSDAttributeGroupDefinition) {
                return null;
            }
            container = container.getContainer();
        }
        return null;
    }

    public boolean isFeatureReference() {
        return this.isNamedComponentReference();
    }

    public XSDFeature getResolvedFeature() {
        return (XSDFeature)this.getResolvedNamedComponent();
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(", constraint: ");
        if (this.constraintESet) {
            result.append((Object)this.constraint);
        } else {
            result.append("<unset>");
        }
        result.append(", form: ");
        if (this.formESet) {
            result.append((Object)this.form);
        } else {
            result.append("<unset>");
        }
        result.append(", lexicalValue: ");
        result.append(this.lexicalValue);
        result.append(')');
        return result.toString();
    }

    public boolean isGlobal() {
        XSDConcreteComponent container = this.getContainer();
        while (container != null) {
            if (container instanceof XSDScope) {
                return container instanceof XSDSchema;
            }
            if (container instanceof XSDModelGroupDefinition || container instanceof XSDAttributeGroupDefinition) {
                return false;
            }
            container = container.getContainer();
        }
        return true;
    }

    public Boolean getFeatureReference() {
        return new Boolean(this.isFeatureReference());
    }

    public XSDTypeDefinition getType() {
        return null;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getTargetNamespace();
            }
            case 7: {
                return this.getAliasName();
            }
            case 8: {
                return this.getURI();
            }
            case 9: {
                return this.getAliasURI();
            }
            case 10: {
                return this.getQName();
            }
            case 11: {
                return this.getValue();
            }
            case 12: {
                return this.getConstraint();
            }
            case 13: {
                return this.getForm();
            }
            case 14: {
                return this.getLexicalValue();
            }
            case 15: {
                return this.isGlobal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.isFeatureReference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.getScope();
            }
            case 18: {
                return this.getResolvedFeature();
            }
            case 19: {
                return this.getType();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setTargetNamespace((String)newValue);
                return;
            }
            case 11: {
                this.setValue(newValue);
                return;
            }
            case 12: {
                this.setConstraint((XSDConstraint)((Object)newValue));
                return;
            }
            case 13: {
                this.setForm((XSDForm)((Object)newValue));
                return;
            }
            case 14: {
                this.setLexicalValue((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(XSDConcreteComponentImpl.ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setName(XSDNamedComponentImpl.NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetNamespace(XSDNamedComponentImpl.TARGET_NAMESPACE_EDEFAULT);
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 12: {
                this.unsetConstraint();
                return;
            }
            case 13: {
                this.unsetForm();
                return;
            }
            case 14: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return XSDConcreteComponentImpl.ELEMENT_EDEFAULT == null ? this.element != null : !XSDConcreteComponentImpl.ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return XSDNamedComponentImpl.NAME_EDEFAULT == null ? this.name != null : !XSDNamedComponentImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return XSDNamedComponentImpl.TARGET_NAMESPACE_EDEFAULT == null ? this.targetNamespace != null : !XSDNamedComponentImpl.TARGET_NAMESPACE_EDEFAULT.equals(this.targetNamespace);
            }
            case 7: {
                return this.getAliasName() != null;
            }
            case 8: {
                return this.getURI() != null;
            }
            case 9: {
                return this.getAliasURI() != null;
            }
            case 10: {
                return this.getQName() != null;
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 12: {
                return this.isSetConstraint();
            }
            case 13: {
                return this.isSetForm();
            }
            case 14: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 15: {
                return this.isGlobal();
            }
            case 16: {
                return this.isFeatureReference();
            }
            case 17: {
                return this.getScope() != null;
            }
            case 18: {
                return this.getResolvedFeature() != null;
            }
            case 19: {
                return this.getType() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }
}

